/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.sample.components.source;

import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.dm.muws.events.ManagementEvent;
import org.apache.muse.ws.notification.impl.TopicFilter;
import org.apache.muse.ws.notification.remote.NotificationProducerClient;
import org.apache.muse.ws.resource.WsResource;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.api.impl.AbstractSource;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedEventConsumer;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.binding.Binding;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ManagedResource
public class WefSource
extends AbstractSource {
    private static Class[] supportedTypes = new Class[]{ManagementEvent.class, Element.class};
    Element binding = null;
    @ManagedFrameworkAutowire(name="WSDM")
    private Binding wsdmBinding;

    public void setWsdmBinding(Binding wsdmBinding) {
        this.wsdmBinding = wsdmBinding;
    }

    public WefSource(ContributionManager manager, Element binding) {
        super(manager);
        this.binding = binding;
    }

    protected Class[] getSupportedTypes() {
        return supportedTypes;
    }

    public boolean acceptWireTarget(IWireTarget target) throws Exception {
        if (target instanceof IDataFilterService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class type = classArray[n];
                if (((IDataFilterService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (target instanceof IDataTransformService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n3 = classArray.length;
            while (n < n3) {
                Class type = classArray[n];
                if (((IDataTransformService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (target instanceof IDataSinkService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n4 = classArray.length;
            while (n < n4) {
                Class type = classArray[n];
                if (((IDataSinkService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return false;
    }

    public boolean cancel() throws Exception {
        return false;
    }

    public boolean connect() throws Exception {
        Element[] targets = XmlUtils.getAllElements((Node)this.binding, (String)"http://www.eclipse.org/xmlns/sample/wefSource/1.0", (String)"target");
        Object consumerObject = this.wsdmBinding.getBindingForObject((Object)this);
        if (consumerObject != null && consumerObject instanceof WsResource) {
            EndpointReference consumer = ((WsResource)consumerObject).getEndpointReference();
            Element[] elementArray = targets;
            int n = 0;
            int n2 = elementArray.length;
            while (n < n2) {
                Element[] topics;
                Element target = elementArray[n];
                Element eprElement = XmlUtils.getElement((Node)target, (QName)WsaConstants.EPR_QNAME);
                EndpointReference epr = new EndpointReference(eprElement);
                NotificationProducerClient producer = new NotificationProducerClient(epr);
                producer.setTrace(true);
                Element[] elementArray2 = topics = XmlUtils.getAllElements((Node)target, (String)"http://www.eclipse.org/xmlns/sample/wefSource/1.0", (String)"topic");
                int n3 = 0;
                int n4 = elementArray2.length;
                while (n3 < n4) {
                    String durationString;
                    Element topic = elementArray2[n3];
                    Date expirationDate = null;
                    TopicFilter filter = null;
                    QName topicName = null;
                    String topicNamespace = topic.getAttribute("topicNamespace");
                    String topicValue = topic.getAttribute("topicValue");
                    if (topicValue != null) {
                        topicName = new QName(topicNamespace, topicValue, "wef");
                        filter = new TopicFilter(topicName);
                    }
                    if ((durationString = topic.getAttribute("duration")) != null && !"".equals(durationString)) {
                        long duration = XsdUtils.getDuration((String)durationString);
                        expirationDate = new Date(duration += System.currentTimeMillis());
                    }
                    producer.subscribe(consumer, filter, expirationDate);
                    ++n3;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean disconnect() throws Exception {
        return false;
    }

    public Class[] getOutputTypes() {
        return null;
    }

    public boolean pause() throws Exception {
        return false;
    }

    public boolean resume() throws Exception {
        return false;
    }

    public boolean run() throws Exception {
        return false;
    }

    @ManagedEventConsumer
    public void processMessage(Element element) {
        System.out.println("Got one!");
    }

    public DataSource getDataSource() {
        return null;
    }
}

