/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.net.InetAddress;

public final class ParserConstants {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final char FILE_SEPARATOR_CHARACTER = FILE_SEPARATOR.charAt(0);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String OS_PLATFORM = System.getProperty("os.name", "Windows");
    public static final boolean IS_ZOS_PLATFORM = OS_PLATFORM.equals("z/OS") || OS_PLATFORM.equals("OS/390");
    public static final String HYADES_VERSION = "0.2.0";
    public static final String REMOTE_LOG_LOADER_CLASS = "org.eclipse.hyades.logging.parsers.importer.RemoteLogParserLoader";
    public static final String APACHE_HTTP_SERVER_ERROR_LOG_PARSER_NAME = "Apache HTTP Server V1.3.26 error log";
    public static final String APACHE_HTTP_SERVER_ERROR_LOG_PARSER_VERSION = "0.2.0";
    public static final String APACHE_HTTP_SERVER_ACCESS_LOG_PARSER_NAME = "Apache HTTP Server V1.3.26 access log";
    public static final String APACHE_HTTP_SERVER_ACCESS_LOG_PARSER_VERSION = "0.2.0";
    public static final String HOST_ID_FORMAT_IPV4 = "IPV4";
    public static final String HOST_ID_FORMAT_IPV6 = "IPV6";
    public static final String MESSAGE_ARRAY_SIZE_KEY = "array_size";
    public static final String FILE_PATH_KEY = "file_path";
    public static final String FILE_NAME_KEY = "fileName";
    public static final String DIRECTORY_KEY = "directory";
    public static final String FILE_FOOTER_SIZE_KEY = "file_footer_size";
    public static final String CONFIDENCE_BUFFER_SIZE_KEY = "confidence_buffer_size";
    public static final String FILE_CHARSET_KEY = "characater_set";
    public static final String FILE_LOCALE_KEY = "locale";
    public static final String FILE_ULOCALE_KEY = "ULocale";
    public static final String ENABLE_ICU_KEY = "enableICU";
    public static final String CONTINUOUS_KEY = "continuous";
    public static final String FILTER_SPECIFICATION_KEY = "filter";
    public static final String FILTER_EXIT_CLASS = "filterExitClass";
    public static final String APACHE_VERSION_KEY = "APACHE_VERSION";
    public static final String APPLICATION_VERSION_KEY = "version";
    public static final String APACHE_HTTP_SERVER = "Apache HTTP Server";
    public static final String LOCALE_EN_US = "en-US";
    public static final short CBE_SEVERITY_1 = 50;
    public static final short CBE_SEVERITY_2 = 30;
    public static final short CBE_SEVERITY_3 = 10;
    public static final short CBE_SEVERITY_MINOR = 40;
    public static final short CBE_SEVERITY_FATAL = 60;
    public static final String APACHE_COMPONENT_TYPE = "HTTPServer";
    public static final String APACHE_COMPONENT_ID_TYPE = "ProductName";
    public static final String MESSAGE_EXTENDED_DATA_ELEMENT = "message";
    public static final String XML_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String UNKNOWN = "Unknown";
    public static final String NOT_APPLICABLE = "Not Applicable";
    public static final String NONE = "None";
    public static final String FILE = "file";
    public static final String CLIENT = "client";
    public static final String SIX_ZERO = ".000000";
    public static final String APACHE_ACCESS_TIME_STAMP_FORMAT = "dd/MMM/yyyy:HH:mm:ss";
    public static final String APACHE_ERROR_TIME_STAMP_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    public static final String CATEGORY = "category";
    public static final String CGI = "CGI_debugging_output";
    public static final String WARN_STRING = "warn";
    public static final String ERROR_STRING = "error";
    public static final String ALERT_STRING = "alert";
    public static final String CRIT_STRING = "crit";
    public static final String EMERG_STRING = "emerg";
    public static final String INTERNAL_REASONING_SCOPE = "INTERNAL";
    public static final String EXTERNAL_REASONING_SCOPE = "EXTERNAL";
    public static final String SUCCESSFUL_SUCCESS_DISPOSITION = "SUCCESSFUL";
    public static final String UNSUCCESSFUL_SUCCESS_DISPOSITION = "UNSUCCESSFUL";
    public static final String START_SITUATION_CATEGORY_NAME = "StartSituation";
    public static final String RESTART_INITIATED_SITUATION_QUALIFIER = "RESTART INITIATED";
    public static final String START_COMPLETED_SITUATION_QUALIFIER = "START COMPLETED";
    public static final String START_INITIATED_SITUATION_QUALIFIER = "START INITIATED";
    public static final String STOP_SITUATION_CATEGORY_NAME = "StopSituation";
    public static final String STOP_INITIATED_SITUATION_QUALIFIER = "STOP INITIATED";
    public static final String ABORT_INITIATED_SITUATION_QUALIFIER = "ABORT INITIATED";
    public static final String PAUSE_INITIATED_SITUATION_QUALIFIER = "PAUSE INITIATED";
    public static final String STOP_COMPLETED_SITUATION_QUALIFIER = "STOP COMPLETED";
    public static final String CONNECT_SITUATION_CATEGORY_NAME = "ConnectSituation";
    public static final String REPORT_SITUATION_CATEGORY_NAME = "ReportSituation";
    public static final String LOG_REPORT_CATEGORY = "LOG";
    public static final String PERFORMANCE_REPORT_CATEGORY = "PERFORMANCE";
    public static final String SECURITY_REPORT_CATEGORY = "SECURITY";
    public static final String HEARTBEAT_REPORT_CATEGORY = "HEARTBEAT";
    public static final String STATUS_REPORT_CATEGORY = "STATUS";
    public static final String TRACE_REPORT_CATEGORY = "TRACE";
    public static final String FEATURE_SITUATION_CATEGORY_NAME = "FeatureSituation";
    public static final String AVAILABLE_FEATURE_DISPOSITION = "AVAILABLE";
    public static final String NOT_AVAILABLE_FEATURE_DISPOSITION = "NOT AVAILABLE";
    public static final String CONFIGURE_SITUATION_CATEGORY_NAME = "ConfigureSituation";
    public static final String DEPENDENCY_SITUATION_CATEGORY_NAME = "DependencySituation";
    public static final String MET_DEPENDENCY_DISPOSITION = "MET";
    public static final String NOT_MET_DEPENDENCY_DISPOSITION = "NOT MET";
    public static final String CREATE_SITUATION_CATEGORY_NAME = "CreateSituation";
    public static final String DESTROY_SITUATION_CATEGORY_NAME = "DestroySituation";
    public static final String AVAILABLE_SITUATION_CATEGORY_NAME = "AvailableSituation";
    public static final String STARTABLE_OPERATION_DISPOSITION = "STARTABLE";
    public static final String NONSTARTABLE_OPERATION_DISPOSITION = "NONSTARTABLE";
    public static final String FUNCTION_PROCESS_PROCESSING_DISPOSITION = "FUNCTION_PROCESS";
    public static final String FUNCTION_BLOCK_PROCESSING_DISPOSITION = "FUNCTION_BLOCK";
    public static final String MGMT_PROCESS_PROCESSING_DISPOSITION = "MGMTTASK_PROCESS";
    public static final String MGMT_BLOCKED_PROCESSING_DISPOSITION = "MGMTTASK_BLOCKED";
    public static final String AVAILABLE_AVAILABILITY_DISPOSITION = "AVAILABLE";
    public static final String NOT_AVAILABLE_AVAILABILITY_DISPOSITION = "NOT AVAILABLE";
    public static final String REQUEST_SITUATION_CATEGORY_NAME = "RequestSituation";
    public static final String REQUEST_INITIATED_SITUATION_QUALIFIER = "REQUEST INITIATED";
    public static final String REQUEST_COMPLETED_SITUATION_QUALIFIER = "REQUEST COMPLETED";
    public static final String OTHER_SITUATION_CATEGORY_NAME = "OtherSituation";
    public static final String EXTENDED_DATA_ELEMENT_NOVALUE = "noValue";
    public static final String LOCALHOST_ID;
    public static final String LOCALHOST_ID_FORMAT;
    public static final String LOCALHOST_NAME;
    public static final String UNKNOWN_HOST = "Unknown Host";
    public static final String JAVA_UTIL_LOGGING_COMPONENTID_TYPE = "Application";
    public static final String JAVA_UTIL_LOGGING_COMPONENT_TYPE = "Logging_Application";
    public static final String JAVA_UTIL_LOGGING_EXEC_ENV = "Java";
    public static final String JAVA_UTIL_LOGGING_STR_VERSION = "1.4";
    public static final String JAVA_UTIL_LOGGING_STR_PRODUCT_NAME = "Java Logging XML log";
    public static final String JAVA_UTIL_LOGGING_STR_LOG = "log";
    public static final String JAVA_UTIL_LOGGING_STR_RECORD = "record";
    public static final String JAVA_UTIL_LOGGING_STR_MESSAGE = "record.message";
    public static final String JAVA_UTIL_LOGGING_STR_DATE = "record.date";
    public static final String JAVA_UTIL_LOGGING_STR_LOGGER = "record.logger";
    public static final String JAVA_UTIL_LOGGING_STR_SEQUENCE = "record.sequence";
    public static final String JAVA_UTIL_LOGGING_STR_MILLIS = "record.millis";
    public static final String JAVA_UTIL_LOGGING_STR_LEVEL = "record.level";
    public static final String JAVA_UTIL_LOGGING_STR_THREAD = "record.thread";
    public static final String JAVA_UTIL_LOGGING_STR_METHOD = "record.method";
    public static final String JAVA_UTIL_LOGGING_STR_CLASS = "record.class";
    public static final String JAVA_UTIL_LOGGING_STR_KEY = "record.key";
    public static final String JAVA_UTIL_LOGGING_STR_CATALOG = "record.catalog";
    public static final String JAVA_UTIL_LOGGING_STR_PARAM = "record.param";
    public static final String JAVA_UTIL_LOGGING_STR_EXCEPTION = "record.exception";
    public static final String JAVA_UTIL_LOGGING_STR_EXCEPTION_MSG = "record.exception.message";
    public static final String JAVA_UTIL_LOGGING_STR_EXCEPTION_FRAME = "record.exception.frame";
    public static final String JAVA_UTIL_LOGGING_STR_EXCEPTION_FRAME_CLASS = "record.exception.frame.class";
    public static final String JAVA_UTIL_LOGGING_STR_EXCEPTION_FRAME_METHOD = "record.exception.frame.method";
    public static final String JAVA_UTIL_LOGGING_STR_EXCEPTION_FRAME_LINE = "record.exception.frame.line";
    public static final String JAVA_UTIL_LOGGING_STR_EDE_SEQUENCE_NUMBER = "sequenceNumber";
    public static final String JAVA_UTIL_LOGGING_STR_EDE_STACKTRACE = "stackTrace";
    public static final String JAVA_UTIL_LOGGING_STR_EDE_LOGGER_NAME = "loggerName";
    public static final String JAVA_UTIL_LOGGING_STR_EDE_THREAD_ID = "threadID";
    public static final String JAVA_UTIL_LOGGING_STR_EDE_METHOD_NAME = "sourceMethodName";
    public static final String JAVA_UTIL_LOGGING_STR_EDE_CLASS_NAME = "sourceClassName";
    public static final String JAVA_UTIL_LOGGING_STR_EDE_NAME_STR = "name";
    public static final String JAVA_UTIL_LOGGING_STR_EDE_VALUE_STR = "value";
    public static final String JAVA_UTIL_LOGGING_STR_STRINGARRAY = "stringArray";
    public static final String CBE_TIME_STAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String WINDOWS_EVENT_TIME_STAMP_FORMAT = "MM/dd/yyyy HH:mm:ss.S";

    static {
        String localHostId = null;
        String localHostIdFormat = null;
        String localHostName = null;
        try {
            localHostId = InetAddress.getLocalHost().getHostAddress();
            localHostIdFormat = localHostId.indexOf(58) != -1 ? HOST_ID_FORMAT_IPV6 : HOST_ID_FORMAT_IPV4;
        }
        catch (Exception exception) {
            localHostId = UNKNOWN_HOST;
            localHostIdFormat = NONE;
        }
        try {
            localHostName = InetAddress.getByName(localHostId).getHostName();
        }
        catch (Exception exception) {
            localHostName = null;
        }
        LOCALHOST_ID = localHostId;
        LOCALHOST_ID_FORMAT = localHostIdFormat;
        LOCALHOST_NAME = localHostName;
    }
}

