/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.logging.core.internationalization;

import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.eclipse.hyades.internal.logging.core.internationalization.ICUInternationalizationUtilities;
import org.eclipse.hyades.internal.logging.core.internationalization.JavaInternationalizationUtilities;

public final class InternationalizationUtilities {
    private static boolean isICUAvailable = true;

    public static String format(long milliseconds, String dateFormatPattern, Locale locale, String timeZoneID) throws IllegalArgumentException {
        if (isICUAvailable) {
            try {
                return ICUInternationalizationUtilities.format(milliseconds, dateFormatPattern, ULocale.forLocale((Locale)locale), timeZoneID);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isICUAvailable = false;
            }
        }
        return JavaInternationalizationUtilities.format(milliseconds, dateFormatPattern, locale, timeZoneID);
    }

    public static String format(String message, Object[] arguments) throws IllegalArgumentException {
        return InternationalizationUtilities.format(message, arguments, Locale.getDefault());
    }

    public static String format(String message, Object[] arguments, Locale locale) throws IllegalArgumentException {
        if (isICUAvailable) {
            try {
                return ICUInternationalizationUtilities.format(message, arguments, ULocale.forLocale((Locale)locale));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isICUAvailable = false;
            }
        }
        return JavaInternationalizationUtilities.format(message, arguments, locale);
    }

    public static String[] tokenize(String string) {
        return InternationalizationUtilities.tokenize(string, " \t\n\r\f");
    }

    public static String[] tokenize(String string, String delimiters) {
        if (isICUAvailable) {
            try {
                return ICUInternationalizationUtilities.tokenize(string, delimiters);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isICUAvailable = false;
            }
        }
        return JavaInternationalizationUtilities.tokenize(string, delimiters);
    }

    public static char charAt(String string, int index) throws IndexOutOfBoundsException {
        if (isICUAvailable) {
            try {
                return ICUInternationalizationUtilities.charAt(string, index);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isICUAvailable = false;
            }
        }
        return JavaInternationalizationUtilities.charAt(string, index);
    }
}

