/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.internal.logging.core.internationalization.InternationalizationUtilities;
import org.eclipse.hyades.logging.core.DeserializationException;
import org.eclipse.hyades.logging.core.SerializationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlUtility {
    private static boolean isJAXPAvailable = true;
    private static final String DEFAULT_ENCODING = "UTF-8";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static String serialize(Document document) throws SerializationException {
        return XmlUtility.serialize(document, true);
    }

    public static String serialize(Document document, boolean format) throws SerializationException {
        return XmlUtility.serialize(document, format, DEFAULT_ENCODING);
    }

    public static String serialize(Document document, boolean format, String encoding) throws SerializationException {
        try {
            return new String(XmlUtility.serializeAsByteArray(document, format, encoding), encoding);
        }
        catch (UnsupportedEncodingException u) {
            throw new SerializationException(u.getMessage());
        }
    }

    public static void serialize(Document document, File outputFile) throws SerializationException {
        XmlUtility.serialize(document, outputFile, true);
    }

    public static void serialize(Document document, File outputFile, boolean format) throws SerializationException {
        XmlUtility.serialize(document, outputFile, format, DEFAULT_ENCODING);
    }

    /*
     * Exception decompiling
     */
    public static void serialize(Document document, File outputFile, boolean format, String encoding) throws SerializationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 65->69)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void serialize(Document document, OutputStream outputStream) throws SerializationException {
        XmlUtility.serialize(document, outputStream, true);
    }

    public static void serialize(Document document, OutputStream outputStream, boolean format) throws SerializationException {
        XmlUtility.serialize(document, outputStream, format, DEFAULT_ENCODING);
    }

    /*
     * Exception decompiling
     */
    public static void serialize(Document document, OutputStream outputStream, boolean format, String encoding) throws SerializationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 66->70)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] serializeAsByteArray(Document document) throws SerializationException {
        return XmlUtility.serializeAsByteArray(document, true);
    }

    public static byte[] serializeAsByteArray(Document document, boolean format) throws SerializationException {
        return XmlUtility.serializeAsByteArray(document, format, DEFAULT_ENCODING);
    }

    public static byte[] serializeAsByteArray(Document document, boolean format, String encoding) throws SerializationException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlUtility.serialize(document, byteArrayOutputStream, format, encoding);
        return byteArrayOutputStream.toByteArray();
    }

    public static void serialize(Document document, Writer writer) throws SerializationException {
        XmlUtility.serialize(document, writer, true);
    }

    public static void serialize(Document document, Writer writer, boolean format) throws SerializationException {
        try {
            XmlUtility.serialize(document, writer, format, ((OutputStreamWriter)writer).getEncoding());
        }
        catch (ClassCastException classCastException) {
            XmlUtility.serialize(document, writer, format, DEFAULT_ENCODING);
        }
    }

    public static void serialize(Document document, Writer writer, boolean format, String encoding) throws SerializationException {
        if (isJAXPAvailable) {
            try {
                JAXPXMLSerializer.serialize(document, writer, format, Charset.forName(encoding).name());
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isJAXPAvailable = false;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                isJAXPAvailable = false;
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                isJAXPAvailable = false;
            }
            catch (Exception e) {
                throw new SerializationException(e.toString());
            }
        }
        try {
            XercesXMLSerializer.serialize(document, writer, format, Charset.forName(encoding).name());
        }
        catch (Exception e) {
            throw new SerializationException(e.toString());
        }
    }

    public static Document deserialize(String xmlDocumentString) throws DeserializationException {
        return XmlUtility.deserialize(new InputSource(new StringReader(xmlDocumentString)));
    }

    public static Document deserialize(File inputFile) throws DeserializationException {
        try {
            return XmlUtility.deserialize(new InputSource(new FileInputStream(inputFile)));
        }
        catch (FileNotFoundException f) {
            throw new DeserializationException(f.toString());
        }
    }

    public static Document deserialize(InputStream inputStream) throws DeserializationException {
        return XmlUtility.deserialize(new InputSource(inputStream));
    }

    public static Document deserialize(InputSource inputSource) throws DeserializationException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
        }
        catch (Exception e) {
            throw new DeserializationException(e.toString());
        }
    }

    public static String normalize(String string) {
        if (string == null) {
            return "null";
        }
        int stringLength = string.length();
        if (stringLength == 0) {
            return "";
        }
        int marker = 0;
        int counter = 0;
        char[] characters = string.toCharArray();
        StringBuffer normalizedString = new StringBuffer(stringLength);
        while (counter < stringLength) {
            if (characters[counter] < '(' || characters[counter] > ';' && characters[counter] < '?' || characters[counter] > '~') {
                if (characters[counter] == '<') {
                    normalizedString.append(characters, marker, counter - marker);
                    marker = counter + 1;
                    normalizedString.append("&lt;");
                } else if (characters[counter] == '>') {
                    normalizedString.append(characters, marker, counter - marker);
                    marker = counter + 1;
                    normalizedString.append("&gt;");
                } else if (characters[counter] == '&') {
                    normalizedString.append(characters, marker, counter - marker);
                    marker = counter + 1;
                    normalizedString.append("&amp;");
                } else if (characters[counter] == '\"') {
                    normalizedString.append(characters, marker, counter - marker);
                    marker = counter + 1;
                    normalizedString.append("&quot;");
                } else if (characters[counter] == '\'') {
                    normalizedString.append(characters, marker, counter - marker);
                    marker = counter + 1;
                    normalizedString.append("&apos;");
                } else if (characters[counter] == '\t') {
                    normalizedString.append(characters, marker, counter - marker);
                    marker = counter + 1;
                    normalizedString.append("&#x9;");
                } else if (characters[counter] == '\n') {
                    normalizedString.append(characters, marker, counter - marker);
                    marker = counter + 1;
                    normalizedString.append("&#xA;");
                } else if (characters[counter] == '\r') {
                    normalizedString.append(characters, marker, counter - marker);
                    marker = counter + 1;
                    normalizedString.append("&#xD;");
                } else if (!(characters[counter] >= ' ' && characters[counter] <= '\ud7ff' || characters[counter] >= '\ue000' && characters[counter] <= '\ufffd')) {
                    normalizedString.append(characters, marker, counter - marker);
                    marker = counter + 1;
                    normalizedString.append('?');
                }
            }
            ++counter;
        }
        if (marker == 0) {
            return string;
        }
        if (marker < counter) {
            normalizedString.append(characters, marker, counter - marker);
        }
        return normalizedString.toString();
    }

    public static String denormalize(String string) {
        if (string == null) {
            return "null";
        }
        int stringLength = string.length();
        if (stringLength == 0) {
            return "";
        }
        int marker = 0;
        int counter = 0;
        int semiColonIndex = -1;
        String entityReferenceName = null;
        char[] characters = string.toCharArray();
        StringBuffer denormalizedString = new StringBuffer(stringLength);
        while (counter < stringLength) {
            if (characters[counter] == '&' && (semiColonIndex = string.indexOf(59, counter + 1)) != -1) {
                entityReferenceName = string.substring(counter + 1, semiColonIndex).trim();
                if (entityReferenceName.equals("lt")) {
                    denormalizedString.append(characters, marker, counter - marker);
                    denormalizedString.append('<');
                } else if (entityReferenceName.equals("gt")) {
                    denormalizedString.append(characters, marker, counter - marker);
                    denormalizedString.append('>');
                } else if (entityReferenceName.equals("amp")) {
                    denormalizedString.append(characters, marker, counter - marker);
                    denormalizedString.append('&');
                } else if (entityReferenceName.equals("quot")) {
                    denormalizedString.append(characters, marker, counter - marker);
                    denormalizedString.append('\"');
                } else if (entityReferenceName.equals("apos")) {
                    denormalizedString.append(characters, marker, counter - marker);
                    denormalizedString.append('\'');
                } else if (entityReferenceName.equals("#x9") || entityReferenceName.equals("#09")) {
                    denormalizedString.append(characters, marker, counter - marker);
                    denormalizedString.append('\t');
                } else if (entityReferenceName.equals("#xA") || entityReferenceName.equals("#10")) {
                    denormalizedString.append(characters, marker, counter - marker);
                    denormalizedString.append('\n');
                } else if (entityReferenceName.equals("#xD") || entityReferenceName.equals("#13")) {
                    denormalizedString.append(characters, marker, counter - marker);
                    denormalizedString.append('\r');
                } else {
                    denormalizedString.append(characters, marker, semiColonIndex + 1 - marker);
                }
                counter = semiColonIndex;
                marker = counter + 1;
            }
            ++counter;
        }
        if (marker == 0) {
            return string;
        }
        if (marker < counter) {
            denormalizedString.append(characters, marker, counter - marker);
        }
        return denormalizedString.toString();
    }

    private static void removeIgnorableWhitespace(Node node) {
        if (node != null) {
            String nodeValue;
            if (node.getNodeType() == 3 && (nodeValue = node.getNodeValue()) != null && nodeValue.trim().length() == 0) {
                node.setNodeValue(nodeValue.trim());
            }
            Node child = node.getFirstChild();
            while (child != null) {
                XmlUtility.removeIgnorableWhitespace(child);
                child = child.getNextSibling();
            }
        }
    }

    private static class JAXPXMLSerializer {
        private JAXPXMLSerializer() {
        }

        private static void serialize(Document document, Writer writer, boolean format, String encoding) throws Exception {
            DocumentType documentType;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", format ? String.valueOf("  ".length()) : "0");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", encoding);
            writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            writer.flush();
            if (format) {
                writer.write(Constants.LINE_SEPARATOR);
                writer.flush();
            }
            if ((documentType = document.getDoctype()) != null) {
                String systemId = documentType.getSystemId();
                String internalSubset = documentType.getInternalSubset();
                if (systemId != null || internalSubset != null) {
                    StringBuffer documentTypeBuffer = new StringBuffer();
                    documentTypeBuffer.append("<!DOCTYPE ");
                    documentTypeBuffer.append(documentType.getName());
                    if (systemId != null) {
                        String publicId = documentType.getPublicId();
                        if (publicId != null) {
                            documentTypeBuffer.append(" PUBLIC \"");
                            documentTypeBuffer.append(publicId);
                            documentTypeBuffer.append("\" \"");
                        } else {
                            documentTypeBuffer.append(" SYSTEM \"");
                        }
                        documentTypeBuffer.append(systemId);
                        documentTypeBuffer.append("\">");
                    } else {
                        documentTypeBuffer.append(" [");
                        String[] tokens = InternationalizationUtilities.tokenize(internalSubset.trim(), "\n\r\f");
                        if (format) {
                            documentTypeBuffer.append(Constants.LINE_SEPARATOR);
                            int counter = 0;
                            while (counter < tokens.length) {
                                documentTypeBuffer.append("  ");
                                documentTypeBuffer.append(tokens[counter].trim());
                                documentTypeBuffer.append(Constants.LINE_SEPARATOR);
                                ++counter;
                            }
                        } else {
                            int counter = 0;
                            while (counter < tokens.length) {
                                documentTypeBuffer.append(tokens[counter].trim());
                                ++counter;
                            }
                        }
                        documentTypeBuffer.append("]>");
                    }
                    if (format) {
                        documentTypeBuffer.append(Constants.LINE_SEPARATOR);
                    }
                    writer.write(documentTypeBuffer.toString());
                    writer.flush();
                }
            }
            if (format) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", String.valueOf("  ".length()));
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf("  ".length()));
                transformer.transform(new DOMSource(document), new StreamResult(writer));
            } else {
                transformer.setOutputProperty("indent", "no");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "0");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "0");
                Node clonedDocument = document.cloneNode(true);
                XmlUtility.removeIgnorableWhitespace(clonedDocument);
                transformer.transform(new DOMSource(clonedDocument), new StreamResult(writer));
            }
        }
    }

    private static class XercesXMLSerializer {
        private XercesXMLSerializer() {
        }

        private static void serialize(Document document, Writer writer, boolean format, String encoding) throws Exception {
            DocumentType documentType;
            Class<?> outputFormatClass = Class.forName("org.apache.xml.serialize.OutputFormat");
            Object outputFormat = outputFormatClass.newInstance();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            outputFormatClass.getMethod("setMethod", classArray).invoke(outputFormat, "xml");
            outputFormatClass.getMethod("setOmitXMLDeclaration", Boolean.TYPE).invoke(outputFormat, Boolean.TRUE);
            outputFormatClass.getMethod("setOmitDocumentType", Boolean.TYPE).invoke(outputFormat, Boolean.TRUE);
            outputFormatClass.getMethod("setLineWidth", Integer.TYPE).invoke(outputFormat, new Integer(0));
            Class[] classArray2 = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz2;
            outputFormatClass.getMethod("setLineSeparator", classArray2).invoke(outputFormat, Constants.LINE_SEPARATOR);
            Class<?> clazz3 = outputFormat.getClass();
            Class[] classArray3 = new Class[1];
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray3[0] = clazz4;
            clazz3.getMethod("setEncoding", classArray3).invoke(outputFormat, encoding);
            writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            writer.flush();
            if (format) {
                writer.write(Constants.LINE_SEPARATOR);
                writer.flush();
            }
            if ((documentType = document.getDoctype()) != null) {
                String systemId = documentType.getSystemId();
                String internalSubset = documentType.getInternalSubset();
                if (systemId != null || internalSubset != null) {
                    StringBuffer documentTypeBuffer = new StringBuffer();
                    documentTypeBuffer.append("<!DOCTYPE ");
                    documentTypeBuffer.append(documentType.getName());
                    if (systemId != null) {
                        String publicId = documentType.getPublicId();
                        if (publicId != null) {
                            documentTypeBuffer.append(" PUBLIC \"");
                            documentTypeBuffer.append(publicId);
                            documentTypeBuffer.append("\" \"");
                        } else {
                            documentTypeBuffer.append(" SYSTEM \"");
                        }
                        documentTypeBuffer.append(systemId);
                        documentTypeBuffer.append("\">");
                    } else {
                        documentTypeBuffer.append(" [");
                        String[] tokens = InternationalizationUtilities.tokenize(internalSubset.trim(), "\n\r\f");
                        if (format) {
                            documentTypeBuffer.append(Constants.LINE_SEPARATOR);
                            int counter = 0;
                            while (counter < tokens.length) {
                                documentTypeBuffer.append("  ");
                                documentTypeBuffer.append(tokens[counter].trim());
                                documentTypeBuffer.append(Constants.LINE_SEPARATOR);
                                ++counter;
                            }
                        } else {
                            int counter = 0;
                            while (counter < tokens.length) {
                                documentTypeBuffer.append(tokens[counter].trim());
                                ++counter;
                            }
                        }
                        documentTypeBuffer.append("]>");
                    }
                    if (format) {
                        documentTypeBuffer.append(Constants.LINE_SEPARATOR);
                    }
                    writer.write(documentTypeBuffer.toString());
                    writer.flush();
                }
            }
            outputFormat.getClass().getMethod("setIndent", Integer.TYPE).invoke(outputFormat, new Integer(format ? "  ".length() : 0));
            Class<?> xmlSerializerClass = Class.forName("org.apache.xml.serialize.XMLSerializer");
            Class[] classArray4 = new Class[2];
            Class<?> clazz5 = class$3;
            if (clazz5 == null) {
                try {
                    clazz5 = class$3 = Class.forName("java.io.Writer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray4[0] = clazz5;
            classArray4[1] = outputFormat.getClass();
            Object xmlSerializer = xmlSerializerClass.getConstructor(classArray4).newInstance(writer, outputFormat);
            if (format) {
                Class[] classArray5 = new Class[1];
                Class<?> clazz6 = class$4;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$4 = Class.forName("org.w3c.dom.Document");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray5[0] = clazz6;
                xmlSerializerClass.getMethod("serialize", classArray5).invoke(xmlSerializer, document);
            } else {
                Node clonedDocument = document.cloneNode(true);
                XmlUtility.removeIgnorableWhitespace(clonedDocument);
                Class[] classArray6 = new Class[1];
                Class<?> clazz7 = class$4;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$4 = Class.forName("org.w3c.dom.Document");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray6[0] = clazz7;
                xmlSerializerClass.getMethod("serialize", classArray6).invoke(xmlSerializer, clonedDocument);
            }
        }
    }
}

