/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.xml.namespace.QName;
import org.apache.muse.core.Capability;
import org.apache.muse.core.Environment;
import org.apache.muse.core.Resource;
import org.apache.muse.core.SimpleResource;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.MessageHeaders;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.impl.SimpleDescription;
import org.apache.muse.ws.dm.muws.impl.SimpleIdentity;
import org.apache.muse.ws.dm.muws.impl.SimpleManageabilityCharacteristics;
import org.apache.muse.ws.dm.muws.impl.SimpleMetrics;
import org.apache.muse.ws.dm.muws.impl.SimpleOperationalStatus;
import org.apache.muse.ws.dm.muws.impl.SimpleRelationships;
import org.apache.muse.ws.notification.impl.SimpleNotificationConsumer;
import org.apache.muse.ws.notification.impl.SimpleNotificationProducer;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.OpenMetadataDescriptor;
import org.apache.muse.ws.resource.metadata.WsrmdConstants;
import org.apache.muse.ws.resource.metadata.impl.SimpleMetadataDescriptor;
import org.apache.muse.ws.resource.metadata.impl.WsrmdUtils;
import org.apache.muse.ws.resource.properties.ResourcePropertyCollection;
import org.apache.muse.ws.resource.properties.get.impl.SimpleGetCapability;
import org.apache.muse.ws.resource.properties.impl.SimpleResourcePropertyCollection;
import org.apache.muse.ws.resource.properties.impl.WsrpUtils;
import org.apache.muse.ws.resource.properties.query.impl.SimpleQueryCapability;
import org.apache.muse.ws.resource.properties.schema.OpenPropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.ResourcePropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.impl.SimpleResourcePropertiesSchema;
import org.apache.muse.ws.resource.properties.set.impl.SimpleSetCapability;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedOperation;
import org.eclipse.cosmos.dc.mgmt.api.OperationalStatus;
import org.eclipse.cosmos.dc.mgmt.common.util.ManagementProxy;
import org.eclipse.cosmos.dc.mgmt.common.util.SequentialResourceIDFactory;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.capabilities.IdentityCapability;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.DynamicAdvertisementCapability;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.DynamicCapability;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.DynamicMetadataDescriptor;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.DynamicOperationalStatus;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.WSDLSource;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.WSDMBindingFactory;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMAttributeInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMNotificationInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMOperationInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDMBinding
extends SimpleResource
implements WsResource {
    private Object resource;
    private String resourceId;
    private ResourcePropertyCollection _properties = null;
    static String contextPath = "cosmos";
    static String port = System.getProperty("org.osgi.service.http.port", "80");
    private static Messages _MESSAGES = MessagesFactory.get(SimpleResource.class);
    private WSDMInfo info;

    public static URI getLocalAddress(String contextPath, String port) throws UnknownHostException {
        String ip = InetAddress.getLocalHost().getHostAddress();
        StringBuffer address = new StringBuffer();
        address.append("http://");
        address.append(ip);
        address.append(':');
        address.append(port);
        if (contextPath.charAt(0) != '/') {
            address.append('/');
        }
        address.append(contextPath);
        return URI.create(address.toString());
    }

    Object getResource() {
        return this.resource;
    }

    public String getNamespace() {
        return this.info.getTargetNamespace();
    }

    public WSDMBinding(WSDMInfo info, Object resource) {
        this.info = info;
        this.resource = resource;
        String resourceId = null;
        WSDMAttributeInfo resourceIdAttribute = info.getResourceIdField();
        if (resource instanceof ManagementProxy) {
            resource = ((ManagementProxy)resource).getProxiedObject();
        }
        if (resourceIdAttribute != null) {
            try {
                String name = resourceIdAttribute.getName();
                name = name.length() == 1 ? name.toUpperCase() : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
                Method getId = resource.getClass().getMethod("get" + name, new Class[0]);
                Object idObject = getId.invoke(resource, new Object[0]);
                resourceId = idObject.toString();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            resourceId = SequentialResourceIDFactory.getResourceID();
        }
        this.resourceId = resourceId;
        try {
            URI uri = WSDMBinding.getLocalAddress(String.valueOf(contextPath) + "/services/" + info.getResourceName(), port);
            this.setEndpointReference(new EndpointReference(uri));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        QName name = WsaConstants.DEFAULT_RESOURCE_ID_QNAME;
        this.getEndpointReference().addParameter(name, (Object)resourceId);
        WSDMAttributeInfo resourceIdField = info.getResourceIdField();
        if (resourceIdField == null) {
            SimpleIdentity identityCap = new SimpleIdentity();
            identityCap.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/Identity");
            this.addCapability((Capability)identityCap);
        } else {
            try {
                Object value = resourceIdField.getGetter().invoke(resource, null);
                IdentityCapability identityCap = new IdentityCapability(value.toString());
                identityCap.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/Identity");
                this.addCapability((Capability)identityCap);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public Element invoke(Element soapBody) {
        MessageHeaders wsa = this.getEnvironment().getAddressingContext();
        wsa.getAction();
        System.out.println("SOAP:" + XmlUtils.toString((Node)soapBody));
        return super.invoke(soapBody);
    }

    protected ResourcePropertyCollection createPropertyCollection() {
        return new SimpleResourcePropertyCollection();
    }

    public void initialize() throws SoapFault {
        SimpleOperationalStatus operationalStatus;
        SimpleDescription description = new SimpleDescription();
        description.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/Description");
        description.setResource((Resource)this);
        description.setMessageHandlers(this.info.createMessageHandlers(SimpleDescription.class));
        description.setCaption(new String[]{"Test Caption"});
        this.addCapability((Capability)description);
        WSDLSource metaData = new WSDLSource(this.info);
        WSDMOperationInfo[] wSDMOperationInfoArray = (WSDMOperationInfo[])this.info.getOperations();
        int n = 0;
        int n2 = wSDMOperationInfoArray.length;
        while (n < n2) {
            WSDMOperationInfo operation = wSDMOperationInfoArray[n];
            if (operation.isMetaDataMethod()) {
                ManagedOperation managedOperation = operation.getOperationMethod().getAnnotation(ManagedOperation.class);
                metaData.addDialectHandler(managedOperation.MetaDataType(), operation.getOperationMethod());
            }
            ++n;
        }
        metaData.setCapabilityURI("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata");
        metaData.setResource((Resource)this);
        metaData.setMessageHandlers(this.info.createMessageHandlers(WSDLSource.class));
        this.addCapability((Capability)metaData);
        SimpleGetCapability simpleGet = new SimpleGetCapability();
        simpleGet.setCapabilityURI("http://docs.oasis-open.org/wsrf/rpw-2/Get");
        simpleGet.setResource((Resource)this);
        simpleGet.setMessageHandlers(this.info.createMessageHandlers(SimpleGetCapability.class));
        this.addCapability((Capability)simpleGet);
        SimpleSetCapability simpleSet = new SimpleSetCapability();
        simpleSet.setCapabilityURI("http://docs.oasis-open.org/wsrf/rpw-2/Set");
        simpleSet.setResource((Resource)this);
        simpleSet.setMessageHandlers(this.info.createMessageHandlers(SimpleSetCapability.class));
        this.addCapability((Capability)simpleSet);
        SimpleManageabilityCharacteristics simpleManageability = new SimpleManageabilityCharacteristics();
        simpleManageability.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/ManageabilityCharacteristics");
        simpleManageability.setResource((Resource)this);
        simpleManageability.setMessageHandlers(this.info.createMessageHandlers(SimpleManageabilityCharacteristics.class));
        this.addCapability((Capability)simpleManageability);
        if (!this.info.hasNamespace("http://docs.oasis-open.org/wsdm/muws/capabilities/OperationalStatus") || !(this.resource instanceof OperationalStatus)) {
            operationalStatus = new SimpleOperationalStatus();
            operationalStatus.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/OperationalStatus");
            operationalStatus.setResource((Resource)this);
            operationalStatus.setMessageHandlers(this.info.createMessageHandlers(SimpleOperationalStatus.class));
            this.addCapability((Capability)operationalStatus);
        } else {
            operationalStatus = new DynamicOperationalStatus((OperationalStatus)this.resource);
            operationalStatus.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/OperationalStatus");
            operationalStatus.setResource((Resource)this);
            operationalStatus.setMessageHandlers(this.info.createMessageHandlers(DynamicOperationalStatus.class));
            this.addCapability((Capability)operationalStatus);
        }
        SimpleQueryCapability queryCapability = new SimpleQueryCapability();
        queryCapability.setCapabilityURI("http://docs.oasis-open.org/wsrf/rpw-2/QueryResourceProperties/QueryResourcePropertiesRequest");
        queryCapability.setResource((Resource)this);
        queryCapability.setMessageHandlers(this.info.createMessageHandlers(SimpleQueryCapability.class));
        this.addCapability((Capability)queryCapability);
        if (this.info.getRelations().length > 0) {
            SimpleRelationships relationships = new SimpleRelationships();
            relationships.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships");
            relationships.setResource((Resource)this);
            relationships.setMessageHandlers(this.info.createMessageHandlers(SimpleRelationships.class));
            this.addCapability((Capability)relationships);
        }
        if (this.info.getNotifications().length > 0 || this.info.isAdvertised()) {
            SimpleNotificationProducer notificationProducer = new SimpleNotificationProducer();
            notificationProducer.setCapabilityURI("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
            notificationProducer.setResource((Resource)this);
            notificationProducer.setMessageHandlers(this.info.createMessageHandlers(SimpleNotificationProducer.class));
            this.addCapability((Capability)notificationProducer);
            WSDMNotificationInfo[] wSDMNotificationInfoArray = (WSDMNotificationInfo[])this.info.getNotifications();
            int n3 = 0;
            int n4 = wSDMNotificationInfoArray.length;
            while (n3 < n4) {
                WSDMNotificationInfo notification = wSDMNotificationInfoArray[n3];
                if (!notification.isSpecNotification()) {
                    String namespace = notification.getNamespace();
                    if ("".equals(namespace)) {
                        namespace = this.info.getTargetNamespace();
                    }
                    notification.getNotifTypes();
                    notification.getName();
                    if (notificationProducer.getTopicNamespace(namespace) == null) {
                        notificationProducer.addTopicNamespace(namespace);
                    }
                    notificationProducer.addTopic(new QName(namespace, notification.getName()));
                }
                ++n3;
            }
        }
        if (this.info.hasMetrics()) {
            SimpleMetrics metrics = new SimpleMetrics();
            metrics.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/Metrics");
            metrics.setResource((Resource)this);
            metrics.setMessageHandlers(this.info.createMessageHandlers(SimpleMetrics.class));
            this.addCapability((Capability)metrics);
        }
        if (this.info.isAdvertised()) {
            WSDMBindingFactory.getDefault();
            EndpointReference epr = WSDMBindingFactory.getAdvertisementTarget(this.info.getAdvertisementConsumer());
            DynamicAdvertisementCapability advertisement = new DynamicAdvertisementCapability();
            advertisement.setInitialConsumerEpr(epr);
            advertisement.setCapabilityURI("http://docs.oasis-open.org/wsdm/muws/capabilities/Advertisement");
            advertisement.setResource((Resource)this);
            advertisement.setMessageHandlers(this.info.createMessageHandlers(DynamicAdvertisementCapability.class));
            this.addCapability((Capability)advertisement);
        }
        if (this.info.hasEventConsumers()) {
            SimpleNotificationConsumer notificationConsumer = new SimpleNotificationConsumer();
            notificationConsumer.setCapabilityURI("http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/NotifyRequest");
            notificationConsumer.setResource((Resource)this);
            notificationConsumer.setMessageHandlers(this.info.createMessageHandlers(SimpleNotificationConsumer.class));
            this.addCapability((Capability)notificationConsumer);
        }
        String[] namespaces = this.info.getNamespaces();
        int i = 0;
        String[] stringArray = namespaces;
        int n5 = 0;
        int namespace = stringArray.length;
        while (n5 < namespace) {
            String namespace2 = stringArray[n5];
            if (!namespace2.equals("http://docs.oasis-open.org/wsdm/muws/capabilities/OperationalStatus")) {
                DynamicCapability customCapability = new DynamicCapability(this.info, namespace2, "dyn" + i++);
                customCapability.setCapabilityURI(namespace2);
                customCapability.setResource((Resource)this);
                this.addCapability((Capability)customCapability);
            }
            ++n5;
        }
        this._properties = this.createPropertyCollection();
        WSDLSource wsdlSource = new WSDLSource(this.info);
        wsdlSource.setEnvironment(this.getEnvironment());
        Document wsdl = wsdlSource.getWSDLDocument();
        ResourcePropertiesSchema schema = this.createPropertiesSchema(wsdl);
        this._properties.setSchema(schema);
        MetadataDescriptor metadata = this.createMetadataDescriptor(wsdl);
        this._properties.setMetadata(metadata);
        super.initialize();
        this._properties.applyMetadata();
        this._properties.validateMetadata();
    }

    public void shutdown() throws SoapFault {
        System.out.println("Unexpected call to shutdown");
        throw new UnsupportedOperationException();
    }

    public ResourcePropertyCollection getPropertyCollection() {
        return this._properties;
    }

    protected MetadataDescriptor createMetadataDescriptor(Document wsdl) {
        String path;
        Element portTypeXML = WsdlUtils.getPortType((Node)wsdl, (QName)this.getWsdlPortType());
        String rmdName = XmlUtils.getAttribute((Element)portTypeXML, (QName)WsrmdConstants.DESCRIPTOR_ATTR_QNAME);
        String rmdPath = XmlUtils.getAttribute((Element)portTypeXML, (QName)WsrmdConstants.DESCRIPTOR_LOCATION_ATTR_QNAME);
        if (rmdName == null && rmdPath == null && !this.info.hasMetrics()) {
            return OpenMetadataDescriptor.getInstance();
        }
        if (this.info.hasMetrics()) {
            DynamicMetadataDescriptor descriptor = new DynamicMetadataDescriptor(this.info, wsdl.getDocumentElement());
            return descriptor;
        }
        if ((rmdName == null || rmdPath == null) && rmdName != rmdPath) {
            throw new RuntimeException(_MESSAGES.get("IncompleteMetadataAttributes"));
        }
        Environment env = this.getEnvironment();
        Document rmdDoc = env.getDocument(path = env.createRelativePath(this.getWsdlPath(), rmdPath));
        Element descriptorXML = WsrmdUtils.getMetadataDescriptor((Document)rmdDoc, (String)rmdName);
        if (descriptorXML == null) {
            Object[] filler = new Object[]{rmdPath, rmdName};
            throw new RuntimeException(_MESSAGES.get("DescriptorNotFound", filler));
        }
        return new SimpleMetadataDescriptor(descriptorXML);
    }

    protected ResourcePropertiesSchema createPropertiesSchema(Document wsdl) {
        QName wsrpName = WsrpUtils.getPropertiesName((Node)wsdl, (QName)this.getWsdlPortType());
        Element wsrpDoc = WsdlUtils.getElementDeclaration((Node)wsdl, (QName)wsrpName);
        if (wsrpDoc == null) {
            Object[] filler = new Object[]{this.getContextPath(), this.getWsdlPath()};
            this.getLog().warning(_MESSAGES.get("NoWSRPDocument", filler));
            return OpenPropertiesSchema.getInstance();
        }
        return new SimpleResourcePropertiesSchema(wsrpName, wsrpDoc);
    }
}

