/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import com.ibm.icu.util.ULocale;
import java.io.UnsupportedEncodingException;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.IStatus;
import org.eclipse.hyades.logging.adapter.impl.Component;
import org.eclipse.hyades.logging.adapter.impl.Status;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.w3c.dom.Element;

public abstract class Context
extends Component
implements IContext {
    private boolean continuousOperation = false;
    private long maximumIdleTime = 0L;
    private long pauseInterval = 0L;
    private long pauseCount = 0L;
    private Locale locale = null;
    private ULocale uLocale = null;
    private boolean enableICU = false;
    private String charset;
    private int year;
    private int month;
    private int day;
    private String timezone;
    private boolean hardStop = false;
    private boolean validating = false;
    private static final String CONTEXT_INSTANCE_NAME = "Context Instance";
    protected IContextListener listener;

    public void stop() {
        super.stop();
        this.listener = null;
        this.status.setActive(false);
    }

    public void resetControledStop() {
        this.resetPauseCount();
    }

    protected void resetPauseCount() {
        this.pauseCount = 0L;
    }

    protected void incrementPauseCount() {
        ++this.pauseCount;
    }

    protected long getPauseCount() {
        return this.pauseCount;
    }

    protected void setPauseCount(long newPauseCount) {
        this.pauseCount = newPauseCount;
    }

    public void setContinuousOperation(boolean newContinuousOperation) {
        this.continuousOperation = newContinuousOperation;
        this.updateConfigurationAttribute("continuousOperation", newContinuousOperation ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public boolean getContinuousOperation() {
        return this.continuousOperation;
    }

    public void setMaximumIdleTime(long newMaximumIdleTime) {
        this.maximumIdleTime = newMaximumIdleTime;
        this.updateConfigurationAttribute("maximumIdleTime", Long.toString(newMaximumIdleTime));
    }

    public long getMaximumIdleTime() {
        return this.maximumIdleTime;
    }

    public void setPauseInterval(long newPauseInterval) {
        this.pauseInterval = newPauseInterval;
        this.updateConfigurationAttribute("pauseInterval", Long.toString(newPauseInterval));
    }

    public long getPauseInterval() {
        return this.pauseInterval;
    }

    public void update() throws AdapterInvalidConfig {
        this.status.setName(this.getName());
        Element element = this.getConfiguration();
        if (element == null) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextConfigurationErrorNoConfigurationFatal_ERROR_", this.getName()));
        }
        if (element.hasAttribute("continuousOperation")) {
            String contOp = element.getAttribute("continuousOperation");
            if (contOp != null && (contOp.equalsIgnoreCase("true") || contOp.equalsIgnoreCase("false"))) {
                this.setContinuousOperation(Boolean.valueOf(contOp));
            } else {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Continuous_Operation_Value_Invalid_ERROR_", contOp, "continuousOperation", CONTEXT_INSTANCE_NAME, Boolean.TRUE.toString(), Boolean.FALSE.toString()));
            }
        }
        if (this.continuousOperation) {
            if (element.hasAttribute("pauseInterval")) {
                String pauseInt = element.getAttribute("pauseInterval");
                try {
                    this.setPauseInterval(Long.valueOf(pauseInt));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Pause_Interval_Value_Invalid_ERROR_", pauseInt, "pauseInterval", CONTEXT_INSTANCE_NAME));
                }
            } else {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Required_Continuous_Attribute_Missing_ERROR_", "pauseInterval", CONTEXT_INSTANCE_NAME, "continuousOperation", Boolean.toString(this.continuousOperation)));
            }
            if (this.pauseInterval <= 0L) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Pause_Interval_Value_Invalid_ERROR_", Long.toString(this.pauseInterval), "pauseInterval", CONTEXT_INSTANCE_NAME));
            }
            if (element.hasAttribute("maximumIdleTime")) {
                String maxIdle = element.getAttribute("maximumIdleTime");
                try {
                    this.setMaximumIdleTime(Long.valueOf(maxIdle));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Max_Idle_Time_Value_Invalid_ERROR_", maxIdle, "maximumIdleTime", CONTEXT_INSTANCE_NAME));
                }
            } else {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Required_Continuous_Attribute_Missing_ERROR_", "maximumIdleTime", CONTEXT_INSTANCE_NAME, "continuousOperation", Boolean.toString(this.continuousOperation)));
            }
            if (this.maximumIdleTime < 0L) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Max_Idle_Time_Value_Invalid_ERROR_", Long.toString(this.maximumIdleTime), "maximumIdleTime", CONTEXT_INSTANCE_NAME));
            }
        }
        String isoLanguageCode = element.getAttribute("isoLanguageCode");
        String isoCountryCode = element.getAttribute("isoCountryCode");
        this.charset = element.getAttribute("charset");
        if (element.hasAttribute("enableICU")) {
            String icu = element.getAttribute("enableICU");
            if (icu != null && (icu.equalsIgnoreCase("true") || icu.equalsIgnoreCase("false"))) {
                this.enableICU = Boolean.valueOf(icu);
            } else {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Continuous_Operation_Value_Invalid_ERROR_", icu, "enableICU", CONTEXT_INSTANCE_NAME, Boolean.TRUE.toString(), Boolean.FALSE.toString()));
            }
        }
        if ((isoLanguageCode == null || isoLanguageCode.equals("") || isoLanguageCode.equals("default")) && (isoCountryCode == null || isoCountryCode.equals("") || isoCountryCode.equals("default"))) {
            this.locale = Locale.getDefault();
            if (this.enableICU) {
                this.uLocale = ULocale.getDefault();
            }
        } else {
            Locale[] supportedLocals = Locale.getAvailableLocales();
            int i = 0;
            while (i < supportedLocals.length) {
                if (isoLanguageCode != null && !isoLanguageCode.equals("")) {
                    if (isoLanguageCode.equals(supportedLocals[i].getLanguage())) {
                        if (isoCountryCode != null && !isoCountryCode.equals("")) {
                            if (supportedLocals[i].getCountry().equals(isoCountryCode)) {
                                this.locale = supportedLocals[i];
                                break;
                            }
                        } else {
                            this.locale = supportedLocals[i];
                        }
                    }
                } else if (supportedLocals[i].getCountry().equals(isoCountryCode)) {
                    this.locale = supportedLocals[i];
                    break;
                }
                ++i;
            }
            if (this.enableICU) {
                ULocale[] supportedULocals = ULocale.getAvailableLocales();
                int i2 = 0;
                while (i2 < supportedULocals.length) {
                    if (isoLanguageCode != null && !isoLanguageCode.equals("")) {
                        if (isoLanguageCode.equals(supportedULocals[i2].getLanguage())) {
                            if (isoCountryCode != null && !isoCountryCode.equals("")) {
                                if (supportedULocals[i2].getCountry().equals(isoCountryCode)) {
                                    this.uLocale = supportedULocals[i2];
                                    break;
                                }
                            } else {
                                this.uLocale = supportedULocals[i2];
                            }
                        }
                    } else if (supportedULocals[i2].getCountry().equals(isoCountryCode)) {
                        this.uLocale = supportedULocals[i2];
                        break;
                    }
                    ++i2;
                }
            }
        }
        if (this.locale == null && this.uLocale == null) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_LocaleNotFound_ERROR_", isoLanguageCode, isoCountryCode));
        }
        CommonBaseEvent localeEvent = this.getEventFactory().createCommonBaseEvent();
        String localeName = this.enableICU ? this.uLocale.getDisplayName() : this.locale.getDisplayName();
        localeEvent.setMsg(Messages.getString("HyadesGAContextInstanceConfiguration_ContextLocaleSetting_INFO_", localeName));
        localeEvent.setSeverity((short)10);
        this.log(localeEvent);
        if (this.charset == null || this.charset.equals("") || this.charset.equals("default")) {
            String fileEncoding = null;
            try {
                fileEncoding = System.getProperty("file.encoding");
            }
            catch (SecurityException securityException) {}
            if (fileEncoding != null) {
                this.charset = fileEncoding;
            } else {
                this.charset = System.getProperty("os.name", "Windows").equals("z/OS") || System.getProperty("os.name", "Windows").equals("OS/390") ? "IBM-1047" : "UTF-8";
                CommonBaseEvent charsetEvent = this.getEventFactory().createCommonBaseEvent();
                charsetEvent.setMsg(Messages.getString("HyadesGAContextInstanceConfiguration_JVM_Charset_Not_Found_WARN_", this.charset));
                charsetEvent.setSeverity((short)30);
                this.log(charsetEvent);
            }
        }
        try {
            this.charset.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_CharsetNotSupported_ERROR_", this.charset));
        }
        CommonBaseEvent charsetEvent = this.getEventFactory().createCommonBaseEvent();
        charsetEvent.setMsg(Messages.getString("HyadesGAContextInstanceConfiguration_ContextCharsetSetting_INFO_", this.charset));
        charsetEvent.setSeverity((short)10);
        this.log(charsetEvent);
        this.timezone = element.getAttribute("timezone");
        if (this.timezone == null || this.timezone.equals("")) {
            this.timezone = null;
        } else if (this.timezone.length() != 5 || !this.timezone.matches("[-+]\\d{4}")) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Timezone_Value_Invalid_ERROR_", this.timezone, "timezone", CONTEXT_INSTANCE_NAME));
        }
        String yearStr = element.getAttribute("year");
        if (yearStr == null || yearStr.equals("")) {
            GregorianCalendar currentCal = new GregorianCalendar();
            this.year = currentCal.get(1);
        } else {
            try {
                this.year = Integer.parseInt(yearStr);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Pause_Interval_Value_Invalid_ERROR_", yearStr, "year", CONTEXT_INSTANCE_NAME));
            }
        }
        if (this.year <= 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Pause_Interval_Value_Invalid_ERROR_", yearStr, "year", CONTEXT_INSTANCE_NAME));
        }
        String monStr = element.getAttribute("month");
        if (monStr == null || monStr.equals("")) {
            GregorianCalendar currentCal = new GregorianCalendar();
            this.month = currentCal.get(2) + 1;
        } else {
            try {
                this.month = Integer.parseInt(monStr);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Month_Value_Invalid_ERROR_", monStr, "month", CONTEXT_INSTANCE_NAME));
            }
        }
        if (this.month <= 0 || this.month > 12) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Month_Value_Invalid_ERROR_", monStr, "month", CONTEXT_INSTANCE_NAME));
        }
        String dayStr = element.getAttribute("day");
        if (dayStr == null || dayStr.equals("")) {
            GregorianCalendar currentCal = new GregorianCalendar();
            this.day = currentCal.get(5);
        } else {
            try {
                this.day = Integer.parseInt(dayStr);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Day_Value_Invalid_ERROR_", dayStr, "day", CONTEXT_INSTANCE_NAME));
            }
        }
        if (this.day <= 0 || this.day > 31) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_Day_Value_Invalid_ERROR_", dayStr, "day", CONTEXT_INSTANCE_NAME));
        }
        super.update();
        CommonBaseEvent configureEvent = this.getEventFactory().createCommonBaseEvent();
        configureEvent.setMsg(Messages.getString("HyadesGAContextInstanceConfiguration_ConfigurationComplete_INFO_", this.getName()));
        configureEvent.setSeverity((short)10);
        Situation configSituation = this.getEventFactory().createSituation();
        configSituation.setConfigureSituation("INTERNAL", "SUCCESSFUL");
        configureEvent.setSituation(configSituation);
        this.log(configureEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleControledStop() {
        if (!this.getContinuousOperation()) {
            this.hardStop = false;
            this.stop();
        } else if (this.getMaximumIdleTime() == 0L || this.getMaximumIdleTime() / this.getPauseInterval() >= this.getPauseCount()) {
            try {
                Context context = this;
                synchronized (context) {
                    Thread.sleep(this.getPauseInterval());
                }
            }
            catch (Exception exception) {}
            this.incrementPauseCount();
        } else {
            this.hardStop = true;
            this.stop();
        }
    }

    public void setContextListener(IContextListener listener) {
        this.listener = listener;
    }

    public IContextListener getContextListener() {
        return this.listener;
    }

    protected boolean isHardStop() {
        return this.hardStop;
    }

    public void setHardStop() {
        this.hardStop = true;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        String country = locale.getCountry();
        String language = locale.getLanguage();
        if (country != null) {
            this.updateConfigurationAttribute("isoCountryCode", country);
        }
        if (language != null) {
            this.updateConfigurationAttribute("isoLanguageCode", language);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
        this.updateConfigurationAttribute("charset", charset);
    }

    public Status getContextStatus() {
        IComponent[] components;
        if (this.status.getChildrenStatus() == null && (components = this.getComponents()) != null) {
            IStatus[] statuses = new Status[components.length];
            int i = 0;
            while (i < components.length) {
                statuses[i] = ((Component)components[i]).getComponentStatus();
                ++i;
            }
            this.status.setChildrenStatus(statuses);
        }
        return this.status;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public int getYear() {
        return this.year;
    }

    public void setDay(int day) {
        this.day = day;
        this.updateConfigurationAttribute("day", Integer.toString(day));
    }

    public void setMonth(int month) {
        this.month = month;
        this.updateConfigurationAttribute("month", Integer.toString(month));
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
        this.updateConfigurationAttribute("timezone", timezone);
    }

    public void setYear(int year) {
        this.year = year;
        this.updateConfigurationAttribute("year", Integer.toString(year));
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public ULocale getULocale() {
        return this.uLocale;
    }

    public boolean isEnableICU() {
        return this.enableICU;
    }

    public void setEnableICU(boolean enableICU) {
        this.enableICU = enableICU;
        String enaString = enableICU ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        this.updateConfigurationAttribute("enableICU", enaString);
    }
}

