/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.logging.adapter.internal.filters.InvalidAttributeNameException;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl;

public class RangeFilterHelper {
    public static final String RANGEFILTER = "RangeFilter";
    public static final String EVENTS = "events";
    public static final String SECONDS = "seconds";
    private int eventCounter = 0;
    private boolean cacheCBE = false;
    private CommonBaseEvent[] cbeCacheArray = null;
    private ArrayList cbeCacheArrayList = null;
    private int rangeLimit = 0;
    private boolean time = false;
    private long baseTime = 0L;
    private CBEComparator cbeComparator = null;

    public String getValueFromPath(CommonBaseEvent cbe, List path) throws InvalidAttributeNameException {
        if (cbe == null | path == null) {
            return null;
        }
        Iterator i = path.iterator();
        if (path.isEmpty() || !i.next().equals(RANGEFILTER)) {
            throw new InvalidAttributeNameException();
        }
        if (i.hasNext()) {
            String attributeName = (String)i.next();
            if (attributeName.equals(EVENTS)) {
                ++this.eventCounter;
                return Integer.toString(this.eventCounter);
            }
            if (attributeName.equals(SECONDS)) {
                this.time = true;
                long createTime = cbe.getCreationTimeAsLong();
                if (this.baseTime == 0L) {
                    this.baseTime = createTime;
                    return "0";
                }
                if (this.baseTime > createTime) {
                    return Long.toString((this.baseTime - createTime) / 1000L);
                }
                return Long.toString((createTime - this.baseTime) / 1000L);
            }
        }
        throw new InvalidAttributeNameException();
    }

    public boolean isCacheCBE() {
        return this.cacheCBE;
    }

    public void cache(CommonBaseEvent cbe, boolean filterResult) {
        CommonBaseEvent newCBE;
        try {
            newCBE = (CommonBaseEvent)((CommonBaseEventImpl)cbe).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            newCBE = cbe;
        }
        CacheElement element = new CacheElement(newCBE, filterResult);
        if (this.time) {
            if (this.cbeCacheArrayList == null) {
                this.cbeCacheArrayList = new ArrayList();
                this.cbeCacheArrayList.add(element);
            } else {
                this.cbeCacheArrayList.add(element);
                Collections.sort(this.cbeCacheArrayList, this.getCbeComparator());
                long maxEvtTime = ((CacheElement)this.cbeCacheArrayList.get(this.cbeCacheArrayList.size() - 1)).getCreationTime();
                int removeCount = 0;
                while (removeCount < this.cbeCacheArrayList.size()) {
                    long ctime = ((CacheElement)this.cbeCacheArrayList.get(removeCount)).getCreationTime();
                    if ((maxEvtTime - ctime) / 1000L <= (long)this.rangeLimit) break;
                    ++removeCount;
                }
                int j = 0;
                while (j < removeCount) {
                    this.cbeCacheArrayList.remove(0);
                    ++j;
                }
            }
        } else {
            if (this.cbeCacheArrayList == null) {
                this.cbeCacheArrayList = new ArrayList(this.rangeLimit);
            }
            if (this.cbeCacheArrayList.size() == this.rangeLimit) {
                this.cbeCacheArrayList.remove(0);
            }
            this.cbeCacheArrayList.add(element);
        }
    }

    public void setCacheCBE(boolean cacheCBE) {
        this.cacheCBE = cacheCBE;
    }

    public CommonBaseEvent[] getCbeCacheArray() {
        if (this.cbeCacheArray == null && this.cbeCacheArrayList != null && this.cbeCacheArrayList.size() > 0) {
            this.cbeCacheArray = new CommonBaseEvent[this.cbeCacheArrayList.size()];
            Iterator i = this.cbeCacheArrayList.iterator();
            int j = 0;
            while (i.hasNext()) {
                CacheElement e = (CacheElement)i.next();
                if (!e.isFilterTrue()) continue;
                this.cbeCacheArray[j++] = e.getCbe();
            }
        }
        return this.cbeCacheArray;
    }

    public int getRangeLimit() {
        return this.rangeLimit;
    }

    public void setRangeLimit(int rangeLimit) {
        this.rangeLimit = rangeLimit;
    }

    protected CBEComparator getCbeComparator() {
        if (this.cbeComparator == null) {
            this.cbeComparator = new CBEComparator();
        }
        return this.cbeComparator;
    }

    protected class CBEComparator
    implements Comparator {
        protected CBEComparator() {
        }

        public int compare(Object e1, Object e2) {
            long etime2;
            long etime1 = ((CacheElement)e1).getCreationTime();
            if (etime1 < (etime2 = ((CacheElement)e2).getCreationTime())) {
                return -1;
            }
            if (etime1 > etime2) {
                return 1;
            }
            CommonBaseEvent eCBE1 = ((CacheElement)e1).getCbe();
            CommonBaseEvent eCBE2 = ((CacheElement)e2).getCbe();
            if (eCBE1.getSequenceNumber() < eCBE2.getSequenceNumber()) {
                return -1;
            }
            if (eCBE1.getSequenceNumber() > eCBE2.getSequenceNumber()) {
                return 1;
            }
            return 0;
        }
    }

    protected class CacheElement {
        private CommonBaseEvent cbe;
        private boolean filterTrue;
        private long creationTime;

        public CacheElement(CommonBaseEvent evt, boolean filterResult) {
            this.cbe = evt;
            this.filterTrue = filterResult;
            this.creationTime = evt.getCreationTimeAsLong();
        }

        public CommonBaseEvent getCbe() {
            return this.cbe;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public boolean isFilterTrue() {
            return this.filterTrue;
        }
    }
}

