/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import org.eclipse.hyades.logging.adapter.internal.filters.IFilterAtom;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterType;

public class StringFilterType
implements IFilterType {
    public static final String EQUALS = "equals";
    public static final String STARTS_WITH = "startsWith";
    public static final String CONTAINS = "contains";
    public static final String ENDS_WITH = "endsWith";
    public static final String GREATERTHAN = "greaterThan";
    public static final String LESSTHAN = "lessThan";
    public static final String GREATERTHANOREQUAL = "greaterThanOrEqual";
    public static final String LESSTHANOREQUAL = "lessThanOrEqual";
    private static final String[] operands = new String[]{"contains", "endsWith", "equals", "startsWith", "greaterThan", "lessThan", "greaterThanOrEqual", "lessThanOrEqual"};

    public String[] getOperators() {
        return operands;
    }

    public boolean processRule(IFilterAtom rule) {
        boolean result = rule.isNegated();
        String leftOperand = rule.getLeftOperand();
        if (rule.getOperator().equals(CONTAINS)) {
            if (leftOperand != null) {
                result = this.contains(leftOperand, rule.getRightOperand());
            } else {
                String[] leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    int k = 0;
                    while (k < leftOperands.length) {
                        result = this.contains(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        } else if (rule.getOperator().equals(ENDS_WITH)) {
            if (leftOperand != null) {
                result = this.endsWith(leftOperand, rule.getRightOperand());
            } else {
                String[] leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    int k = 0;
                    while (k < leftOperands.length) {
                        result = this.endsWith(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        } else if (rule.getOperator().equals(EQUALS)) {
            if (leftOperand != null) {
                result = this.equals(leftOperand, rule.getRightOperand());
            } else {
                String[] leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    int k = 0;
                    while (k < leftOperands.length) {
                        result = this.equals(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        } else if (rule.getOperator().equals(STARTS_WITH)) {
            if (leftOperand != null) {
                result = this.startsWith(leftOperand, rule.getRightOperand());
            } else {
                String[] leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    int k = 0;
                    while (k < leftOperands.length) {
                        result = this.startsWith(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        } else if (rule.getOperator().equals(GREATERTHAN)) {
            if (leftOperand != null) {
                result = this.greaterThan(leftOperand, rule.getRightOperand());
            } else {
                String[] leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    int k = 0;
                    while (k < leftOperands.length) {
                        result = this.greaterThan(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        } else if (rule.getOperator().equals(LESSTHAN)) {
            if (leftOperand != null) {
                result = this.lessThan(leftOperand, rule.getRightOperand());
            } else {
                String[] leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    int k = 0;
                    while (k < leftOperands.length) {
                        result = this.lessThan(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        } else if (rule.getOperator().equals(GREATERTHANOREQUAL)) {
            if (leftOperand != null) {
                result = this.greaterThanOrEquals(leftOperand, rule.getRightOperand());
            } else {
                String[] leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    int k = 0;
                    while (k < leftOperands.length) {
                        result = this.greaterThanOrEquals(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        } else if (rule.getOperator().equals(LESSTHANOREQUAL)) {
            if (leftOperand != null) {
                result = this.lessThanOrEquals(leftOperand, rule.getRightOperand());
            } else {
                String[] leftOperands = rule.getLeftOperands();
                if (leftOperands != null) {
                    int k = 0;
                    while (k < leftOperands.length) {
                        result = this.lessThanOrEquals(leftOperands[k], rule.getRightOperand());
                        if (!rule.isNegated() && result) {
                            return result;
                        }
                        if (rule.isNegated() && !result) {
                            return !result;
                        }
                        ++k;
                    }
                }
            }
        }
        if (rule.isNegated()) {
            return !result;
        }
        return result;
    }

    private boolean equals(String lhs, String rhs) {
        return lhs.equals(rhs);
    }

    private boolean contains(String lhs, String rhs) {
        int result = lhs.indexOf(rhs);
        return result != -1;
    }

    private boolean endsWith(String lhs, String rhs) {
        return lhs.endsWith(rhs);
    }

    private boolean startsWith(String lhs, String rhs) {
        return lhs.startsWith(rhs);
    }

    private boolean greaterThan(String lhs, String rhs) {
        return lhs.compareTo(rhs) > 0;
    }

    private boolean lessThan(String lhs, String rhs) {
        return lhs.compareTo(rhs) < 0;
    }

    private boolean greaterThanOrEquals(String lhs, String rhs) {
        return lhs.compareTo(rhs) >= 0;
    }

    private boolean lessThanOrEquals(String lhs, String rhs) {
        return lhs.compareTo(rhs) <= 0;
    }
}

