/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Locale;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.internal.util.TimeParser;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class ICUTimeParser
extends TimeParser {
    private SimpleDateFormat formatter = null;
    private SimpleDateFormat newFormatter = null;
    private static final String[] timeIds = TimeZone.getAvailableIDs();

    private void setFormat(String _format, ULocale locale) throws AdapterException {
        if (_format != null) {
            this.format = _format.trim();
            try {
                this.formatter = new SimpleDateFormat(this.format, locale);
            }
            catch (IllegalArgumentException e) {
                throw new AdapterException(e);
            }
            this.newFormatter = this.format.indexOf(90) != -1 || this.format.indexOf(122) != -1 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    }

    public ICUTimeParser(String timeFormat, ULocale locale) throws AdapterException {
        super(timeFormat, locale.toLocale());
        this.setFormat(timeFormat, locale);
    }

    public ICUTimeParser(String timeFormat, Locale locale) throws AdapterException {
        super(timeFormat, locale);
        this.setFormat(timeFormat, new ULocale(locale.toString()));
    }

    public String parse(String strTime) throws AdapterException {
        try {
            Date dt;
            if (this.formatter != null && this.format != null && strTime != null && !strTime.equals("") && (dt = this.formatter.parse(strTime.trim())) != null) {
                if (this.format.indexOf(90) != -1 || this.format.indexOf(122) != -1) {
                    StringBuffer test = new StringBuffer();
                    String timeZoneId = this.getTimeZoneId(strTime);
                    if (timeZoneId != null && !timeZoneId.trim().equals("")) {
                        this.newFormatter.setTimeZone(TimeZone.getTimeZone((String)timeZoneId));
                    }
                    test = this.newFormatter.format(dt, test, new FieldPosition(0));
                    String timeStamp = test.toString();
                    timeStamp = String.valueOf(timeStamp.substring(0, timeStamp.length() - 2)) + ":" + timeStamp.substring(timeStamp.length() - 2);
                    return timeStamp;
                }
                StringBuffer timeStampBuf = new StringBuffer(this.newFormatter.format(dt).trim());
                Calendar localCalendar = Calendar.getInstance();
                localCalendar.setTime(dt);
                int utcOffset = (localCalendar.get(15) + localCalendar.get(16)) / 60000;
                if (utcOffset < 0) {
                    timeStampBuf.append("-");
                } else {
                    timeStampBuf.append("+");
                }
                utcOffset = Math.abs(utcOffset);
                String numberHours = String.valueOf(utcOffset / 60);
                if (numberHours.length() == 1) {
                    timeStampBuf.append("0");
                }
                timeStampBuf.append(numberHours);
                timeStampBuf.append(":");
                String numberMinutes = String.valueOf(utcOffset % 60);
                if (numberMinutes.length() == 1) {
                    timeStampBuf.append("0");
                }
                timeStampBuf.append(numberMinutes);
                return timeStampBuf.toString();
            }
        }
        catch (Exception ex) {
            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_TimeParser_Exception_ERROR_", strTime.trim(), this.format), ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getTimeZoneId(String strTime) {
        try {
            String tmpFormat;
            block18: {
                String tmpcachedGMTId;
                tmpFormat = this.format;
                tmpFormat = tmpFormat.replaceAll("''", "");
                strTime = strTime.replaceAll("'", "");
                int singleQuoteIndex = tmpFormat.indexOf(39);
                while (true) {
                    if (singleQuoteIndex == -1) {
                        if (tmpFormat.indexOf(122) == -1 && tmpFormat.indexOf(90) == -1) {
                            return null;
                        }
                        if (this.cachedTimeId != null && !this.cachedTimeId.equals("")) {
                            if (strTime.indexOf(this.cachedTimeId) == -1) break;
                            return this.cachedTimeId;
                        }
                        break block18;
                    }
                    int secondQuoteIndex = tmpFormat.indexOf(39, singleQuoteIndex + 1);
                    if (secondQuoteIndex == -1) {
                        return null;
                    }
                    String tmpString = tmpFormat.substring(singleQuoteIndex + 1, secondQuoteIndex);
                    int tmpStringIndex = strTime.indexOf(tmpString);
                    if (tmpStringIndex == -1) {
                        return null;
                    }
                    strTime = String.valueOf(strTime.substring(0, tmpStringIndex)) + strTime.substring(tmpStringIndex + tmpString.length());
                    tmpFormat = String.valueOf(tmpFormat.substring(0, singleQuoteIndex)) + tmpFormat.substring(secondQuoteIndex + 1);
                    singleQuoteIndex = tmpFormat.indexOf(39);
                }
                if (this.cachedTimeId.startsWith("GMT") && tmpFormat.indexOf(43) == -1 && tmpFormat.indexOf(45) == -1 && strTime.indexOf(tmpcachedGMTId = this.cachedTimeId.substring(3)) != -1) {
                    return this.cachedTimeId;
                }
            }
            int i = 0;
            while (true) {
                if (i >= timeIds.length) {
                    String tzStr = this.getTimeZone(tmpFormat, strTime);
                    if (tzStr != null && !tzStr.equals("")) {
                        this.cachedTimeId = tzStr;
                    }
                    return tzStr;
                }
                String tzId = timeIds[i].matches("[A-Z]{3}\\d{1}[A-Z]{3}") ? timeIds[i].substring(4) : timeIds[i];
                if (strTime.lastIndexOf(tzId) != -1) {
                    if (!timeIds[i].equals("GMT")) {
                        this.cachedTimeId = timeIds[i];
                        return timeIds[i];
                    }
                    String[] strs = strTime.split("(GMT)(\\s)*([+]|[-]){1}([0-9]){1,2}[:]?[0-5][0-9]");
                    if (strs.length == 1 && strs[0].equals(strTime) || strs.length > 2) {
                        this.cachedTimeId = timeIds[i];
                        return timeIds[i];
                    }
                    if (strs.length == 1) {
                        strTime = strTime.substring(strs[0].length());
                    } else if (strs.length == 2) {
                        strTime = strTime.substring(strs[0].length(), strTime.lastIndexOf(strs[1]));
                    }
                    this.cachedTimeId = strTime = strTime.trim().replaceAll("(\\s)+", "");
                    return strTime;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }
}

