/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class TimeParser {
    protected String format = null;
    private SimpleDateFormat formatter = null;
    private SimpleDateFormat newFormatter = null;
    private Locale locale = null;
    private static final String[] timeIds = TimeZone.getAvailableIDs();
    protected String cachedTimeId = null;
    protected final String XML_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected final String XML_DATETIME_FORMAT_WITHOUT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    private void setFormat(String _format, Locale locale) throws AdapterException {
        if (_format != null && !_format.equals(this.format)) {
            this.format = _format.trim();
            try {
                this.formatter = new SimpleDateFormat(this.format, locale);
                this.locale = locale;
            }
            catch (IllegalArgumentException e) {
                throw new AdapterException(e);
            }
            this.newFormatter = this.format.indexOf(90) != -1 || this.format.indexOf(122) != -1 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    }

    public TimeParser(String timeFormat, Locale locale) throws AdapterException {
        this.setFormat(timeFormat, locale);
    }

    public String parse(String strTime) throws AdapterException {
        try {
            Date dt;
            if (this.formatter != null && this.format != null && strTime != null && !strTime.equals("") && (dt = this.formatter.parse(strTime.trim(), new ParsePosition(0))) != null) {
                if (this.format.indexOf(90) != -1 || this.format.indexOf(122) != -1) {
                    StringBuffer test = new StringBuffer();
                    String timeZoneId = this.getTimeZoneId(strTime);
                    if (timeZoneId != null && !timeZoneId.trim().equals("")) {
                        this.newFormatter.setTimeZone(TimeZone.getTimeZone(timeZoneId));
                    }
                    test = this.newFormatter.format(dt, test, new FieldPosition(0));
                    String timeStamp = test.toString();
                    timeStamp = String.valueOf(timeStamp.substring(0, timeStamp.length() - 2)) + ":" + timeStamp.substring(timeStamp.length() - 2);
                    return timeStamp;
                }
                StringBuffer timeStampBuf = new StringBuffer(this.newFormatter.format(dt).trim());
                Calendar localCalendar = Calendar.getInstance();
                localCalendar.setTime(dt);
                int utcOffset = (localCalendar.get(15) + localCalendar.get(16)) / 60000;
                if (utcOffset < 0) {
                    timeStampBuf.append("-");
                } else {
                    timeStampBuf.append("+");
                }
                utcOffset = Math.abs(utcOffset);
                String numberHours = String.valueOf(utcOffset / 60);
                if (numberHours.length() == 1) {
                    timeStampBuf.append("0");
                }
                timeStampBuf.append(numberHours);
                timeStampBuf.append(":");
                String numberMinutes = String.valueOf(utcOffset % 60);
                if (numberMinutes.length() == 1) {
                    timeStampBuf.append("0");
                }
                timeStampBuf.append(numberMinutes);
                return timeStampBuf.toString();
            }
        }
        catch (Exception ex) {
            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_TimeParser_Exception_ERROR_", strTime.trim(), this.format), ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getTimeZoneId(String strTime) {
        try {
            String tmpFormat;
            block18: {
                String tmpcachedGMTId;
                tmpFormat = this.format;
                tmpFormat = tmpFormat.replaceAll("''", "");
                strTime = strTime.replaceAll("'", "");
                int singleQuoteIndex = tmpFormat.indexOf(39);
                while (true) {
                    if (singleQuoteIndex == -1) {
                        if (tmpFormat.indexOf(122) == -1 && tmpFormat.indexOf(90) == -1) {
                            return null;
                        }
                        if (this.cachedTimeId != null && !this.cachedTimeId.equals("")) {
                            if (strTime.indexOf(this.cachedTimeId) == -1) break;
                            return this.cachedTimeId;
                        }
                        break block18;
                    }
                    int secondQuoteIndex = tmpFormat.indexOf(39, singleQuoteIndex + 1);
                    if (secondQuoteIndex == -1) {
                        return null;
                    }
                    String tmpString = tmpFormat.substring(singleQuoteIndex + 1, secondQuoteIndex);
                    int tmpStringIndex = strTime.indexOf(tmpString);
                    if (tmpStringIndex == -1) {
                        return null;
                    }
                    strTime = String.valueOf(strTime.substring(0, tmpStringIndex)) + strTime.substring(tmpStringIndex + tmpString.length());
                    tmpFormat = String.valueOf(tmpFormat.substring(0, singleQuoteIndex)) + tmpFormat.substring(secondQuoteIndex + 1);
                    singleQuoteIndex = tmpFormat.indexOf(39);
                }
                if (this.cachedTimeId.startsWith("GMT") && tmpFormat.indexOf(43) == -1 && tmpFormat.indexOf(45) == -1 && strTime.indexOf(tmpcachedGMTId = this.cachedTimeId.substring(3)) != -1) {
                    return this.cachedTimeId;
                }
            }
            int i = 0;
            while (true) {
                if (i >= timeIds.length) {
                    String tzStr = this.getTimeZone(tmpFormat, strTime);
                    if (tzStr != null && !tzStr.equals("")) {
                        this.cachedTimeId = tzStr;
                    }
                    return tzStr;
                }
                String tzId = timeIds[i].matches("[A-Z]{3}\\d{1}[A-Z]{3}") ? timeIds[i].substring(4) : timeIds[i];
                if (strTime.lastIndexOf(tzId) != -1) {
                    if (!timeIds[i].equals("GMT")) {
                        this.cachedTimeId = timeIds[i];
                        return timeIds[i];
                    }
                    String[] strs = strTime.split("(GMT)(\\s)*([+]|[-]){1}([0-9]){1,2}[:]?[0-5][0-9]");
                    if (strs.length == 1 && strs[0].equals(strTime) || strs.length > 2) {
                        this.cachedTimeId = timeIds[i];
                        return timeIds[i];
                    }
                    if (strs.length == 1) {
                        strTime = strTime.substring(strs[0].length());
                    } else if (strs.length == 2) {
                        strTime = strTime.substring(strs[0].length(), strTime.lastIndexOf(strs[1]));
                    }
                    this.cachedTimeId = strTime = strTime.trim().replaceAll("(\\s)+", "");
                    return strTime;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getTimeZone(String formatStr, String timeStr) {
        formatStr = formatStr.trim();
        timeStr = timeStr.trim();
        if (formatStr.equals("Z") || formatStr.equals("z")) {
            if (timeStr.matches("([+]|[-])([0-9]){1,2}[0-5][0-9]")) {
                return "GMT" + timeStr;
            }
            return null;
        }
        boolean hasNoDelimiter = true;
        char[] formatStrChars = formatStr.toCharArray();
        int i = 0;
        while (i < formatStrChars.length) {
            if (!Character.isLetterOrDigit(formatStrChars[i])) {
                String[] subTimeStr;
                hasNoDelimiter = false;
                String[] formatters = formatStr.split("[\\" + formatStrChars[i] + "]");
                if (formatters.length == (subTimeStr = timeStr.split("[\\" + formatStrChars[i] + "]")).length || (formatStrChars[i] == '-' || formatStrChars[i] == '+') && formatters.length == subTimeStr.length - 1) {
                    int k = 0;
                    while (k < formatters.length) {
                        if (formatters[k].indexOf(90) != -1 || formatters[k].indexOf(122) != -1) {
                            if ((formatStrChars[i] == '-' || formatStrChars[i] == '+') && formatters.length == subTimeStr.length - 1) {
                                return this.getTimeZone(formatters[k], String.valueOf(subTimeStr[k]) + formatStrChars[i] + subTimeStr[k + 1]);
                            }
                            return this.getTimeZone(formatters[k], subTimeStr[k]);
                        }
                        ++k;
                    }
                } else {
                    return null;
                }
            }
            ++i;
        }
        if (hasNoDelimiter) {
            String[] strs = timeStr.trim().split("([+]|[-])([0-9]){1,2}[0-5][0-9]");
            if (strs.length == 1 && !strs[0].equals(timeStr)) {
                return "GMT" + timeStr.substring(strs[0].length());
            }
            if (strs.length == 2) {
                int startIndex = strs[0].length();
                int endIndex = timeStr.lastIndexOf(strs[1]);
                return "GMT" + timeStr.substring(startIndex, endIndex);
            }
        }
        return null;
    }
}

