/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.internal.parsers.AttributeStatement;
import org.eclipse.hyades.logging.adapter.internal.parsers.GroupStatement;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.parsers.StatementException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Parser
extends ProcessUnit
implements IParser {
    protected List ruleSets;
    protected String separatorToken;
    protected Pattern separatorPattern;
    protected String designationToken;
    protected Pattern designationPattern;

    public void update() throws AdapterInvalidConfig {
        super.update();
        Element element = this.getConfiguration();
        if (element == null || !element.getNodeName().equals("cc:Parser")) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Parser_Preparation_No_Parser_Element_ERROR_", "cc:Parser"));
        }
        NodeList rules = element.getChildNodes();
        this.separatorToken = element.getAttribute("separatorToken");
        this.designationToken = element.getAttribute("designationToken");
        if (this.separatorToken != null && !this.separatorToken.equals("")) {
            this.compileSeparatorToken(this.separatorToken);
        }
        if (this.designationToken != null && !this.designationToken.equals("")) {
            this.compileDesignationToken(this.designationToken);
        }
        this.prepareRules(rules);
    }

    protected void compileSeparatorToken(String token) throws AdapterInvalidConfig {
        try {
            this.separatorPattern = Pattern.compile(token, 8);
        }
        catch (PatternSyntaxException e) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Parser_Preparation_Separator_Token_Pattern_Invalid_ERROR_", e.getMessage()));
        }
    }

    protected void compileDesignationToken(String token) throws AdapterInvalidConfig {
        try {
            this.designationPattern = Pattern.compile(token, 8);
        }
        catch (PatternSyntaxException e) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Parser_Preparation_Designation_Token_Pattern_Invalid_ERROR_", e.getMessage()));
        }
    }

    protected void prepareRules(NodeList rules) throws AdapterInvalidConfig {
        int ruleCount = rules.getLength();
        if (ruleCount > 0) {
            this.ruleSets = new ArrayList();
            int i = 0;
            while (i < ruleCount) {
                block13: {
                    Element rule = null;
                    try {
                        rule = (Element)rules.item(i);
                    }
                    catch (ClassCastException classCastException) {
                        break block13;
                    }
                    if (rule != null) {
                        IStatement statement = null;
                        if (rule.getNodeName().endsWith("RuleElement")) {
                            statement = new GroupStatement(this);
                        } else if (rule.getNodeName().endsWith("RuleAttribute")) {
                            statement = new AttributeStatement(this);
                        } else {
                            throw new AdapterInvalidConfig();
                        }
                        try {
                            statement.prepare(rule, null);
                            this.ruleSets.add(statement);
                        }
                        catch (PreparationException e) {
                            CommonBaseEvent event;
                            if (e.getDetails() == null) {
                                event = this.getEventFactory().createCommonBaseEvent();
                                event.setMsg(e.getLocalizedMessage());
                                event.setSeverity((short)50);
                                this.log(event);
                            } else {
                                event = this.getEventFactory().createCommonBaseEvent();
                                event.setMsg(String.valueOf(e.getLocalizedMessage()) + " " + e.getDetails() + ". ");
                                event.setSeverity((short)50);
                                this.log(event);
                            }
                            CommonBaseEvent secondEvent = this.getEventFactory().createCommonBaseEvent();
                            secondEvent.getMsgDataElement().setMsgCatalogId("HyadesGASubstitutionRuleIgnored_WARN_");
                            secondEvent.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{e.getDigraph()});
                            secondEvent.setSeverity((short)50);
                            this.log(secondEvent);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public Object[] processEventItems(Object[] msgs) {
        if (this.ruleSets != null && msgs != null) {
            ArrayList<List> collection = new ArrayList<List>();
            int i = 0;
            while (i < msgs.length) {
                if (msgs[i] != null && ((MessageString)msgs[i]).getValue() != null && ((MessageString)msgs[i]).getValue().length() != 0) {
                    HashMap map = this.prepareEnvData(((MessageString)msgs[i]).getValue());
                    ListIterator iter = this.ruleSets.listIterator();
                    List result = null;
                    while (iter.hasNext()) {
                        IStatement statement = (IStatement)iter.next();
                        try {
                            result = statement.run(((MessageString)msgs[i]).getValue(), map);
                            collection.add(result);
                        }
                        catch (AdapterException e) {
                            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                            event.setMsg(e.getLocalizedMessage());
                            event.setSeverity((short)50);
                            this.log(event);
                        }
                        catch (StatementException statementException) {}
                    }
                }
                ++i;
            }
            this.incrementItemsProcessedCount(collection.size());
            this.trace("HyadesGATrace_Component_Processing_End_INFO_", this.getName(), Integer.toString(collection.size()));
            if (collection.size() == 0) {
                return null;
            }
            return collection.toArray();
        }
        this.trace("HyadesGATrace_Component_Processing_End_INFO_", this.getName(), Integer.toString(0));
        return null;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        if (!(msgs instanceof MessageString[])) {
            throw new AdapterInvalidConfig("This parser will only accept arrays of MessageString");
        }
        return msgs;
    }

    protected HashMap prepareEnvData(String line) {
        HashMap<Object, String> result = new HashMap<Object, String>();
        if (this.separatorToken == null || this.separatorToken.equals("")) {
            return result;
        }
        String[] list = this.separatorPattern.split(line);
        int i = 0;
        while (i < list.length) {
            String hashKey = "";
            String val = "";
            String current = list[i];
            if (current.length() > 0) {
                if (this.designationToken == null || this.designationToken.equals("")) {
                    val = current.trim();
                    if (val.length() > 0) {
                        result.put(new Long(i), val);
                    }
                } else {
                    Matcher matcher = this.designationPattern.matcher(current);
                    if (matcher.find()) {
                        if (matcher.start() > 0) {
                            hashKey = current.substring(0, matcher.start()).trim();
                            if (matcher.end() < current.length() && (val = current.substring(matcher.end()).trim()).length() > 0 && hashKey.length() > 0) {
                                result.put(hashKey, val);
                            }
                        }
                    } else {
                        val = current.trim();
                        if (val.length() > 0) {
                            result.put(new Long(i), val);
                        }
                    }
                }
            }
            ++i;
        }
        return result;
    }
}

