/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import com.ibm.icu.util.ULocale;
import java.util.Locale;
import javax.xml.transform.TransformerException;
import org.eclipse.hyades.logging.adapter.util.ISeverityFilterExit;
import org.eclipse.hyades.logging.adapter.util.ITimeFilterExit;
import org.eclipse.hyades.logging.adapter.util.InvalidFilterSpecification;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathAPI;

public abstract class AbstractXPATHFilterExit
implements ISeverityFilterExit,
ITimeFilterExit {
    private FastXPathAPI api;
    private CommonBaseEvent cbe = null;
    private String filterSpecification = null;
    private boolean filterOnSeverity = false;
    private boolean filterOnCreationTime = false;
    private Locale locale = null;
    private ULocale uLocale = null;
    private boolean enableICU = false;
    private int year;
    private int month;
    private int day;
    private String timezone;
    EventFactory eventFactory = new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.parsers.Parser");

    public AbstractXPATHFilterExit() throws InstantiationException {
        this.api = new FastXPathAPI(null);
        this.cbe = this.eventFactory.createCommonBaseEvent();
        this.cbe.init();
    }

    public boolean filter(String record) {
        try {
            this.setCommonBaseEvent(record);
            return this.api.match((Object)this.cbe, this.getFilterSpecification());
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getFilterSpecification() {
        return this.filterSpecification;
    }

    protected CommonBaseEvent getCommonBaseEvent() {
        return this.cbe;
    }

    protected void setCommonBaseEvent(String record) {
        if (this.filterOnSeverity) {
            this.cbe.setSeverity(this.parseSeverity(record));
        }
        if (this.filterOnCreationTime) {
            this.cbe.setCreationTime(this.parseTime(record));
        }
    }

    public short getCurrentSeverity() {
        return this.cbe.getSeverity();
    }

    public String getCurrentCreationTime() {
        return this.cbe.getCreationTime();
    }

    public void setFilterSpecification(String filterSpec) throws InvalidFilterSpecification {
        try {
            Object returnValue = this.api.getFastXPathEngine().getExpression(filterSpec);
            if (returnValue == null) {
                throw new InvalidFilterSpecification(Messages.getString("HyadesGA_FilterExit_Invalid_XPATHFilterSpecification_ERROR_", filterSpec));
            }
        }
        catch (TransformerException e) {
            throw new InvalidFilterSpecification(Messages.getString("HyadesGA_FilterExit_Invalid_XPATHFilterSpecification_ERROR_", filterSpec), e);
        }
        if (filterSpec.indexOf("@creationTime") != -1) {
            this.filterOnCreationTime = true;
        }
        if (filterSpec.indexOf("@severity") != -1) {
            this.filterOnSeverity = true;
        }
        this.filterSpecification = filterSpec;
    }

    public int getDay() {
        return this.day;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getMonth() {
        return this.month;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public ULocale getULocale() {
        return this.uLocale;
    }

    public int getYear() {
        return this.year;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setULocale(ULocale ulocale) {
        this.uLocale = ulocale;
    }

    public void setYear(int year) {
        this.year = year;
    }

    protected boolean isFilterOnSeverity() {
        return this.filterOnSeverity;
    }

    protected boolean isFilterOnCreationTime() {
        return this.filterOnCreationTime;
    }
}

