/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.util.IFilterExit;
import org.eclipse.hyades.logging.adapter.util.InvalidFilterSpecification;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class BasicFilterExit
implements IFilterExit {
    private Pattern compiledExpression = null;

    public boolean filter(String data) throws AdapterException {
        if (this.compiledExpression != null) {
            Matcher matcher = this.compiledExpression.matcher(data);
            boolean found = matcher.find();
            return found;
        }
        throw new AdapterException();
    }

    public void setFilterSpecification(String filterSpec) throws InvalidFilterSpecification {
        try {
            this.compiledExpression = Pattern.compile(filterSpec, 8);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidFilterSpecification(Messages.getString("HyadesGA_FilterExit_Invalid_FilterSpecification_ERROR_", filterSpec), e);
        }
    }
}

