/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.importer;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.hyades.logging.commons.Logger;
import org.eclipse.hyades.logging.core.IPreemptedLogger;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.ParserUtilities;
import org.eclipse.hyades.logging.parsers.internal.importer.GLADebug;
import org.eclipse.hyades.logging.parsers.internal.importer.GLALogger;
import org.eclipse.hyades.logging.parsers.internal.importer.GLALoggerFactory;
import org.eclipse.hyades.logging.parsers.internal.importer.StatusMonitor;

public class RemoteLogParserLoader {
    public static void main(String[] args) {
        Log statusLogger;
        Log logger;
        block56: {
            Thread statusMonitorThread = null;
            logger = null;
            statusLogger = null;
            long maxWaitTimeInMillis = 300000L;
            long statusLoggerWaitTime = 10000L;
            if (GLADebug.INSTANCE.debug) {
                GLADebug.INSTANCE.log("In RemoteLogParserLoader");
            }
            try {
                maxWaitTimeInMillis = Long.parseLong(System.getProperty("org.eclipse.hyades.logging.parsers.maxWaitTimeInMillis"));
            }
            catch (Exception exception) {}
            try {
                int parameterNum;
                System.setProperty("org.apache.commons.logging.Log", "org.eclipse.hyades.logging.parsers.importer.ImportCBELogger");
                logger = LogFactory.getLog((String)"Remote Log Loader IRemoteEntity");
                if (GLADebug.INSTANCE.debug) {
                    GLADebug.INSTANCE.log("RemoteLogParserLoader: Created data logging agent.");
                }
                GLALoggerFactory logFactory = new GLALoggerFactory();
                statusLogger = logFactory.getInstance("Remote Log Loader Status IRemoteEntity");
                if (GLADebug.INSTANCE.debug) {
                    GLADebug.INSTANCE.log("RemoteLogParserLoader: Created status logging agent.");
                }
                if ((parameterNum = args.length) == 0) {
                    throw new LogParserException(ParserUtilities.getResourceString((String)"REMOTE_LOG_PARSER_PARAMETER_ERROR_"));
                }
                int parameterIndex = 0;
                if (GLADebug.INSTANCE.debug) {
                    GLADebug.INSTANCE.log("RemoteLogParserLoader: here were " + parameterNum + " parameters passed on the command line.");
                }
                if (args[parameterIndex].trim().equals("org.eclipse.hyades.logging.parsers.importer.RemoteLogParserLoader")) {
                    ++parameterIndex;
                }
                String parserClassName = null;
                if (parameterNum <= parameterIndex) {
                    throw new LogParserException(ParserUtilities.getResourceString((String)"REMOTE_LOG_PARSER_CLASSNAME_PARAMETER_ERROR_"));
                }
                parserClassName = args[parameterIndex];
                if (GLADebug.INSTANCE.debug) {
                    GLADebug.INSTANCE.log("RemoteLogParserLoader: Parser wrapper class name is " + parserClassName);
                }
                if (parameterNum <= ++parameterIndex) {
                    throw new LogParserException(ParserUtilities.getResourceString((String)"REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
                }
                Hashtable<String, String> parserParameters = new Hashtable<String, String>();
                String keyValuePair = null;
                int equalsSignIndex = -1;
                while (parameterNum > parameterIndex) {
                    String value;
                    String key;
                    if ((equalsSignIndex = (keyValuePair = args[parameterIndex++]).indexOf(61)) == -1) continue;
                    if (keyValuePair.charAt(0) == '\"' && keyValuePair.charAt(keyValuePair.length() - 1) == '\"' && keyValuePair.substring(1, keyValuePair.length() - 1).indexOf(34) == -1) {
                        key = keyValuePair.substring(1, equalsSignIndex);
                        value = keyValuePair.substring(equalsSignIndex + 1, keyValuePair.length() - 1);
                    } else {
                        key = keyValuePair.substring(0, equalsSignIndex);
                        value = keyValuePair.substring(equalsSignIndex + 1);
                    }
                    if (GLADebug.INSTANCE.debug) {
                        GLADebug.INSTANCE.log("RemoteLogParserLoader: Adding entry to hash table with key=" + key + " value=" + value);
                    }
                    parserParameters.put(key, value);
                }
                if (parserParameters.isEmpty()) {
                    throw new LogParserException(ParserUtilities.getResourceString((String)"REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
                }
                Locale clientLocale = null;
                if (parserParameters.containsKey("client_locale_language")) {
                    String clientLanguage = (String)parserParameters.get("client_locale_language");
                    if (parserParameters.containsKey("client_locale_country")) {
                        String clientCountry = (String)parserParameters.get("client_locale_language");
                        clientLocale = parserParameters.containsKey("client_locale_variant") ? new Locale(clientLanguage, clientCountry, (String)parserParameters.get("client_locale_variant")) : new Locale(clientLanguage, clientCountry);
                    } else {
                        clientLocale = new Locale(clientLanguage);
                    }
                }
                if (logger instanceof IPreemptedLogger) {
                    ((IPreemptedLogger)logger).waitUntilLogging(maxWaitTimeInMillis);
                    if (!((IPreemptedLogger)logger).isLogging()) {
                        throw new LogParserException(ParserUtilities.getResourceString((String)"REMOTE_LOG_PARSER_MONITORING_ERROR_", (Locale)clientLocale, (String)parserClassName, (String)String.valueOf((double)maxWaitTimeInMillis / 1000.0)));
                    }
                }
                if (statusLogger instanceof IPreemptedLogger) {
                    ((IPreemptedLogger)statusLogger).waitUntilLogging(statusLoggerWaitTime);
                    if (!((IPreemptedLogger)statusLogger).isLogging()) {
                        ((IPreemptedLogger)statusLogger).finalize();
                        statusLogger = null;
                    }
                }
                try {
                    if (logger instanceof Logger) {
                        ((Logger)logger).setLevel(0);
                    }
                    if (statusLogger != null && statusLogger instanceof GLALogger) {
                        ((Logger)statusLogger).setLevel(0);
                    }
                    if (GLADebug.INSTANCE.debug) {
                        GLADebug.INSTANCE.log("RemoteLogParserLoader: About to get parser wrapper object.");
                    }
                    Class<?> parserClass = Class.forName(parserClassName);
                    Object parser = parserClass.newInstance();
                    if (GLADebug.INSTANCE.debug) {
                        GLADebug.INSTANCE.log("RemoteLogParserLoader: About to call parser wrapper setUserInput.");
                    }
                    parserClass.getMethod("setUserInput", parserParameters.getClass()).invoke(parser, parserParameters);
                    if (statusLogger != null) {
                        if (GLADebug.INSTANCE.debug) {
                            GLADebug.INSTANCE.log("RemoteLogParserLoader: About to call parser wrapper setParserLogger.");
                        }
                        parserClass.getMethod("setParserLogger", Class.forName("org.apache.commons.logging.Log")).invoke(parser, statusLogger);
                        StatusMonitor statusMonitor = new StatusMonitor(parser, parserClass, statusLogger);
                        statusMonitorThread = new Thread(statusMonitor);
                        if (GLADebug.INSTANCE.debug) {
                            GLADebug.INSTANCE.log("RemoteLogParserLoader: About to start status monitor thread.");
                        }
                        statusMonitorThread.start();
                    }
                    if (GLADebug.INSTANCE.debug) {
                        GLADebug.INSTANCE.log("RemoteLogParserLoader: About to call parser wrapper parse.");
                    }
                    parserClass.getMethod("parse", Class.forName("org.apache.commons.logging.Log")).invoke(parser, logger);
                    if (GLADebug.INSTANCE.debug) {
                        GLADebug.INSTANCE.log("RemoteLogParserLoader: Parsing completed!");
                    }
                    if (statusLogger != null) {
                        statusMonitorThread.interrupt();
                    }
                    if (GLADebug.INSTANCE.debug) {
                        GLADebug.INSTANCE.log("RemoteLogParserLoader: After stopping status monitoring thread.");
                    }
                }
                catch (InvocationTargetException i) {
                    if (GLADebug.INSTANCE.debug) {
                        GLADebug.INSTANCE.log("RemoteLogParserLoader: Caught InvocationTargetException: " + i.getTargetException().getMessage());
                    }
                    if (statusMonitorThread != null) {
                        statusMonitorThread.interrupt();
                    }
                    throw new LogParserException(ParserUtilities.getResourceString((String)"REMOTE_LOG_PARSER_EXECUTION_ERROR_", (Locale)clientLocale, (String)parserClassName, (String)i.getTargetException().getLocalizedMessage()));
                }
                catch (Throwable t) {
                    if (GLADebug.INSTANCE.debug) {
                        GLADebug.INSTANCE.log("RemoteLogParserLoader: Caught exception from reflection block: " + t.getMessage());
                    }
                    if (statusMonitorThread != null) {
                        statusMonitorThread.interrupt();
                    }
                    throw new LogParserException(ParserUtilities.getResourceString((String)"REMOTE_LOG_PARSER_INITIALIZATION_ERROR_", (Locale)clientLocale, (String)parserClassName), t);
                }
            }
            catch (Throwable t) {
                String errMessage;
                if (GLADebug.INSTANCE.debug) {
                    GLADebug.INSTANCE.log("RemoteLogParserLoader: Caught throwable from main block: " + t.toString());
                }
                if ((errMessage = t.getMessage()) == null) {
                    errMessage = t.toString();
                }
                LoggingAgent errorLogger = new LoggingAgent("Remote Log Loader Error IRemoteEntity");
                errorLogger.waitUntilLogging(maxWaitTimeInMillis);
                if (errorLogger.isLogging()) {
                    errorLogger.write(errMessage);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    System.err.println(errMessage);
                }
                if (GLADebug.INSTANCE.debug) {
                    GLADebug.INSTANCE.log("RemoteLogParserLoader: About to deregister error agent.");
                }
                errorLogger.deregister();
                if (!GLADebug.INSTANCE.debug) break block56;
                GLADebug.INSTANCE.log("RemoteLogParserLoader: After deregistering error agent.");
            }
        }
        if (logger != null && logger instanceof IPreemptedLogger) {
            if (GLADebug.INSTANCE.debug) {
                GLADebug.INSTANCE.log("RemoteLogParserLoader: About to finalize data agent.");
            }
            ((IPreemptedLogger)logger).finalize();
            if (GLADebug.INSTANCE.debug) {
                GLADebug.INSTANCE.log("RemoteLogParserLoader: After finalizing data agent.");
            }
        }
        if (statusLogger != null && statusLogger instanceof IPreemptedLogger) {
            if (GLADebug.INSTANCE.debug) {
                GLADebug.INSTANCE.log("RemoteLogParserLoader: About to finalize status agent.");
            }
            ((IPreemptedLogger)statusLogger).finalize();
            if (GLADebug.INSTANCE.debug) {
                GLADebug.INSTANCE.log("RemoteLogParserLoader: After finalizing status agent.");
            }
        }
    }
}

