/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.internal.adapter.formatters;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.ICBEPropertyConstants;
import org.eclipse.hyades.logging.adapter.IDirectedGraph;
import org.eclipse.hyades.logging.adapter.IFormatter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.util.SequenceNumbersByTime;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.parsers.importer.ParserWrapper;
import org.eclipse.hyades.logging.parsers.internal.importer.LocalLogImportLoader;

public class LocalLogImportCBEFormatter
extends ProcessUnit
implements IFormatter,
ICBEPropertyConstants {
    private Log logger;
    private static final String BUILTIN = "##BUILTIN";
    private String localHostId = null;
    private String localHostIdFormat = null;
    private boolean set_version = false;
    private boolean setSequenceNumber = false;
    private SequenceNumbersByTime seqNums = null;
    private XMLLoader xmlLoader;
    private final int COMMONBASEEVENT_ATTRIBUTES_INDEX = 0;
    private final int COMMONBASEEVENT_CONTEXTDATAELEMENTS_INDEX = 1;
    private final int COMMONBASEEVENT_REPORTER_SOURCE_COMPONENTID_INDEX = 2;
    private final int COMMONBASEEVENT_SITUATION_INDEX = 3;
    private final int COMMONBASEEVENT_ASSOCIATEDEVENTS_INDEX = 4;
    private final int COMMONBASEEVENT_EXTENDEDDATAELEMENTS_INDEX = 5;
    private final int COMMONBASEEVENT_MSGDATAELEMENT_INDEX = 6;
    private final int COMMONBASEEVENT_LAST_INDEX = 7;
    private HashMap[] commonBaseEventMaps = new HashMap[7];
    private final int DEFAULT_EXTENDED_DATA_PROPERTY_INDEX = 4;
    private int CHECK_ALL_REQURIED_PROPERTIES = 0;
    private final int CONTAIN_LOCATION = 1;
    private final int CONTAIN_LOCATION_TYPE = 2;
    private final int CONTAIN_COMPONENT = 4;
    private final int CONTAIN_SUB_COMPONENT = 8;
    private final int CONTAIN_COMPONENT_ID_TYPE = 16;
    private final int CONTAIN_COMPONENT_TYPE = 32;
    private final int CONTAIN_ALL_REQURIED_COMPONENTIDENTIFICATION_PROPERTIES = 63;
    private final int CONTAIN_SITUATION_TYPE = 1;
    private final int CONTAIN_CATEGORY_NAME = 2;
    private final int CONTAIN_ALL_REQURIED_SITUATION_PROPERTIES = 3;
    private static final String NONE = "None";
    private static final String UNKNOWN_HOST = "Unknown Host";
    private static final String VERSION_DEFAULT = "1.0.1";
    private static final String LOCATION_TYPE_IPV4 = "IPV4";
    private static final String LOCATION_TYPE_IPV6 = "IPV6";
    private static final String LOCATION_TYPE_NWA = "NWA";
    private static final String LOCATION_TYPE_ISDN = "ISDN";
    private static final String LOCATION_TYPE_ICD = "ICD";
    private static final String LOCATION_TYPE_OID_OSI = "OID-OSI";
    private static final String LOCATION_TYPE_DIAL = "Dial";
    private static final String LOCATION_TYPE_HWA = "HWA";
    private static final String LOCATION_TYPE_HID = "HID";
    private static final String LOCATION_TYPE_X25 = "X25";
    private static final String LOCATION_TYPE_DCC = "DCC";
    private static final String LOCATION_TYPE_SNA = "SNA";
    private static final String LOCATION_TYPE_IPX = "IPX";
    private static final String LOCATION_TYPE_E_164 = "E.164";
    private static final String LOCATION_TYPE_HOSTNAME = "Hostname";
    private static final String LOCATION_TYPE_FQ_HOSTNAME = "FQHostname";
    private static final String LOCATION_TYPE_DEVICE_NAME = "Devicename";
    private static final String LOCATION_TYPE_UNKNOWN = "Unknown";

    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null || msgs.length == 0) {
            return null;
        }
        this.processDirectedGraphs(msgs);
        return null;
    }

    private void processDirectedGraphs(Object[] msgs) {
        if (this.xmlLoader == null) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_LOCAL_LOG_IMPORT_CBE_Formatter_XMLLoader_ERROR_");
            event.setSeverity((short)50);
            return;
        }
        int k = 0;
        while (k < msgs.length) {
            int i = 0;
            while (i < this.commonBaseEventMaps.length) {
                this.commonBaseEventMaps[i] = new HashMap();
                ++i;
            }
            boolean validateCreationTime = false;
            Iterator ni = ((List)msgs[k]).iterator();
            while (ni.hasNext()) {
                String key;
                IDirectedGraph graphEntry = (IDirectedGraph)ni.next();
                List path = graphEntry.getPath();
                if (!((String)path.get(0)).equals("CommonBaseEvent")) continue;
                String elementTag = (String)path.get(2);
                if (elementTag.equals("extensionName") || elementTag.equals("severity") || elementTag.equals("priority") || elementTag.equals("repeatCount") || elementTag.equals("elapsedTime") || elementTag.equals("version") || elementTag.equals("##other") || elementTag.equals("localInstanceId") || elementTag.equals("globalInstanceId") || elementTag.equals("msg") || elementTag.equals("sequenceNumber")) {
                    key = "CommonBaseEvent";
                    ArrayList<IDirectedGraph> commonBaseEventElements = (ArrayList<IDirectedGraph>)this.commonBaseEventMaps[0].get(key);
                    if (commonBaseEventElements == null) {
                        commonBaseEventElements = new ArrayList<IDirectedGraph>();
                        this.commonBaseEventMaps[0].put(key, commonBaseEventElements);
                    }
                    commonBaseEventElements.add(graphEntry);
                    continue;
                }
                if (elementTag.equals("creationTime")) {
                    this.xmlLoader.attributeName("creationTime");
                    if (!(graphEntry.getValue() instanceof String)) {
                        try {
                            Long lValue = (Long)graphEntry.getValue();
                            EventHelpers.longToDate((long)lValue);
                        }
                        catch (Exception exception) {
                            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "creationTime"});
                            event.setSeverity((short)50);
                            this.log(event);
                            break;
                        }
                    }
                    validateCreationTime = true;
                    String key2 = "CommonBaseEvent";
                    ArrayList<IDirectedGraph> commonBaseEventElements = (ArrayList<IDirectedGraph>)this.commonBaseEventMaps[0].get(key2);
                    if (commonBaseEventElements == null) {
                        commonBaseEventElements = new ArrayList<IDirectedGraph>();
                        this.commonBaseEventMaps[0].put(key2, commonBaseEventElements);
                    }
                    commonBaseEventElements.add(graphEntry);
                    continue;
                }
                if (elementTag.equals("msgDataElement")) {
                    key = elementTag;
                    ArrayList<IDirectedGraph> msgDataElements = (ArrayList<IDirectedGraph>)this.commonBaseEventMaps[6].get(key);
                    if (msgDataElements == null) {
                        msgDataElements = new ArrayList<IDirectedGraph>();
                        this.commonBaseEventMaps[6].put(key, msgDataElements);
                    }
                    msgDataElements.add(graphEntry);
                    continue;
                }
                if (elementTag.equals("contextDataElements")) {
                    key = String.valueOf(elementTag) + (String)path.get(3);
                    ArrayList<IDirectedGraph> contextDataElements = (ArrayList<IDirectedGraph>)this.commonBaseEventMaps[1].get(key);
                    if (contextDataElements == null) {
                        contextDataElements = new ArrayList<IDirectedGraph>();
                        this.commonBaseEventMaps[1].put(key, contextDataElements);
                    }
                    contextDataElements.add(graphEntry);
                    continue;
                }
                if (elementTag.equals("reporterComponentId") || elementTag.equals("sourceComponentId")) {
                    int checkElement;
                    key = String.valueOf((String)path.get(2)) + (String)path.get(3);
                    ArrayList<Integer> sourceOrReportElements = (ArrayList<Integer>)this.commonBaseEventMaps[2].get(key);
                    if (sourceOrReportElements == null) {
                        sourceOrReportElements = new ArrayList<Integer>();
                        sourceOrReportElements.add(new Integer(0));
                        this.commonBaseEventMaps[2].put(key, sourceOrReportElements);
                    }
                    if ((checkElement = this.validateComponentIdentificationElement((Integer)sourceOrReportElements.get(0), graphEntry)) == -1) break;
                    sourceOrReportElements.set(0, new Integer(checkElement));
                    sourceOrReportElements.add((Integer)graphEntry);
                    continue;
                }
                if (elementTag.equals("situation")) {
                    int checkElement;
                    key = String.valueOf((String)path.get(2)) + (String)path.get(3);
                    ArrayList<Integer> situationElements = (ArrayList<Integer>)this.commonBaseEventMaps[3].get(key);
                    if (situationElements == null) {
                        situationElements = new ArrayList<Integer>();
                        situationElements.add(new Integer(0));
                        this.commonBaseEventMaps[3].put(key, situationElements);
                    }
                    if ((checkElement = this.validateSituationElement((Integer)situationElements.get(0), graphEntry)) == -1) break;
                    situationElements.set(0, new Integer(checkElement));
                    situationElements.add((Integer)graphEntry);
                    continue;
                }
                if (elementTag.startsWith("associatedEvents")) {
                    key = String.valueOf((String)path.get(2)) + (String)path.get(3);
                    ArrayList<IDirectedGraph> associatedEventElements = (ArrayList<IDirectedGraph>)this.commonBaseEventMaps[4].get(key);
                    if (associatedEventElements == null) {
                        associatedEventElements = new ArrayList<IDirectedGraph>();
                        this.commonBaseEventMaps[4].put(key, associatedEventElements);
                    }
                    associatedEventElements.add(graphEntry);
                    continue;
                }
                if (elementTag.startsWith("extendedDataElements")) {
                    key = String.valueOf((String)path.get(2)) + (String)path.get(3);
                    ArrayList<IDirectedGraph> sameExtendedDataElements = (ArrayList<IDirectedGraph>)this.commonBaseEventMaps[5].get(key);
                    if (sameExtendedDataElements == null) {
                        sameExtendedDataElements = new ArrayList<IDirectedGraph>();
                        this.commonBaseEventMaps[5].put(key, sameExtendedDataElements);
                    }
                    sameExtendedDataElements.add(graphEntry);
                    continue;
                }
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Property_WARN_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(0)});
                event.setSeverity((short)30);
                this.log(event);
            }
            if (validateCreationTime && this.validateComponentIdentification(this.commonBaseEventMaps[2]) && this.validateSituationElements(this.commonBaseEventMaps[3])) {
                String guid = Guid.generate();
                this.xmlLoader.startElement("CommonBaseEvent", false, false);
                this.xmlLoader.attributeName("globalInstanceId");
                this.xmlLoader.attributeValueCharacters(guid);
                this.createModelElements();
                this.xmlLoader.endElement("CommonBaseEvent", 0);
                this.incrementItemsProcessedCount();
            }
            ++k;
        }
        this.trace("HyadesGATrace_Component_Processing_End_INFO_", this.getName(), Integer.toString(this.getItemsProcessedCount()));
    }

    public void update() throws AdapterInvalidConfig {
        String key = null;
        super.update();
        Hashtable formatterProperties = this.getProperties();
        if (formatterProperties != null && !formatterProperties.isEmpty()) {
            key = (String)formatterProperties.get("loggerKey");
        }
        if (key != null) {
            this.logger = ParserWrapper.getLogInstance(key);
            if (this.logger instanceof LocalLogImportLoader) {
                this.xmlLoader = ((LocalLogImportLoader)this.logger).getXMLLoader();
            }
        }
    }

    private void getLocalHostInfo() {
        try {
            this.localHostId = InetAddress.getLocalHost().getHostAddress();
            this.localHostIdFormat = this.localHostId.indexOf(58) != -1 ? LOCATION_TYPE_IPV6 : LOCATION_TYPE_IPV4;
        }
        catch (Exception exception) {
            this.localHostId = UNKNOWN_HOST;
            this.localHostIdFormat = NONE;
        }
    }

    private String getLocalHostId() {
        if (this.localHostId == null) {
            this.getLocalHostInfo();
        }
        return this.localHostId;
    }

    private String getLocalHostIdFormat() {
        if (this.localHostIdFormat == null) {
            this.getLocalHostInfo();
        }
        return this.localHostIdFormat;
    }

    private void createSituationElement(HashMap situationElementMap) {
        Iterator elementGroup = situationElementMap.values().iterator();
        while (elementGroup.hasNext()) {
            ArrayList graphEntries = (ArrayList)elementGroup.next();
            this.xmlLoader.startElement("situation", false, false);
            int i = 1;
            while (i < graphEntries.size()) {
                IDirectedGraph graphEntry = (IDirectedGraph)graphEntries.get(i);
                List path = graphEntry.getPath();
                String elementTag = (String)path.get(4);
                if (((String)path.get(4)).equals("categoryName")) {
                    this.xmlLoader.attributeName("categoryName");
                    this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                } else if (elementTag.equals("AvailableSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("AvailableSituation") || elementTag.equals("RequestSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("RequestSituation") || elementTag.equals("StartSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("StartSituation") || elementTag.equals("StopSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("StopSituation") || elementTag.equals("ConnectSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("ConnectSituation") || elementTag.equals("ConfigureSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("ConfigureSituation") || elementTag.equals("CreateSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("CreateSituation") || elementTag.equals("DestroySituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("DestroySituation") || elementTag.equals("ReportSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("ReportSituation") || elementTag.equals("FeatureSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("FeatureSituation") || elementTag.equals("DependencySituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("DependencySituation") || elementTag.equals("OtherSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("OtherSituation")) {
                    this.xmlLoader.attributeName("categoryName");
                    int pindex = 6;
                    if (elementTag.equals("situationType")) {
                        this.xmlLoader.attributeValueCharacters((String)path.get(6));
                        pindex = 8;
                    } else {
                        this.xmlLoader.attributeValueCharacters((String)path.get(4));
                    }
                    this.xmlLoader.startElement("situationType", false, false);
                    this.xmlLoader.attributeName((String)path.get(pindex));
                    this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                    this.xmlLoader.endElement("situationType", 0);
                } else {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_SituationType_WARN_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(6)});
                    event.setSeverity((short)30);
                    this.log(event);
                }
                ++i;
            }
            this.xmlLoader.endElement("situation", 0);
        }
    }

    private void createExtendedDataElement(HashMap extetendedDataElementMap, int propertyIndex, boolean childrenElement) {
        Iterator elementGroup = extetendedDataElementMap.values().iterator();
        while (elementGroup.hasNext()) {
            ArrayList graphEntries = (ArrayList)elementGroup.next();
            if (childrenElement) {
                this.xmlLoader.startElement("children", false, false);
            } else {
                this.xmlLoader.startElement("extendedDataElements", false, false);
            }
            ArrayList<IDirectedGraph> valueEntires = new ArrayList<IDirectedGraph>();
            HashMap<String, ArrayList<IDirectedGraph>> childrenMap = null;
            boolean set_value_or_hexvalue = false;
            int i = 0;
            while (i < graphEntries.size()) {
                IDirectedGraph graphEntry = (IDirectedGraph)graphEntries.get(i);
                List path = graphEntry.getPath();
                String property = (String)path.get(propertyIndex);
                if (property.equals("name")) {
                    this.xmlLoader.attributeName("name");
                    this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                } else if (property.equals("type")) {
                    this.xmlLoader.attributeName("type");
                    this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                } else if (property.equals("values")) {
                    if (set_value_or_hexvalue) {
                        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ExtendedDataElement_WARN_");
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), property, "values"});
                        event.setSeverity((short)30);
                        this.log(event);
                    } else {
                        valueEntires.add(graphEntry);
                        set_value_or_hexvalue = true;
                    }
                } else if (property.equals("hexValue")) {
                    if (set_value_or_hexvalue) {
                        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ExtendedDataElement_WARN_");
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), property, "values"});
                        event.setSeverity((short)30);
                        this.log(event);
                    } else {
                        set_value_or_hexvalue = true;
                        this.xmlLoader.attributeName("type");
                        this.xmlLoader.attributeValueCharacters("hexBinary");
                        this.xmlLoader.attributeName("hexValue");
                        this.xmlLoader.attributeValueCharacters((char[])graphEntry.getValue());
                    }
                } else if (property.equals("children")) {
                    if (childrenMap == null) {
                        childrenMap = new HashMap<String, ArrayList<IDirectedGraph>>();
                    }
                    int childPropertyIndex = propertyIndex + 1;
                    String childEDKey = String.valueOf(property) + (String)path.get(childPropertyIndex);
                    ArrayList<IDirectedGraph> childrendList = (ArrayList<IDirectedGraph>)childrenMap.get(childEDKey);
                    if (childrendList == null) {
                        childrendList = new ArrayList<IDirectedGraph>();
                        childrenMap.put(childEDKey, childrendList);
                    }
                    childrendList.add(graphEntry);
                } else {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_ExtendedDataElement_WARN_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), property});
                    event.setSeverity((short)30);
                    this.log(event);
                }
                ++i;
            }
            int v = 0;
            while (v < valueEntires.size()) {
                IDirectedGraph valueGraphEntry = (IDirectedGraph)valueEntires.get(v);
                int valuesLength = 0;
                String value = (String)valueGraphEntry.getValue();
                if (value != null && (valuesLength = value.trim().length()) > 1024) {
                    this.xmlLoader.attributeName("type");
                    this.xmlLoader.attributeValueCharacters("stringArray");
                    int counter = 0;
                    while (counter < valuesLength) {
                        this.xmlLoader.startElement("values", false, false);
                        String subValue = value.substring(counter, Math.min(counter + 1024, valuesLength));
                        this.xmlLoader.characters(subValue.toCharArray(), 0, subValue.length());
                        this.xmlLoader.endElement("values", 0);
                        counter += 1024;
                    }
                } else {
                    this.xmlLoader.startElement("values", false, false);
                    this.xmlLoader.characters(value.toCharArray(), 0, value.length());
                    this.xmlLoader.endElement("values", 0);
                }
                ++v;
            }
            if (childrenMap != null) {
                this.createExtendedDataElement(childrenMap, propertyIndex + 2, true);
            }
            if (childrenElement) {
                this.xmlLoader.endElement("children", 0);
                continue;
            }
            this.xmlLoader.endElement("extendedDataElements", 0);
        }
    }

    private void createContextElement(HashMap contextElementMap) {
        Iterator elementGroup = contextElementMap.values().iterator();
        while (elementGroup.hasNext()) {
            ArrayList graphEntries = (ArrayList)elementGroup.next();
            this.xmlLoader.startElement("contextDataElements", false, false);
            boolean exist_contextValue_or_contextId = false;
            int i = 0;
            while (i < graphEntries.size()) {
                CommonBaseEvent event;
                IDirectedGraph graphEntry = (IDirectedGraph)graphEntries.get(i);
                List path = graphEntry.getPath();
                if (((String)path.get(4)).equals("contextId")) {
                    if (exist_contextValue_or_contextId) {
                        event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ContextDataElement_WARN_");
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4), "contextValue"});
                        event.setSeverity((short)30);
                        this.log(event);
                    } else {
                        this.xmlLoader.attributeName("contextId");
                        this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                        exist_contextValue_or_contextId = true;
                    }
                } else if (((String)path.get(4)).equals("type")) {
                    this.xmlLoader.attributeName("type");
                    this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                } else if (((String)path.get(4)).equals("name")) {
                    this.xmlLoader.attributeName("name");
                    this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                } else if (((String)path.get(4)).equals("contextValue")) {
                    if (exist_contextValue_or_contextId) {
                        event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ContextDataElement_WARN_");
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4), "contextId"});
                        event.setSeverity((short)30);
                        this.log(event);
                    } else {
                        this.xmlLoader.attributeName("contextValue");
                        this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                        exist_contextValue_or_contextId = true;
                    }
                } else {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ContextDataElement_WARN_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                    event.setSeverity((short)30);
                    this.log(event);
                }
                ++i;
            }
            this.xmlLoader.endElement("contextDataElements", 0);
        }
    }

    private void createMsgDataElement(HashMap msgDataElementMap) {
        Iterator elementGroup = msgDataElementMap.values().iterator();
        while (elementGroup.hasNext()) {
            ArrayList graphEntries = (ArrayList)elementGroup.next();
            this.xmlLoader.startElement("msgDataElement", false, false);
            int i = 0;
            while (i < graphEntries.size()) {
                IDirectedGraph graphEntry = (IDirectedGraph)graphEntries.get(i);
                List path = graphEntry.getPath();
                String elementTag = (String)path.get(4);
                if (elementTag.equals("msgId") || elementTag.equals("msgIdType") || elementTag.equals("msgCatalogId") || elementTag.equals("msgCatalogType") || elementTag.equals("msgCatalog") || elementTag.equals("msgLocale")) {
                    this.xmlLoader.attributeName(elementTag);
                    this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                } else if (elementTag.equals("msgCatalogTokens")) {
                    this.xmlLoader.attributeName("msgCatalogTokens");
                    String msgCatTok = (String)graphEntry.getValue();
                    if (msgCatTok != null && msgCatTok.length() > 0) {
                        this.xmlLoader.attributeValueCharacters(msgCatTok);
                    }
                } else {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_MsgDataElement_WARN_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                    event.setSeverity((short)30);
                    this.log(event);
                }
                ++i;
            }
            this.xmlLoader.endElement("msgDataElement", 0);
        }
    }

    private void createAssociateEventElement(HashMap associateEventElementMap) {
        Iterator elementGroup = associateEventElementMap.values().iterator();
        while (elementGroup.hasNext()) {
            ArrayList graphEntries = (ArrayList)elementGroup.next();
            this.xmlLoader.startElement("associatedEvents", false, false);
            ArrayList<IDirectedGraph> associateionInfoList = new ArrayList<IDirectedGraph>();
            int i = 0;
            while (i < graphEntries.size()) {
                CommonBaseEvent event;
                IDirectedGraph graphEntry = (IDirectedGraph)graphEntries.get(i);
                List path = graphEntry.getPath();
                if (((String)path.get(4)).equals("associationEngine")) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociatedEvent_WARN_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                    event.setSeverity((short)30);
                    this.log(event);
                } else if (((String)path.get(4)).equals("associationEngineInfo")) {
                    associateionInfoList.add(graphEntry);
                } else if (((String)path.get(4)).equals("resolvedEvents")) {
                    this.xmlLoader.attributeName("resolvedEvents");
                    this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                } else {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociatedEvent_WARN_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                    event.setSeverity((short)30);
                    this.log(event);
                }
                ++i;
            }
            if (associateionInfoList.size() > 0) {
                boolean set_gid = false;
                this.xmlLoader.startElement("associationEngineInfo", false, false);
                int a = 0;
                while (a < associateionInfoList.size()) {
                    IDirectedGraph associationInfoEntry = (IDirectedGraph)associateionInfoList.get(a);
                    List path = associationInfoEntry.getPath();
                    String elementTag = (String)path.get(6);
                    if (elementTag.equals("id") || elementTag.equals("name") || elementTag.equals("type")) {
                        this.xmlLoader.attributeName(elementTag);
                        this.xmlLoader.attributeValueCharacters((String)associationInfoEntry.getValue());
                        if (elementTag.equals("id")) {
                            set_gid = true;
                        }
                    } else {
                        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociationEngine_WARN_");
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(6)});
                        event.setSeverity((short)30);
                        this.log(event);
                    }
                    ++a;
                }
                if (!set_gid) {
                    this.xmlLoader.attributeName("id");
                    this.xmlLoader.attributeValueCharacters(Guid.generate());
                }
                this.xmlLoader.endElement("associationEngineInfo", 0);
            }
            this.xmlLoader.endElement("associatedEvents", 0);
        }
    }

    private void createReportComponent_or_SoucreComponenElement(HashMap componentElementMap) {
        Iterator elementGroup = componentElementMap.values().iterator();
        while (elementGroup.hasNext()) {
            ArrayList graphEntries = (ArrayList)elementGroup.next();
            List path = ((IDirectedGraph)graphEntries.get(1)).getPath();
            if (((String)path.get(2)).equals("reporterComponentId")) {
                this.xmlLoader.startElement("reporterComponentId", false, false);
            } else {
                this.xmlLoader.startElement("sourceComponentId", false, false);
            }
            int i = 1;
            while (i < graphEntries.size()) {
                String value;
                IDirectedGraph graphEntry = (IDirectedGraph)graphEntries.get(i);
                path = graphEntry.getPath();
                String elementTag = (String)path.get(4);
                if (elementTag.equals("location")) {
                    value = (String)graphEntry.getValue();
                    if (value.equals(BUILTIN)) {
                        value = this.getLocalHostId();
                    }
                    this.xmlLoader.attributeName("location");
                    this.xmlLoader.attributeValueCharacters(value);
                } else if (((String)path.get(4)).equals("locationType")) {
                    value = (String)graphEntry.getValue();
                    if (value.equals(BUILTIN)) {
                        value = this.getLocalHostIdFormat();
                    }
                    this.xmlLoader.attributeName("locationType");
                    this.xmlLoader.attributeValueCharacters(value);
                } else if (elementTag.equals("application") || elementTag.equals("executionEnvironment") || elementTag.equals("component") || elementTag.equals("subComponent") || elementTag.equals("componentIdType") || elementTag.equals("componentType") || elementTag.equals("processId") || elementTag.equals("threadId") || elementTag.equals("instanceId")) {
                    this.xmlLoader.attributeName(elementTag);
                    this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                } else {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ComponentIdentification_WARN_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                    event.setSeverity((short)30);
                    this.log(event);
                }
                ++i;
            }
            if (((String)path.get(2)).equals("reporterComponentId")) {
                this.xmlLoader.endElement("reporterComponentId", 0);
                continue;
            }
            this.xmlLoader.endElement("sourceComponentId", 0);
        }
    }

    private void createCommonBaseEventAttributes(HashMap componentElementMap) {
        Iterator elementGroup = componentElementMap.values().iterator();
        ArrayList<String> longMsgs = new ArrayList<String>();
        ArrayList<String> otherData = new ArrayList<String>();
        String creationTime = "";
        while (elementGroup.hasNext()) {
            ArrayList graphEntries = (ArrayList)elementGroup.next();
            List path = ((IDirectedGraph)graphEntries.get(0)).getPath();
            int i = 0;
            while (i < graphEntries.size()) {
                String value;
                IDirectedGraph graphEntry = (IDirectedGraph)graphEntries.get(i);
                path = graphEntry.getPath();
                String elementTag = (String)path.get(2);
                if (elementTag.equals("extensionName") || elementTag.equals("severity") || elementTag.equals("priority") || elementTag.equals("repeatCount") || elementTag.equals("elapsedTime") || elementTag.equals("version")) {
                    this.xmlLoader.attributeName(elementTag);
                    this.xmlLoader.attributeValueCharacters((String)graphEntry.getValue());
                    if (elementTag.equals("version")) {
                        this.set_version = true;
                    }
                } else if (elementTag.equals("creationTime")) {
                    this.xmlLoader.attributeName("creationTime");
                    String strValue = "";
                    try {
                        strValue = (String)graphEntry.getValue();
                        this.xmlLoader.attributeValueCharacters(strValue);
                        creationTime = strValue;
                    }
                    catch (ClassCastException classCastException) {
                        Long lValue = (Long)graphEntry.getValue();
                        strValue = EventHelpers.longToDate((long)lValue);
                        this.xmlLoader.attributeValueCharacters(strValue);
                        creationTime = strValue;
                    }
                } else if (elementTag.equals("localInstanceId")) {
                    this.xmlLoader.attributeName("localInstanceId");
                    value = (String)graphEntry.getValue();
                    if (value.equals(BUILTIN)) {
                        value = String.valueOf(this.getLocalHostId()) + System.currentTimeMillis() + Integer.toString("localInstanceId".hashCode());
                    }
                    this.xmlLoader.attributeValueCharacters(value);
                } else if (elementTag.equals("globalInstanceId")) {
                    this.xmlLoader.attributeName("globalInstanceId");
                    value = (String)graphEntry.getValue();
                    if (value.equals(BUILTIN)) {
                        value = new Guid().toString();
                    }
                    this.xmlLoader.attributeValueCharacters(value);
                } else if (elementTag.equals("##other")) {
                    otherData.add((String)graphEntry.getValue());
                } else if (elementTag.equals("msg")) {
                    String message = (String)graphEntry.getValue();
                    int msgLength = message.length();
                    if (msgLength <= 1024) {
                        this.xmlLoader.attributeName("msg");
                        this.xmlLoader.attributeValueCharacters(message);
                    } else {
                        this.xmlLoader.attributeName("msg");
                        this.xmlLoader.attributeValueCharacters(message.substring(0, 1024));
                        longMsgs.add(message);
                    }
                } else if (elementTag.equals("sequenceNumber")) {
                    value = (String)graphEntry.getValue();
                    if (value.equals(BUILTIN)) {
                        this.setSequenceNumber = true;
                    } else {
                        this.xmlLoader.attributeName("sequenceNumber");
                        this.xmlLoader.attributeValueCharacters(value);
                    }
                }
                ++i;
            }
        }
        if (!this.set_version) {
            this.xmlLoader.attributeName("version");
            this.xmlLoader.attributeValueCharacters(VERSION_DEFAULT);
        }
        if (this.setSequenceNumber) {
            if (this.seqNums == null) {
                this.seqNums = new SequenceNumbersByTime();
            }
            this.xmlLoader.attributeName("sequenceNumber");
            String seqNumStr = Long.toString(this.seqNums.getSequenceNumber(creationTime));
            this.xmlLoader.attributeValueCharacters(seqNumStr);
        }
        int k = 0;
        while (k < longMsgs.size()) {
            String msg = (String)longMsgs.get(k);
            int msgLength = msg.length();
            this.xmlLoader.startElement("extendedDataElements", false, false);
            this.xmlLoader.attributeName("name");
            this.xmlLoader.attributeValueCharacters("message");
            this.xmlLoader.attributeName("type");
            this.xmlLoader.attributeValueCharacters("stringArray");
            int counter = 0;
            while (counter < msgLength) {
                this.xmlLoader.startElement("values", false, false);
                String subValue = msg.substring(counter, Math.min(counter + 1024, msgLength));
                this.xmlLoader.characters(subValue.toCharArray(), 0, subValue.length());
                this.xmlLoader.endElement("values", 0);
                counter += 1024;
            }
            this.xmlLoader.endElement("extendedDataElements", 0);
            ++k;
        }
        int d = 0;
        while (d < otherData.size()) {
            String otherDataValue = (String)otherData.get(d);
            this.xmlLoader.startElement("otherData", false, false);
            this.xmlLoader.characters(otherDataValue.toCharArray(), 0, otherDataValue.length());
            this.xmlLoader.endElement("otherData", 0);
            ++d;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateComponentIdentification(HashMap ids) {
        this.CHECK_ALL_REQURIED_PROPERTIES = 0;
        elementGroup = ids.values().iterator();
        if (elementGroup.hasNext()) ** GOTO lbl50
        return false;
lbl-1000:
        // 1 sources

        {
            graphEntries = (ArrayList)elementGroup.next();
            this.CHECK_ALL_REQURIED_PROPERTIES = (Integer)graphEntries.get(0);
            if (this.CHECK_ALL_REQURIED_PROPERTIES == 63) continue;
            if ((this.CHECK_ALL_REQURIED_PROPERTIES & 1) != 1) {
                event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "location"});
                event.setSeverity((short)50);
                this.log(event);
                return false;
            }
            if ((this.CHECK_ALL_REQURIED_PROPERTIES & 2) != 2) {
                event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "locationType"});
                event.setSeverity((short)50);
                this.log(event);
                return false;
            }
            if ((this.CHECK_ALL_REQURIED_PROPERTIES & 4) != 4) {
                event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "component"});
                event.setSeverity((short)50);
                this.log(event);
                return false;
            }
            if ((this.CHECK_ALL_REQURIED_PROPERTIES & 16) != 16) {
                event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "componentIdType"});
                event.setSeverity((short)50);
                this.log(event);
                return false;
            }
            if ((this.CHECK_ALL_REQURIED_PROPERTIES & 32) != 32) {
                event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "componentType"});
                event.setSeverity((short)50);
                this.log(event);
                return false;
            }
            if ((this.CHECK_ALL_REQURIED_PROPERTIES & 8) == 8) continue;
            event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "subComponent"});
            event.setSeverity((short)50);
            this.log(event);
            return false;
lbl50:
            // 3 sources

            ** while (elementGroup.hasNext())
        }
lbl51:
        // 1 sources

        return true;
    }

    private int validateComponentIdentificationElement(Integer containProperties, IDirectedGraph graphEntry) {
        int CHECK_ALL_REQURIED_PROPERTIES = containProperties;
        List path = graphEntry.getPath();
        String elementTag = (String)path.get(4);
        if (elementTag.equals("location")) {
            CHECK_ALL_REQURIED_PROPERTIES |= 1;
            String location = (String)graphEntry.getValue();
            if (location.equals(BUILTIN)) {
                location = this.getLocalHostId();
            }
            if (location.length() > 256) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.Location", (Object)location, (Object)new Integer(location.length()), (Object)new Integer(256));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (((String)path.get(4)).equals("locationType")) {
            CHECK_ALL_REQURIED_PROPERTIES |= 2;
            String locationType = (String)graphEntry.getValue();
            String errMsg = "";
            if (locationType.equals(BUILTIN)) {
                locationType = this.getLocalHostIdFormat();
            }
            if (locationType.length() > 32) {
                errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.LocationType", (Object)locationType, (Object)new Integer(locationType.length()), (Object)new Integer(32));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
            if (!(locationType.equals(LOCATION_TYPE_UNKNOWN) || locationType.equals(LOCATION_TYPE_IPV4) || locationType.equals(LOCATION_TYPE_IPV6) || locationType.equals(LOCATION_TYPE_NWA) || locationType.equals(LOCATION_TYPE_ISDN) || locationType.equals(LOCATION_TYPE_ICD) || locationType.equals(LOCATION_TYPE_OID_OSI) || locationType.equals(LOCATION_TYPE_DIAL) || locationType.equals(LOCATION_TYPE_HWA) || locationType.equals(LOCATION_TYPE_HID) || locationType.equals(LOCATION_TYPE_X25) || locationType.equals(LOCATION_TYPE_DCC) || locationType.equals(LOCATION_TYPE_SNA) || locationType.equals(LOCATION_TYPE_IPX) || locationType.equals(LOCATION_TYPE_E_164) || locationType.equals(LOCATION_TYPE_HOSTNAME) || locationType.equals(LOCATION_TYPE_FQ_HOSTNAME) || locationType.equals(LOCATION_TYPE_DEVICE_NAME))) {
                errMsg = EventHelpers.getString((String)"LOG_COMPONENT_IDENTIFICATION_INVALID_LOCATION_TYPE_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.LocationType", (Object)locationType);
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (elementTag.equals("component")) {
            CHECK_ALL_REQURIED_PROPERTIES |= 4;
            String component = (String)graphEntry.getValue();
            if (component.length() > 256) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.Component", (Object)component, (Object)new Integer(component.length()), (Object)new Integer(256));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (elementTag.equals("subComponent")) {
            CHECK_ALL_REQURIED_PROPERTIES |= 8;
            String subComponent = (String)graphEntry.getValue();
            if (subComponent.length() > 512) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.SubComponent", (Object)subComponent, (Object)new Integer(subComponent.length()), (Object)new Integer(512));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (elementTag.equals("componentIdType")) {
            CHECK_ALL_REQURIED_PROPERTIES |= 0x10;
            String componentIdType = (String)graphEntry.getValue();
            if (componentIdType.length() > 32) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.ComponentIdType", (Object)componentIdType, (Object)new Integer(componentIdType.length()), (Object)new Integer(32));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (elementTag.equals("componentType")) {
            CHECK_ALL_REQURIED_PROPERTIES |= 0x20;
            String componentType = (String)graphEntry.getValue();
            if (componentType.length() > 512) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.ComponentType", (Object)componentType, (Object)new Integer(componentType.length()), (Object)new Integer(512));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (elementTag.equals("application")) {
            String application = (String)graphEntry.getValue();
            if (application.length() > 256) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.Application", (Object)application, (Object)new Integer(application.length()), (Object)new Integer(256));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (elementTag.equals("executionEnvironment")) {
            String executionEnvironment = (String)graphEntry.getValue();
            if (executionEnvironment.length() > 256) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.ExecutionEnvironment", (Object)executionEnvironment, (Object)new Integer(executionEnvironment.length()), (Object)new Integer(256));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (elementTag.equals("processId")) {
            String processId = (String)graphEntry.getValue();
            if (processId.length() > 64) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.ProcessId", (Object)processId, (Object)new Integer(processId.length()), (Object)new Integer(64));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (elementTag.equals("threadId")) {
            String threadId = (String)graphEntry.getValue();
            if (threadId.length() > 64) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.ThreadId", (Object)threadId, (Object)new Integer(threadId.length()), (Object)new Integer(64));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (elementTag.equals("instanceId")) {
            String instanceId = (String)graphEntry.getValue();
            if (instanceId.length() > 128) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_LENGTH_EXC_", (Object)"CommonBaseEvent.ComponentIdentification.InstanceId", (Object)instanceId, (Object)new Integer(instanceId.length()), (Object)new Integer(128));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
            event.setSeverity((short)50);
            this.log(event);
            return -1;
        }
        return CHECK_ALL_REQURIED_PROPERTIES;
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateSituationElements(HashMap situations) {
        CHECK_ALL_REQURIED_PROPERTIES = 0;
        elementGroup = situations.values().iterator();
        if (elementGroup.hasNext()) ** GOTO lbl22
        return false;
lbl-1000:
        // 1 sources

        {
            graphEntries = (ArrayList)elementGroup.next();
            CHECK_ALL_REQURIED_PROPERTIES = (Integer)graphEntries.get(0);
            if (CHECK_ALL_REQURIED_PROPERTIES == 3) continue;
            if ((CHECK_ALL_REQURIED_PROPERTIES & 1) != 1) {
                event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "situationType"});
                event.setSeverity((short)50);
                this.log(event);
                return false;
            }
            if ((CHECK_ALL_REQURIED_PROPERTIES & 2) == 2) continue;
            event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "categoryName"});
            event.setSeverity((short)50);
            this.log(event);
            return false;
lbl22:
            // 3 sources

            ** while (elementGroup.hasNext())
        }
lbl23:
        // 1 sources

        return true;
    }

    private int validateSituationElement(Integer containedProperties, IDirectedGraph graphEntry) {
        int CHECK_ALL_REQURIED_PROPERTIES = containedProperties;
        List path = graphEntry.getPath();
        String elementTag = (String)path.get(4);
        if (elementTag.equals("categoryName")) {
            CHECK_ALL_REQURIED_PROPERTIES |= 2;
            String categoryName = (String)graphEntry.getValue();
            if (!(categoryName.equals("StartSituation") || categoryName.equals("StopSituation") || categoryName.equals("ConnectSituation") || categoryName.equals("ConfigureSituation") || categoryName.equals("RequestSituation") || categoryName.equals("FeatureSituation") || categoryName.equals("DependencySituation") || categoryName.equals("CreateSituation") || categoryName.equals("DestroySituation") || categoryName.equals("ReportSituation") || categoryName.equals("AvailableSituation") || categoryName.equals("OtherSituation"))) {
                String errMsg = EventHelpers.getString((String)"LOG_INVALID_SITUATION_TYPE_EXC_", (Object)"CommonBaseEvent.Situation.CategoryName", (Object)categoryName, (Object)"[".concat("StartSituation").concat("StopSituation").concat("ConnectSituation").concat("ConfigureSituation").concat("RequestSituation").concat("FeatureSituation").concat("DependencySituation").concat("CreateSituation").concat("DestroySituation").concat("ReportSituation").concat("AvailableSituation").concat("OtherSituation").concat("]"));
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                event.setSeverity((short)50);
                this.log(event);
                return -1;
            }
        } else if (elementTag.equals("AvailableSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("AvailableSituation") || elementTag.equals("RequestSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("RequestSituation") || elementTag.equals("StartSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("StartSituation") || elementTag.equals("StopSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("StopSituation") || elementTag.equals("ConnectSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("ConnectSituation") || elementTag.equals("ConfigureSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("ConfigureSituation") || elementTag.equals("CreateSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("CreateSituation") || elementTag.equals("DestroySituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("DestroySituation") || elementTag.equals("ReportSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("ReportSituation") || elementTag.equals("FeatureSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("FeatureSituation") || elementTag.equals("DependencySituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("DependencySituation") || elementTag.equals("OtherSituation") || elementTag.equals("situationType") && ((String)path.get(6)).equals("OtherSituation")) {
            CHECK_ALL_REQURIED_PROPERTIES = 3;
        } else {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_SituationType_WARN_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), elementTag});
            event.setSeverity((short)50);
            this.log(event);
            return -1;
        }
        return CHECK_ALL_REQURIED_PROPERTIES;
    }

    private void createModelElements() {
        int i = 0;
        while (i < this.commonBaseEventMaps.length) {
            if (this.commonBaseEventMaps[i] != null) {
                switch (i) {
                    case 0: {
                        this.createCommonBaseEventAttributes(this.commonBaseEventMaps[i]);
                        break;
                    }
                    case 1: {
                        this.createContextElement(this.commonBaseEventMaps[i]);
                        break;
                    }
                    case 2: {
                        this.createReportComponent_or_SoucreComponenElement(this.commonBaseEventMaps[i]);
                        break;
                    }
                    case 3: {
                        this.createSituationElement(this.commonBaseEventMaps[i]);
                        break;
                    }
                    case 4: {
                        this.createAssociateEventElement(this.commonBaseEventMaps[i]);
                        break;
                    }
                    case 5: {
                        this.createExtendedDataElement(this.commonBaseEventMaps[i], 4, false);
                        break;
                    }
                    case 6: {
                        this.createMsgDataElement(this.commonBaseEventMaps[i]);
                    }
                }
            }
            ++i;
        }
    }
}

