/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.internal.adapter.outputters;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.parsers.internal.adapter.outputters.CBEProducerToConsumerNavigator;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.util.ModelDebugger;

public class CBEtoCSVOutputter
extends CBEProducerToConsumerNavigator {
    public static final String LARGE_RESOURCE_SUPPORT_PASSWORD = "largeResourceSupportPassword";
    public static final String LARGE_RESOURCE_SUPPORT_USERNAME = "largeResourceSupportUsername";
    public static final String LARGE_RESOURCE_SUPPORT_LOCATION = "largeResourceSupportLocation";
    public static final String LARGE_RESOURCE_SUPPORT_CURRENT_DBTYPE = "largeResourceSupportStoreType";
    public static final String LARGE_RESOURCE_SUPPORT_JDBC_LOCATION = "largeResourceSupportJDBCLocation";
    protected static final byte[] NEWLINE = "\n".getBytes();
    public static String ENCODING = "UTF8";
    public static int BUFFER_SIZE = 65536;
    protected byte[] DELIMITER = ",".getBytes();
    protected byte[] QUOTES = "\"".getBytes();
    protected byte[] FALSE = "F".getBytes();
    protected byte[] SLASH = "/".getBytes();
    protected String dbType;
    protected String dbLocation;
    protected String dbUsername;
    protected String dbPassword;
    protected int baseID = 0;
    protected int ABSTRACTDEFAULTEVENT = this.baseID++;
    protected int CBEAVAILABLESITUATION = this.baseID++;
    protected int CBECOMMONBASEEVENT = this.baseID++;
    protected int CBECOMMONBASEEVENT_CONTEXTDATAELEMENTS = this.baseID++;
    protected int CBECOMMONBASEEVENT_OTHERDATA = this.baseID++;
    protected int CBECOMPONENTIDENTIFICATION = this.baseID++;
    protected int CBECONFIGURESITUATION = this.baseID++;
    protected int CBECONNECTSITUATION = this.baseID++;
    protected int CBECONTEXTDATAELEMENT = this.baseID++;
    protected int CBECREATESITUATION = this.baseID++;
    protected int CBEDEFAULTELEMENT = this.baseID++;
    protected int CBEDEFAULTELEMENT_CHILDREN = this.baseID++;
    protected int CBEDEFAULTELEMENT_VALUES = this.baseID++;
    protected int CBEDEFAULTEVENT = this.baseID++;
    protected int CBEDEFAULTEVENT_EXTENDEDPROPERTIES = this.baseID++;
    protected int CBEDEPENDENCYSITUATION = this.baseID++;
    protected int CBEDESTROYSITUATION = this.baseID++;
    protected int CBEEXTENDEDDATAELEMENT = this.baseID++;
    protected int CBEFEATURESITUATION = this.baseID++;
    protected int CBEMSGDATAELEMENT = this.baseID++;
    protected int CBEMSGDATAELEMENT_MSGCATALOGTOKENS = this.baseID++;
    protected int CBEOTHERSITUATION = this.baseID++;
    protected int CBEOTHERSITUATION_ANYDATA = this.baseID++;
    protected int CBEREPORTSITUATION = this.baseID++;
    protected int CBEREQUESTSITUATION = this.baseID++;
    protected int CBESITUATION = this.baseID++;
    protected int CBESTARTSITUATION = this.baseID++;
    protected int CBESTOPSITUATION = this.baseID++;
    protected int ID_TABLE = this.baseID++;
    protected int PROXY_TABLE = this.baseID++;
    protected int RESOURCE_TABLE = this.baseID++;
    protected int TRCAGENT = this.baseID++;
    protected int TRCAGENTPROXY = this.baseID++;
    protected int typeBaseId = 0;
    protected int AbstractDefaultEvent_TYPE_Index = this.typeBaseId++;
    protected int CBEAvailableSituation_TYPE_Index = this.typeBaseId++;
    protected int CBECommonBaseEvent_TYPE_Index = this.typeBaseId++;
    protected int CBEComponentIdentification_TYPE_Index = this.typeBaseId++;
    protected int CBEConfigureSituation_TYPE_Index = this.typeBaseId++;
    protected int CBEConnectSituation_TYPE_Index = this.typeBaseId++;
    protected int CBEContextDataElement_TYPE_Index = this.typeBaseId++;
    protected int CBECreateSituation_TYPE_Index = this.typeBaseId++;
    protected int CBEDefaultElement_TYPE_Index = this.typeBaseId++;
    protected int CBEDefaultEvent_TYPE_Index = this.typeBaseId++;
    protected int CBEDependencySituation_TYPE_Index = this.typeBaseId++;
    protected int CBEDestroySituation_TYPE_Index = this.typeBaseId++;
    protected int CBEExtendedDataElement_TYPE_Index = this.typeBaseId++;
    protected int CBEFeatureSituation_TYPE_Index = this.typeBaseId++;
    protected int CBEMsgDataElement_TYPE_Index = this.typeBaseId++;
    protected int CBEOtherSituation_TYPE_Index = this.typeBaseId++;
    protected int CBEReportSituation_TYPE_Index = this.typeBaseId++;
    protected int CBERequestSituation_TYPE_Index = this.typeBaseId++;
    protected int CBESituation_TYPE_Index = this.typeBaseId++;
    protected int CBEStartSituation_TYPE_Index = this.typeBaseId++;
    protected int CBEStopSituation_TYPE_Index = this.typeBaseId++;
    protected int TRCAgent_TYPE_Index = this.typeBaseId++;
    protected int TRCAgentProxy_TYPE_Index = this.typeBaseId++;
    public static final String[] fileNamesPrefix = new String[]{"ABSTRACTDEFAULTEVENT", "CBEAVAILABLESITUATION", "CBECOMMONBASEEVENT", "CBECOMMONBASEEVENT_CONTEXTDATAELEMENTS", "CBECOMMONBASEEVENT_OTHERDATA", "CBECOMPONENTIDENTIFICATION", "CBECONFIGURESITUATION", "CBECONNECTSITUATION", "CBECONTEXTDATAELEMENT", "CBECREATESITUATION", "CBEDEFAULTELEMENT", "CBEDEFAULTELEMENT_CHILDREN", "CBEDEFAULTELEMENT_VALUES", "CBEDEFAULTEVENT", "CBEDEFAULTEVENT_EXTENDEDPROPERTIES", "CBEDEPENDENCYSITUATION", "CBEDESTROYSITUATION", "CBEEXTENDEDDATAELEMENT", "CBEFEATURESITUATION", "CBEMSGDATAELEMENT", "CBEMSGDATAELEMENT_MSGCATALOGTOKENS", "CBEOTHERSITUATION", "CBEOTHERSITUATION_ANYDATA", "CBEREPORTSITUATION", "CBEREQUESTSITUATION", "CBESITUATION", "CBESTARTSITUATION", "CBESTOPSITUATION", "ID_TABLE", "PROXY_TABLE", "RESOURCE_TABLE", "TRCAGENT", "TRCAGENTPROXY"};
    protected OutputStream[] outputStreams = new OutputStream[this.baseID];
    protected File[] outputFiles = new File[this.baseID];
    public static final byte[][] typesIds = new byte[][]{"1".getBytes(), "8".getBytes(), "9".getBytes(), "10".getBytes(), "11".getBytes(), "12".getBytes(), "13".getBytes(), "14".getBytes(), "15".getBytes(), "16".getBytes(), "17".getBytes(), "18".getBytes(), "19".getBytes(), "20".getBytes(), "21".getBytes(), "22".getBytes(), "23".getBytes(), "24".getBytes(), "25".getBytes(), "26".getBytes(), "27".getBytes(), "67".getBytes(), "68".getBytes()};
    protected Map dbIds = new HashMap();
    protected int lastId = 1;
    public boolean loadCSVFiles;
    public boolean deleteCSVFiles;
    protected StringBuffer sb;
    protected byte[] agentDBId;
    protected String dirPrefix;
    protected String[] importCommands;
    protected String[] importCommandArgs;
    protected BufferedOutputStream importScriptOutputStream;
    protected String importSciptFileName;
    protected Properties dbConnectionProperties;
    protected String agentResourceURI;
    protected String agentProxyURI;
    protected File importSciptFile;
    protected IHyadesResourceExtension hyadesResourceExtension;
    protected String postFix;
    protected boolean saveResourceAndAgent;
    protected String dbJDBCLocation;
    public static Hashtable locks = new Hashtable();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CBEtoCSVOutputter() {
        this.loadCSVFiles = ModelDebugger.INSTANCE.debugLoadCSVFiles;
        this.deleteCSVFiles = ModelDebugger.INSTANCE.debugDeleteCSVFiles;
        this.sb = new StringBuffer();
        this.importCommandArgs = new String[]{"AbstractDefaultEvent", "p_p,id,agent,agent_TYPE,agent_Order,Is_EMF_Proxy", "CBEAvailableSituation", "p_p,id,operationDisposition,processingDisposition,availabilityDisposition,Is_EMF_Proxy", "CBECommonBaseEvent", "p_p,id,localInstanceId,globalInstanceId,creationTime,timeZone,severity,priority,msg,repeatCount,elapsedTime,sequenceNumber,version,reporterComponentId,reporterComponentId_TYPE,sourceComponentId,sourceComponentId_TYPE,msgDataElement,msgDataElement_TYPE,situation,situation_TYPE,Is_EMF_Proxy", "CBECommonBaseEvent_contextDataElements", "Source_Id,Source_TYPE,Target_Order,Target_TYPE,Target_Id", "CBECommonBaseEvent_otherData", "Id,Value,Order", "CBEComponentIdentification", "p_p,id,location,locationType,application,executionEnvironment,component,subComponent,componentIdType,instanceId,processId,threadId,componentType,Is_EMF_Proxy", "CBEConfigureSituation", "p_p,id,successDisposition,Is_EMF_Proxy", "CBEConnectSituation", "p_p,id,successDisposition,situationDisposition,Is_EMF_Proxy", "CBEContextDataElement", "p_p,id,contextId,type,name,contextValue,Is_EMF_Proxy", "CBECreateSituation", "p_p,id,successDisposition,Is_EMF_Proxy", "CBEDefaultElement", "p_p,id,name,Is_EMF_Proxy", "CBEDefaultElement_children", "Source_Id,Source_TYPE,Target_Order,Target_TYPE,Target_Id", "CBEDefaultElement_values", "Id,Value,Order", "CBEDefaultEvent", "p_p,id,extensionName,Is_EMF_Proxy", "CBEDefaultEvent_extendedProperties", "Source_Id,Source_TYPE,Target_Order,Target_TYPE,Target_Id", "CBEDependencySituation", "p_p,id,dependencyDisposition,Is_EMF_Proxy", "CBEDestroySituation", "p_p,id,successDisposition,Is_EMF_Proxy", "CBEExtendedDataElement", "p_p,id,type,hexValue,Is_EMF_Proxy", "CBEFeatureSituation", "p_p,id,featureDisposition,Is_EMF_Proxy", "CBEMsgDataElement", "p_p,id,msgId,msgIdType,msgCatalogId,msgCatalog,msgLocale,msgCatalogType,Is_EMF_Proxy", "CBEMsgDataElement_msgCatalogTokens", "Id,Value,Order", "CBEOtherSituation", "p_p,id,Is_EMF_Proxy", "CBEOtherSituation_anyData", "Id,Value,Order", "CBEReportSituation", "p_p,id,reportCategory,Is_EMF_Proxy", "CBERequestSituation", "p_p,id,successDisposition,situationQualifier,Is_EMF_Proxy", "CBESituation", "p_p,id,categoryName,reasoningScope,Is_EMF_Proxy", "CBEStartSituation", "p_p,id,successDisposition,situationQualifier,Is_EMF_Proxy", "CBEStopSituation", "p_p,id,successDisposition,situationQualifier,Is_EMF_Proxy", "CorrelationContainer", "p_p,id,correlationContainerProxy,correlationContainerProxy_TYPE,Is_EMF_Proxy", "CorrelationContainerProxy", "p_p,id,name,creationTime,monitor,monitor_TYPE,monitor_Order,correlationEngine,correlationEngine_TYPE,Is_EMF_Proxy", "CorrelationContainerProxy_correlatedAgents", "Source_Id,Source_TYPE,Target_Order,Target_TYPE,Target_Id", "CorrelationEngine", "p_p,id,type,name,description,databaseId,Is_EMF_Proxy", "CorrelationEntry", "p_p,id,correlationContainer,correlationContainer_TYPE,correlationContainer_Order,key,key_TYPE,Is_EMF_Proxy", "CorrelationEntry_value", "Source_Id,Source_TYPE,Target_Order,Target_TYPE,Target_Id", "Id_Table", "Id", "Proxy_Table", "URI,Table_Name,Id,Proxy_URI", "Resource_Table", "URI,Table_Name,Id", "TRCAgent", "p_p,id,name,type,runtimeId,startTime,stopTime,collectionMode,version,view,view_TYPE,process,process_TYPE,agentProxy,agentProxy_TYPE,Is_EMF_Proxy", "TRCAgentProxy", "p_p,id,name,type,runtimeId,startTime,stopTime,collectionMode,deltaTime,processProxy,processProxy_TYPE,processProxy_Order,Is_EMF_Proxy"};
    }

    public synchronized void update() throws AdapterInvalidConfig {
        try {
            try {
                super.update();
            }
            catch (Exception exception) {}
            Hashtable outputterProperties = this.getProperties();
            if (outputterProperties != null && !outputterProperties.isEmpty()) {
                this.dbType = (String)outputterProperties.get(LARGE_RESOURCE_SUPPORT_CURRENT_DBTYPE);
                this.dbLocation = (String)outputterProperties.get(LARGE_RESOURCE_SUPPORT_LOCATION);
                this.dbUsername = (String)outputterProperties.get(LARGE_RESOURCE_SUPPORT_USERNAME);
                this.dbPassword = LoadersUtils.restorePassword((String)((String)outputterProperties.get(LARGE_RESOURCE_SUPPORT_PASSWORD)));
                this.dbJDBCLocation = (String)outputterProperties.get(LARGE_RESOURCE_SUPPORT_JDBC_LOCATION);
                this.dbConnectionProperties = new Properties();
                this.dbConnectionProperties.put(LARGE_RESOURCE_SUPPORT_CURRENT_DBTYPE, this.dbType);
                if (this.dbLocation != null && this.dbLocation.trim().length() > 0) {
                    this.dbConnectionProperties.put("location", this.dbLocation);
                } else {
                    this.dbConnectionProperties.put("location", "");
                }
                if (this.dbUsername != null && this.dbUsername.trim().length() > 0) {
                    this.dbConnectionProperties.put("user", this.dbUsername);
                } else {
                    this.dbConnectionProperties.put("user", "");
                }
                if (this.dbPassword != null && this.dbPassword.trim().length() > 0) {
                    this.dbConnectionProperties.put("password", this.dbPassword);
                } else {
                    this.dbConnectionProperties.put("password", "");
                }
                if (this.dbJDBCLocation != null && this.dbJDBCLocation.trim().length() > 0) {
                    this.dbConnectionProperties.put(LARGE_RESOURCE_SUPPORT_JDBC_LOCATION, this.dbJDBCLocation);
                }
            }
            Hashtable hashtable = this.getProperties();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.hyades.models.hierarchy.TRCAgent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.agentResourceURI = (String)hashtable.get(clazz.getName());
            Hashtable hashtable2 = this.getProperties();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.hyades.models.hierarchy.TRCAgentProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.agentProxyURI = (String)hashtable2.get(clazz2.getName());
            this.postFix = (String.valueOf(this.dbType) + "_" + this.dbLocation + "_" + this.dbUsername).replace(':', '_').replace('/', '_').replace('\\', '_');
            while (locks.contains(this.postFix)) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            locks.put(this.postFix, this.postFix);
            int agentId = this.getAgentId();
            this.lastId = this.getLastDBId() + 1;
            if (agentId == -1) {
                agentId = this.lastId++;
                this.saveResourceAndAgent = this.dbLocation != null && (this.dbLocation.length() == 0 || this.dbLocation.startsWith("127.0.0.1:") || this.dbLocation.startsWith("localhost:"));
            }
            this.agentDBId = Integer.toString(agentId).getBytes();
            this.hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get((Object)LoadersUtils.getPostfix((String)this.agentResourceURI));
            this.start();
        }
        catch (Throwable t) {
            locks.remove(this.postFix);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    protected int getLastDBId() {
        try {
            IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get((Object)LoadersUtils.getPostfix((String)this.agentResourceURI));
            ResultSet resultSet = (ResultSet)hyadesResourceExtension.executeQuery("SELECT " + this.getQuotes() + "Id" + this.getQuotes() + " FROM " + this.getQuotes() + "Id_Table" + this.getQuotes(), this.agentResourceURI, 2, this.dbConnectionProperties);
            int res = -1;
            if (resultSet.next()) {
                res = resultSet.getInt(1);
            }
            resultSet.close();
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected int getAgentId() {
        try {
            IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get((Object)LoadersUtils.getPostfix((String)this.agentResourceURI));
            ResultSet resultSet = (ResultSet)hyadesResourceExtension.executeQuery("SELECT " + this.getQuotes() + "Id" + this.getQuotes() + " FROM " + this.getQuotes() + "Resource_Table" + this.getQuotes() + " WHERE " + this.getQuotes() + "URI" + this.getQuotes() + "='" + this.agentResourceURI + "'", this.agentResourceURI, 2, this.dbConnectionProperties);
            int res = -1;
            if (resultSet.next()) {
                res = resultSet.getInt(1);
            }
            resultSet.close();
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected String getQuotes() {
        return this.dbType.equals("DB2") ? "" : "\"";
    }

    public void start() {
        try {
            if (this.outputFiles[0] != null) {
                return;
            }
            super.start();
            File dir = File.createTempFile("CSVfiles_" + this.postFix + "-", "");
            dir.delete();
            dir.mkdirs();
            dir.deleteOnExit();
            this.dirPrefix = String.valueOf(dir.getAbsolutePath()) + File.separator;
            this.importCommands = new String[this.importCommandArgs.length / 2];
            int i = 0;
            while (i < this.importCommandArgs.length) {
                String tableName = this.importCommandArgs[i];
                String columns = this.importCommandArgs[i + 1];
                this.setImportCommand(i, tableName, columns);
                i += 2;
            }
            this.importSciptFileName = String.valueOf(this.dirPrefix) + File.separator + "importCBEsCSVsIn" + this.dbType.replace('/', '_') + ".sql";
            this.importSciptFile = new File(this.importSciptFileName);
            this.importScriptOutputStream = new BufferedOutputStream(new FileOutputStream(this.importSciptFile), BUFFER_SIZE);
            i = 0;
            while (i < fileNamesPrefix.length) {
                this.outputFiles[i] = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + fileNamesPrefix[i] + ".CSV");
                this.outputStreams[i] = new BufferedOutputStream(new FileOutputStream(this.outputFiles[i]), BUFFER_SIZE);
                ++i;
            }
            this.cbeCount = 0;
            ++this.lastId;
            this.writeNL(this.outputStreams[this.TRCAGENT], ("\"/\"," + new String(this.agentDBId) + ",,\"Logging\",,,,,,,,,," + this.lastId + "," + new String(typesIds[this.TRCAgentProxy_TYPE_Index]) + ",").getBytes(ENCODING));
            this.writeNL(this.outputStreams[this.RESOURCE_TABLE], ("\"" + this.agentResourceURI + "\",\"TRCAgent\"," + new String(this.agentDBId)).getBytes(ENCODING));
            if (this.saveResourceAndAgent) {
                this.outputStreams[this.TRCAGENT].close();
                this.outputStreams[this.RESOURCE_TABLE].close();
                this.loadTable(this.getImportCommand(fileNamesPrefix[this.TRCAGENT]).substring(0, this.getImportCommand(fileNamesPrefix[this.TRCAGENT]).length() - 1));
                this.loadTable(this.getImportCommand(fileNamesPrefix[this.RESOURCE_TABLE]).substring(0, this.getImportCommand(fileNamesPrefix[this.RESOURCE_TABLE]).length() - 1));
            }
            if (this.agentProxyURI != null) {
                this.writeNL(this.outputStreams[this.TRCAGENTPROXY], ("," + this.lastId + ",,,,,,,,,,,\"T\"").getBytes(ENCODING));
                this.writeNL(this.outputStreams[this.PROXY_TABLE], ("\"" + this.agentResourceURI + "\",\"TRCAgentProxy\"," + this.lastId + ",\"" + this.agentProxyURI + "\"").getBytes(ENCODING));
            }
        }
        catch (Throwable t) {
            locks.remove(this.postFix);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    protected void setImportCommand(int i, String tableName, String columns) {
        this.importCommands[i / 2] = this.dbType.equals("DB2") ? "LOAD FROM \"" + this.dirPrefix + (String.valueOf(tableName) + ".csv").toUpperCase() + "\" OF DEL MODIFIED BY DELPRIORITYCHAR " + (tableName.equalsIgnoreCase(fileNamesPrefix[this.ID_TABLE]) ? "REPLACE" : "INSERT") + " INTO " + this.dbUsername + "." + tableName + " (" + columns + ");" : "CALL SYSCS_UTIL.SYSCS_IMPORT_DATA (NULL,'" + tableName + "','" + columns + "',NULL,'" + this.dirPrefix + (String.valueOf(tableName) + ".csv").toUpperCase() + "',NULL, NULL,NULL," + (tableName.equalsIgnoreCase(fileNamesPrefix[this.ID_TABLE]) ? 1 : 0) + ");";
    }

    public void stop() {
        try {
            this.updateLastID();
            this.writeNL(this.outputStreams[this.ID_TABLE], String.valueOf(++this.lastId).getBytes(ENCODING));
            long totalCSVFileSize = 0L;
            int nonEmtpyCSVFiles = 0;
            int i = 0;
            while (i < fileNamesPrefix.length) {
                if (!this.saveResourceAndAgent || i != this.TRCAGENT && i != this.RESOURCE_TABLE) {
                    this.outputStreams[i].close();
                }
                totalCSVFileSize += this.outputFiles[i].length();
                if (this.outputFiles[i].length() > 0L) {
                    if (this.saveResourceAndAgent && (i == this.TRCAGENT || i == this.RESOURCE_TABLE)) {
                        this.importScriptOutputStream.write(("--" + this.getImportCommand(fileNamesPrefix[i]) + "\n").getBytes(ENCODING));
                    } else {
                        this.importScriptOutputStream.write((String.valueOf(this.getImportCommand(fileNamesPrefix[i])) + "\n").getBytes(ENCODING));
                    }
                    ++nonEmtpyCSVFiles;
                }
                ++i;
            }
            this.importScriptOutputStream.close();
            if (ModelDebugger.INSTANCE.debugPerfUtil) {
                this.p.stopAndPrintStatus();
                this.p.setMessageAndStart("CSV loadCSVFiles, totalCSVFileSize=" + totalCSVFileSize + ", nonEmtpyCSVFiles=" + nonEmtpyCSVFiles);
            }
            if (this.loadCSVFiles) {
                this.loadCSVFiles();
            }
            if (ModelDebugger.INSTANCE.debugPerfUtil) {
                this.p.stopAndPrintStatus();
                this.p.setMessageAndStart("CSV deleteCSVFiles=" + this.deleteCSVFiles + ", totalCSVFileSize=" + totalCSVFileSize + ", nonEmtpyCSVFiles=" + nonEmtpyCSVFiles);
            }
            if (this.deleteCSVFiles) {
                this.importSciptFile.delete();
                i = 0;
                while (i < fileNamesPrefix.length) {
                    this.outputFiles[i].delete();
                    ++i;
                }
            }
            super.stop();
            locks.remove(this.postFix);
        }
        catch (Throwable t) {
            locks.remove(this.postFix);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t.fillInStackTrace());
        }
    }

    protected void updateLastID() {
        try {
            this.hyadesResourceExtension.executeQuery("UPDATE " + this.getQuotes() + "Id_Table" + this.getQuotes() + " SET " + this.getQuotes() + "Id" + this.getQuotes() + "=" + ++this.lastId, this.agentResourceURI, 3, this.dbConnectionProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected String getImportCommand(String tableName) {
        int i = 0;
        while (i < this.importCommands.length) {
            if (this.importCommands[i].indexOf(tableName) > 0) {
                return this.importCommands[i];
            }
            ++i;
        }
        return "import command for " + tableName + " not found";
    }

    protected void loadCSVFiles() {
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.importSciptFileName));
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.substring(0, line.length() - 1)).startsWith("--")) continue;
                this.loadTable(line);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected Object loadTable(String loadTableCommand) {
        if (this.dbType.equals("DB2")) {
            return this.loadTableUsingDB2(loadTableCommand);
        }
        return this.loadTableUsingDerby(loadTableCommand);
    }

    protected Object loadTableUsingDerby(String loadTableCommand) {
        Object result;
        block3: {
            result = null;
            try {
                result = this.hyadesResourceExtension.executeQuery(loadTableCommand, this.agentResourceURI, 4, this.dbConnectionProperties);
            }
            catch (Exception e) {
                if (!ModelDebugger.INSTANCE.debug) break block3;
                System.out.println("CBEtoCSVOutputter.loadCSVUsingDerby() line=" + loadTableCommand);
                e.printStackTrace(System.out);
            }
        }
        if (ModelDebugger.INSTANCE.debug) {
            System.out.println("result=" + result + ", statement=" + loadTableCommand);
        }
        return result;
    }

    protected Object loadTableUsingDB2(String loadTableCommand) {
        Object result;
        block7: {
            result = null;
            try {
                loadTableCommand = "CALL SYSPROC.DB2LOAD (1<4,'','" + loadTableCommand + "',>4,'',>-5,>-5,>-5,>-5,>-5,>-5,>-5,>-5,>-5,'')";
                result = this.hyadesResourceExtension.executeQuery(loadTableCommand, this.agentResourceURI, 4, this.dbConnectionProperties);
                if (result instanceof CallableStatement) {
                    CallableStatement pstatement = (CallableStatement)result;
                    if (pstatement.getWarnings() != null) {
                        pstatement.getWarnings().printStackTrace();
                        loadTableCommand = loadTableCommand.replaceFirst("INSERT", "TERMINATE");
                        result = this.hyadesResourceExtension.executeQuery(loadTableCommand, this.agentResourceURI, 4, this.dbConnectionProperties);
                        if (result instanceof CallableStatement && pstatement.getWarnings() != null) {
                            pstatement.getWarnings().printStackTrace();
                        }
                    } else {
                        pstatement.getConnection().commit();
                    }
                }
            }
            catch (Exception e) {
                if (!ModelDebugger.INSTANCE.debug) break block7;
                System.out.println("CBEtoCSVOutputter.loadCSVUsingDB2() line=" + loadTableCommand);
                e.printStackTrace(System.out);
            }
        }
        if (ModelDebugger.INSTANCE.debug) {
            System.out.println("result=" + result + ", statement=" + loadTableCommand);
        }
        return result;
    }

    protected void mapAssociatedEvents(CommonBaseEvent object, int common_base_event__associated_events) {
    }

    protected void mapAttribute(CommonBaseEvent eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void write(OutputStream outputStream, Object data) {
        try {
            if (data == null) {
                return;
            }
            if (data instanceof String) {
                outputStream.write(this.QUOTES);
                outputStream.write(this.escape((String)data));
                outputStream.write(this.QUOTES);
            } else {
                outputStream.write(data.toString().getBytes(ENCODING));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeDL(OutputStream outputStream, Object data) {
        try {
            this.write(outputStream, data);
            outputStream.write(this.DELIMITER);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeNL(OutputStream outputStream, Object data) {
        try {
            this.write(outputStream, data);
            outputStream.write(NEWLINE);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeDL(OutputStream outputStream, short data) {
        try {
            outputStream.write(Short.toString(data).getBytes());
            outputStream.write(this.DELIMITER);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeNL(OutputStream outputStream, short data) {
        try {
            outputStream.write(Short.toString(data).getBytes());
            outputStream.write(NEWLINE);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeDL(OutputStream outputStream, double data) {
        try {
            outputStream.write(Double.toString(data).getBytes());
            outputStream.write(this.DELIMITER);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeNL(OutputStream outputStream, double data) {
        try {
            outputStream.write(Double.toString(data).getBytes());
            outputStream.write(NEWLINE);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeDL(OutputStream outputStream, int data) {
        try {
            outputStream.write(Integer.toString(data).getBytes());
            outputStream.write(this.DELIMITER);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void write(OutputStream outputStream, int data) {
        try {
            outputStream.write(Integer.toString(data).getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeDL(OutputStream outputStream, String data) {
        try {
            if (data != null) {
                outputStream.write(this.QUOTES);
                outputStream.write(this.escape(data));
                outputStream.write(this.QUOTES);
            }
            outputStream.write(this.DELIMITER);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeNL(OutputStream outputStream, String data) {
        try {
            if (data != null) {
                outputStream.write(this.QUOTES);
                outputStream.write(this.escape(data));
                outputStream.write(this.QUOTES);
            }
            outputStream.write(NEWLINE);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected byte[] escape(String data) {
        this.sb.setLength(0);
        try {
            int i = 0;
            int len = data.length();
            while (i < len) {
                if (data.charAt(i) == '\"') {
                    this.sb.append('\"');
                    this.sb.append('\"');
                } else {
                    this.sb.append(data.charAt(i));
                }
                ++i;
            }
            return this.sb.toString().getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void writeDL(OutputStream outputStream, byte[] data) {
        try {
            outputStream.write(data);
            outputStream.write(this.DELIMITER);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void write(OutputStream outputStream, byte[] data) {
        try {
            outputStream.write(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeNL(OutputStream outputStream, byte[] data) {
        try {
            outputStream.write(data);
            outputStream.write(NEWLINE);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void writeNL(OutputStream outputStream, int data) {
        try {
            outputStream.write(Integer.toString(data).getBytes());
            outputStream.write(NEWLINE);
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }

    protected void mapContainmentReference(AvailableSituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBEAVAILABLESITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(CommonBaseEvent eObject, int sourceFeatureID, int targetFeatureID) {
        switch (targetFeatureID) {
            case 2: {
                this.writeDL(this.outputStreams[this.CBEDEFAULTEVENT], eObject.getExtensionName());
                break;
            }
            case 16: {
                EList l = eObject.getAny();
                if (l.size() <= 0) break;
                byte[] id = this.getDBId((EObject)eObject);
                int i = 0;
                while (i < l.size()) {
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT_OTHERDATA], id);
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT_OTHERDATA], l.get(i));
                    this.writeNL(this.outputStreams[this.CBECOMMONBASEEVENT_OTHERDATA], i);
                    ++i;
                }
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 15: {
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
                break;
            }
            case 7: {
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], LoadersUtils.convertCreationTime((String)eObject.getCreationTime()));
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], LoadersUtils.getDeltaTimeZoneInMinutesFromCIMFormat((String)eObject.getCreationTime()));
                break;
            }
            case 19: {
                if (eObject.getSourceComponentId() == null) {
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], eObject.getSourceComponentId());
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], eObject.getSourceComponentId());
                    break;
                }
                byte[] id = this.getDBId((EObject)eObject.getSourceComponentId());
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], id);
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], typesIds[this.CBEComponentIdentification_TYPE_Index]);
                this.writePPandID(this.CBECOMPONENTIDENTIFICATION, this.getDBParentPath((EObject)eObject.getSourceComponentId()), id);
                this.processFeatures(eObject.getSourceComponentId());
                this.write(this.outputStreams[this.CBECOMPONENTIDENTIFICATION], NEWLINE);
                break;
            }
            case 18: {
                if (eObject.getReporterComponentId() == null) {
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], eObject.getReporterComponentId());
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], eObject.getReporterComponentId());
                    break;
                }
                byte[] id = this.getDBId((EObject)eObject.getReporterComponentId());
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], id);
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], typesIds[this.CBEComponentIdentification_TYPE_Index]);
                this.writePPandID(this.CBECOMPONENTIDENTIFICATION, this.getDBParentPath((EObject)eObject.getReporterComponentId()), id);
                this.processFeatures(eObject.getReporterComponentId());
                this.write(this.outputStreams[this.CBECOMPONENTIDENTIFICATION], NEWLINE);
                break;
            }
            case 20: {
                if (eObject.getMsgDataElement() == null) {
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], eObject.getMsgDataElement());
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], eObject.getMsgDataElement());
                    break;
                }
                byte[] id = this.getDBId((EObject)eObject.getMsgDataElement());
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], id);
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], typesIds[this.CBEMsgDataElement_TYPE_Index]);
                this.writePPandID(this.CBEMSGDATAELEMENT, this.getDBParentPath((EObject)eObject.getSourceComponentId()), id);
                this.processFeatures(eObject.getMsgDataElement());
                this.write(this.outputStreams[this.CBEMSGDATAELEMENT], NEWLINE);
                break;
            }
            case 4: {
                if (eObject.getExtendedDataElements().size() <= 0) break;
                int index = 0;
                byte[] id = this.getDBId((EObject)eObject);
                Iterator iter = eObject.getExtendedDataElements().iterator();
                while (iter.hasNext()) {
                    ExtendedDataElement element = (ExtendedDataElement)iter.next();
                    this.writeDL(this.outputStreams[this.CBEDEFAULTEVENT_EXTENDEDPROPERTIES], id);
                    this.writeDL(this.outputStreams[this.CBEDEFAULTEVENT_EXTENDEDPROPERTIES], typesIds[this.CBECommonBaseEvent_TYPE_Index]);
                    this.writeDL(this.outputStreams[this.CBEDEFAULTEVENT_EXTENDEDPROPERTIES], index++);
                    this.writeDL(this.outputStreams[this.CBEDEFAULTEVENT_EXTENDEDPROPERTIES], typesIds[this.CBEExtendedDataElement_TYPE_Index]);
                    this.writeNL(this.outputStreams[this.CBEDEFAULTEVENT_EXTENDEDPROPERTIES], this.getDBId((EObject)element));
                    this.processFeatures(element);
                }
                break;
            }
            case 17: {
                if (eObject.getContextDataElements().size() <= 0) break;
                int index = 0;
                byte[] id = this.getDBId((EObject)eObject);
                byte[] pp = null;
                Iterator iter = eObject.getContextDataElements().iterator();
                while (iter.hasNext()) {
                    ContextDataElement element = (ContextDataElement)iter.next();
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT_CONTEXTDATAELEMENTS], id);
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT_CONTEXTDATAELEMENTS], typesIds[this.CBEContextDataElement_TYPE_Index]);
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT_CONTEXTDATAELEMENTS], index++);
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT_CONTEXTDATAELEMENTS], typesIds[this.CBEContextDataElement_TYPE_Index]);
                    this.writeNL(this.outputStreams[this.CBECOMMONBASEEVENT_CONTEXTDATAELEMENTS], this.getDBId((EObject)element));
                    if (pp == null) {
                        pp = this.getDBParentPath((EObject)element);
                    }
                    this.writePPandID(this.CBECONTEXTDATAELEMENT, pp, this.getDBId((EObject)element));
                    this.processFeatures(element);
                    this.write(this.outputStreams[this.CBECONTEXTDATAELEMENT], NEWLINE);
                }
                break;
            }
            case 21: {
                if (eObject.getSituation() == null) {
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], eObject.getSituation());
                    this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], eObject.getSituation());
                    break;
                }
                int situationTypeHashCode = LoadersUtils.getHashCode((String)eObject.getSituation().getSituationType().eClass().getName());
                byte[] pp = this.getDBParentPath((EObject)eObject.getSituation());
                byte[] id = this.getDBId((EObject)eObject.getSituation());
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], id);
                this.writeDL(this.outputStreams[this.CBECOMMONBASEEVENT], this.getSituationTypeId(situationTypeHashCode));
                this.writePPandID(this.CBESITUATION, pp, id);
                this.writeDL(this.outputStreams[this.CBESITUATION], eObject.getSituation().getCategoryName());
                this.writePPandID(this.getSituationStreamIndex(situationTypeHashCode), pp, id);
                this.processFeatures(eObject.getSituation().getSituationType());
                this.write(this.outputStreams[this.getSituationStreamIndex(situationTypeHashCode)], NEWLINE);
                this.write(this.outputStreams[this.CBESITUATION], NEWLINE);
                break;
            }
            default: {
                System.out.println("CBEtoCSVOutputter.mapContainmentReference(CommonBaseEvent eObject) - unknown feature " + eObject.eClass().getEStructuralFeature(sourceFeatureID).getName() + "! sourceFeatureID=" + sourceFeatureID + ", targetFeatureID=" + targetFeatureID);
            }
        }
    }

    protected void writePPandID(int typeIndex, byte[] pp, byte[] id) {
        this.write(this.outputStreams[typeIndex], this.QUOTES);
        this.write(this.outputStreams[typeIndex], pp);
        this.writeDL(this.outputStreams[typeIndex], this.QUOTES);
        this.writeDL(this.outputStreams[typeIndex], id);
    }

    protected byte[] getSituationTypeId(int situationTypeHashCode) {
        switch (situationTypeHashCode) {
            case -1436959403: {
                return typesIds[this.CBEAvailableSituation_TYPE_Index];
            }
            case 1722987992: {
                return typesIds[this.CBEConfigureSituation_TYPE_Index];
            }
            case 1254796372: {
                return typesIds[this.CBEConnectSituation_TYPE_Index];
            }
            case 1759439938: {
                return typesIds[this.CBECreateSituation_TYPE_Index];
            }
            case 886633171: {
                return typesIds[this.CBEDependencySituation_TYPE_Index];
            }
            case -832669884: {
                return typesIds[this.CBEDestroySituation_TYPE_Index];
            }
            case 1878013896: {
                return typesIds[this.CBEFeatureSituation_TYPE_Index];
            }
            case -520308498: {
                return typesIds[this.CBEOtherSituation_TYPE_Index];
            }
            case 106133258: {
                return typesIds[this.CBEReportSituation_TYPE_Index];
            }
            case 2034121807: {
                return typesIds[this.CBERequestSituation_TYPE_Index];
            }
            case -1429712932: {
                return typesIds[this.CBEStartSituation_TYPE_Index];
            }
            case -1286110212: {
                return typesIds[this.CBEStopSituation_TYPE_Index];
            }
        }
        return typesIds[this.CBESituation_TYPE_Index];
    }

    protected int getSituationStreamIndex(int situationTypeHashCode) {
        switch (situationTypeHashCode) {
            case -1436959403: {
                return this.CBEAVAILABLESITUATION;
            }
            case 1722987992: {
                return this.CBECONFIGURESITUATION;
            }
            case 1254796372: {
                return this.CBECONNECTSITUATION;
            }
            case 1759439938: {
                return this.CBECREATESITUATION;
            }
            case 886633171: {
                return this.CBEDEPENDENCYSITUATION;
            }
            case -832669884: {
                return this.CBEDESTROYSITUATION;
            }
            case 1878013896: {
                return this.CBEFEATURESITUATION;
            }
            case -520308498: {
                return this.CBEOTHERSITUATION;
            }
            case 106133258: {
                return this.CBEREPORTSITUATION;
            }
            case 2034121807: {
                return this.CBEREQUESTSITUATION;
            }
            case -1429712932: {
                return this.CBESTARTSITUATION;
            }
            case -1286110212: {
                return this.CBESTOPSITUATION;
            }
        }
        return this.CBESITUATION;
    }

    protected byte[] getDBId(EObject eObject) {
        byte[] id = (byte[])this.dbIds.get(eObject);
        if (id == null) {
            ++this.lastId;
            id = Integer.toString(this.lastId).getBytes();
            this.dbIds.put(eObject, id);
        }
        return id;
    }

    protected byte[] getDBParentPath(EObject eObject) {
        byte[] pp = this.getDBPath(eObject.eContainer());
        byte[] res = new byte[pp.length + 1];
        System.arraycopy(pp, 0, res, 0, pp.length);
        System.arraycopy(this.SLASH, 0, res, pp.length, 1);
        return res;
    }

    protected byte[] getDBPath(EObject eObject) {
        if (eObject == null) {
            return this.agentDBId;
        }
        byte[] pp = this.getDBPath(eObject.eContainer());
        byte[] id = this.getDBId(eObject);
        byte[] res = new byte[pp.length + id.length + 1];
        System.arraycopy(pp, 0, res, 0, pp.length);
        System.arraycopy(this.SLASH, 0, res, pp.length, 1);
        System.arraycopy(id, 0, res, pp.length + 1, id.length);
        return res;
    }

    protected CommonBaseEvent[] processCBEs(CommonBaseEvent[] events) {
        this.dbIds.clear();
        return super.processCBEs(events);
    }

    protected void processFeatures(CommonBaseEvent eObject) {
        byte[] pp = this.getDBParentPath((EObject)eObject);
        byte[] id = this.getDBId((EObject)eObject);
        this.writePPandID(this.ABSTRACTDEFAULTEVENT, pp, id);
        this.writeDL(this.outputStreams[this.ABSTRACTDEFAULTEVENT], this.agentDBId);
        this.writeDL(this.outputStreams[this.ABSTRACTDEFAULTEVENT], typesIds[this.AbstractDefaultEvent_TYPE_Index]);
        this.writeDL(this.outputStreams[this.ABSTRACTDEFAULTEVENT], this.cbeCount++);
        this.writePPandID(this.CBEDEFAULTEVENT, pp, id);
        this.writePPandID(this.CBECOMMONBASEEVENT, pp, id);
        super.processFeatures(eObject);
        this.write(this.outputStreams[this.CBECOMMONBASEEVENT], NEWLINE);
        this.write(this.outputStreams[this.CBEDEFAULTEVENT], NEWLINE);
        this.write(this.outputStreams[this.ABSTRACTDEFAULTEVENT], NEWLINE);
    }

    protected void mapContainmentReference(ComponentIdentification eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBECOMPONENTIDENTIFICATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(ConfigureSituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBECONFIGURESITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(ConnectSituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBECONNECTSITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(ContextDataElement eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBECONTEXTDATAELEMENT], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(CreateSituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBECREATESITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(DependencySituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBEDEPENDENCYSITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(DestroySituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBEDESTROYSITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void processFeatures(ExtendedDataElement eObject) {
        byte[] pp = this.getDBParentPath((EObject)eObject);
        byte[] id = this.getDBId((EObject)eObject);
        this.writePPandID(this.CBEEXTENDEDDATAELEMENT, pp, id);
        this.writePPandID(this.CBEDEFAULTELEMENT, pp, id);
        super.processFeatures(eObject);
        if (eObject.getChildren().size() == 0) {
            this.write(this.outputStreams[this.CBEDEFAULTELEMENT], NEWLINE);
            this.write(this.outputStreams[this.CBEEXTENDEDDATAELEMENT], NEWLINE);
        }
    }

    protected void mapContainmentReference(ExtendedDataElement eObject, int sourceFeatureID, int targetFeatureID) {
        switch (targetFeatureID) {
            case 2: {
                int index = 0;
                byte[] id = this.getDBId((EObject)eObject);
                if (eObject.getChildren().size() > 0) {
                    this.write(this.outputStreams[this.CBEDEFAULTELEMENT], NEWLINE);
                    this.write(this.outputStreams[this.CBEEXTENDEDDATAELEMENT], NEWLINE);
                }
                Iterator iter = eObject.getChildren().iterator();
                while (iter.hasNext()) {
                    ExtendedDataElement element = (ExtendedDataElement)iter.next();
                    this.writeDL(this.outputStreams[this.CBEDEFAULTELEMENT_CHILDREN], id);
                    this.writeDL(this.outputStreams[this.CBEDEFAULTELEMENT_CHILDREN], typesIds[this.CBEExtendedDataElement_TYPE_Index]);
                    this.writeDL(this.outputStreams[this.CBEDEFAULTELEMENT_CHILDREN], index++);
                    this.writeDL(this.outputStreams[this.CBEDEFAULTELEMENT_CHILDREN], typesIds[this.CBEExtendedDataElement_TYPE_Index]);
                    this.writeNL(this.outputStreams[this.CBEDEFAULTELEMENT_CHILDREN], this.getDBId((EObject)element));
                    this.processFeatures(element);
                }
                break;
            }
            case 1: {
                int index = 0;
                byte[] id = this.getDBId((EObject)eObject);
                Iterator iter = eObject.getValues().iterator();
                while (iter.hasNext()) {
                    String element = (String)iter.next();
                    this.writeDL(this.outputStreams[this.CBEDEFAULTELEMENT_VALUES], id);
                    this.writeDL(this.outputStreams[this.CBEDEFAULTELEMENT_VALUES], element);
                    this.writeNL(this.outputStreams[this.CBEDEFAULTELEMENT_VALUES], index);
                }
                break;
            }
            case 0: {
                this.writeDL(this.outputStreams[this.CBEDEFAULTELEMENT], eObject.getName());
                break;
            }
            default: {
                this.writeDL(this.outputStreams[this.CBEEXTENDEDDATAELEMENT], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
            }
        }
    }

    protected void mapContainmentReference(FeatureSituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBEFEATURESITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(MsgDataElement eObject, int sourceFeatureID, int targetFeatureID) {
        if (targetFeatureID == 3) {
            int index = 0;
            byte[] id = this.getDBId((EObject)eObject);
            Iterator iter = eObject.getMsgCatalogTokens().iterator();
            while (iter.hasNext()) {
                MsgCatalogToken element = (MsgCatalogToken)iter.next();
                this.writeDL(this.outputStreams[this.CBEMSGDATAELEMENT_MSGCATALOGTOKENS], id);
                this.writeDL(this.outputStreams[this.CBEMSGDATAELEMENT_MSGCATALOGTOKENS], element.getValue());
                this.writeNL(this.outputStreams[this.CBEMSGDATAELEMENT_MSGCATALOGTOKENS], index++);
            }
        } else {
            this.writeDL(this.outputStreams[this.CBEMSGDATAELEMENT], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
        }
    }

    protected void mapContainmentReference(OtherSituation eObject, int sourceFeatureID, int targetFeatureID) {
        if (sourceFeatureID == 2) {
            if (eObject.getAny() != null && eObject.getAny().length() > 0) {
                this.writeDL(this.outputStreams[this.CBEOTHERSITUATION_ANYDATA], this.getDBId((EObject)eObject));
                this.writeDL(this.outputStreams[this.CBEOTHERSITUATION_ANYDATA], eObject.getAny());
                this.writeDL(this.outputStreams[this.CBEOTHERSITUATION_ANYDATA], 0);
            }
        } else {
            this.writeDL(this.outputStreams[this.CBEOTHERSITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
        }
    }

    protected void mapContainmentReference(ReportSituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBEREPORTSITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(RequestSituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBEREQUESTSITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(Situation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBESITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(SituationType eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBESITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(StartSituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBESTARTSITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected void mapContainmentReference(StopSituation eObject, int sourceFeatureID, int targetFeatureID) {
        this.writeDL(this.outputStreams[this.CBESTOPSITUATION], ((InternalEObject)eObject).eGet(sourceFeatureID, false, false));
    }

    protected boolean db2AdminProcExists() {
        boolean result;
        block4: {
            result = false;
            try {
                String sql = "SELECT COUNT(*) FROM SYSCAT.PROCEDURES WHERE PROCSCHEMA='SYSPROC' AND PROCNAME='ADMIN_CMD'";
                ResultSet rs = (ResultSet)this.hyadesResourceExtension.executeQuery(sql, this.agentResourceURI, 2, this.dbConnectionProperties);
                if (rs != null && rs.next() && rs.getInt(1) > 0) {
                    result = true;
                }
                if (rs != null) {
                    rs.getStatement().close();
                }
            }
            catch (Exception e) {
                if (!ModelDebugger.INSTANCE.debug) break block4;
                System.out.print("CBEtoCSVOutputter.db2AdminProcExists() error:");
                e.printStackTrace(System.out);
            }
        }
        return result;
    }
}

