/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.tptp.gla.components.transform;

import javax.xml.namespace.QName;
import org.apache.muse.ws.dm.muws.events.Component;
import org.apache.muse.ws.dm.muws.events.ManagementEvent;
import org.apache.muse.ws.dm.muws.events.impl.SimpleComponent;
import org.apache.muse.ws.dm.muws.events.impl.SimpleComponentAddress;
import org.apache.muse.ws.dm.muws.events.impl.SimpleManagementEvent;
import org.apache.muse.ws.dm.muws.events.impl.SimpleSituation;
import org.eclipse.cosmos.dc.common.api.impl.AbstractTransform;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.Situation;

@ManagedResource
public class WefCbeTransform
extends AbstractTransform {
    private static Class[] supportedInputTypes = new Class[]{CommonBaseEvent.class};
    private static Class[] supportedOutputTypes = new Class[]{ManagementEvent.class};

    public WefCbeTransform(ContributionManager manager) {
        super(manager);
    }

    public boolean acceptWireTarget(IWireTarget target) throws Exception {
        return true;
    }

    protected Class[] getSupportedTypes() {
        return supportedInputTypes;
    }

    public boolean transformType(Class toType, Class fromType) {
        return ManagementEvent.class.equals((Object)toType) && CommonBaseEvent.class.isAssignableFrom(fromType);
    }

    public ManagementEvent transformCbeToWef(CommonBaseEvent cbe) {
        SimpleManagementEvent wef = new SimpleManagementEvent();
        wef.setEventID(cbe.getGlobalInstanceId());
        Situation cbeSit = cbe.getSituation();
        SimpleSituation situation = new SimpleSituation();
        situation.setSeverity(this.convertCBEServerity(cbe.getSeverity()));
        situation.setMessage(cbe.getMsg());
        situation.setCategoryType(new QName(cbeSit.getCategoryName()));
        situation.setPriority(this.convertCBEPriority(cbe.getPriority()));
        wef.setSituation((org.apache.muse.ws.dm.muws.events.Situation)situation);
        wef.setReporter(this.convertComponent(cbe.getReporterComponentId()));
        wef.setSource(this.convertComponent(cbe.getSourceComponentId()));
        super.dispatch((Object)wef);
        return wef;
    }

    private short convertCBEServerity(short cbeSeverity) {
        switch (cbeSeverity) {
            case 50: {
                return 5;
            }
            case 60: {
                return 6;
            }
            case 20: {
                return 3;
            }
            case 10: {
                return 1;
            }
            case 40: {
                return 3;
            }
            case 30: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        return 0;
    }

    private short convertCBEPriority(short cbePriority) {
        switch (cbePriority) {
            case 70: {
                return 70;
            }
            case 10: {
                return 10;
            }
            case 50: {
                return 50;
            }
        }
        return 50;
    }

    private Component convertComponent(ComponentIdentification cbeComponent) {
        if (cbeComponent == null) {
            return null;
        }
        SimpleComponent component = new SimpleComponent();
        cbeComponent.getComponent();
        cbeComponent.getComponentIdType();
        cbeComponent.getComponentType();
        cbeComponent.getInstanceId();
        cbeComponent.getLocation();
        cbeComponent.getLocationType();
        cbeComponent.getApplication();
        cbeComponent.getProcessId();
        cbeComponent.getSubComponent();
        cbeComponent.getThreadId();
        String resourceId = cbeComponent.getInstanceId();
        if (resourceId == null) {
            resourceId = String.valueOf(cbeComponent.getComponent()) + ":" + cbeComponent.getLocationType() + ":" + cbeComponent.getLocation();
        }
        component.setName(new QName(this.encode2XML(cbeComponent.getComponent())));
        component.setResourceID(resourceId);
        new SimpleComponentAddress();
        return component;
    }

    private String encode2XML(String string) {
        return "encoded";
    }

    public Class[] getTransformTypes(Class fromType) {
        if (CommonBaseEvent.class.isAssignableFrom(fromType)) {
            return supportedOutputTypes;
        }
        return EMPTY_CLASS_LIST;
    }
}

