/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.dc.local.registry;

import org.apache.muse.core.serializer.Serializer;
import org.eclipse.cosmos.dc.common.ConsoleExtension;
import org.eclipse.cosmos.dc.common.registry.DataFlow;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.DataSourceType;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.registry.util.RegistrySerializer;
import org.eclipse.cosmos.dc.common.spi.ServiceRegistry;
import org.eclipse.cosmos.dc.mgmt.binding.Binding;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.util.WSDMHelperRegistry;
import org.eclipse.cosmos.dc.runtime.Runtime;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import com.ibatis.common.resources.Resources;

import java.io.Reader;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.sql.SQLException;


public class OSGiProviderRegistryHost implements ProviderRegistry {
	
	private SqlMapClient sqlMapper;
	
	private ProviderRegistry delegate;
		
	protected void activate(ComponentContext ctx)
	{
	
		ServiceReference ref = ctx.getBundleContext().getServiceReference("org.eclipse.cosmos.dc.mgmt.common.ContributionManager");
		ContributionManager manager = (ContributionManager)ctx.getBundleContext().getService(ref);
		delegate = new SQLProviderRegistry();
		((SQLProviderRegistry)delegate).setManager(manager);

		ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
		try {
			Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
			Reader reader = Resources.getResourceAsReader("org/eclipse/cosmos/dc/local/registry/persistence/sql/SqlMapConfig.xml");
			sqlMapper = SqlMapClientBuilder.buildSqlMapClient(reader);
			((SQLProviderRegistry)delegate).setSqlMapper(sqlMapper);
			reader.close();
			
			ref = ctx.getBundleContext().getServiceReference("org.eclipse.cosmos.dc.mgmt.binding.Binding");
			Binding binding = (Binding)ctx.getBundleContext().getService(ref);
			
			if(binding instanceof WSDMHelperRegistry){
				WSDMHelperRegistry helper = (WSDMHelperRegistry)binding;
				helper.registerSerializer(DataSet.class, RegistrySerializer.getDataSetSerializer());
				helper.registerSerializer(DataFlow.class, RegistrySerializer.getDataFlowSerializer());
				helper.registerSerializer(DataSource.class, RegistrySerializer.getDataSourceSerializer());
				helper.registerSerializer(DataSourceType.class, RegistrySerializer.getDataSourceTypeSerializer());
				helper.registerSerializer(DimensionSet.class, RegistrySerializer.getKeySetSerializer());
			}
		}catch(Throwable t){
			t.printStackTrace();
		}finally{
			Thread.currentThread().setContextClassLoader(prevLoader);
		}

	}
	
	protected void deactivate(ComponentContext ctxt)
	{
	}

	public Collection<DataFlow> getAllDataFlows() throws Exception {
		return delegate.getAllDataFlows();
	}

	public Collection<DataSet> getAllDataSets() throws Exception {
		return delegate.getAllDataSets();
	}

	public Collection<DataSource> getAllDataSources() throws Exception {
		return delegate.getAllDataSources();
	}

	public DataFlow getDataFlow(String name) throws Exception {
		return delegate.getDataFlow(name);
	}

	public DataSet getDataSet(String name) throws Exception {
		return delegate.getDataSet(name);
	}

	public Collection<DataSet> getDataSetsForFlow(DataFlow flow) throws Exception {
		return delegate.getDataSetsForFlow(flow);
	}

	public Collection<DataSet> getDataSetsForFlow(String flow) throws Exception {
		return delegate.getDataSetsForFlow(flow);
	}

	public Collection<DataSet> getDataSetsForSource(DataSource source) throws Exception {
		return delegate.getDataSetsForSource(source);
	}

	public Collection<DataSet> getDataSetsForSource(String source) throws Exception {
		return delegate.getDataSetsForSource(source);
	}

	public DataSource getDataSource(String name) throws Exception {
		return delegate.getDataSource(name);
	}

	public DataSourceType getDataSourceType(String name) throws Exception {
		return delegate.getDataSourceType(name);
	}

	public DimensionSet getDimensionSet(String name) throws Exception {
		return delegate.getDimensionSet(name);
	}

	public boolean registerDataFlow(DataFlow flow) throws Exception {
		return delegate.registerDataFlow(flow);
	}

	public boolean registerDataSet(DataSet ds) throws Exception {
		return delegate.registerDataSet(ds);
	}

	public boolean registerDataSource(DataSource src) throws Exception {
		return delegate.registerDataSource(src);
	}

	public boolean registerDataSourceType(DataSourceType src) throws Exception {
		return delegate.registerDataSourceType(src);
	}

	public boolean registerDimensionSet(DimensionSet dims) throws Exception {
		return delegate.registerDimensionSet(dims);
	}

	public boolean updateDataSet(DataSet ds) throws Exception {
		return delegate.updateDataSet(ds);
	}

	public Collection<DataSet> getDataSetsForSourceKeyset(String source,
			String keyset) throws Exception {
		return delegate.getDataSetsForSourceKeyset(source, keyset);
	}

	public DataSet getLatestDataSetForSourceKeyset(String source,
			String keyset) throws Exception {
		return delegate.getLatestDataSetForSourceKeyset(source, keyset);
	}
	
}
