/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import com.ibm.icu.text.DecimalFormat;
import java.util.ArrayList;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.TransformationEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;

public final class AxesRenderHelper {
    static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/render");
    AxesRenderer renderer;
    OneAxis ax;
    int iWhatToDraw;
    IPrimitiveRenderer ipr;
    private Axis axModel;
    private PlotWithAxes pwa;
    private Insets insCA;
    private ScriptHandler sh;
    private double dLocation;
    private AutoScale sc;
    private IntersectionValue iv;
    private int iMajorTickStyle;
    private int iMinorTickStyle;
    private int iLabelLocation;
    private int iOrientation;
    private IDisplayServer xs;
    private Label la;
    private double[] daEndPoints;
    private AxisTickCoordinates da;
    private double[] daMinor;
    private String sText;
    private int iDimension;
    private double dSeriesThickness;
    private NumberDataElement nde;
    private FormatSpecifier fs;
    private boolean bAxisLabelStaggered;
    private DecimalFormat df;
    private LineAttributes lia;
    private LineAttributes liaMajorTick;
    private LineAttributes liaMinorTick;
    private boolean bRenderAxisLabels;
    private boolean bRenderAxisTitle;
    private Location lo;
    private TransformationEvent trae;
    private TextRenderEvent tre;
    private LineRenderEvent lre;
    private boolean bRendering3D;
    private boolean bRenderOrthogonal3DAxis;
    private boolean bRenderBase3DAxis;
    private boolean bRenderAncillary3DAxis;
    private DeferredCache dc;
    private int axisType;
    private Location panningOffset;
    private boolean bTransposed;
    private double[] daEndPoints3D;
    private AxisTickCoordinates da3D;
    private Location3D lo3d;
    private Text3DRenderEvent t3dre;
    private Line3DRenderEvent l3dre;
    private boolean bTickBetweenCategories;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    AxesRenderHelper(AxesRenderer renderer, IPrimitiveRenderer ipr, Plot pl, OneAxis ax, int iWhatToDraw) {
        this.init(renderer, ipr, pl, ax, iWhatToDraw);
    }

    private void init(AxesRenderer renderer, IPrimitiveRenderer ipr, Plot pl, OneAxis ax, int iWhatToDraw) {
        this.renderer = renderer;
        this.ax = ax;
        this.iWhatToDraw = iWhatToDraw;
        this.ipr = ipr;
        this.axModel = ax.getModelAxis();
        this.pwa = (PlotWithAxes)renderer.getComputations();
        this.insCA = this.pwa.getAxes().getInsets();
        this.sh = this.getRunTimeContext().getScriptHandler();
        this.dLocation = ax.getAxisCoordinate();
        this.sc = ax.getScale();
        this.iv = ax.getIntersectionValue();
        this.iMajorTickStyle = ax.getGrid().getTickStyle(0);
        this.iMinorTickStyle = ax.getGrid().getTickStyle(1);
        this.iLabelLocation = ax.getLabelPosition();
        this.iOrientation = ax.getOrientation();
        this.xs = renderer.getDevice().getDisplayServer();
        this.la = LabelImpl.copyInstance(ax.getLabel());
        this.daEndPoints = this.sc.getEndPoints();
        this.da = this.sc.getTickCordinates();
        this.daMinor = this.sc.getMinorCoordinates(ax.getGrid().getMinorCountPerMajor());
        this.sText = null;
        this.iDimension = this.pwa.getDimension();
        this.nde = NumberDataElementImpl.create(0.0);
        this.dSeriesThickness = this.pwa.getSeriesThickness();
        this.fs = ax.getModelAxis().getFormatSpecifier();
        this.bAxisLabelStaggered = this.sc.isAxisLabelStaggered();
        this.df = null;
        this.lia = ax.getLineAttributes();
        this.liaMajorTick = ax.getGrid().getTickAttributes(0);
        this.liaMinorTick = ax.getGrid().getTickAttributes(1);
        this.bRenderAxisLabels = (iWhatToDraw & 2) == 2 && this.la.isVisible();
        this.bRenderAxisTitle = (iWhatToDraw & 2) == 2;
        this.lo = LocationImpl.create(0.0, 0.0);
        EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
        StructureSource structureSource = StructureSource.createAxis(this.axModel);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.chart.event.TransformationEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.trae = (TransformationEvent)eventObjectCache.getEventObject(structureSource, clazz);
        EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)ipr);
        StructureSource structureSource2 = StructureSource.createAxis(this.axModel);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.birt.chart.event.TextRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.tre = (TextRenderEvent)eventObjectCache2.getEventObject(structureSource2, clazz2);
        EventObjectCache eventObjectCache3 = (EventObjectCache)((Object)ipr);
        StructureSource structureSource3 = StructureSource.createAxis(this.axModel);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.lre = (LineRenderEvent)eventObjectCache3.getEventObject(structureSource3, clazz3);
        this.bRendering3D = this.iDimension == 2;
        this.bRenderOrthogonal3DAxis = (iWhatToDraw & 9) == 9 && this.bRendering3D;
        this.bRenderBase3DAxis = (iWhatToDraw & 5) == 5 && this.bRendering3D;
        this.bRenderAncillary3DAxis = (iWhatToDraw & 0x11) == 17 && this.bRendering3D;
        this.dc = renderer.getDeferredCache();
        this.axisType = ax.getAxisType();
        this.panningOffset = renderer.getPanningOffset();
        this.bTransposed = renderer.isTransposed();
        this.daEndPoints3D = null;
        this.da3D = null;
        this.lo3d = null;
        this.t3dre = null;
        this.l3dre = null;
        this.bTickBetweenCategories = this.axModel.getScale().isTickBetweenCategories();
    }

    private RunTimeContext getRunTimeContext() {
        return this.renderer.getRunTimeContext();
    }

    private void processTrigger(Trigger tg, StructureSource source) {
        this.renderer.processTrigger(tg, source);
    }

    IAxisTypeComputation createAxisTypeComputation(ComputationContext context) throws ChartException {
        if ((this.sc.getType() & 0x10) == 16 || this.sc.isCategoryScale()) {
            return new TextAxisTypeComputation(context);
        }
        if ((this.sc.getType() & 2) == 2) {
            return new LinearAxisTypeComputation();
        }
        if ((this.sc.getType() & 4) == 4) {
            return new LogAxisTypeComputation();
        }
        if ((this.sc.getType() & 8) == 8) {
            return new DatetimeAxisTypeComputation();
        }
        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.undefined.axis.type", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
    }

    void renderVerticalAxisByType(ComputationContext context, double dXEnd, double dZEnd, double dZ, double dStaggeredLabelOffset) throws ChartException {
        int iDirection = this.sc.getDirection() != 1 ? -1 : 1;
        IAxisTypeComputation computation = this.createAxisTypeComputation(context);
        computation.initialize();
        double dOffset = computation instanceof TextAxisTypeComputation && this.bTickBetweenCategories ? (double)iDirection * this.sc.getUnitSize() / 2.0 : 0.0;
        int length = computation instanceof TextAxisTypeComputation ? this.da.size() - 1 : this.da.size();
        double x = this.iLabelLocation == 1 ? context.dTick1 - 1.0 : context.dTick2 + 1.0;
        int i = 0;
        while (i < length) {
            block23: {
                int y;
                block22: {
                    double dXMinorTick2;
                    computation.handlePreEachTick(i);
                    y = (int)this.da.getCoordinate(i);
                    if (this.bRendering3D) {
                        context.y3d = (int)this.da3D.getCoordinate(i);
                    }
                    if ((this.iWhatToDraw & 1) != 1) break block22;
                    double dXMinorTick1 = (this.iMinorTickStyle & 1) == 1 ? context.dX - 5.0 : context.dX;
                    double d = dXMinorTick2 = (this.iMinorTickStyle & 2) == 2 ? context.dX + 5.0 : context.dX;
                    if (dXMinorTick1 != dXMinorTick2 && i != this.da.size() - 1 && !this.bRenderOrthogonal3DAxis) {
                        LineRenderEvent lreMinor = null;
                        int k = 0;
                        while (k < this.daMinor.length - 1) {
                            if (!(computation instanceof LinearAxisTypeComputation && (iDirection == -1 && (double)y - this.daMinor[k] <= this.da.getCoordinate(i + 1) || iDirection == 1 && (double)y + this.daMinor[k] >= this.da.getCoordinate(i + 1)))) {
                                EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ipr);
                                StructureSource structureSource = StructureSource.createAxis(this.axModel);
                                Class<?> clazz = class$2;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                lreMinor = (LineRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
                                lreMinor.setLineAttributes(this.liaMinorTick);
                                lreMinor.setStart(LocationImpl.create(dXMinorTick1, (double)y + (double)iDirection * this.daMinor[k]));
                                lreMinor.setEnd(LocationImpl.create(dXMinorTick2, (double)y + (double)iDirection * this.daMinor[k]));
                                this.ipr.drawLine(lreMinor);
                            }
                            ++k;
                        }
                    }
                    if (computation instanceof TextAxisTypeComputation && !this.bTickBetweenCategories && i == 0) break block23;
                    if (context.dTick1 != context.dTick2) {
                        if (!this.bRenderOrthogonal3DAxis) {
                            this.lre.setLineAttributes(this.liaMajorTick);
                            this.lre.getStart().set(context.dTick1, y);
                            this.lre.getEnd().set(context.dTick2, y);
                            this.ipr.drawLine(this.lre);
                        }
                        if (this.iv != null && this.iDimension == 1 && this.iv.getType() == 3) {
                            this.lre.setStart(LocationImpl.create(context.dX, y));
                            this.lre.setEnd(LocationImpl.create(context.dX + this.dSeriesThickness, (double)y - this.dSeriesThickness));
                            this.ipr.drawLine(this.lre);
                        }
                    }
                }
                if (this.bRenderAxisLabels && this.sc.isTickLabelVisible(i)) {
                    double sx = x;
                    double sx2 = dXEnd;
                    if (this.bAxisLabelStaggered && this.sc.isTickLabelStaggered(i)) {
                        if (this.iLabelLocation == 1) {
                            sx -= dStaggeredLabelOffset;
                            sx2 += dStaggeredLabelOffset;
                        } else {
                            sx += dStaggeredLabelOffset;
                            sx2 -= dStaggeredLabelOffset;
                        }
                    }
                    ScriptHandler.callFunction(this.sh, "beforeDrawAxisLabel", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", this.la);
                    if (this.ax.getLabel().isVisible() && this.la.isVisible()) {
                        if (this.bRendering3D) {
                            this.lo3d.set(sx - this.pwa.getHorizontalSpacingInPixels(), context.y3d + dOffset, dZEnd + this.pwa.getHorizontalSpacingInPixels());
                            this.t3dre.setLocation3D(this.lo3d);
                            this.t3dre.setTextPosition(1);
                            this.t3dre.setAction(2);
                            this.dc.addLabel(this.t3dre);
                            this.lo3d.set(sx2 + this.pwa.getHorizontalSpacingInPixels(), context.y3d + dOffset, dZ - this.pwa.getHorizontalSpacingInPixels());
                            this.t3dre.setLocation3D(this.lo3d);
                            this.t3dre.setTextPosition(2);
                            this.t3dre.setAction(2);
                            this.dc.addLabel(this.t3dre);
                        } else {
                            this.lo.set(sx, (double)y + dOffset);
                            this.tre.setAction(2);
                            this.ipr.drawText(this.tre);
                        }
                    }
                    ScriptHandler.callFunction(this.sh, "afterDrawAxisLabel", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", this.la);
                }
                computation.handlePostEachTick(i);
            }
            ++i;
        }
        computation.close();
    }

    void renderHorizontalAxisByType(ComputationContext context, double dXEnd, double dZEnd, double dZ, double dStaggeredLabelOffset) throws ChartException {
        int length;
        int iDirection = this.sc.getDirection() == -1 ? -1 : 1;
        IAxisTypeComputation computation = this.createAxisTypeComputation(context);
        computation.initialize();
        double dOffset = computation instanceof TextAxisTypeComputation && this.bTickBetweenCategories ? (double)iDirection * this.sc.getUnitSize() / 2.0 : 0.0;
        int n = length = computation instanceof TextAxisTypeComputation ? this.da.size() - 1 : this.da.size();
        double y = this.iLabelLocation == 3 ? (this.bRendering3D ? context.dTick1 + 1.0 : context.dTick1 - 1.0) : (this.bRendering3D ? context.dTick2 - 1.0 : context.dTick2 + 1.0);
        int i = 0;
        while (i < length) {
            block23: {
                int x;
                block22: {
                    double dYMinorTick2;
                    double dYMinorTick1;
                    computation.handlePreEachTick(i);
                    x = (int)this.da.getCoordinate(i);
                    if (this.bRendering3D) {
                        context.x3d = (int)this.da3D.getCoordinate(i);
                        context.z3d = (int)this.da3D.getCoordinate(i);
                    }
                    if ((this.iWhatToDraw & 1) != 1) break block22;
                    double d = (this.iMinorTickStyle & 1) == 1 ? (this.bRendering3D ? context.dY + 5.0 : context.dY - 5.0) : (dYMinorTick1 = context.dY);
                    double d2 = (this.iMinorTickStyle & 2) == 2 ? (this.bRendering3D ? context.dY - 5.0 : context.dY + 5.0) : (dYMinorTick2 = context.dY);
                    if (dYMinorTick1 != -dYMinorTick2 && i != this.da.size() - 1 && !this.bRenderBase3DAxis && !this.bRenderAncillary3DAxis) {
                        LineRenderEvent lreMinor = null;
                        int k = 0;
                        while (k < this.daMinor.length - 1) {
                            if (!(computation instanceof LinearAxisTypeComputation && (iDirection == 1 && (double)x + this.daMinor[k] >= this.da.getCoordinate(i + 1) || iDirection == -1 && (double)x - this.daMinor[k] <= this.da.getCoordinate(i + 1)))) {
                                EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ipr);
                                StructureSource structureSource = StructureSource.createAxis(this.axModel);
                                Class<?> clazz = class$2;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                lreMinor = (LineRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
                                lreMinor.setLineAttributes(this.liaMinorTick);
                                lreMinor.setStart(LocationImpl.create((double)x + (double)iDirection * this.daMinor[k], dYMinorTick1));
                                lreMinor.setEnd(LocationImpl.create((double)x + (double)iDirection * this.daMinor[k], dYMinorTick2));
                                this.ipr.drawLine(lreMinor);
                            }
                            ++k;
                        }
                    }
                    if (computation instanceof TextAxisTypeComputation && !this.bTickBetweenCategories && i == 0) break block23;
                    if (context.dTick1 != context.dTick2) {
                        if (!this.bRenderBase3DAxis && !this.bRenderAncillary3DAxis) {
                            this.lre.setLineAttributes(this.liaMajorTick);
                            this.lre.getStart().set(x, context.dTick1);
                            this.lre.getEnd().set(x, context.dTick2);
                            this.ipr.drawLine(this.lre);
                        }
                        if (this.iv != null && this.iDimension == 1 && this.iv.getType() == 3) {
                            this.lre.getStart().set(x, context.dY);
                            this.lre.getEnd().set((double)x + this.dSeriesThickness, context.dY - this.dSeriesThickness);
                            this.ipr.drawLine(this.lre);
                        }
                    }
                }
                if (this.bRenderAxisLabels && this.sc.isTickLabelVisible(i)) {
                    ScriptHandler.callFunction(this.sh, "beforeDrawAxisLabel", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", this.la);
                    double sy = y;
                    if (this.bAxisLabelStaggered && this.sc.isTickLabelStaggered(i)) {
                        sy = this.iLabelLocation == 3 ? (sy -= dStaggeredLabelOffset) : (sy += dStaggeredLabelOffset);
                    }
                    if (this.ax.getLabel().isVisible() && this.la.isVisible()) {
                        if (this.bRendering3D) {
                            if (this.axisType == 5) {
                                this.lo3d.set(context.x3d + dOffset, sy - this.pwa.getVerticalSpacingInPixels(), dZEnd + this.pwa.getVerticalSpacingInPixels());
                            } else {
                                this.lo3d.set(dXEnd + this.pwa.getVerticalSpacingInPixels(), sy - this.pwa.getVerticalSpacingInPixels(), context.z3d + dOffset);
                            }
                            this.t3dre.setLocation3D(this.lo3d);
                            this.t3dre.setAction(2);
                            this.dc.addLabel(this.t3dre);
                        } else {
                            this.lo.set((double)x + dOffset, sy);
                            this.tre.setAction(2);
                            this.ipr.drawText(this.tre);
                        }
                    }
                    ScriptHandler.callFunction(this.sh, "afterDrawAxisLabel", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", this.la);
                }
                computation.handlePostEachTick(i);
            }
            ++i;
        }
        computation.close();
    }

    public final void renderEachAxis() throws ChartException {
        ComputationContext context;
        double dStaggeredLabelOffset = this.sc.computeStaggeredAxisLabelOffset(this.xs, this.la, this.iOrientation);
        if (!this.lia.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.unset.axis.visibility", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        this.tre.setLabel(this.la);
        this.tre.setTextPosition(this.iLabelLocation);
        this.tre.setLocation(this.lo);
        this.lre.setLineAttributes(this.lia);
        this.lre.setStart(LocationImpl.create(0.0, 0.0));
        this.lre.setEnd(LocationImpl.create(0.0, 0.0));
        double dXStart = 0.0;
        double dXEnd = 0.0;
        double dZStart = 0.0;
        double dZEnd = 0.0;
        if (this.iDimension == 2) {
            AllAxes aax = this.pwa.getAxes();
            dXEnd = aax.getPrimaryBase().getScale().getEnd();
            dZEnd = aax.getAncillaryBase().getScale().getEnd();
            dXStart = aax.getPrimaryBase().getScale().getStart();
            dZStart = aax.getAncillaryBase().getScale().getStart();
            this.daEndPoints3D = this.sc.getEndPoints();
            this.da3D = this.sc.getTickCordinates();
            this.lo3d = Location3DImpl.create(0.0, 0.0, 0.0);
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ipr);
            StructureSource structureSource = StructureSource.createAxis(this.axModel);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.Text3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.t3dre = (Text3DRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
            this.t3dre.setLabel(this.la);
            this.t3dre.setAction(2);
            this.t3dre.setTextPosition(this.iLabelLocation);
            this.t3dre.setLocation3D(this.lo3d);
            EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)this.ipr);
            StructureSource structureSource2 = StructureSource.createAxis(this.axModel);
            Class<?> clazz2 = class$4;
            if (clazz2 == null) {
                try {
                    clazz2 = class$4 = Class.forName("org.eclipse.birt.chart.event.Line3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.l3dre = (Line3DRenderEvent)eventObjectCache2.getEventObject(structureSource2, clazz2);
            this.l3dre.setLineAttributes(this.lia);
            this.l3dre.setStart3D(Location3DImpl.create(0.0, 0.0, 0.0));
            this.l3dre.setEnd3D(Location3DImpl.create(0.0, 0.0, 0.0));
        }
        if (this.iOrientation == 1) {
            context = new ComputationContext(true);
            context.y3d = 0.0;
            context.dX = this.dLocation;
            double dZ = 0.0;
            if (this.bRendering3D) {
                Location3D l3d = this.ax.getAxisCoordinate3D();
                context.dX = l3d.getX();
                dZ = l3d.getZ();
            }
            if (this.iv != null && this.iv.getType() == 1 && this.iDimension == 1) {
                this.trae.setTransform(2);
                this.trae.setTranslation(this.dSeriesThickness, -this.dSeriesThickness);
                this.ipr.applyTransformation(this.trae);
            }
            context.dTick1 = (this.iMajorTickStyle & 1) == 1 ? context.dX - 5.0 : context.dX;
            double d = context.dTick2 = (this.iMajorTickStyle & 2) == 2 ? context.dX + 5.0 : context.dX;
            if ((this.iWhatToDraw & 1) == 1 && this.lia.isVisible()) {
                double dEnd;
                if (this.bRenderOrthogonal3DAxis) {
                    EList elTriggers;
                    double dStart = this.daEndPoints3D[0];
                    dEnd = this.daEndPoints3D[1];
                    this.l3dre.setLineAttributes(this.lia);
                    this.l3dre.setStart3D(context.dX, dStart, dZ);
                    this.l3dre.setEnd3D(context.dX, dEnd, dZ);
                    this.dc.addLine(this.l3dre);
                    this.l3dre.setStart3D(context.dX, dStart, dZEnd);
                    this.l3dre.setEnd3D(context.dX, dEnd, dZEnd);
                    this.dc.addLine(this.l3dre);
                    this.l3dre.setStart3D(dXEnd, dStart, dZ);
                    this.l3dre.setEnd3D(dXEnd, dEnd, dZ);
                    this.dc.addLine(this.l3dre);
                    if (this.renderer.isInteractivityEnabled() && !(elTriggers = this.axModel.getTriggers()).isEmpty()) {
                        Trigger tg;
                        int t;
                        InteractionEvent iev;
                        ArrayList<Trigger> cachedTriggers = null;
                        Location3D[] loaHotspot = new Location3D[4];
                        EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource = StructureSource.createAxis(this.axModel);
                        Class<?> clazz = class$5;
                        if (clazz == null) {
                            try {
                                clazz = class$5 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
                        loaHotspot[0] = Location3DImpl.create(context.dX - 4.0, dStart, dZ + 4.0);
                        loaHotspot[1] = Location3DImpl.create(context.dX + 4.0, dStart, dZ - 4.0);
                        loaHotspot[2] = Location3DImpl.create(context.dX + 4.0, dEnd, dZ - 4.0);
                        loaHotspot[3] = Location3DImpl.create(context.dX - 4.0, dEnd, dZ + 4.0);
                        pre3d.setPoints3D(loaHotspot);
                        pre3d.setDoubleSided(true);
                        if (this.renderer.get3DEngine().processEvent(pre3d, this.panningOffset.getX(), this.panningOffset.getY()) != null) {
                            EventObjectCache eventObjectCache3 = (EventObjectCache)((Object)this.ipr);
                            StructureSource structureSource3 = StructureSource.createAxis(this.axModel);
                            Class<?> clazz3 = class$6;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = class$6 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            iev = (InteractionEvent)eventObjectCache3.getEventObject(structureSource3, clazz3);
                            cachedTriggers = new ArrayList<Trigger>();
                            t = 0;
                            while (t < elTriggers.size()) {
                                tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                                this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                                cachedTriggers.add(tg);
                                iev.addTrigger(TriggerImpl.copyInstance(tg));
                                ++t;
                            }
                            iev.setHotSpot(pre3d);
                            this.ipr.enableInteraction(iev);
                        }
                        EventObjectCache eventObjectCache4 = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource4 = StructureSource.createAxis(this.axModel);
                        Class<?> clazz4 = class$5;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$5 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        pre3d = (Polygon3DRenderEvent)eventObjectCache4.getEventObject(structureSource4, clazz4);
                        loaHotspot = new Location3D[]{Location3DImpl.create(dXStart - 4.0, dStart, dZEnd + 4.0), Location3DImpl.create(dXStart + 4.0, dStart, dZEnd - 4.0), Location3DImpl.create(dXStart + 4.0, dEnd, dZEnd - 4.0), Location3DImpl.create(dXStart - 4.0, dEnd, dZEnd + 4.0)};
                        pre3d.setPoints3D(loaHotspot);
                        pre3d.setDoubleSided(true);
                        if (this.renderer.get3DEngine().processEvent(pre3d, this.panningOffset.getX(), this.panningOffset.getY()) != null) {
                            EventObjectCache eventObjectCache5 = (EventObjectCache)((Object)this.ipr);
                            StructureSource structureSource5 = StructureSource.createAxis(this.axModel);
                            Class<?> clazz5 = class$6;
                            if (clazz5 == null) {
                                try {
                                    clazz5 = class$6 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            iev = (InteractionEvent)eventObjectCache5.getEventObject(structureSource5, clazz5);
                            if (cachedTriggers == null) {
                                cachedTriggers = new ArrayList();
                                t = 0;
                                while (t < elTriggers.size()) {
                                    tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                                    this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                                    cachedTriggers.add(tg);
                                    iev.addTrigger(TriggerImpl.copyInstance(tg));
                                    ++t;
                                }
                            } else {
                                t = 0;
                                while (t < cachedTriggers.size()) {
                                    iev.addTrigger(TriggerImpl.copyInstance((Trigger)cachedTriggers.get(t)));
                                    ++t;
                                }
                            }
                            iev.setHotSpot(pre3d);
                            this.ipr.enableInteraction(iev);
                        }
                        EventObjectCache eventObjectCache6 = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource6 = StructureSource.createAxis(this.axModel);
                        Class<?> clazz6 = class$5;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$5 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        pre3d = (Polygon3DRenderEvent)eventObjectCache6.getEventObject(structureSource6, clazz6);
                        loaHotspot = new Location3D[]{Location3DImpl.create(dXEnd - 4.0, dStart, dZStart + 4.0), Location3DImpl.create(dXEnd + 4.0, dStart, dZStart - 4.0), Location3DImpl.create(dXEnd + 4.0, dEnd, dZStart - 4.0), Location3DImpl.create(dXEnd - 4.0, dEnd, dZStart + 4.0)};
                        pre3d.setPoints3D(loaHotspot);
                        pre3d.setDoubleSided(true);
                        if (this.renderer.get3DEngine().processEvent(pre3d, this.panningOffset.getX(), this.panningOffset.getY()) != null) {
                            EventObjectCache eventObjectCache7 = (EventObjectCache)((Object)this.ipr);
                            StructureSource structureSource7 = StructureSource.createAxis(this.axModel);
                            Class<?> clazz7 = class$6;
                            if (clazz7 == null) {
                                try {
                                    clazz7 = class$6 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            iev = (InteractionEvent)eventObjectCache7.getEventObject(structureSource7, clazz7);
                            if (cachedTriggers == null) {
                                t = 0;
                                while (t < elTriggers.size()) {
                                    tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                                    this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                                    iev.addTrigger(tg);
                                    ++t;
                                }
                            } else {
                                t = 0;
                                while (t < cachedTriggers.size()) {
                                    iev.addTrigger((Trigger)cachedTriggers.get(t));
                                    ++t;
                                }
                            }
                            iev.setHotSpot(pre3d);
                            this.ipr.enableInteraction(iev);
                        }
                    }
                } else {
                    EList elTriggers;
                    double dStart = this.daEndPoints[0] + this.insCA.getBottom();
                    dEnd = this.daEndPoints[1] - this.insCA.getTop();
                    if (this.sc.getDirection() == 1) {
                        dStart = this.daEndPoints[1] + this.insCA.getBottom();
                        dEnd = this.daEndPoints[0] - this.insCA.getTop();
                    }
                    if (this.iv != null && this.iv.getType() == 3 && this.iDimension == 1) {
                        Location[] loa = new Location[]{LocationImpl.create(context.dX, dStart), LocationImpl.create(context.dX + this.dSeriesThickness, dStart - this.dSeriesThickness), LocationImpl.create(context.dX + this.dSeriesThickness, dEnd - this.dSeriesThickness), LocationImpl.create(context.dX, dEnd)};
                        EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource = StructureSource.createAxis(this.axModel);
                        Class<?> clazz = class$7;
                        if (clazz == null) {
                            try {
                                clazz = class$7 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
                        pre.setPoints(loa);
                        pre.setBackground(ColorDefinitionImpl.create(255, 255, 255, 127));
                        pre.setOutline(this.lia);
                        this.ipr.fillPolygon(pre);
                    }
                    this.lre.setLineAttributes(this.lia);
                    this.lre.getStart().set(context.dX, dStart);
                    this.lre.getEnd().set(context.dX, dEnd);
                    this.ipr.drawLine(this.lre);
                    if (this.renderer.isInteractivityEnabled() && !(elTriggers = this.axModel.getTriggers()).isEmpty()) {
                        EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource = StructureSource.createAxis(this.axModel);
                        Class<?> clazz = class$6;
                        if (clazz == null) {
                            try {
                                clazz = class$6 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        InteractionEvent iev = (InteractionEvent)eventObjectCache.getEventObject(structureSource, clazz);
                        int t = 0;
                        while (t < elTriggers.size()) {
                            Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                            this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                            iev.addTrigger(tg);
                            ++t;
                        }
                        Location[] loaHotspot = new Location[]{LocationImpl.create(context.dX - 2.0, dStart), LocationImpl.create(context.dX + 2.0, dStart), LocationImpl.create(context.dX + 2.0, dEnd), LocationImpl.create(context.dX - 2.0, dEnd)};
                        EventObjectCache eventObjectCache8 = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource8 = StructureSource.createAxis(this.axModel);
                        Class<?> clazz8 = class$7;
                        if (clazz8 == null) {
                            try {
                                clazz8 = class$7 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache8.getEventObject(structureSource8, clazz8);
                        pre.setPoints(loaHotspot);
                        iev.setHotSpot(pre);
                        this.ipr.enableInteraction(iev);
                    }
                }
            }
            this.renderVerticalAxisByType(context, dXEnd, dZEnd, dZ, dStaggeredLabelOffset);
            this.la = LabelImpl.copyInstance(this.ax.getTitle());
            if (this.la.isVisible() && this.bRenderAxisTitle) {
                ScriptHandler.callFunction(this.sh, "beforeDrawAxisTitle", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawAxisTitle", this.la);
                String sRestoreValue = this.la.getCaption().getValue();
                this.la.getCaption().setValue(this.getRunTimeContext().externalizedMessage(sRestoreValue));
                BoundingBox bb = null;
                try {
                    bb = Methods.computeBox(this.xs, this.ax.getTitlePosition(), this.la, 0.0, 0.0, ChartUtil.computeHeightOfOrthogonalAxisTitle((ChartWithAxes)this.renderer.cm, this.xs));
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                }
                if (this.ax.getTitle().isVisible() && this.la.isVisible()) {
                    if (this.bRendering3D) {
                        Bounds cbo = this.renderer.getPlotBounds();
                        this.tre.setBlockBounds(BoundsImpl.create(cbo.getLeft() + (cbo.getWidth() / 3.0 - bb.getWidth()) / 2.0, cbo.getTop() + 30.0, bb.getWidth(), bb.getHeight()));
                        this.tre.setLabel(this.la);
                        this.tre.setBlockAlignment(this.la.getCaption().getFont().getAlignment());
                        this.tre.setAction(3);
                        this.ipr.drawText(this.tre);
                        this.tre.setBlockBounds(BoundsImpl.create(cbo.getLeft() + cbo.getWidth() - bb.getWidth(), cbo.getTop() + 60.0, bb.getWidth(), bb.getHeight()));
                        this.ipr.drawText(this.tre);
                    } else {
                        Bounds boundsTitle = ((ChartWithAxes)this.renderer.cm).getTitle().getBounds();
                        Bounds bo = BoundsImpl.create(this.ax.getTitleCoordinate(), (boundsTitle.getTop() + boundsTitle.getHeight()) / 72.0 * (double)this.xs.getDpiResolution(), bb.getWidth(), ChartUtil.computeHeightOfOrthogonalAxisTitle((ChartWithAxes)this.renderer.cm, this.xs));
                        this.tre.setBlockBounds(bo);
                        this.tre.setLabel(this.la);
                        if (this.ax.getModelAxis().getAssociatedAxes().size() != 0) {
                            this.tre.setBlockAlignment(ChartUtil.transposeAlignment(this.la.getCaption().getFont().getAlignment()));
                        } else {
                            this.tre.setBlockAlignment(this.la.getCaption().getFont().getAlignment());
                        }
                        this.tre.setAction(3);
                        if (this.ax.getTitle().isVisible()) {
                            this.ipr.drawText(this.tre);
                        }
                    }
                }
                this.la.getCaption().setValue(sRestoreValue);
                ScriptHandler.callFunction(this.sh, "afterDrawAxisTitle", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawAxisTitle", this.la);
            }
            this.la = LabelImpl.copyInstance(this.ax.getLabel());
            if (this.iv != null && this.iv.getType() == 1 && this.iDimension == 1) {
                this.trae.setTranslation(-this.dSeriesThickness, this.dSeriesThickness);
                this.ipr.applyTransformation(this.trae);
            }
        } else if (this.iOrientation == 0) {
            context = new ComputationContext(false);
            context.x3d = 0.0;
            context.z3d = 0.0;
            context.dY = this.dLocation;
            double dX = 0.0;
            double dZ = 0.0;
            if (this.bRendering3D) {
                Location3D l3d = this.ax.getAxisCoordinate3D();
                dX = l3d.getX();
                context.dY = l3d.getY();
                dZ = l3d.getZ();
            }
            double d = (this.iMajorTickStyle & 1) == 1 ? (this.bRendering3D ? context.dY + 5.0 : context.dY - 5.0) : (context.dTick1 = context.dY);
            double d2 = (this.iMajorTickStyle & 2) == 2 ? (this.bRendering3D ? context.dY - 5.0 : context.dY + 5.0) : (context.dTick2 = context.dY);
            if (this.iv != null && this.iDimension == 1 && (this.bTransposed && this.renderer.isRightToLeft() && this.iv.getType() == 2 || !this.renderer.isRightToLeft() && this.iv.getType() == 1)) {
                this.trae.setTransform(2);
                this.trae.setTranslation(this.dSeriesThickness, -this.dSeriesThickness);
                this.ipr.applyTransformation(this.trae);
            }
            if ((this.iWhatToDraw & 1) == 1 && this.lia.isVisible()) {
                double dEnd;
                if (this.bRenderBase3DAxis) {
                    EList elTriggers;
                    double dStart = this.daEndPoints3D[0];
                    dEnd = this.daEndPoints3D[1];
                    this.l3dre.setLineAttributes(this.lia);
                    this.l3dre.setStart3D(dStart, context.dY, dZ);
                    this.l3dre.setEnd3D(dEnd, context.dY, dZ);
                    this.dc.addLine(this.l3dre);
                    if (this.renderer.isInteractivityEnabled() && !(elTriggers = this.axModel.getTriggers()).isEmpty()) {
                        EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource = StructureSource.createAxis(this.axModel);
                        Class<?> clazz = class$5;
                        if (clazz == null) {
                            try {
                                clazz = class$5 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
                        Location3D[] loaHotspot = new Location3D[]{Location3DImpl.create(dStart, context.dY - 4.0, dZ), Location3DImpl.create(dStart, context.dY + 4.0, dZ), Location3DImpl.create(dEnd, context.dY + 4.0, dZ), Location3DImpl.create(dEnd, context.dY - 4.0, dZ)};
                        pre3d.setPoints3D(loaHotspot);
                        pre3d.setDoubleSided(true);
                        if (this.renderer.get3DEngine().processEvent(pre3d, this.panningOffset.getX(), this.panningOffset.getY()) != null) {
                            EventObjectCache eventObjectCache9 = (EventObjectCache)((Object)this.ipr);
                            StructureSource structureSource9 = StructureSource.createAxis(this.axModel);
                            Class<?> clazz9 = class$6;
                            if (clazz9 == null) {
                                try {
                                    clazz9 = class$6 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            InteractionEvent iev = (InteractionEvent)eventObjectCache9.getEventObject(structureSource9, clazz9);
                            int t = 0;
                            while (t < elTriggers.size()) {
                                Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                                this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                                iev.addTrigger(tg);
                                ++t;
                            }
                            iev.setHotSpot(pre3d);
                            this.ipr.enableInteraction(iev);
                        }
                    }
                } else if (this.bRenderAncillary3DAxis) {
                    EList elTriggers;
                    double dStart = this.daEndPoints3D[0];
                    dEnd = this.daEndPoints3D[1];
                    this.l3dre.setLineAttributes(this.lia);
                    this.l3dre.setStart3D(dX, context.dY, dStart);
                    this.l3dre.setEnd3D(dX, context.dY, dEnd);
                    this.dc.addLine(this.l3dre);
                    if (this.renderer.isInteractivityEnabled() && !(elTriggers = this.axModel.getTriggers()).isEmpty()) {
                        EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource = StructureSource.createAxis(this.axModel);
                        Class<?> clazz = class$5;
                        if (clazz == null) {
                            try {
                                clazz = class$5 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
                        Location3D[] loaHotspot = new Location3D[]{Location3DImpl.create(dX, context.dY - 4.0, dStart), Location3DImpl.create(dX, context.dY + 4.0, dStart), Location3DImpl.create(dX, context.dY + 4.0, dEnd), Location3DImpl.create(dX, context.dY - 4.0, dEnd)};
                        pre3d.setPoints3D(loaHotspot);
                        pre3d.setDoubleSided(true);
                        if (this.renderer.get3DEngine().processEvent(pre3d, this.panningOffset.getX(), this.panningOffset.getY()) != null) {
                            EventObjectCache eventObjectCache10 = (EventObjectCache)((Object)this.ipr);
                            StructureSource structureSource10 = StructureSource.createAxis(this.axModel);
                            Class<?> clazz10 = class$6;
                            if (clazz10 == null) {
                                try {
                                    clazz10 = class$6 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            InteractionEvent iev = (InteractionEvent)eventObjectCache10.getEventObject(structureSource10, clazz10);
                            int t = 0;
                            while (t < elTriggers.size()) {
                                Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                                this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                                iev.addTrigger(tg);
                                ++t;
                            }
                            iev.setHotSpot(pre3d);
                            this.ipr.enableInteraction(iev);
                        }
                    }
                } else {
                    EList elTriggers;
                    double dStart = this.daEndPoints[0] - this.insCA.getLeft();
                    dEnd = this.daEndPoints[1] + this.insCA.getRight();
                    if (this.sc.getDirection() == -1) {
                        dStart = this.daEndPoints[1] - this.insCA.getLeft();
                        dEnd = this.daEndPoints[0] + this.insCA.getRight();
                    }
                    if (this.iv != null && this.iv.getType() == 3 && this.iDimension == 1) {
                        Location[] loa = new Location[]{LocationImpl.create(dStart, context.dY), LocationImpl.create(dStart + this.dSeriesThickness, context.dY - this.dSeriesThickness), LocationImpl.create(dEnd + this.dSeriesThickness, context.dY - this.dSeriesThickness), LocationImpl.create(dEnd, context.dY)};
                        EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource = StructureSource.createAxis(this.axModel);
                        Class<?> clazz = class$7;
                        if (clazz == null) {
                            try {
                                clazz = class$7 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
                        pre.setPoints(loa);
                        pre.setBackground(ColorDefinitionImpl.create(255, 255, 255, 127));
                        pre.setOutline(this.lia);
                        this.ipr.fillPolygon(pre);
                    }
                    this.lre.setLineAttributes(this.lia);
                    this.lre.getStart().set(dStart, context.dY);
                    this.lre.getEnd().set(dEnd, context.dY);
                    this.ipr.drawLine(this.lre);
                    if (this.renderer.isInteractivityEnabled() && !(elTriggers = this.axModel.getTriggers()).isEmpty()) {
                        EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource = StructureSource.createAxis(this.axModel);
                        Class<?> clazz = class$6;
                        if (clazz == null) {
                            try {
                                clazz = class$6 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        InteractionEvent iev = (InteractionEvent)eventObjectCache.getEventObject(structureSource, clazz);
                        int t = 0;
                        while (t < elTriggers.size()) {
                            Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                            this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                            iev.addTrigger(tg);
                            ++t;
                        }
                        Location[] loaHotspot = new Location[]{LocationImpl.create(dStart, context.dY - 2.0), LocationImpl.create(dEnd, context.dY - 2.0), LocationImpl.create(dEnd, context.dY + 2.0), LocationImpl.create(dStart, context.dY + 2.0)};
                        EventObjectCache eventObjectCache11 = (EventObjectCache)((Object)this.ipr);
                        StructureSource structureSource11 = StructureSource.createAxis(this.axModel);
                        Class<?> clazz11 = class$7;
                        if (clazz11 == null) {
                            try {
                                clazz11 = class$7 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache11.getEventObject(structureSource11, clazz11);
                        pre.setPoints(loaHotspot);
                        iev.setHotSpot(pre);
                        this.ipr.enableInteraction(iev);
                    }
                }
            }
            this.renderHorizontalAxisByType(context, dXEnd, dZEnd, dZ, dStaggeredLabelOffset);
            this.la = LabelImpl.copyInstance(this.ax.getTitle());
            if (this.la.isVisible() && this.bRenderAxisTitle) {
                ScriptHandler.callFunction(this.sh, "beforeDrawAxisTitle", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawAxisTitle", this.la);
                String sRestoreValue = this.la.getCaption().getValue();
                this.la.getCaption().setValue(this.getRunTimeContext().externalizedMessage(sRestoreValue));
                this.la.getCaption().getFont().setAlignment(this.renderer.switchTextAlignment(this.la.getCaption().getFont().getAlignment()));
                BoundingBox bb = null;
                try {
                    bb = Methods.computeBox(this.xs, this.ax.getTitlePosition(), this.la, 0.0, 0.0, Math.abs(this.daEndPoints[1] - this.daEndPoints[0]));
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                }
                if (this.ax.getTitle().isVisible() && this.la.isVisible()) {
                    if (this.bRendering3D) {
                        Bounds cbo = this.renderer.getPlotBounds();
                        if (this.axisType == 5) {
                            this.tre.setBlockBounds(BoundsImpl.create(cbo.getLeft() + (cbo.getWidth() / 3.0 - bb.getWidth()), cbo.getTop() + cbo.getHeight() - Math.min(bb.getHeight(), bb.getWidth()), bb.getWidth(), bb.getHeight()));
                        } else {
                            this.tre.setBlockBounds(BoundsImpl.create(cbo.getLeft() + cbo.getWidth() * 2.0 / 3.0 + (cbo.getWidth() / 3.0 - bb.getWidth()) / 2.0, cbo.getTop() + cbo.getHeight() - Math.min(bb.getHeight(), bb.getWidth()), bb.getWidth(), bb.getHeight()));
                        }
                        this.tre.setLabel(this.la);
                        this.tre.setBlockAlignment(this.la.getCaption().getFont().getAlignment());
                        this.tre.setAction(3);
                        this.ipr.drawText(this.tre);
                    } else {
                        Bounds bo = BoundsImpl.create(this.daEndPoints[0], this.ax.getTitleCoordinate(), this.daEndPoints[1] - this.daEndPoints[0], bb.getHeight());
                        this.tre.setBlockBounds(bo);
                        this.tre.setLabel(this.la);
                        if (this.ax.getModelAxis().getAssociatedAxes().size() != 0) {
                            this.tre.setBlockAlignment(this.la.getCaption().getFont().getAlignment());
                        } else {
                            this.tre.setBlockAlignment(ChartUtil.transposeAlignment(this.la.getCaption().getFont().getAlignment()));
                        }
                        this.tre.setAction(3);
                        this.ipr.drawText(this.tre);
                    }
                }
                ScriptHandler.callFunction(this.sh, "afterDrawAxisTitle", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawAxisTitle", this.la);
            }
            this.la = LabelImpl.copyInstance(this.ax.getLabel());
            if (this.iv != null && this.iDimension == 1 && (this.bTransposed && this.renderer.isRightToLeft() && this.iv.getType() == 2 || !this.renderer.isRightToLeft() && this.iv.getType() == 1)) {
                this.trae.setTranslation(-this.dSeriesThickness, this.dSeriesThickness);
                this.ipr.applyTransformation(this.trae);
            }
        }
    }

    final class ComputationContext {
        boolean isVertical;
        double dTick1;
        double dTick2;
        double dX;
        double y3d;
        double dY;
        double x3d;
        double z3d;

        public ComputationContext(boolean isVertical) {
            this.isVertical = isVertical;
        }
    }

    private final class DatetimeAxisTypeComputation
    implements IAxisTypeComputation {
        CDateTime cdt;
        CDateTime cdtAxisValue;
        int iUnit;
        int iStep;
        IDateFormatWrapper sdf;

        private DatetimeAxisTypeComputation() {
        }

        public void close() throws ChartException {
        }

        public void handlePostEachTick(int i) throws ChartException {
            this.cdt = this.cdtAxisValue.forward(this.iUnit, this.iStep * (i + 1));
        }

        public void handlePreEachTick(int i) throws ChartException {
            try {
                AxesRenderHelper.this.sText = ValueFormatter.format((Object)this.cdt, AxesRenderHelper.this.fs, AxesRenderHelper.this.ax.getRunTimeContext().getULocale(), this.sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                AxesRenderHelper.this.sText = IConstants.NULL_STRING;
            }
            AxesRenderHelper.this.la.getCaption().setValue(AxesRenderHelper.this.sText);
        }

        public void initialize() throws ChartException {
            this.cdtAxisValue = Methods.asDateTime(AxesRenderHelper.this.sc.getMinimum());
            this.iUnit = Methods.asInteger(AxesRenderHelper.this.sc.getUnit());
            this.iStep = Methods.asInteger(AxesRenderHelper.this.sc.getStep());
            if (AxesRenderHelper.this.fs == null) {
                this.sdf = DateFormatWrapperFactory.getPreferredDateFormat(this.iUnit, AxesRenderHelper.this.getRunTimeContext().getULocale());
            }
            this.cdt = this.cdtAxisValue;
        }
    }

    static interface IAxisTypeComputation {
        public void initialize() throws ChartException;

        public void close() throws ChartException;

        public void handlePreEachTick(int var1) throws ChartException;

        public void handlePostEachTick(int var1) throws ChartException;
    }

    private final class LinearAxisTypeComputation
    implements IAxisTypeComputation {
        double dAxisValue;
        double dAxisStep;

        private LinearAxisTypeComputation() {
        }

        public void close() throws ChartException {
        }

        public void handlePostEachTick(int i) throws ChartException {
            this.dAxisValue = i == AxesRenderHelper.this.da.size() - 2 ? Methods.asDouble(AxesRenderHelper.this.sc.getMaximum()) : (this.dAxisValue += this.dAxisStep);
        }

        public void handlePreEachTick(int i) throws ChartException {
            if (AxesRenderHelper.this.bRenderAxisLabels && AxesRenderHelper.this.sc.isTickLabelVisible(i)) {
                AxesRenderHelper.this.nde.setValue(this.dAxisValue);
                try {
                    AxesRenderHelper.this.sText = ValueFormatter.format(AxesRenderHelper.this.nde, AxesRenderHelper.this.fs, AxesRenderHelper.this.ax.getRunTimeContext().getULocale(), AxesRenderHelper.this.df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    AxesRenderHelper.this.sText = IConstants.NULL_STRING;
                }
                AxesRenderHelper.this.la.getCaption().setValue(AxesRenderHelper.this.sText);
            }
        }

        public void initialize() throws ChartException {
            this.dAxisValue = Methods.asDouble(AxesRenderHelper.this.sc.getMinimum());
            this.dAxisStep = Methods.asDouble(AxesRenderHelper.this.sc.getStep());
            if (AxesRenderHelper.this.fs == null) {
                AxesRenderHelper.this.df = AxesRenderHelper.this.sc.computeDecimalFormat(this.dAxisValue, this.dAxisStep);
            }
        }
    }

    private final class LogAxisTypeComputation
    implements IAxisTypeComputation {
        double dAxisValue;
        double dAxisStep;

        private LogAxisTypeComputation() {
        }

        public void close() throws ChartException {
        }

        public void handlePostEachTick(int i) throws ChartException {
            this.dAxisValue *= this.dAxisStep;
        }

        public void handlePreEachTick(int i) throws ChartException {
            if (AxesRenderHelper.this.bRenderAxisLabels) {
                AxesRenderHelper.this.nde.setValue(this.dAxisValue);
                try {
                    AxesRenderHelper.this.sText = ValueFormatter.format(AxesRenderHelper.this.nde, AxesRenderHelper.this.fs, AxesRenderHelper.this.ax.getRunTimeContext().getULocale(), AxesRenderHelper.this.df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    AxesRenderHelper.this.sText = IConstants.NULL_STRING;
                }
                AxesRenderHelper.this.la.getCaption().setValue(AxesRenderHelper.this.sText);
            }
        }

        public void initialize() throws ChartException {
            this.dAxisValue = Methods.asDouble(AxesRenderHelper.this.sc.getMinimum());
            this.dAxisStep = Methods.asDouble(AxesRenderHelper.this.sc.getStep());
            if (AxesRenderHelper.this.fs == null) {
                AxesRenderHelper.this.df = AxesRenderHelper.this.sc.computeDecimalFormat(this.dAxisValue, this.dAxisStep);
            }
        }
    }

    private final class TextAxisTypeComputation
    implements IAxisTypeComputation {
        ComputationContext context;
        ITextMetrics itmText;
        int iDateTimeUnit;

        TextAxisTypeComputation(ComputationContext context) {
            this.context = context;
        }

        public void initialize() throws ChartException {
            this.iDateTimeUnit = AxesRenderHelper.this.sc.getType() == 8 ? CDateTime.computeUnit(AxesRenderHelper.this.sc.getData()) : 0;
            this.itmText = AxesRenderHelper.this.xs.getTextMetrics(AxesRenderHelper.this.la);
            AxesRenderHelper.this.sc.getData().reset();
        }

        public void close() throws ChartException {
            if (AxesRenderHelper.this.bTickBetweenCategories) {
                if (this.context.isVertical) {
                    int y = (int)AxesRenderHelper.this.da.getEnd();
                    if (AxesRenderHelper.this.bRendering3D) {
                        this.context.y3d = (int)AxesRenderHelper.this.da3D.getEnd();
                    }
                    if (this.context.dTick1 != this.context.dTick2) {
                        if (!AxesRenderHelper.this.bRenderOrthogonal3DAxis) {
                            AxesRenderHelper.this.lre.setLineAttributes(AxesRenderHelper.this.liaMajorTick);
                            AxesRenderHelper.this.lre.getStart().set(this.context.dTick1, y);
                            AxesRenderHelper.this.lre.getEnd().set(this.context.dTick2, y);
                            AxesRenderHelper.this.ipr.drawLine(AxesRenderHelper.this.lre);
                        }
                        if (AxesRenderHelper.this.iv != null && AxesRenderHelper.this.iDimension == 1 && AxesRenderHelper.this.iv.getType() == 3) {
                            AxesRenderHelper.this.lre.setStart(LocationImpl.create(this.context.dX, y));
                            AxesRenderHelper.this.lre.setEnd(LocationImpl.create(this.context.dX + AxesRenderHelper.this.dSeriesThickness, (double)y - AxesRenderHelper.this.dSeriesThickness));
                            AxesRenderHelper.this.ipr.drawLine(AxesRenderHelper.this.lre);
                        }
                    }
                } else {
                    int x = (int)AxesRenderHelper.this.da.getEnd();
                    if ((AxesRenderHelper.this.iWhatToDraw & 1) == 1 && this.context.dTick1 != this.context.dTick2) {
                        if (!AxesRenderHelper.this.bRenderBase3DAxis && !AxesRenderHelper.this.bRenderAncillary3DAxis) {
                            AxesRenderHelper.this.lre.setLineAttributes(AxesRenderHelper.this.liaMajorTick);
                            AxesRenderHelper.this.lre.getStart().set(x, this.context.dTick1);
                            AxesRenderHelper.this.lre.getEnd().set(x, this.context.dTick2);
                            AxesRenderHelper.this.ipr.drawLine(AxesRenderHelper.this.lre);
                        }
                        if (AxesRenderHelper.this.iv != null && AxesRenderHelper.this.iDimension == 1 && AxesRenderHelper.this.iv.getType() == 3) {
                            AxesRenderHelper.this.lre.getStart().set(x, this.context.dY);
                            AxesRenderHelper.this.lre.getEnd().set((double)x + AxesRenderHelper.this.dSeriesThickness, this.context.dY - AxesRenderHelper.this.dSeriesThickness);
                            AxesRenderHelper.this.ipr.drawLine(AxesRenderHelper.this.lre);
                        }
                    }
                }
            }
            this.itmText.dispose();
        }

        public void handlePostEachTick(int i) throws ChartException {
        }

        public void handlePreEachTick(int i) throws ChartException {
            if (AxesRenderHelper.this.bRenderAxisLabels) {
                if (!AxesRenderHelper.this.bTickBetweenCategories && i == 0) {
                    AxesRenderHelper.this.la.getCaption().setValue("");
                } else {
                    AxesRenderHelper.this.la.getCaption().setValue(AxesRenderHelper.this.sc.formatCategoryValue(AxesRenderHelper.this.sc.getType(), AxesRenderHelper.this.sc.getData().next(), this.iDateTimeUnit));
                }
                if (AxesRenderHelper.this.sc.isTickLabelVisible(i)) {
                    this.itmText.reuse(AxesRenderHelper.this.la);
                }
            }
        }
    }
}

