/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.Grid;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWith2DAxes;
import org.eclipse.birt.chart.computation.withaxes.PlotWith3DAxes;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.BlockGenerationEvent;
import org.eclipse.birt.chart.event.ClipRenderEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.I3DRenderEvent;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Oval3DRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.internal.model.FittingCalculator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.CurveFitting;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataElement;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.render.AxesRenderHelper;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.IAxesDecorator;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.render.MarkerRenderer;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;

public abstract class AxesRenderer
extends BaseRenderer {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/render");
    private Axis ax;
    private boolean leftWallFill = false;
    private boolean rightWallFill = false;
    private boolean floorFill = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public final void render(Map htRenderers, Bounds bo) throws ChartException {
        Enumeration e;
        Block bl;
        boolean bFirstInSequence = this.iSeriesIndex == 0;
        boolean bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        long lTimer = System.currentTimeMillis();
        Chart cm = this.getModel();
        IDeviceRenderer idr = this.getDevice();
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        if (bFirstInSequence) {
            lTimer = System.currentTimeMillis();
            htRenderers.put("T", new Long(lTimer));
            bl = cm.getBlock();
            e = bl.children(true);
            BlockGenerationEvent bge = new BlockGenerationEvent(bl);
            ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
            bge.updateBlock(bl);
            this.renderChartBlock(idr, bl, StructureSource.createChartBlock(bl));
            ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
            while (e.hasMoreElements()) {
                bl = (Block)e.nextElement();
                bge.updateBlock(bl);
                if (bl instanceof Plot) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderPlot(idr, (Plot)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    if (bLastInSequence) continue;
                    break;
                }
                if (bl instanceof TitleBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderTitle(idr, (TitleBlock)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof LabelBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLabel(idr, bl, StructureSource.createUnknown(bl));
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof Legend) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLegend(idr, (Legend)bl, htRenderers);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderBlock(idr, bl, StructureSource.createUnknown(bl));
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
            }
        } else if (bLastInSequence) {
            bl = cm.getBlock();
            e = bl.children(true);
            BlockGenerationEvent bge = new BlockGenerationEvent(this);
            boolean bStarted = false;
            while (e.hasMoreElements()) {
                bl = (Block)e.nextElement();
                if (!bStarted && !bl.isPlot()) continue;
                bStarted = true;
                bge.updateBlock(bl);
                if (bl instanceof Plot) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderPlot(idr, (Plot)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof TitleBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderTitle(idr, (TitleBlock)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof LabelBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLabel(idr, bl, StructureSource.createUnknown(bl));
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof Legend) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLegend(idr, (Legend)bl, htRenderers);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderBlock(idr, bl, StructureSource.createUnknown(bl));
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
            }
        } else {
            BlockGenerationEvent bge = new BlockGenerationEvent(this);
            Plot p = cm.getPlot();
            bge.updateBlock(p);
            ScriptHandler.callFunction(sh, "beforeDrawBlock", p, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", p);
            this.renderPlot(idr, p);
            ScriptHandler.callFunction(sh, "afterDrawBlock", p, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawBlock", p);
        }
        lTimer = System.currentTimeMillis() - lTimer;
        if (htRenderers.containsKey("T")) {
            Long l = (Long)htRenderers.get("T");
            htRenderers.put("T", new Long(l + lTimer));
        } else {
            htRenderers.put("T", new Long(lTimer));
        }
        if (bLastInSequence) {
            Object obj = this.getComputations();
            if (obj instanceof PlotWith2DAxes) {
                PlotWith2DAxes pw2da = (PlotWith2DAxes)this.getComputations();
                pw2da.getStackedSeriesLookup().resetSubUnits();
            }
            logger.log(1, Messages.getString("info.elapsed.render.time", new Object[]{new Long(lTimer)}, this.getRunTimeContext().getULocale()));
            htRenderers.remove("T");
        }
    }

    private final int compare(DataElement de1, DataElement de2) throws ChartException {
        Class<?> c2;
        if (de1 == null && de2 == null) {
            return 0;
        }
        if (de1 == null || de2 == null) {
            return -2;
        }
        Class<?> c1 = de1.getClass();
        if (c1.equals(c2 = de2.getClass())) {
            if (de1 instanceof NumberDataElement) {
                return Double.compare(((NumberDataElement)de1).getValue(), ((NumberDataElement)de2).getValue());
            }
            if (de1 instanceof DateTimeDataElement) {
                long l1 = ((DateTimeDataElement)de1).getValue();
                long l2 = ((DateTimeDataElement)de1).getValue();
                return l1 < l1 ? -1 : (l1 == l2 ? 0 : 1);
            }
            if (de1 instanceof TextDataElement) {
                throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.unsupported.compare.text", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.unsupported.compare.unknown.objects", new Object[]{de1, de2}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.unsupported.compare.different.objects", new Object[]{de1, de2}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
    }

    private static final TextAlignment anchorToAlignment(Anchor anc) {
        TextAlignment ta = TextAlignmentImpl.create();
        if (anc == null) {
            return ta;
        }
        switch (anc.getValue()) {
            case 0: 
            case 1: 
            case 7: {
                ta.setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                ta.setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
                break;
            }
            default: {
                ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            }
        }
        switch (anc.getValue()) {
            case 1: 
            case 2: 
            case 3: {
                ta.setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                ta.setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
                break;
            }
            default: {
                ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            }
        }
        return ta;
    }

    private void sort(double[] a, double[] b, final boolean sortFirstArray) {
        double[][] sa = new double[a.length][2];
        int i = 0;
        while (i < a.length) {
            double[] ca = new double[]{a[i], b[i]};
            sa[i] = ca;
            ++i;
        }
        Arrays.sort(sa, new Comparator(){

            public int compare(Object o1, Object o2) {
                double[] l1 = (double[])o1;
                double[] l2 = (double[])o2;
                if (sortFirstArray) {
                    if (l1[0] == l2[0]) {
                        return 0;
                    }
                    if (l1[0] < l2[0]) {
                        return -1;
                    }
                } else {
                    if (l1[1] == l2[1]) {
                        return 0;
                    }
                    if (l1[1] < l2[1]) {
                        return -1;
                    }
                }
                return 1;
            }
        });
        i = 0;
        while (i < a.length) {
            a[i] = sa[i][0];
            b[i] = sa[i][1];
            ++i;
        }
    }

    protected final void renderFittingCurve(IPrimitiveRenderer ipr, Location[] points, CurveFitting curve, boolean bShowAsTape, boolean bDeferred) throws ChartException {
        if (!curve.getLineAttributes().isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.curve.line.visibility.not.defined", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean isTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        if (curve.getLineAttributes().isVisible()) {
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "beforeDrawFittingCurve", curve, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawFittingCurve", curve);
            double[] xArray = new double[points.length];
            double[] yArray = new double[points.length];
            int i = 0;
            while (i < xArray.length) {
                xArray[i] = points[i].getX();
                yArray[i] = points[i].getY();
                ++i;
            }
            this.sort(xArray, yArray, !isTransposed);
            double[] baseArray = xArray;
            double[] orthogonalArray = yArray;
            if (isTransposed) {
                baseArray = yArray;
                orthogonalArray = xArray;
            }
            FittingCalculator fc = new FittingCalculator(baseArray, orthogonalArray, 0.33);
            double[] fitYarray = fc.getFittedValue();
            orthogonalArray = fitYarray;
            if (isTransposed) {
                baseArray = fitYarray;
                orthogonalArray = yArray;
                this.sort(baseArray, orthogonalArray, false);
            }
            if (curve.getLineAttributes().getColor() != null) {
                CurveRenderer crdr = new CurveRenderer((ChartWithAxes)this.getModel(), this, curve.getLineAttributes(), LocationImpl.create(baseArray, orthogonalArray), bShowAsTape, -1.0, bDeferred, false, null, false, true);
                crdr.draw(ipr);
            }
            if (curve.getLabel().isSetVisible() && curve.getLabel().isVisible()) {
                double xs;
                double ys;
                Label lb = LabelImpl.copyInstance(curve.getLabel());
                String sPreviousValue = lb.getCaption().getValue();
                lb.getCaption().setValue(this.getRunTimeContext().externalizedMessage(sPreviousValue));
                BoundingBox bb = Methods.computeBox(this.getXServer(), 1, lb, 0.0, 0.0);
                Anchor lbAnchor = curve.getLabelAnchor();
                if (lbAnchor == null) {
                    lbAnchor = Anchor.NORTH_LITERAL;
                }
                int horizontal = 3;
                int vertical = 3;
                switch (lbAnchor.getValue()) {
                    case 5: 
                    case 6: 
                    case 7: {
                        horizontal = 1;
                        break;
                    }
                    case 0: 
                    case 4: {
                        horizontal = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        horizontal = 2;
                    }
                }
                switch (lbAnchor.getValue()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        vertical = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        vertical = 4;
                    }
                }
                if (isTransposed) {
                    if (horizontal == 1) {
                        ys = orthogonalArray[orthogonalArray.length - 1] - bb.getHeight();
                        horizontal = 2;
                    } else if (horizontal == 2) {
                        ys = orthogonalArray[0];
                        horizontal = 1;
                    } else {
                        ys = orthogonalArray[0] + (orthogonalArray[orthogonalArray.length - 1] - orthogonalArray[0]) / 2.0 - bb.getHeight() / 2.0;
                    }
                    xs = this.getFitYPosition(orthogonalArray, baseArray, horizontal, bb.getHeight(), bb.getWidth(), vertical == 4);
                } else {
                    xs = horizontal == 1 ? xArray[0] : (horizontal == 2 ? xArray[xArray.length - 1] - bb.getWidth() : xArray[0] + (xArray[xArray.length - 1] - xArray[0]) / 2.0 - bb.getWidth() / 2.0);
                    ys = this.getFitYPosition(xArray, fitYarray, horizontal, bb.getWidth(), bb.getHeight(), vertical == 3);
                }
                bb.setLeft(xs);
                bb.setTop(ys);
                this.renderLabel(StructureSource.createSeries(this.getSeries()), 3, lb, Position.RIGHT_LITERAL, LocationImpl.create(bb.getLeft(), bb.getTop()), BoundsImpl.create(bb.getLeft(), bb.getTop(), bb.getWidth(), bb.getHeight()));
            }
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "afterDrawFittingCurve", curve, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawFittingCurve", curve);
        }
    }

    private double getFitYPosition(double[] xa, double[] ya, int align, double width, double height, boolean above) {
        int gap = 10;
        double rt = 0.0;
        if (align == 1) {
            rt = ya[0];
        } else if (align == 2) {
            rt = ya[ya.length - 1];
        } else if (ya.length % 2 == 1) {
            rt = ya[ya.length / 2];
        } else {
            int x = ya.length / 2;
            rt = (ya[x] + ya[x - 1]) / 2.0;
        }
        return above ? rt - height - (double)gap : rt + (double)gap;
    }

    private final void renderMarkerRanges(OneAxis[] oaxa, Bounds boPlotClientArea) throws ChartException {
        int iAxisCount = oaxa.length;
        double dMin = 0.0;
        double dMax = 0.0;
        int iCompare = 0;
        Bounds bo = BoundsImpl.create(0.0, 0.0, 0.0, 0.0);
        IDeviceRenderer idr = this.getDevice();
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        boolean bTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        StringBuffer sb = new StringBuffer();
        Bounds boText = BoundsImpl.create(0.0, 0.0, 0.0, 0.0);
        Anchor anc = null;
        Label la = null;
        double dOriginalAngle = 0.0;
        int i = 0;
        while (i < iAxisCount) {
            Axis ax = oaxa[i].getModelAxis();
            int iOrientation = ax.getOrientation().getValue();
            if (bTransposed) {
                iOrientation = iOrientation == 0 ? 1 : 0;
            }
            AutoScale asc = oaxa[i].getScale();
            EList el = ax.getMarkerRanges();
            int iRangeCount = el.size();
            int j = 0;
            while (j < iRangeCount) {
                block41: {
                    EList elTriggers;
                    MarkerRange mr = (MarkerRange)el.get(j);
                    ScriptHandler.callFunction(sh, "beforeDrawMarkerRange", ax, mr, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawMarkerRange", mr);
                    DataElement deStart = mr.getStartValue();
                    DataElement deEnd = mr.getEndValue();
                    try {
                        iCompare = this.compare(deStart, deEnd);
                    }
                    catch (ChartException dfex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)dfex));
                    }
                    if (iCompare == 1) {
                        DataElement deTemp = deStart;
                        deStart = deEnd;
                        deEnd = deTemp;
                    }
                    if (this.isDimension3D()) {
                        return;
                    }
                    try {
                        dMin = deStart == null ? (iOrientation == 0 ? boPlotClientArea.getLeft() : boPlotClientArea.getTop() + boPlotClientArea.getHeight()) : PlotWith2DAxes.getLocation(asc, deStart);
                    }
                    catch (Exception exception) {
                        logger.log(2, Messages.getString("exception.cannot.locate.start.marker.range", new Object[]{deStart, mr}, this.getRunTimeContext().getULocale()));
                        break block41;
                    }
                    try {
                        dMax = deEnd == null ? (iOrientation == 0 ? boPlotClientArea.getLeft() + boPlotClientArea.getWidth() : boPlotClientArea.getTop()) : PlotWith2DAxes.getLocation(asc, deEnd);
                    }
                    catch (Exception exception) {
                        logger.log(2, Messages.getString("exception.cannot.locate.end.marker.range", new Object[]{deEnd, mr}, this.getRunTimeContext().getULocale()));
                        break block41;
                    }
                    EventObjectCache eventObjectCache = (EventObjectCache)((Object)idr);
                    StructureSource structureSource = StructureSource.createMarkerRange(mr);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.birt.chart.event.RectangleRenderEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    RectangleRenderEvent rre = (RectangleRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
                    if (iOrientation == 0) {
                        if (dMax > boPlotClientArea.getLeft() + boPlotClientArea.getWidth()) {
                            dMax = boPlotClientArea.getLeft() + boPlotClientArea.getWidth();
                        }
                        if (dMin < boPlotClientArea.getLeft()) {
                            dMax = boPlotClientArea.getLeft();
                        }
                        bo.set(dMin, boPlotClientArea.getTop(), dMax - dMin, boPlotClientArea.getHeight());
                    } else {
                        if (dMax < boPlotClientArea.getTop()) {
                            dMax = boPlotClientArea.getTop();
                        }
                        if (dMin > boPlotClientArea.getTop() + boPlotClientArea.getHeight()) {
                            dMin = boPlotClientArea.getTop() + boPlotClientArea.getHeight();
                        }
                        bo.set(boPlotClientArea.getLeft(), dMax, boPlotClientArea.getWidth(), dMin - dMax);
                    }
                    if (pwa.getDimension() == 1) {
                        if (iOrientation == 0) {
                            bo.translate(pwa.getSeriesThickness(), 0.0);
                        } else {
                            bo.translate(0.0, -pwa.getSeriesThickness());
                        }
                    }
                    rre.setBounds(bo);
                    rre.setOutline(mr.getOutline());
                    rre.setBackground(mr.getFill());
                    idr.fillRectangle(rre);
                    idr.drawRectangle(rre);
                    la = LabelImpl.copyInstance(mr.getLabel());
                    if (la.isVisible()) {
                        if (la.getCaption().getValue() != null && !"".equals(la.getCaption().getValue()) && la.getCaption().getValue().length() > 0) {
                            la.getCaption().setValue(oaxa[i].getRunTimeContext().externalizedMessage(la.getCaption().getValue()));
                        } else {
                            try {
                                sb.delete(0, sb.length());
                                sb.append(Messages.getString("prefix.marker.range.caption", this.getRunTimeContext().getULocale()));
                                sb.append(ValueFormatter.format(deStart, mr.getFormatSpecifier(), oaxa[i].getRunTimeContext().getULocale(), null));
                                sb.append(Messages.getString("separator.marker.range.caption", this.getRunTimeContext().getULocale()));
                                sb.append(ValueFormatter.format(deEnd, mr.getFormatSpecifier(), oaxa[i].getRunTimeContext().getULocale(), null));
                                sb.append(Messages.getString("suffix.marker.range.caption", this.getRunTimeContext().getULocale()));
                                la.getCaption().setValue(sb.toString());
                            }
                            catch (ChartException dfex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)dfex));
                            }
                        }
                        anc = this.switchAnchor(mr.getLabelAnchor());
                        if (bTransposed) {
                            dOriginalAngle = la.getCaption().getFont().getRotation();
                            try {
                                la.getCaption().getFont().setRotation(pwa.getTransposedAngle(dOriginalAngle));
                                anc = ChartUtil.transposeAnchor(anc);
                            }
                            catch (IllegalArgumentException uiex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                            }
                        }
                        BoundingBox bb = null;
                        try {
                            bb = Methods.computeBox(idr.getDisplayServer(), 1, la, 0.0, 0.0);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                        }
                        boText.set(0.0, 0.0, bb.getWidth(), bb.getHeight());
                        EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)idr);
                        StructureSource structureSource2 = StructureSource.createMarkerRange(mr);
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.eclipse.birt.chart.event.TextRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        TextRenderEvent tre = (TextRenderEvent)eventObjectCache2.getEventObject(structureSource2, clazz2);
                        tre.setBlockBounds(bo);
                        tre.setBlockAlignment(AxesRenderer.anchorToAlignment(anc));
                        tre.setLabel(la);
                        tre.setAction(3);
                        this.getDeferredCache().addLabel(tre);
                    }
                    if (this.isInteractivityEnabled() && !(elTriggers = mr.getTriggers()).isEmpty()) {
                        EventObjectCache eventObjectCache3 = (EventObjectCache)((Object)idr);
                        StructureSource structureSource3 = StructureSource.createMarkerRange(mr);
                        Class<?> clazz3 = class$2;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        InteractionEvent iev = (InteractionEvent)eventObjectCache3.getEventObject(structureSource3, clazz3);
                        int t = 0;
                        while (t < elTriggers.size()) {
                            Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                            this.processTrigger(tg, StructureSource.createMarkerRange(mr));
                            iev.addTrigger(tg);
                            ++t;
                        }
                        iev.setHotSpot(rre);
                        idr.enableInteraction(iev);
                    }
                    ScriptHandler.callFunction(sh, "afterDrawMarkerRange", ax, mr, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawMarkerRange", mr);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void renderBackground(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        LineRenderEvent lre;
        int j;
        Line3DRenderEvent lre3d;
        AutoScale sc;
        LineAttributes lia;
        PolygonRenderEvent pre;
        Location[] loa;
        super.renderBackground(ipr, p);
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        ClientArea ca = p.getClientArea();
        Bounds bo = pwa.getPlotBounds();
        EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
        StructureSource structureSource = StructureSource.createPlot(p);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.chart.event.RectangleRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
        if (!this.isDimension3D()) {
            if (ca.getShadowColor() != null) {
                rre.setBounds(bo.translateInstance(3.0, 3.0));
                rre.setBackground(ca.getShadowColor());
                ipr.fillRectangle(rre);
            }
            rre.setBounds(bo);
            rre.setOutline(ca.getOutline());
            rre.setBackground(ca.getBackground());
            ipr.fillRectangle(rre);
        }
        double dSeriesThickness = pwa.getSeriesThickness();
        double[] daX = new double[]{bo.getLeft() - dSeriesThickness, bo.getLeft() + bo.getWidth() - dSeriesThickness};
        double[] daY = new double[]{bo.getTop() + bo.getHeight() + dSeriesThickness, bo.getTop() + dSeriesThickness};
        AllAxes aax = pwa.getAxes();
        AutoScale scPrimaryBase = null;
        AutoScale scPrimaryOrthogonal = null;
        AutoScale scAncillaryBase = null;
        double dXStart = 0.0;
        double dYStart = 0.0;
        double dZStart = 0.0;
        double dXEnd = 0.0;
        double dYEnd = 0.0;
        double dZEnd = 0.0;
        int baseTickCount = 0;
        int ancillaryTickCount = 0;
        int orthogonalTickCount = 0;
        double xStep = 0.0;
        double yStep = 0.0;
        double zStep = 0.0;
        if (this.isDimension3D()) {
            scPrimaryBase = aax.getPrimaryBase().getScale();
            scPrimaryOrthogonal = aax.getPrimaryOrthogonal().getScale();
            scAncillaryBase = aax.getAncillaryBase().getScale();
            dXStart = scPrimaryBase.getStart();
            dYStart = scPrimaryOrthogonal.getStart();
            dZStart = scAncillaryBase.getStart();
            dXEnd = scPrimaryBase.getEnd();
            dYEnd = scPrimaryOrthogonal.getEnd();
            dZEnd = scAncillaryBase.getEnd();
            baseTickCount = scPrimaryBase.getTickCordinates().size();
            ancillaryTickCount = scAncillaryBase.getTickCordinates().size();
            orthogonalTickCount = scPrimaryOrthogonal.getTickCordinates().size();
            xStep = scPrimaryBase.getUnitSize();
            yStep = scPrimaryOrthogonal.getUnitSize();
            zStep = scAncillaryBase.getUnitSize();
        }
        if (pwa.getDimension() == 1) {
            loa = null;
            if (cwa.getWallFill() == null) {
                this.renderPlane(ipr, StructureSource.createPlot(p), new Location[]{LocationImpl.create(daX[0], daY[0]), LocationImpl.create(daX[0], daY[1])}, ca.getBackground(), ca.getOutline(), cwa.getDimension(), dSeriesThickness, false);
            } else {
                loa = new Location[]{LocationImpl.create(daX[0], daY[0]), LocationImpl.create(daX[0], daY[1]), LocationImpl.create(daX[0] + dSeriesThickness, daY[1] - dSeriesThickness), LocationImpl.create(daX[0] + dSeriesThickness, daY[0] - dSeriesThickness)};
                EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)ipr);
                StructureSource structureSource2 = StructureSource.createPlot(p);
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                pre = (PolygonRenderEvent)eventObjectCache2.getEventObject(structureSource2, clazz2);
                pre.setPoints(loa);
                pre.setBackground(cwa.getWallFill());
                pre.setOutline(ca.getOutline());
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
            if (cwa.getFloorFill() == null) {
                this.renderPlane(ipr, StructureSource.createPlot(p), new Location[]{LocationImpl.create(daX[0], daY[0]), LocationImpl.create(daX[1], daY[0])}, ca.getBackground(), ca.getOutline(), cwa.getDimension(), dSeriesThickness, false);
            } else {
                if (loa == null) {
                    loa = new Location[]{LocationImpl.create(daX[0], daY[0]), LocationImpl.create(daX[1], daY[0]), LocationImpl.create(daX[1] + dSeriesThickness, daY[0] - dSeriesThickness), LocationImpl.create(daX[0] + dSeriesThickness, daY[0] - dSeriesThickness)};
                }
                EventObjectCache eventObjectCache3 = (EventObjectCache)((Object)ipr);
                StructureSource structureSource3 = StructureSource.createPlot(p);
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                pre = (PolygonRenderEvent)eventObjectCache3.getEventObject(structureSource3, clazz3);
                pre.setPoints(loa);
                pre.setBackground(cwa.getFloorFill());
                pre.setOutline(ca.getOutline());
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        } else if (pwa.getDimension() == 2) {
            loa = null;
            EventObjectCache eventObjectCache4 = (EventObjectCache)((Object)ipr);
            StructureSource structureSource4 = StructureSource.createPlot(p);
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            pre = (Polygon3DRenderEvent)eventObjectCache4.getEventObject(structureSource4, clazz4);
            ((Polygon3DRenderEvent)pre).setDoubleSided(true);
            if (cwa.getWallFill() instanceof ColorDefinition && ((ColorDefinition)cwa.getWallFill()).getTransparency() > 0 || !(cwa.getWallFill() instanceof ColorDefinition) && cwa.getWallFill() != null) {
                loa = new Location3D[]{Location3DImpl.create(dXStart, dYStart, dZStart), Location3DImpl.create(dXStart, dYEnd, dZStart), Location3DImpl.create(dXStart, dYEnd, dZEnd), Location3DImpl.create(dXStart, dYStart, dZEnd)};
                ((Polygon3DRenderEvent)pre).setPoints3D((Location3D[])loa);
                ((Polygon3DRenderEvent)pre).setBackground(cwa.getWallFill());
                ((Polygon3DRenderEvent)pre).setDoubleSided(true);
                pre.setOutline(ca.getOutline());
                this.getDeferredCache().addPlane(pre, 3);
                this.leftWallFill = true;
                loa[0] = Location3DImpl.create(dXStart, dYStart, dZStart);
                loa[1] = Location3DImpl.create(dXEnd, dYStart, dZStart);
                loa[2] = Location3DImpl.create(dXEnd, dYEnd, dZStart);
                loa[3] = Location3DImpl.create(dXStart, dYEnd, dZStart);
                ((Polygon3DRenderEvent)pre).setPoints3D((Location3D[])loa);
                ((Polygon3DRenderEvent)pre).setBackground(cwa.getWallFill());
                ((Polygon3DRenderEvent)pre).setDoubleSided(true);
                pre.setOutline(ca.getOutline());
                this.getDeferredCache().addPlane(pre, 3);
                this.rightWallFill = true;
            }
            if (cwa.getFloorFill() instanceof ColorDefinition && ((ColorDefinition)cwa.getFloorFill()).getTransparency() > 0 || !(cwa.getFloorFill() instanceof ColorDefinition) && cwa.getFloorFill() != null) {
                if (loa == null) {
                    loa = new Location3D[]{Location3DImpl.create(dXStart, dYStart, dZStart), Location3DImpl.create(dXStart, dYStart, dZEnd), Location3DImpl.create(dXEnd, dYStart, dZEnd), Location3DImpl.create(dXEnd, dYStart, dZStart)};
                }
                ((Polygon3DRenderEvent)pre).setPoints3D((Location3D[])loa);
                ((Polygon3DRenderEvent)pre).setBackground(cwa.getFloorFill());
                ((Polygon3DRenderEvent)pre).setDoubleSided(true);
                pre.setOutline(ca.getOutline());
                this.getDeferredCache().addPlane(pre, 3);
                this.floorFill = true;
            }
        }
        OneAxis[] oaxa = new OneAxis[2 + aax.getOverlayCount() + (aax.getAncillaryBase() != null ? 1 : 0)];
        oaxa[0] = aax.getPrimaryBase();
        oaxa[1] = aax.getPrimaryOrthogonal();
        int i = 0;
        while (i < aax.getOverlayCount()) {
            oaxa[2 + i] = aax.getOverlay(i);
            ++i;
        }
        if (aax.getAncillaryBase() != null) {
            oaxa[2 + aax.getOverlayCount()] = aax.getAncillaryBase();
        }
        this.renderMarkerRanges(oaxa, bo);
        double x = 0.0;
        double y = 0.0;
        double vnext = 0.0;
        Insets insCA = aax.getInsets();
        double[] doaMinor = null;
        int i2 = 0;
        while (i2 < oaxa.length) {
            block158: {
                int k;
                int j2;
                AxisTickCoordinates da;
                block159: {
                    Grid g = oaxa[i2].getGrid();
                    int iCount = g.getMinorCountPerMajor();
                    lia = oaxa[i2].getGrid().getLineAttributes(1);
                    if (lia == null || !lia.isSetStyle() || !lia.isVisible()) break block158;
                    if (iCount <= 0) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.cannot.split.major", new Object[]{new Integer(iCount)}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                    }
                    sc = oaxa[i2].getScale();
                    doaMinor = sc.getMinorCoordinates(iCount);
                    if (!this.isDimension3D()) break block159;
                    EventObjectCache eventObjectCache5 = (EventObjectCache)((Object)ipr);
                    StructureSource structureSource5 = StructureSource.createPlot(p);
                    Class<?> clazz5 = class$5;
                    if (clazz5 == null) {
                        try {
                            clazz5 = Class.forName("org.eclipse.birt.chart.event.Line3DRenderEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    lre3d = (Line3DRenderEvent)eventObjectCache5.getEventObject(structureSource5, clazz5);
                    lre3d.setLineAttributes(lia);
                    switch (oaxa[i2].getAxisType()) {
                        case 5: {
                            int n;
                            int j3;
                            int k2;
                            AxisTickCoordinates xa = scPrimaryBase.getTickCordinates();
                            if (this.floorFill) {
                                k2 = 0;
                                while (k2 < xa.size() - 1) {
                                    j3 = 0;
                                    while (j3 < doaMinor.length - 1) {
                                        n = 0;
                                        while (n < ancillaryTickCount - 1) {
                                            if (!ChartUtil.mathGE(xa.getCoordinate(k2) + doaMinor[j3], xa.getCoordinate(k2 + 1))) {
                                                lre3d.setStart3D(Location3DImpl.create(xa.getCoordinate(k2) + doaMinor[j3], dYStart, dZStart + (double)n * zStep));
                                                lre3d.setEnd3D(Location3DImpl.create(xa.getCoordinate(k2) + doaMinor[j3], dYStart, dZStart + (double)(n + 1) * zStep));
                                                this.getDeferredCache().addLine(lre3d);
                                            }
                                            ++n;
                                        }
                                        ++j3;
                                    }
                                    ++k2;
                                }
                            }
                            if (this.rightWallFill) {
                                k2 = 0;
                                while (k2 < xa.size() - 1) {
                                    j3 = 0;
                                    while (j3 < doaMinor.length - 1) {
                                        n = 0;
                                        while (n < orthogonalTickCount - 1) {
                                            if (!ChartUtil.mathGE(xa.getCoordinate(k2) + doaMinor[j3], xa.getCoordinate(k2 + 1))) {
                                                lre3d.setStart3D(Location3DImpl.create(xa.getCoordinate(k2) + doaMinor[j3], dYStart + (double)n * yStep, dZStart));
                                                lre3d.setEnd3D(Location3DImpl.create(xa.getCoordinate(k2) + doaMinor[j3], dYStart + (double)(n + 1) * yStep, dZStart));
                                                this.getDeferredCache().addLine(lre3d);
                                            }
                                            ++n;
                                        }
                                        ++j3;
                                    }
                                    ++k2;
                                }
                            }
                            break block158;
                        }
                        case 9: {
                            int n;
                            AxisTickCoordinates ya = scPrimaryOrthogonal.getTickCordinates();
                            if (this.leftWallFill) {
                                int k3 = 0;
                                while (k3 < ya.size() - 1) {
                                    int j4 = 0;
                                    while (j4 < doaMinor.length - 1) {
                                        n = 0;
                                        while (n < ancillaryTickCount - 1) {
                                            if (!ChartUtil.mathGE(ya.getCoordinate(k3) + doaMinor[j4], ya.getCoordinate(k3 + 1))) {
                                                lre3d.setStart3D(Location3DImpl.create(dXStart, ya.getCoordinate(k3) + doaMinor[j4], dZStart + (double)n * zStep));
                                                lre3d.setEnd3D(Location3DImpl.create(dXStart, ya.getCoordinate(k3) + doaMinor[j4], dZStart + (double)(n + 1) * zStep));
                                                this.getDeferredCache().addLine(lre3d);
                                            }
                                            ++n;
                                        }
                                        ++j4;
                                    }
                                    ++k3;
                                }
                            }
                            if (this.rightWallFill) {
                                int k4 = 0;
                                while (k4 < ya.size() - 1) {
                                    int j5 = 0;
                                    while (j5 < doaMinor.length - 1) {
                                        n = 0;
                                        while (n < baseTickCount - 1) {
                                            if (!ChartUtil.mathGE(ya.getCoordinate(k4) + doaMinor[j5], ya.getCoordinate(k4 + 1))) {
                                                lre3d.setStart3D(Location3DImpl.create(dXStart + (double)n * xStep, ya.getCoordinate(k4) + doaMinor[j5], dZStart));
                                                lre3d.setEnd3D(Location3DImpl.create(dXStart + (double)(n + 1) * xStep, ya.getCoordinate(k4) + doaMinor[j5], dZStart));
                                                this.getDeferredCache().addLine(lre3d);
                                            }
                                            ++n;
                                        }
                                        ++j5;
                                    }
                                    ++k4;
                                }
                            }
                            break block158;
                        }
                        case 17: {
                            int n;
                            AxisTickCoordinates za = scAncillaryBase.getTickCordinates();
                            if (this.leftWallFill) {
                                int k5 = 0;
                                while (k5 < za.size() - 1) {
                                    j = 0;
                                    while (j < doaMinor.length - 1) {
                                        n = 0;
                                        while (n < orthogonalTickCount - 1) {
                                            if (!ChartUtil.mathGE(za.getCoordinate(k5) + doaMinor[j], za.getCoordinate(k5 + 1))) {
                                                lre3d.setStart3D(Location3DImpl.create(dXStart, dYStart + (double)n * yStep, za.getCoordinate(k5) + doaMinor[j]));
                                                lre3d.setEnd3D(Location3DImpl.create(dXStart, dYStart + (double)(n + 1) * yStep, za.getCoordinate(k5) + doaMinor[j]));
                                                this.getDeferredCache().addLine(lre3d);
                                            }
                                            ++n;
                                        }
                                        ++j;
                                    }
                                    ++k5;
                                }
                            }
                            if (this.floorFill) {
                                int k6 = 0;
                                while (k6 < za.size() - 1) {
                                    j = 0;
                                    while (j < doaMinor.length - 1) {
                                        n = 0;
                                        while (n < baseTickCount - 1) {
                                            if (!ChartUtil.mathGE(za.getCoordinate(k6) + doaMinor[j], za.getCoordinate(k6 + 1))) {
                                                lre3d.setStart3D(Location3DImpl.create(dXStart + (double)n * xStep, dYStart, za.getCoordinate(k6) + doaMinor[j]));
                                                lre3d.setEnd3D(Location3DImpl.create(dXStart + (double)(n + 1) * xStep, dYStart, za.getCoordinate(k6) + doaMinor[j]));
                                                this.getDeferredCache().addLine(lre3d);
                                            }
                                            ++n;
                                        }
                                        ++j;
                                    }
                                    ++k6;
                                }
                            }
                            break block158;
                        }
                    }
                    break block158;
                }
                if (oaxa[i2].getOrientation() == 0) {
                    int iDirection = sc.getDirection() == -1 ? -1 : 1;
                    da = sc.getTickCordinates();
                    double dY2 = bo.getTop() + 1.0;
                    double dY1 = bo.getTop() + bo.getHeight() - 2.0;
                    if (pwa.getDimension() == 1) {
                        j2 = 0;
                        while (j2 < da.size() - 1) {
                            x = da.getCoordinate(j2);
                            k = 0;
                            while (k < doaMinor.length) {
                                if (!(iDirection == 1 && ChartUtil.mathGE(x + doaMinor[k], da.getCoordinate(j2 + 1)) || iDirection == -1 && ChartUtil.mathLE(x - doaMinor[k], da.getCoordinate(j2 + 1)))) {
                                    EventObjectCache eventObjectCache6 = (EventObjectCache)((Object)ipr);
                                    StructureSource structureSource6 = StructureSource.createPlot(p);
                                    Class<?> clazz6 = class$6;
                                    if (clazz6 == null) {
                                        try {
                                            clazz6 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    lre = (LineRenderEvent)eventObjectCache6.getEventObject(structureSource6, clazz6);
                                    lre.setLineAttributes(lia);
                                    lre.setStart(LocationImpl.create(x + (double)iDirection * doaMinor[k], dY1 + pwa.getSeriesThickness()));
                                    lre.setEnd(LocationImpl.create(x + (double)iDirection * doaMinor[k] + pwa.getSeriesThickness(), dY1));
                                    ipr.drawLine(lre);
                                }
                                ++k;
                            }
                            ++j2;
                        }
                    }
                    j2 = 0;
                    while (j2 < da.size() - 1) {
                        x = da.getCoordinate(j2);
                        vnext = da.getCoordinate(j2 + 1);
                        if (pwa.getDimension() == 1) {
                            x += pwa.getSeriesThickness();
                            vnext += pwa.getSeriesThickness();
                        }
                        k = 0;
                        while (k < doaMinor.length) {
                            if (!(iDirection == 1 && ChartUtil.mathGE(x + doaMinor[k], vnext) || iDirection == -1 && ChartUtil.mathLE(x - doaMinor[k], vnext))) {
                                EventObjectCache eventObjectCache7 = (EventObjectCache)((Object)ipr);
                                StructureSource structureSource7 = StructureSource.createPlot(p);
                                Class<?> clazz7 = class$6;
                                if (clazz7 == null) {
                                    try {
                                        clazz7 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                lre = (LineRenderEvent)eventObjectCache7.getEventObject(structureSource7, clazz7);
                                lre.setLineAttributes(lia);
                                lre.setStart(LocationImpl.create(x + (double)iDirection * doaMinor[k], dY1));
                                lre.setEnd(LocationImpl.create(x + (double)iDirection * doaMinor[k], dY2));
                                ipr.drawLine(lre);
                            }
                            ++k;
                        }
                        ++j2;
                    }
                } else if (oaxa[i2].getOrientation() == 1) {
                    int iDirection = sc.getDirection() != 1 ? -1 : 1;
                    da = sc.getTickCordinates();
                    double dX1 = bo.getLeft() + 1.0;
                    double dX2 = bo.getLeft() + bo.getWidth() - 2.0;
                    if (pwa.getDimension() == 1) {
                        j2 = 0;
                        while (j2 < da.size() - 1) {
                            y = da.getCoordinate(j2) - pwa.getSeriesThickness();
                            vnext = da.getCoordinate(j2 + 1) - pwa.getSeriesThickness();
                            k = 0;
                            while (k < doaMinor.length) {
                                if (!(iDirection == 1 && ChartUtil.mathGE(y + doaMinor[k], vnext) || iDirection == -1 && ChartUtil.mathLE(y - doaMinor[k], vnext))) {
                                    EventObjectCache eventObjectCache8 = (EventObjectCache)((Object)ipr);
                                    StructureSource structureSource8 = StructureSource.createPlot(p);
                                    Class<?> clazz8 = class$6;
                                    if (clazz8 == null) {
                                        try {
                                            clazz8 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    lre = (LineRenderEvent)eventObjectCache8.getEventObject(structureSource8, clazz8);
                                    lre.setLineAttributes(lia);
                                    lre.setStart(LocationImpl.create(dX1, y + (double)iDirection * doaMinor[k]));
                                    lre.setEnd(LocationImpl.create(dX1 - pwa.getSeriesThickness(), y + (double)iDirection * doaMinor[k] + pwa.getSeriesThickness()));
                                    ipr.drawLine(lre);
                                }
                                ++k;
                            }
                            ++j2;
                        }
                    }
                    j2 = 0;
                    while (j2 < da.size() - 1) {
                        y = da.getCoordinate(j2);
                        vnext = da.getCoordinate(j2 + 1);
                        if (pwa.getDimension() == 1) {
                            y -= pwa.getSeriesThickness();
                            vnext -= pwa.getSeriesThickness();
                        }
                        k = 0;
                        while (k < doaMinor.length) {
                            if (!(iDirection == 1 && ChartUtil.mathGE(y + doaMinor[k], vnext) || iDirection == -1 && ChartUtil.mathLE(y - doaMinor[k], vnext))) {
                                EventObjectCache eventObjectCache9 = (EventObjectCache)((Object)ipr);
                                StructureSource structureSource9 = StructureSource.createPlot(p);
                                Class<?> clazz9 = class$6;
                                if (clazz9 == null) {
                                    try {
                                        clazz9 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                lre = (LineRenderEvent)eventObjectCache9.getEventObject(structureSource9, clazz9);
                                lre.setLineAttributes(lia);
                                lre.setStart(LocationImpl.create(dX1, y + (double)iDirection * doaMinor[k]));
                                lre.setEnd(LocationImpl.create(dX2, y + (double)iDirection * doaMinor[k]));
                                ipr.drawLine(lre);
                            }
                            ++k;
                        }
                        ++j2;
                    }
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < oaxa.length) {
            block160: {
                AxisTickCoordinates da;
                block161: {
                    lia = oaxa[i2].getGrid().getLineAttributes(0);
                    if (lia == null || !lia.isSetStyle() || !lia.isVisible()) break block160;
                    sc = oaxa[i2].getScale();
                    if (!this.isDimension3D()) break block161;
                    EventObjectCache eventObjectCache10 = (EventObjectCache)((Object)ipr);
                    StructureSource structureSource10 = StructureSource.createPlot(p);
                    Class<?> clazz10 = class$5;
                    if (clazz10 == null) {
                        try {
                            clazz10 = Class.forName("org.eclipse.birt.chart.event.Line3DRenderEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    lre3d = (Line3DRenderEvent)eventObjectCache10.getEventObject(structureSource10, clazz10);
                    lre3d.setLineAttributes(lia);
                    switch (oaxa[i2].getAxisType()) {
                        case 5: {
                            AxisTickCoordinates xa = scPrimaryBase.getTickCordinates();
                            if (this.floorFill) {
                                int k = 0;
                                while (k < xa.size()) {
                                    int j6 = 0;
                                    while (j6 < ancillaryTickCount - 1) {
                                        lre3d.setStart3D(Location3DImpl.create(xa.getCoordinate(k), dYStart, dZStart + (double)j6 * zStep));
                                        lre3d.setEnd3D(Location3DImpl.create(xa.getCoordinate(k), dYStart, dZStart + (double)(j6 + 1) * zStep));
                                        this.getDeferredCache().addLine(lre3d);
                                        ++j6;
                                    }
                                    ++k;
                                }
                            }
                            if (this.rightWallFill) {
                                int k = 0;
                                while (k < xa.size()) {
                                    int j7 = 0;
                                    while (j7 < orthogonalTickCount - 1) {
                                        lre3d.setStart3D(Location3DImpl.create(xa.getCoordinate(k), dYStart + (double)j7 * yStep, dZStart));
                                        lre3d.setEnd3D(Location3DImpl.create(xa.getCoordinate(k), dYStart + (double)(j7 + 1) * yStep, dZStart));
                                        this.getDeferredCache().addLine(lre3d);
                                        ++j7;
                                    }
                                    ++k;
                                }
                            }
                            break block160;
                        }
                        case 9: {
                            AxisTickCoordinates ya = scPrimaryOrthogonal.getTickCordinates();
                            if (this.leftWallFill) {
                                int k = 0;
                                while (k < ya.size()) {
                                    int j8 = 0;
                                    while (j8 < ancillaryTickCount - 1) {
                                        lre3d.setStart3D(Location3DImpl.create(dXStart, ya.getCoordinate(k), dZStart + (double)j8 * zStep));
                                        lre3d.setEnd3D(Location3DImpl.create(dXStart, ya.getCoordinate(k), dZStart + (double)(j8 + 1) * zStep));
                                        this.getDeferredCache().addLine(lre3d);
                                        ++j8;
                                    }
                                    ++k;
                                }
                            }
                            if (this.rightWallFill) {
                                int k = 0;
                                while (k < ya.size()) {
                                    int j9 = 0;
                                    while (j9 < baseTickCount - 1) {
                                        lre3d.setStart3D(Location3DImpl.create(dXStart + (double)j9 * xStep, ya.getCoordinate(k), dZStart));
                                        lre3d.setEnd3D(Location3DImpl.create(dXStart + (double)(j9 + 1) * xStep, ya.getCoordinate(k), dZStart));
                                        this.getDeferredCache().addLine(lre3d);
                                        ++j9;
                                    }
                                    ++k;
                                }
                            }
                            break block160;
                        }
                        case 17: {
                            AxisTickCoordinates za = scAncillaryBase.getTickCordinates();
                            if (this.leftWallFill) {
                                int k = 0;
                                while (k < za.size()) {
                                    j = 0;
                                    while (j < orthogonalTickCount - 1) {
                                        lre3d.setStart3D(Location3DImpl.create(dXStart, dYStart + (double)j * yStep, za.getCoordinate(k)));
                                        lre3d.setEnd3D(Location3DImpl.create(dXStart, dYStart + (double)(j + 1) * yStep, za.getCoordinate(k)));
                                        this.getDeferredCache().addLine(lre3d);
                                        ++j;
                                    }
                                    ++k;
                                }
                            }
                            if (this.floorFill) {
                                int k = 0;
                                while (k < za.size()) {
                                    j = 0;
                                    while (j < baseTickCount - 1) {
                                        lre3d.setStart3D(Location3DImpl.create(dXStart + (double)j * xStep, dYStart, za.getCoordinate(k)));
                                        lre3d.setEnd3D(Location3DImpl.create(dXStart + (double)(j + 1) * xStep, dYStart, za.getCoordinate(k)));
                                        this.getDeferredCache().addLine(lre3d);
                                        ++j;
                                    }
                                    ++k;
                                }
                            }
                            break block160;
                        }
                    }
                    break block160;
                }
                if (oaxa[i2].getOrientation() == 0) {
                    da = sc.getTickCordinates();
                    double dY2 = bo.getTop() + 1.0;
                    double dY1 = bo.getTop() + bo.getHeight() - 2.0;
                    if (pwa.getDimension() == 1) {
                        j = 0;
                        while (j < da.size()) {
                            if (!(j == 0 && insCA.getBottom() < (double)lia.getThickness() || j == da.size() - 1 && insCA.getTop() < (double)lia.getThickness())) {
                                x = da.getCoordinate(j);
                                EventObjectCache eventObjectCache11 = (EventObjectCache)((Object)ipr);
                                StructureSource structureSource11 = StructureSource.createPlot(p);
                                Class<?> clazz11 = class$6;
                                if (clazz11 == null) {
                                    try {
                                        clazz11 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                lre = (LineRenderEvent)eventObjectCache11.getEventObject(structureSource11, clazz11);
                                lre.setLineAttributes(lia);
                                lre.setStart(LocationImpl.create(x, dY1 + pwa.getSeriesThickness()));
                                lre.setEnd(LocationImpl.create(x + pwa.getSeriesThickness(), dY1));
                                ipr.drawLine(lre);
                            }
                            ++j;
                        }
                    }
                    j = 0;
                    while (j < da.size()) {
                        if (!(j == 0 && insCA.getBottom() < (double)lia.getThickness() || j == da.size() - 1 && insCA.getTop() < (double)lia.getThickness())) {
                            x = da.getCoordinate(j);
                            if (pwa.getDimension() == 1) {
                                x += pwa.getSeriesThickness();
                            }
                            EventObjectCache eventObjectCache12 = (EventObjectCache)((Object)ipr);
                            StructureSource structureSource12 = StructureSource.createPlot(p);
                            Class<?> clazz12 = class$6;
                            if (clazz12 == null) {
                                try {
                                    clazz12 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            lre = (LineRenderEvent)eventObjectCache12.getEventObject(structureSource12, clazz12);
                            lre.setLineAttributes(lia);
                            lre.setStart(LocationImpl.create(x, dY1));
                            lre.setEnd(LocationImpl.create(x, dY2));
                            ipr.drawLine(lre);
                        }
                        ++j;
                    }
                } else if (oaxa[i2].getOrientation() == 1) {
                    da = sc.getTickCordinates();
                    double dX1 = bo.getLeft() + 1.0;
                    double dX2 = bo.getLeft() + bo.getWidth() - 2.0;
                    if (pwa.getDimension() == 1) {
                        j = 0;
                        while (j < da.size()) {
                            if (!(j == 0 && insCA.getLeft() < (double)lia.getThickness() || j == da.size() - 1 && insCA.getRight() < (double)lia.getThickness())) {
                                y = da.getCoordinate(j) - pwa.getSeriesThickness();
                                EventObjectCache eventObjectCache13 = (EventObjectCache)((Object)ipr);
                                StructureSource structureSource13 = StructureSource.createPlot(p);
                                Class<?> clazz13 = class$6;
                                if (clazz13 == null) {
                                    try {
                                        clazz13 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                lre = (LineRenderEvent)eventObjectCache13.getEventObject(structureSource13, clazz13);
                                lre.setLineAttributes(lia);
                                lre.setStart(LocationImpl.create(dX1, y));
                                lre.setEnd(LocationImpl.create(dX1 - pwa.getSeriesThickness(), y + pwa.getSeriesThickness()));
                                ipr.drawLine(lre);
                            }
                            ++j;
                        }
                    }
                    j = 0;
                    while (j < da.size()) {
                        if (!(j == 0 && insCA.getLeft() < (double)lia.getThickness() || j == da.size() - 1 && insCA.getRight() < (double)lia.getThickness())) {
                            y = da.getCoordinate(j);
                            if (pwa.getDimension() == 1) {
                                y -= pwa.getSeriesThickness();
                            }
                            EventObjectCache eventObjectCache14 = (EventObjectCache)((Object)ipr);
                            StructureSource structureSource14 = StructureSource.createPlot(p);
                            Class<?> clazz14 = class$6;
                            if (clazz14 == null) {
                                try {
                                    clazz14 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            lre = (LineRenderEvent)eventObjectCache14.getEventObject(structureSource14, clazz14);
                            lre.setLineAttributes(lia);
                            lre.setStart(LocationImpl.create(dX1, y));
                            lre.setEnd(LocationImpl.create(dX2, y));
                            ipr.drawLine(lre);
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        if (!this.isDimension3D() && p.getClientArea().getOutline().isVisible()) {
            rre.setBounds(bo);
            ipr.drawRectangle(rre);
        }
    }

    private final void renderAxesStructure(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        AllAxes aax = pwa.getAxes();
        if (pwa.getDimension() == 2) {
            this.renderEachAxis(ipr, p, aax.getPrimaryBase(), 5);
            this.renderEachAxis(ipr, p, aax.getAncillaryBase(), 17);
            this.renderEachAxis(ipr, p, aax.getPrimaryOrthogonal(), 9);
        } else {
            int iCount = aax.getOverlayCount() + 2;
            OneAxis[] oaxa = new OneAxis[iCount];
            oaxa[0] = aax.getPrimaryBase();
            oaxa[1] = aax.getPrimaryOrthogonal();
            int i = 0;
            while (i < iCount - 2) {
                oaxa[i + 2] = aax.getOverlay(i);
                ++i;
            }
            i = 0;
            while (i < iCount) {
                this.renderEachAxis(ipr, p, oaxa[i], 1);
                ++i;
            }
        }
    }

    private final void renderAxesLabels(IPrimitiveRenderer ipr, Plot p, OneAxis[] oaxa) throws ChartException {
        int i = 0;
        while (i < oaxa.length) {
            this.renderEachAxis(ipr, p, oaxa[i], 2);
            ++i;
        }
    }

    public final void renderPlot(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        if (!p.isVisible()) {
            return;
        }
        boolean bFirstInSequence = this.iSeriesIndex == 0;
        boolean bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        if (bFirstInSequence) {
            this.renderBackground(ipr, p);
            this.renderAxesStructure(ipr, p);
        }
        if (this.getSeries() != null) {
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "beforeDrawSeries", this.getSeries(), this, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawSeries", this.getSeries());
            this.renderSeries(ipr, p, this.srh);
            this.flushSeries();
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "afterDrawSeries", this.getSeries(), this, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawSeries", this.getSeries());
            this.renderAxesDecoration(ipr, this.srh);
        }
        if (bLastInSequence) {
            Location panningOffset = this.getPanningOffset();
            try {
                if (this.isDimension3D()) {
                    this.getDeferredCache().process3DEvent(this.get3DEngine(), panningOffset.getX(), panningOffset.getY());
                }
                this.getDeferredCache().flush();
            }
            catch (ChartException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)ex));
            }
            AllAxes aax = pwa.getAxes();
            OneAxis[] oaxa = new OneAxis[2 + aax.getOverlayCount() + (aax.getAncillaryBase() != null ? 1 : 0)];
            oaxa[0] = aax.getPrimaryBase();
            oaxa[1] = aax.getPrimaryOrthogonal();
            int i = 0;
            while (i < aax.getOverlayCount()) {
                oaxa[2 + i] = aax.getOverlay(i);
                ++i;
            }
            if (aax.getAncillaryBase() != null) {
                oaxa[2 + aax.getOverlayCount()] = aax.getAncillaryBase();
            }
            Bounds bo = pwa.getPlotBounds();
            this.renderMarkerLines(oaxa, bo);
            this.renderAxesLabels(ipr, p, oaxa);
            try {
                if (this.isDimension3D()) {
                    this.getDeferredCache().process3DEvent(this.get3DEngine(), panningOffset.getX(), panningOffset.getY());
                }
                this.getDeferredCache().flush();
            }
            catch (ChartException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)ex));
            }
        }
    }

    protected void renderAxesDecoration(IPrimitiveRenderer ipr, ISeriesRenderingHints srh) throws ChartException {
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        AllAxes aax = pwa.getAxes();
        if (pwa.getDimension() != 2) {
            int iCount = aax.getOverlayCount() + 2;
            OneAxis[] oaxa = new OneAxis[iCount];
            oaxa[0] = aax.getPrimaryBase();
            oaxa[1] = aax.getPrimaryOrthogonal();
            int i = 0;
            while (i < iCount - 2) {
                oaxa[i + 2] = aax.getOverlay(i);
                ++i;
            }
            i = 0;
            while (i < iCount) {
                IAxesDecorator iad = this.getAxesDecorator(oaxa[i]);
                if (iad != null) {
                    iad.decorateAxes(ipr, srh, oaxa[i]);
                }
                ++i;
            }
        }
    }

    public IAxesDecorator getAxesDecorator(OneAxis ax) {
        return null;
    }

    protected final void renderMarker(Object oParent, IPrimitiveRenderer ipr, Marker m, Location lo, LineAttributes lia, Fill fPaletteEntry, DataPointHints dph, Integer markerSize, boolean bDeferred, boolean bConsiderTranspostion) throws ChartException {
        EList elTriggers;
        if (dph != null && (AxesRenderer.isNaN(dph.getOrthogonalValue()) || dph.isOutside())) {
            return;
        }
        if (dph != null && dph.getOrthogonalValue() instanceof Double) {
            fPaletteEntry = ChartUtil.convertFill(fPaletteEntry, (Double)dph.getOrthogonalValue(), null);
        }
        Series se = this.getSeries();
        StructureSource oSource = oParent instanceof Legend ? StructureSource.createLegend((Legend)oParent) : WrappedStructureSource.createSeriesDataPoint(se, dph);
        boolean bTransposed = bConsiderTranspostion && ((ChartWithAxes)this.getModel()).isTransposed();
        Location panningOffset = this.getPanningOffset();
        PrimitiveRenderEvent preCopy = null;
        if (m == null || m != null && (!m.isSetVisible() || !m.isVisible())) {
            OvalRenderEvent ore;
            int iSize = 5;
            if (m != null) {
                iSize = m.getSize();
            }
            if (lo instanceof Location3D) {
                EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("org.eclipse.birt.chart.event.Oval3DRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ore = (Oval3DRenderEvent)eventObjectCache.getEventObject(oSource, clazz);
                Location3D lo3d = (Location3D)lo;
                ((Oval3DRenderEvent)ore).setLocation3D(new Location3D[]{Location3DImpl.create(lo3d.getX() - (double)iSize, lo3d.getY() + (double)iSize, lo3d.getZ()), Location3DImpl.create(lo3d.getX() - (double)iSize, lo3d.getY() - (double)iSize, lo3d.getZ()), Location3DImpl.create(lo3d.getX() + (double)iSize, lo3d.getY() - (double)iSize, lo3d.getZ()), Location3DImpl.create(lo3d.getX() + (double)iSize, lo3d.getY() + (double)iSize, lo3d.getZ())});
                preCopy = ((Oval3DRenderEvent)ore).copy();
            } else {
                EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = class$8 = Class.forName("org.eclipse.birt.chart.event.OvalRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ore = (OvalRenderEvent)eventObjectCache.getEventObject(oSource, clazz);
                ore.setBounds(BoundsImpl.create(lo.getX() - (double)iSize, lo.getY() - (double)iSize, iSize * 2, iSize * 2));
                preCopy = ore.copy();
            }
        } else if (m.isSetVisible() && m.isVisible()) {
            MarkerRenderer mr = new MarkerRenderer(this.getDevice(), oSource, lo, lia, fPaletteEntry, m, markerSize, this.getDeferredCache(), bDeferred, bTransposed);
            mr.draw(ipr);
            preCopy = mr.getRenderArea();
        }
        if (this.isInteractivityEnabled() && dph != null && (!(lo instanceof Location3D) || lo instanceof Location3D && this.get3DEngine().processEvent(preCopy, panningOffset.getX(), panningOffset.getY()) != null) && !(elTriggers = se.getTriggers()).isEmpty()) {
            StructureSource iSource = oParent instanceof Legend ? StructureSource.createSeries(se) : WrappedStructureSource.createSeriesDataPoint(se, dph);
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InteractionEvent iev = (InteractionEvent)eventObjectCache.getEventObject(iSource, clazz);
            int t = 0;
            while (t < elTriggers.size()) {
                Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                this.processTrigger(tg, iSource);
                iev.addTrigger(tg);
                ++t;
            }
            iev.setHotSpot(preCopy);
            ipr.enableInteraction(iev);
        }
    }

    private final void renderMarkerLines(OneAxis[] oaxa, Bounds boPlotClientArea) throws ChartException {
        int iAxisCount = oaxa.length;
        double dCoordinate = 0.0;
        IDeviceRenderer idr = this.getDevice();
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        Location loStart = LocationImpl.create(0.0, 0.0);
        Location loEnd = LocationImpl.create(0.0, 0.0);
        TextRenderEvent tre = null;
        Label la = null;
        double dOriginalAngle = 0.0;
        boolean bTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        Bounds boText = BoundsImpl.create(0.0, 0.0, 0.0, 0.0);
        int i = 0;
        while (i < iAxisCount) {
            Axis ax = oaxa[i].getModelAxis();
            int iOrientation = ax.getOrientation().getValue();
            if (bTransposed) {
                iOrientation = iOrientation == 0 ? 1 : 0;
            }
            AutoScale asc = oaxa[i].getScale();
            EList el = ax.getMarkerLines();
            int iLineCount = el.size();
            int j = 0;
            while (j < iLineCount) {
                block64: {
                    EList elTriggers;
                    MarkerLine ml = (MarkerLine)el.get(j);
                    ScriptHandler.callFunction(sh, "beforeDrawMarkerLine", ax, ml, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawMarkerLine", ml);
                    DataElement deValue = ml.getValue();
                    if (deValue == null) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.marker.line.null.value", new Object[]{ml}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                    }
                    la = LabelImpl.copyInstance(ml.getLabel());
                    if (la.getCaption().getValue() != null && !"".equals(la.getCaption().getValue()) && la.getCaption().getValue().length() > 0) {
                        la.getCaption().setValue(oaxa[i].getRunTimeContext().externalizedMessage(la.getCaption().getValue()));
                    } else {
                        try {
                            la.getCaption().setValue(ValueFormatter.format(deValue, ml.getFormatSpecifier(), oaxa[i].getRunTimeContext().getULocale(), null));
                        }
                        catch (ChartException dfex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)dfex));
                        }
                    }
                    if (this.isDimension3D()) {
                        return;
                    }
                    try {
                        dCoordinate = PlotWith2DAxes.getLocation(asc, deValue);
                    }
                    catch (Exception exception) {
                        logger.log(2, Messages.getString("exception.cannot.locate.value.marker.line", new Object[]{deValue, ml}, this.getRunTimeContext().getULocale()));
                        break block64;
                    }
                    EventObjectCache eventObjectCache = (EventObjectCache)((Object)idr);
                    StructureSource structureSource = StructureSource.createMarkerLine(ml);
                    Class<?> clazz = class$6;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    LineRenderEvent lre = (LineRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
                    if (iOrientation == 0) {
                        if (dCoordinate > boPlotClientArea.getLeft() + boPlotClientArea.getWidth()) {
                            dCoordinate = boPlotClientArea.getLeft() + boPlotClientArea.getWidth();
                        }
                        if (dCoordinate < boPlotClientArea.getLeft()) {
                            dCoordinate = boPlotClientArea.getLeft();
                        }
                        loStart.set(dCoordinate, boPlotClientArea.getTop());
                        loEnd.set(dCoordinate, boPlotClientArea.getTop() + boPlotClientArea.getHeight());
                    } else {
                        if (dCoordinate < boPlotClientArea.getTop()) {
                            dCoordinate = boPlotClientArea.getTop();
                        }
                        if (dCoordinate > boPlotClientArea.getTop() + boPlotClientArea.getHeight()) {
                            dCoordinate = boPlotClientArea.getTop() + boPlotClientArea.getHeight();
                        }
                        loStart.set(boPlotClientArea.getLeft(), dCoordinate);
                        loEnd.set(boPlotClientArea.getLeft() + boPlotClientArea.getWidth(), dCoordinate);
                    }
                    if (pwa.getDimension() == 1) {
                        if (iOrientation == 0) {
                            loStart.translate(0.0, pwa.getSeriesThickness());
                            loEnd.translate(0.0, pwa.getSeriesThickness());
                        } else {
                            loStart.translate(-pwa.getSeriesThickness(), 0.0);
                            loEnd.translate(-pwa.getSeriesThickness(), 0.0);
                        }
                    }
                    lre.setStart(loStart);
                    lre.setEnd(loEnd);
                    lre.setLineAttributes(ml.getLineAttributes());
                    idr.drawLine(lre);
                    if (la.isVisible()) {
                        Anchor anc = this.switchAnchor(ml.getLabelAnchor());
                        if (bTransposed) {
                            dOriginalAngle = la.getCaption().getFont().getRotation();
                            try {
                                la.getCaption().getFont().setRotation(pwa.getTransposedAngle(dOriginalAngle));
                                anc = ChartUtil.transposeAnchor(anc);
                            }
                            catch (IllegalArgumentException uiex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                            }
                        }
                        BoundingBox bb = null;
                        try {
                            bb = Methods.computeBox(idr.getDisplayServer(), 1, la, 0.0, 0.0);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                        }
                        boText.set(0.0, 0.0, bb.getWidth(), bb.getHeight());
                        if (iOrientation == 1) {
                            if (anc != null) {
                                switch (anc.getValue()) {
                                    case 0: 
                                    case 1: 
                                    case 7: {
                                        boText.setTop(loStart.getY() - boText.getHeight());
                                        break;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 5: {
                                        boText.setTop(loStart.getY());
                                        break;
                                    }
                                    default: {
                                        boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                                    }
                                }
                                switch (anc.getValue()) {
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        boText.setLeft(loEnd.getX() - boText.getWidth());
                                        break;
                                    }
                                    case 5: 
                                    case 6: 
                                    case 7: {
                                        boText.setLeft(loStart.getX());
                                        break;
                                    }
                                    default: {
                                        boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                                        break;
                                    }
                                }
                            } else {
                                boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                                boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                            }
                        } else if (anc != null) {
                            switch (anc.getValue()) {
                                case 0: 
                                case 1: 
                                case 7: {
                                    boText.setTop(loStart.getY());
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: {
                                    boText.setTop(loEnd.getY() - boText.getHeight());
                                    break;
                                }
                                default: {
                                    boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                                }
                            }
                            switch (anc.getValue()) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    boText.setLeft(loStart.getX());
                                    break;
                                }
                                case 5: 
                                case 6: 
                                case 7: {
                                    boText.setLeft(loEnd.getX() - boText.getWidth());
                                    break;
                                }
                                default: {
                                    boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                                    break;
                                }
                            }
                        } else {
                            boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                            boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                        }
                        EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)idr);
                        StructureSource structureSource2 = StructureSource.createMarkerLine(ml);
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.eclipse.birt.chart.event.TextRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        tre = (TextRenderEvent)eventObjectCache2.getEventObject(structureSource2, clazz2);
                        tre.setBlockBounds(boText);
                        tre.setBlockAlignment(null);
                        tre.setLabel(la);
                        tre.setAction(3);
                        this.getDeferredCache().addLabel(tre);
                    }
                    if (this.isInteractivityEnabled() && !(elTriggers = ml.getTriggers()).isEmpty()) {
                        EventObjectCache eventObjectCache3 = (EventObjectCache)((Object)idr);
                        StructureSource structureSource3 = StructureSource.createMarkerLine(ml);
                        Class<?> clazz3 = class$2;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        InteractionEvent iev = (InteractionEvent)eventObjectCache3.getEventObject(structureSource3, clazz3);
                        int t = 0;
                        while (t < elTriggers.size()) {
                            Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                            this.processTrigger(tg, StructureSource.createMarkerLine(ml));
                            iev.addTrigger(tg);
                            ++t;
                        }
                        Location[] loaHotspot = new Location[4];
                        if (iOrientation == 0) {
                            loaHotspot[0] = LocationImpl.create(loStart.getX() - 2.0, loStart.getY());
                            loaHotspot[1] = LocationImpl.create(loStart.getX() + 2.0, loStart.getY());
                            loaHotspot[2] = LocationImpl.create(loEnd.getX() + 2.0, loEnd.getY());
                            loaHotspot[3] = LocationImpl.create(loEnd.getX() - 2.0, loEnd.getY());
                        } else {
                            loaHotspot[0] = LocationImpl.create(loStart.getX(), loStart.getY() - 2.0);
                            loaHotspot[1] = LocationImpl.create(loEnd.getX(), loEnd.getY() - 2.0);
                            loaHotspot[2] = LocationImpl.create(loEnd.getX(), loEnd.getY() + 2.0);
                            loaHotspot[3] = LocationImpl.create(loStart.getX(), loStart.getY() + 2.0);
                        }
                        EventObjectCache eventObjectCache4 = (EventObjectCache)((Object)idr);
                        StructureSource structureSource4 = StructureSource.createMarkerLine(ml);
                        Class<?> clazz4 = class$3;
                        if (clazz4 == null) {
                            try {
                                clazz4 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache4.getEventObject(structureSource4, clazz4);
                        pre.setPoints(loaHotspot);
                        iev.setHotSpot(pre);
                        idr.enableInteraction(iev);
                    }
                    ScriptHandler.callFunction(sh, "afterDrawMarkerLine", ax, ml, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawMarkerLine", ml);
                }
                ++j;
            }
            ++i;
        }
    }

    public final void renderEachAxis(IPrimitiveRenderer ipr, Plot pl, OneAxis ax, int iWhatToDraw) throws ChartException {
        new AxesRenderHelper(this, ipr, pl, ax, iWhatToDraw).renderEachAxis();
    }

    public void set(Chart _cm, Object _o, Series _se, Axis _ax, SeriesDefinition _sd) {
        super.set(_cm, _o, _se, _sd);
        this.ax = _ax;
    }

    public final boolean isDimension3D() {
        return this.getModel().getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL;
    }

    public final boolean isTransposed() {
        return ((ChartWithAxes)this.getModel()).isTransposed();
    }

    protected int getPrevVisibleSiblingSeriesIndex(int currentIndex) {
        SeriesDefinition sd = null;
        Series se = this.getSeries();
        if (se.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)se.eContainer();
        }
        if (sd != null) {
            int count = 0;
            int idx = sd.getRunTimeSeries().indexOf(se);
            if (idx > 0) {
                int i = idx - 1;
                while (i >= 0) {
                    ++count;
                    if (((Series)sd.getRunTimeSeries().get(i)).isVisible()) {
                        return currentIndex - count;
                    }
                    --i;
                }
            }
            Axis cax = this.getAxis();
            int iDefintionIndex = cax.getSeriesDefinitions().indexOf((Object)sd);
            int iDefinitionCount = cax.getSeriesDefinitions().size();
            if (iDefinitionCount > 0) {
                int i = iDefintionIndex - 1;
                while (i >= 0) {
                    sd = (SeriesDefinition)cax.getSeriesDefinitions().get(i);
                    int runtimeSeriesCount = sd.getRunTimeSeries().size();
                    int j = runtimeSeriesCount - 1;
                    while (j >= 0) {
                        ++count;
                        if (((Series)sd.getRunTimeSeries().get(j)).isVisible()) {
                            return currentIndex - count;
                        }
                        --j;
                    }
                    --i;
                }
            }
        }
        return -1;
    }

    public final boolean isLastRuntimeSeriesInAxis() {
        SeriesDefinition sd = null;
        Series se = this.getSeries();
        if (se.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)se.eContainer();
        }
        if (sd != null) {
            Axis cax = this.getAxis();
            int iDefintionIndex = cax.getSeriesDefinitions().indexOf((Object)sd);
            int iDefinitionCount = cax.getSeriesDefinitions().size();
            if (iDefinitionCount > 0 && iDefintionIndex == iDefinitionCount - 1) {
                int iThisSeriesIndex = sd.getRunTimeSeries().indexOf(se);
                int iSeriesCount = sd.getRunTimeSeries().size();
                if (iSeriesCount > 0 && iThisSeriesIndex == iSeriesCount - 1) {
                    return true;
                }
            }
        }
        return false;
    }

    protected Engine3D get3DEngine() {
        if (this.isDimension3D()) {
            return ((PlotWith3DAxes)this.oComputations).get3DEngine();
        }
        return null;
    }

    protected Location getPanningOffset() {
        if (this.isDimension3D()) {
            return ((PlotWith3DAxes)this.oComputations).getPanningOffset();
        }
        return null;
    }

    public final Axis getAxis() {
        return this.ax;
    }

    protected final OneAxis getInternalOrthogonalAxis() {
        AllAxes allAxes = ((PlotWithAxes)this.getComputations()).getAxes();
        if (allAxes.getOverlayCount() == 0) {
            return allAxes.getPrimaryOrthogonal();
        }
        EList axesList = ((Axis)this.getAxis().eContainer()).getAssociatedAxes();
        int index = axesList.indexOf((Object)this.getAxis());
        if (index == 0) {
            return allAxes.getPrimaryOrthogonal();
        }
        return allAxes.getOverlay(index - 1);
    }

    protected final OneAxis getInternalBaseAxis() {
        AllAxes allAxes = ((PlotWithAxes)this.getComputations()).getAxes();
        return allAxes.getPrimaryBase();
    }

    protected boolean isShowOutside() {
        return this.getAxis().isPercent() ? false : this.getAxis().getScale().isShowOutside();
    }

    protected final void handleOutsideDataPoints(IPrimitiveRenderer ipr, SeriesRenderingHints srh, double[] faX, double[] faY, boolean bShowAsTape) {
        AutoScale scaleOrth = this.getInternalOrthogonalAxis().getScale();
        Bounds boClientArea = srh.getClientAreaBounds(true);
        if (bShowAsTape) {
            double dSeriesThickness = srh.getSeriesThickness();
            boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
        }
        this.renderClipping(ipr, boClientArea);
        if ((scaleOrth.getType() & 0x20) == 32) {
            return;
        }
        boolean bHideOutside = !this.isShowOutside();
        DataPointHints[] dpha = srh.getDataPoints();
        boolean isCategory = srh.isCategoryScale();
        boolean bTransposed = this.isTransposed();
        int i = 0;
        while (i < dpha.length) {
            if (!isCategory && dpha[i].getBaseValue() == null) {
                dpha[i].markOutside();
            } else {
                int iOutside = 0;
                if (dpha[i].getStackOrthogonalValue() != null) {
                    double value = dpha[i].getStackOrthogonalValue();
                    double min = Methods.asDouble(scaleOrth.getMinimum());
                    double max = Methods.asDouble(scaleOrth.getMaximum());
                    if (value < min) {
                        iOutside = 1;
                    } else if (value > max) {
                        iOutside = 2;
                    }
                } else {
                    iOutside = this.checkEntryByType(scaleOrth, dpha[i].getOrthogonalValue());
                }
                OneAxis axisBase = this.getInternalBaseAxis();
                if (iOutside == 0 && !srh.isCategoryScale()) {
                    iOutside = this.checkEntryByType(axisBase.getScale(), dpha[i].getBaseValue());
                }
                if (iOutside > 0) {
                    if (bHideOutside) {
                        dpha[i].markOutside();
                    } else if (bTransposed) {
                        if (!Double.isNaN(faX[i])) {
                            faX[i] = iOutside == 1 ? boClientArea.getLeft() : boClientArea.getLeft() + boClientArea.getWidth();
                        }
                    } else if (!Double.isNaN(faY[i])) {
                        faY[i] = iOutside == 1 ? boClientArea.getTop() + boClientArea.getHeight() : boClientArea.getTop();
                    }
                }
            }
            ++i;
        }
    }

    protected final void renderClipping(IPrimitiveRenderer ipr, Bounds boClientArea) {
        boolean bFirstInSequence;
        boolean bl = bFirstInSequence = this.iSeriesIndex == 1;
        if (bFirstInSequence && !this.isDimension3D() && !this.isShowOutside()) {
            ClipRenderEvent clip = new ClipRenderEvent(this);
            Location[] locations = new Location[]{LocationImpl.create(boClientArea.getLeft(), boClientArea.getTop()), LocationImpl.create(boClientArea.getLeft(), boClientArea.getTop() + boClientArea.getHeight()), LocationImpl.create(boClientArea.getLeft() + boClientArea.getWidth(), boClientArea.getTop() + boClientArea.getHeight()), LocationImpl.create(boClientArea.getLeft() + boClientArea.getWidth(), boClientArea.getTop())};
            clip.setVertices(locations);
            ipr.setClip(clip);
        }
    }

    protected void restoreClipping(IPrimitiveRenderer ipr) throws ChartException {
        boolean bLastInSequence;
        boolean bl = bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        if (bLastInSequence && !this.isDimension3D() && !this.isShowOutside()) {
            this.flushClipping();
            ClipRenderEvent clip = new ClipRenderEvent(this);
            clip.setVertices(null);
            ipr.setClip(clip);
        }
    }

    protected void flushClipping() throws ChartException {
        this.getDeferredCache().flushOptions(3);
    }

    protected void flushSeries() throws ChartException {
    }

    protected final int checkEntryByType(AutoScale scale, Object entry) {
        int iOutside = 0;
        iOutside = entry == null ? 1 : (scale.getMinimum() == null || scale.getMaximum() == null ? 0 : (entry instanceof Number ? this.checkEntryInNumberRange((Number)entry, scale.getMinimum(), scale.getMaximum()) : (entry instanceof CDateTime ? this.checkEntryInDatetimeRange((CDateTime)((Object)entry), scale.getMinimum(), scale.getMaximum()) : this.checkEntryInRange(entry, scale.getMinimum(), scale.getMaximum()))));
        return iOutside;
    }

    protected final int checkEntryInNumberRange(Number entry, Object min, Object max) {
        int iOutside = 0;
        double value = entry.doubleValue();
        double dmin = Methods.asDouble(min);
        double dmax = Methods.asDouble(max);
        if (value < dmin) {
            iOutside = 1;
        } else if (value > dmax) {
            iOutside = 2;
        }
        return iOutside;
    }

    protected final int checkEntryInDatetimeRange(CDateTime entry, Object min, Object max) {
        int iOutside = 0;
        CDateTime cmin = Methods.asDateTime(min);
        CDateTime cmax = Methods.asDateTime(max);
        if (entry.before((Object)cmin)) {
            iOutside = 1;
        } else if (entry.after((Object)cmax)) {
            iOutside = 2;
        }
        return iOutside;
    }

    protected int checkEntryInRange(Object entry, Object min, Object max) {
        return 0;
    }

    protected void addInteractivity(IPrimitiveRenderer ipr, DataPointHints dph, PrimitiveRenderEvent event) throws ChartException {
        EList elTriggers = this.se.getTriggers();
        if (!elTriggers.isEmpty()) {
            StructureSource iSource = WrappedStructureSource.createSeriesDataPoint(this.se, dph);
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InteractionEvent iev = (InteractionEvent)eventObjectCache.getEventObject(iSource, clazz);
            int t = 0;
            while (t < elTriggers.size()) {
                Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                this.processTrigger(tg, iSource);
                iev.addTrigger(tg);
                ++t;
            }
            if (event instanceof I3DRenderEvent) {
                Location panningOffset = this.getPanningOffset();
                PrimitiveRenderEvent copy = event.copy();
                if (this.get3DEngine().processEvent(copy, panningOffset.getX(), panningOffset.getY()) != null) {
                    iev.setHotSpot(copy);
                    ipr.enableInteraction(iev);
                }
            } else {
                iev.setHotSpot(event);
                ipr.enableInteraction(iev);
            }
        }
    }
}

