/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.importer;

import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.commons.Logger;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.EventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

public class ImportCBELogger
extends Logger {
    private static final String[] LEVEL_NAMES = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private static final EventFactoryHome EVENT_FACTORY_HOME;
    static /* synthetic */ Class class$0;

    static {
        EventFactoryContext eventFactoryContext = EventFactoryContext.getInstance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.logging.parsers.importer.ImportCBELogger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EVENT_FACTORY_HOME = eventFactoryContext.getEventFactoryHome("org.eclipse.hyades.logging.events.cbe.impl.EventXMLFileEventFactoryHomeImpl", clazz.getClassLoader());
    }

    public ImportCBELogger(String name) {
        super(name);
        this.setLevel(0);
    }

    public void trace(Object record) {
        if (this.isTraceEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void trace(Object record, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void debug(Object record) {
        if (this.isDebugEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void debug(Object record, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void info(Object record) {
        if (this.isInfoEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void info(Object record, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void warn(Object record) {
        if (this.isWarnEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void warn(Object record, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void error(Object record) {
        if (this.isErrorEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void error(Object record, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void fatal(Object record) {
        if (this.isFatalEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void fatal(Object record, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    private String convertToXML(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof IExternalizableToXml) {
            return ((IExternalizableToXml)object).externalizeCanonicalXmlString();
        }
        CommonBaseEvent commonBaseEvent = EVENT_FACTORY_HOME.getEventFactory(this.getName()).createCommonBaseEvent();
        try {
            commonBaseEvent.complete();
        }
        catch (CompletionException completionException) {}
        EventHelpers.convertObjectToCommonBaseEvent((CommonBaseEvent)commonBaseEvent, (Object)object, (int)4);
        commonBaseEvent.addExtendedDataElement("Logger_Name", this.getName());
        commonBaseEvent.addExtendedDataElement("Logging_Level", LEVEL_NAMES[this.getLevel()]);
        String result = EventFormatter.toCanonicalXMLString((CommonBaseEvent)commonBaseEvent, (boolean)true).concat(Constants.LINE_SEPARATOR);
        return result;
    }
}

