/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.BlobReader;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriverObject;

public class OdaBlob
extends OdaDriverObject
implements IBlob {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final String COMMA_SEPARATOR = ", ";

    protected OdaBlob(IBlob blob, OdaConnection connection, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((Object)blob, connection, switchContextClassloader, driverClassLoader);
        String context = "OdaBlob( Blob , " + connection + " )\t";
        this.logMethodCalled(context);
    }

    private IBlob getDriverBlob() {
        return (IBlob)this.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws OdaException {
        String context = "OdaBlob.getBinaryStream()\t";
        String unsupportedOpContext = "IBlob.getBinaryStream()";
        this.logMethodCalled("OdaBlob.getBinaryStream()\t");
        try {
            this.setContextClassloader();
            InputStream ret = this.getDriverBlob().getBinaryStream();
            this.logMethodExitWithReturn("OdaBlob.getBinaryStream()\t", ret);
            InputStream inputStream = ret;
            return inputStream;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IBlob.getBinaryStream()");
            InputStream inputStream = null;
            return inputStream;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            InputStream inputStream = null;
            return inputStream;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long position, int length) throws OdaException {
        String context = "OdaBlob.getBytes( " + position + COMMA_SEPARATOR + length + " )\t";
        String unsupportedOpContext = "IBlob.getBytes()";
        this.logMethodCalled(context);
        byte[] ret = null;
        try {
            this.setContextClassloader();
            ret = this.getDriverBlob().getBytes(position, length);
            this.logMethodExitWithReturn(context, ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (UnsupportedOperationException uoException) {
            ret = this.getBytesFromStream(position, length);
            if (ret == null) {
                this.handleUnsupportedOp(uoException, "IBlob.getBytes()");
                byte[] byArray = null;
                return byArray;
            }
            this.logMethodExitWithReturn(context, ret);
            byte[] byArray = ret;
            return byArray;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            byte[] byArray = null;
            return byArray;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws OdaException {
        String context = "OdaBlob.length()\t";
        String unsupportedOpContext = "IBlob.length()";
        this.logMethodCalled("OdaBlob.length()\t");
        try {
            this.setContextClassloader();
            long ret = this.getDriverBlob().length();
            this.logMethodExitWithReturn("OdaBlob.length()\t", ret);
            long l = ret;
            return l;
        }
        catch (UnsupportedOperationException uoException) {
            long l = this.handleUnsupportedOpAndRetZero(uoException, "IBlob.length()");
            return l;
        }
        catch (RuntimeException rtException) {
            long l = this.handleErrorAndReturnZero(rtException);
            return l;
        }
        catch (OdaException odaException) {
            long l = this.handleErrorAndReturnZero(odaException);
            return l;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesFromStream(long startPos, int length) {
        String context = "OdaBlob.getBytesFromStream( " + startPos + COMMA_SEPARATOR + length + " )\t";
        byte[] ret = null;
        try {
            this.setContextClassloader();
            BlobReader reader = new BlobReader(this, this.getReaderBufferSize());
            ret = reader.getBytes(startPos, length);
        }
        catch (RuntimeException rte) {
            this.handleError(rte);
        }
        catch (IOException e) {
            this.log(context, e.toString());
        }
        catch (OdaException ex) {
            this.log(context, ex.toString());
        }
        finally {
            this.resetContextClassloader();
        }
        return ret;
    }

    protected int getReaderBufferSize() {
        return 2048;
    }
}

