/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ContentElementHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.OperatorUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.IFilterConditionElementModel;

public class FilterConditionElementHandle
extends ContentElementHandle
implements IFilterConditionElementModel {
    public FilterConditionElementHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public String getExpr() {
        return this.getStringProperty("expr");
    }

    public void setExpr(String filterExpr) throws SemanticException {
        this.setProperty("expr", filterExpr);
    }

    public String getOperator() {
        return this.getStringProperty("operator");
    }

    public void setOperator(String operator) throws SemanticException {
        ActivityStack stack = this.getModule().getActivityStack();
        stack.startTrans();
        try {
            this.setProperty("operator", operator);
            int level = OperatorUtil.computeFilterOperatorLevel(operator);
            switch (level) {
                case 1: {
                    this.setValue2(null);
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    this.setValue2(null);
                    this.setValue1(null);
                    break;
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public String getValue1() {
        return this.getStringProperty("value1");
    }

    public void setValue1(String value1Expr) throws SemanticException {
        this.setStringProperty("value1", value1Expr);
    }

    public String getValue2() {
        return this.getStringProperty("value2");
    }

    public void setValue2(String value2Expr) throws SemanticException {
        this.setStringProperty("value2", value2Expr);
    }

    public String getFilterTarget() {
        return (String)this.getProperty("filterTarget");
    }

    public void setFilterTarget(String filterTarget) throws SemanticException {
        this.setStringProperty("filterTarget", filterTarget);
    }

    public MemberValueHandle getMember() {
        List contents = this.getContents("member");
        if (contents != null && contents.size() > 0) {
            return (MemberValueHandle)contents.get(0);
        }
        return null;
    }
}

