/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.model.api.IModuleOption;
import org.eclipse.birt.report.model.api.IResourceLocator;

public class ModuleOption
implements IModuleOption {
    protected HashMap options = new HashMap();

    public ModuleOption() {
    }

    public ModuleOption(Map options) {
        if (options != null && !options.isEmpty()) {
            this.options.putAll(options);
        }
    }

    public boolean useSemanticCheck() {
        Object semanticCheck = this.options.get("semanticCheck");
        if (semanticCheck != null) {
            return (Boolean)semanticCheck;
        }
        return true;
    }

    public void setSemanticCheck(boolean useSemanticCheck) {
        this.options.put("semanticCheck", useSemanticCheck);
    }

    public String getResourceFolder() {
        return (String)this.options.get("resourceFolder");
    }

    public void setResourceFolder(String resourceFolder) {
        if (resourceFolder != null) {
            this.options.put("resourceFolder", resourceFolder);
        }
    }

    public void setProperty(String key, Object value) {
        this.options.put(key, value);
    }

    public Object getProperty(String key) {
        return this.options.get(key);
    }

    public boolean markLineNumber() {
        if (!this.useSemanticCheck()) {
            return false;
        }
        Object markLineNumber = this.options.get("markLineNumber");
        if (markLineNumber != null) {
            return (Boolean)markLineNumber;
        }
        return true;
    }

    public void setMarkLineNumber(boolean markLineNumber) {
        this.options.put("markLineNumber", markLineNumber);
    }

    public IResourceLocator getResourceLocator() {
        return (IResourceLocator)this.options.get("resourceLocator");
    }

    public void setResourceLocator(IResourceLocator locator) {
        if (locator != null) {
            this.options.put("resourceLocator", locator);
        }
    }

    public ULocale getLocale() {
        return (ULocale)this.options.get("locale");
    }

    public void setLocale(ULocale locale) {
        if (locale != null) {
            this.options.put("locale", locale);
        }
    }
}

