/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.SlotIterator;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.util.ModelUtil;

public class SlotHandle
extends ElementDetailHandle {
    protected int slotID;

    public SlotHandle(DesignElementHandle element, int slotID) {
        super(element);
        this.slotID = slotID;
    }

    public void add(DesignElementHandle content) throws ContentException, NameException {
        if (content == null) {
            return;
        }
        this.add(content.getElement());
    }

    public void add(DesignElementHandle content, int newPos) throws ContentException, NameException {
        if (content == null) {
            return;
        }
        this.add(content.getElement(), newPos);
    }

    public void add(DesignElement content) throws ContentException, NameException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.slotID));
        cmd.add(content);
    }

    public void add(DesignElement content, int newPos) throws ContentException, NameException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.slotID));
        cmd.add(content, newPos);
    }

    public List paste(DesignElementHandle content) throws ContentException, NameException {
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        this.add(content);
        return this.checkPostPasteErrors(content.getElement());
    }

    public List paste(IDesignElement content) throws ContentException, NameException {
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        this.add(content.getHandle(this.getModule()));
        return this.checkPostPasteErrors((DesignElement)content);
    }

    public List paste(DesignElementHandle content, int newPos) throws ContentException, NameException {
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        this.add(content, newPos);
        return Collections.EMPTY_LIST;
    }

    public List paste(IDesignElement content, int newPos) throws ContentException, NameException {
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        this.add(content.getHandle(this.getModule()), newPos);
        return this.checkPostPasteErrors((DesignElement)content);
    }

    private List checkPostPasteErrors(DesignElement content) {
        Module currentModule = this.getElementHandle().getModule();
        String nameSpace = null;
        if (currentModule != null && currentModule instanceof Library) {
            nameSpace = ((Library)currentModule).getNamespace();
        }
        ModelUtil.revisePropertyNameSpace(this.getModule(), content, content.getDefn().getProperty("extends"), nameSpace);
        ModelUtil.reviseNameSpace(this.getModule(), content, nameSpace);
        List exceptionList = content.validateWithContents(this.getModule());
        List errorDetailList = ErrorDetail.convertExceptionList(exceptionList);
        return errorDetailList;
    }

    public Iterator iterator() {
        return new SlotIterator(this);
    }

    public List getContents() {
        List contents = this.getElement().getSlot(this.slotID).getContents();
        if (contents == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DesignElementHandle> retList = new ArrayList<DesignElementHandle>();
        Iterator iter = contents.iterator();
        while (iter.hasNext()) {
            retList.add(((DesignElement)iter.next()).getHandle(this.getModule()));
        }
        return retList;
    }

    public int getCount() {
        return this.getElement().getSlot(this.slotID).getCount();
    }

    public DesignElementHandle get(int posn) {
        if (posn < 0 || posn >= this.getCount()) {
            return null;
        }
        DesignElement content = this.getElement().getSlot(this.slotID).getContent(posn);
        if (content == null) {
            return null;
        }
        return content.getHandle(this.getModule());
    }

    public void shift(DesignElementHandle content, int toPosn) throws ContentException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.slotID));
        cmd.movePosition(content.getElement(), toPosn);
    }

    public void move(DesignElementHandle content, DesignElementHandle newContainer, int toSlot) throws ContentException {
        if (content == null || newContainer == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.slotID));
        cmd.move(content.getElement(), new ContainerContext(newContainer.getElement(), toSlot));
    }

    public void move(DesignElementHandle content, DesignElementHandle newContainer, int toSlot, int newPos) throws ContentException {
        if (content == null || newContainer == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.slotID));
        cmd.move(content.getElement(), new ContainerContext(newContainer.getElement(), toSlot), newPos);
    }

    public void dropAndClear(DesignElementHandle content) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.slotID));
        cmd.remove(content.getElement(), false);
    }

    public void drop(DesignElementHandle content) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.slotID));
        cmd.remove(content.getElement(), true);
    }

    public void dropAndClear(int posn) throws SemanticException {
        DesignElement content = this.getElement().getSlot(this.slotID).getContent(posn);
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.slotID));
        cmd.remove(content, false);
    }

    public void drop(int posn) throws SemanticException {
        DesignElement content = this.getElement().getSlot(this.slotID).getContent(posn);
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.slotID));
        cmd.remove(content, true);
    }

    public ContainerSlot getSlot() {
        return this.getElement().getSlot(this.slotID);
    }

    public int findPosn(DesignElementHandle content) {
        return this.getSlot().findPosn(content.getElement());
    }

    public int getSlotID() {
        return this.slotID;
    }

    public boolean canContain(String type) {
        return this.getElementHandle().canContain(this.slotID, type);
    }

    public boolean canContain(DesignElementHandle content) {
        return this.getElementHandle().canContain(this.slotID, content);
    }

    public ISlotDefn getDefn() {
        return this.getElement().getDefn().getSlot(this.slotID);
    }
}

