/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.impl;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IModuleOption;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.impl.SimpleElementFactory;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;
import org.eclipse.birt.report.model.api.metadata.MetaDataReaderException;
import org.eclipse.birt.report.model.api.simpleapi.IReportDesign;
import org.eclipse.birt.report.model.metadata.ExtensionManager;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaDataReader;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.eclipse.birt.report.model.simpleapi.ReportDesign;

public class DesignEngineImpl
implements IDesignEngine {
    protected static Logger errorLogger;
    private static final String ROM_DEF_FILE_NAME = "rom.def";
    private DesignConfig designConfig;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.impl.DesignEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        errorLogger = Logger.getLogger(clazz.getName());
    }

    public DesignEngineImpl(DesignConfig config) {
        this.designConfig = config;
    }

    private static void initialize(InputStream is) throws MetaDataReaderException {
        try {
            MetaDataReader.read(is);
            ExtensionManager.initialize();
            org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory.setInstance(new SimpleElementFactory());
        }
        catch (MetaDataParserException e) {
            throw new MetaDataReaderException("Error.MetaDataReaderException.META_DATA_ERROR", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SessionHandle newSessionHandle(ULocale locale) {
        if (!MetaDataDictionary.getInstance().isEmpty()) {
            return new SessionHandle(locale);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.impl.DesignEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            IResourceLocator locator;
            if (!MetaDataDictionary.getInstance().isEmpty()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new SessionHandle(locale);
            }
            MetaDataDictionary.reset();
            try {
                try {
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("org.eclipse.birt.report.model.elements.ReportDesign");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    DesignEngineImpl.initialize(clazz3.getResourceAsStream(ROM_DEF_FILE_NAME));
                }
                catch (MetaDataReaderException metaDataReaderException) {}
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                MetaLogManager.shutDown();
                throw throwable;
            }
            MetaLogManager.shutDown();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            SessionHandle session = new SessionHandle(locale);
            if (this.designConfig != null && (locator = this.designConfig.getResourceLocator()) != null) {
                session.setResourceLocator(locator);
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMetaDataDictionary getMetaData() {
        if (!MetaDataDictionary.getInstance().isEmpty()) {
            return MetaDataDictionary.getInstance();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.impl.DesignEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (!MetaDataDictionary.getInstance().isEmpty()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return MetaDataDictionary.getInstance();
            }
            MetaDataDictionary.reset();
            try {
                try {
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("org.eclipse.birt.report.model.elements.ReportDesign");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    DesignEngineImpl.initialize(clazz3.getResourceAsStream(ROM_DEF_FILE_NAME));
                }
                catch (MetaDataReaderException metaDataReaderException) {}
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                MetaLogManager.shutDown();
                throw throwable;
            }
            MetaLogManager.shutDown();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MetaDataDictionary.getInstance();
        }
    }

    public void registerMetaLogger(IMetaLogger newLogger) {
        MetaLogManager.registerLogger(newLogger);
    }

    public boolean removeMetaLogger(IMetaLogger logger) {
        return MetaLogManager.removeLogger(logger);
    }

    public IReportDesign openDesign(String fileName, InputStream ins, IModuleOption options) throws DesignFileException {
        SessionHandle tmpSession = this.newSessionHandle(null);
        return new ReportDesign(tmpSession.openDesign(fileName, ins, (ModuleOption)options));
    }
}

