/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

class ElementExporter {
    private LibraryHandle targetLibraryHandle;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.util.ElementExporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    ElementExporter(LibraryHandle libraryHandle) {
        this.targetLibraryHandle = libraryHandle;
    }

    static void checkElementToExport(DesignElementHandle elementToExport) {
        ModuleHandle root = elementToExport.getRoot();
        if (!(root instanceof ReportDesignHandle)) {
            throw new IllegalArgumentException("The element to export must be in design file.");
        }
        if (StringUtil.isBlank(elementToExport.getName())) {
            throw new IllegalArgumentException("The element must have name defined.");
        }
    }

    static void checkStructureToExport(StructureHandle structToExport) {
        String memberName = null;
        String propName = null;
        String structName = structToExport.getDefn().getName();
        if ("EmbeddedImage".equals(structName)) {
            propName = "images";
            memberName = "name";
        } else if ("CustomColor".equals(structName)) {
            propName = "colorPalette";
            memberName = "name";
        } else if ("ConfigVar".equals(structName)) {
            propName = "configVars";
            memberName = "name";
        } else {
            throw new IllegalArgumentException("The structure \"" + structName + "\" is not allowed to export.");
        }
        Object value = structToExport.getMember(memberName).getValue();
        if (StringUtil.isBlank((String)value)) {
            throw new IllegalArgumentException("The structure \"" + structName + "\" must have member \"" + memberName + "\" defined.");
        }
        boolean found = false;
        ModuleHandle moduleHandle = structToExport.getElementHandle().getModuleHandle();
        PropertyHandle propertyHandle = moduleHandle.getPropertyHandle(propName);
        ArrayList list = propertyHandle.getListValue();
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Structure struct = (Structure)iter.next();
                if (struct != structToExport.getStructure()) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new IllegalArgumentException("The structure to export must be in design file.");
        }
    }

    void exportStructure(StructureHandle structToExport, boolean canOverride) throws SemanticException {
        Object value;
        Object nameValue;
        String structName = structToExport.getDefn().getName();
        String nameMemberName = null;
        ReferencableStructure newStruct = null;
        PropertyHandle newPropertyHandle = null;
        if ("EmbeddedImage".equals(structName)) {
            nameMemberName = "name";
            newStruct = StructureFactory.createEmbeddedImage();
            newPropertyHandle = this.targetLibraryHandle.getPropertyHandle("images");
        } else if ("CustomColor".equals(structName)) {
            nameMemberName = "name";
            newStruct = StructureFactory.createCustomColor();
            newPropertyHandle = this.targetLibraryHandle.getPropertyHandle("colorPalette");
        } else if ("ConfigVar".equals(structName)) {
            nameMemberName = "name";
            newStruct = StructureFactory.createConfigVar();
            newPropertyHandle = this.targetLibraryHandle.getPropertyHandle("configVars");
        } else {
            throw new IllegalArgumentException("The structure \"" + structName + "\" is not allowed to export.");
        }
        if (!$assertionsDisabled && newStruct == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && newPropertyHandle == null) {
            throw new AssertionError();
        }
        if (canOverride && (nameValue = structToExport.getMember(nameMemberName).getValue()) != null) {
            Iterator iter = newPropertyHandle.iterator();
            while (iter.hasNext()) {
                StructureHandle structureHandle = (StructureHandle)iter.next();
                value = structureHandle.getMember(nameMemberName).getValue();
                if (!nameValue.equals(value)) continue;
                IStructure struct = structureHandle.getStructure();
                newPropertyHandle.removeItem(struct);
                break;
            }
        }
        Iterator iter = structToExport.getDefn().propertiesIterator();
        while (iter.hasNext()) {
            PropertyDefn memberDefn = (PropertyDefn)iter.next();
            String memberName = memberDefn.getName();
            if ("libReference".equals(memberName)) continue;
            value = structToExport.getMember(memberName).getValue();
            Object valueToSet = ModelUtil.copyValue(memberDefn, value);
            newStruct.setProperty(memberName, valueToSet);
        }
        newPropertyHandle.addItem(newStruct);
    }

    void exportElement(DesignElementHandle elementToExport, boolean canOverride) throws SemanticException {
        int slotID;
        if (elementToExport instanceof StyleHandle) {
            this.exportStyle((StyleHandle)elementToExport, canOverride);
            return;
        }
        if (canOverride) {
            int nameSpaceID = ((ElementDefn)elementToExport.getDefn()).getNameSpaceID();
            NameSpace nameSpace = this.targetLibraryHandle.getModule().getNameHelper().getNameSpace(nameSpaceID);
            DesignElement duplicateElement = nameSpace.getElement(elementToExport.getName());
            if (duplicateElement != null) {
                duplicateElement.getHandle(this.targetLibraryHandle.getModule()).drop();
            }
        }
        if ((slotID = this.getTopContainerSlot(elementToExport.getElement())) == 6) {
            slotID = 5;
        } else if (slotID == 4 && elementToExport.getContainer() != elementToExport.getModuleHandle()) {
            slotID = 5;
        } else if (slotID == 9) {
            slotID = 6;
        }
        if (slotID >= 7) {
            return;
        }
        DesignElementHandle newElementHandle = this.duplicateElement(elementToExport, false);
        SlotHandle slotHandle = this.targetLibraryHandle.getSlot(slotID);
        this.addToSlot(slotHandle, newElementHandle);
    }

    void exportStyle(StyleHandle elementToExport, boolean canOverride) throws SemanticException {
        SlotHandle themes = this.targetLibraryHandle.getThemes();
        String defaultThemeName = ModelMessages.getMessage("Theme.defaultThemeName");
        NameSpace nameSpace = this.targetLibraryHandle.getModule().getNameHelper().getNameSpace(6);
        Theme theme = (Theme)nameSpace.getElement(defaultThemeName);
        ThemeHandle themeHandle = null;
        if (theme == null) {
            themeHandle = this.targetLibraryHandle.getElementFactory().newTheme(defaultThemeName);
            themes.add(themeHandle);
        } else {
            themeHandle = (ThemeHandle)theme.getHandle(this.targetLibraryHandle.getModule());
        }
        this.exportStyle(elementToExport, themeHandle, canOverride);
    }

    void exportStyle(StyleHandle elementToExport, ThemeHandle theme, boolean canOverride) throws SemanticException {
        StyleHandle style;
        if (!$assertionsDisabled && theme == null) {
            throw new AssertionError();
        }
        if (canOverride && (style = theme.findStyle(elementToExport.getName())) != null) {
            style.drop();
        }
        DesignElementHandle newElementHandle = this.duplicateElement(elementToExport, false);
        this.addToSlot(theme.getStyles(), newElementHandle);
    }

    void exportDesign(ReportDesignHandle designToExport, boolean canOverride, boolean genDefaultName) throws SemanticException {
        ModelUtil.duplicateProperties(designToExport, this.targetLibraryHandle, false);
        int slotCount = designToExport.getDefn().getSlotCount();
        int i = 0;
        while (i < slotCount) {
            DesignElementHandle contentHandle;
            SlotHandle sourceSlotHandle = designToExport.getSlot(i);
            Iterator iter = sourceSlotHandle.iterator();
            ArrayList<DesignElementHandle> noNameList = new ArrayList<DesignElementHandle>();
            while (iter.hasNext()) {
                contentHandle = (DesignElementHandle)iter.next();
                if (StringUtil.isBlank(contentHandle.getName())) {
                    noNameList.add(contentHandle);
                    continue;
                }
                this.exportElement(contentHandle, canOverride);
            }
            iter = noNameList.iterator();
            while (iter.hasNext()) {
                contentHandle = (DesignElementHandle)iter.next();
                if (!genDefaultName) {
                    String typeName = contentHandle.getDefn().getDisplayName();
                    String location = contentHandle.getElement().getIdentifier();
                    throw new IllegalArgumentException("The element [type=\"" + typeName + "\"," + "location=\"" + location + "\"] must have name defined.");
                }
                this.targetLibraryHandle.getModule().makeUniqueName(contentHandle.getElement());
                this.exportElement(contentHandle, canOverride);
            }
            ++i;
        }
    }

    private int getTopContainerSlot(DesignElement element) {
        int slotID = element.getContainerInfo().getSlotID();
        DesignElement container = element.getContainer();
        while (!(container instanceof Module)) {
            slotID = container.getContainerInfo().getSlotID();
            container = container.getContainer();
            if (!$assertionsDisabled && container == null) {
                throw new AssertionError();
            }
        }
        return slotID;
    }

    private DesignElementHandle duplicateElement(DesignElementHandle elementHandle, boolean onlyFactoryProperty) throws SemanticException {
        String elementName = elementHandle.getDefn().getName();
        String name = elementHandle.getName();
        DesignElementHandle newElementHandle = this.targetLibraryHandle.getElementFactory().newElement(elementName, name);
        ModelUtil.duplicateProperties(elementHandle, newElementHandle, onlyFactoryProperty);
        this.duplicateSlots(elementHandle, newElementHandle);
        return newElementHandle;
    }

    private void duplicateSlots(DesignElementHandle source, DesignElementHandle destination) throws SemanticException {
        int slotCount = source.getDefn().getSlotCount();
        int i = 0;
        while (i < slotCount) {
            SlotHandle sourceSlotHandle = source.getSlot(i);
            SlotHandle destinationSlotHandle = destination.getSlot(i);
            Iterator iter = sourceSlotHandle.iterator();
            while (iter.hasNext()) {
                DesignElementHandle contentHandle = (DesignElementHandle)iter.next();
                DesignElementHandle newContentHandle = this.duplicateElement(contentHandle, true);
                this.addToSlot(destinationSlotHandle, newContentHandle);
            }
            ++i;
        }
        Iterator props = source.getElement().getPropertyDefns().iterator();
        while (props.hasNext()) {
            String propName;
            Object value;
            IPropertyDefn propDefn = (IPropertyDefn)props.next();
            if (propDefn.getTypeCode() != 23 || (value = source.getProperty(propName = propDefn.getName())) == null) continue;
            if (propDefn.isList()) {
                int j = 0;
                while (j < ((List)value).size()) {
                    DesignElementHandle contentHandle = (DesignElementHandle)((ArrayList)value).get(j);
                    DesignElementHandle newContentHandle = this.duplicateElement(contentHandle, false);
                    destination.add(propName, newContentHandle);
                    ++j;
                }
                continue;
            }
            DesignElementHandle newContentHandle = this.duplicateElement((DesignElementHandle)value, false);
            destination.add(propName, newContentHandle);
        }
    }

    private void addToSlot(SlotHandle slotHandle, DesignElementHandle contentHandle) throws SemanticException {
        slotHandle.add(contentHandle);
    }
}

