/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.IContainerDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefnSet;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;
import org.eclipse.birt.report.model.util.ContentIterator;

public final class ContainerContext {
    protected final DesignElement container;
    protected final int containerSlotID;
    protected final String containerProp;
    private final boolean isSlot;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.ContainerContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ContainerContext(DesignElement theContainer, int slotID) {
        if (theContainer == null) {
            throw new IllegalArgumentException("The container of ContainerInfo should not be null");
        }
        this.container = theContainer;
        this.containerSlotID = slotID;
        this.isSlot = true;
        this.containerProp = null;
    }

    public ContainerContext(DesignElement theContainer, String propName) {
        if (theContainer == null || propName == null) {
            throw new IllegalArgumentException("The container and property name should not be null");
        }
        this.container = theContainer;
        this.containerProp = propName;
        this.isSlot = false;
        this.containerSlotID = -1;
    }

    public String getContainerIdentifier() {
        if (this.container.getPropertyDefn(this.containerProp) != null) {
            return this.containerProp;
        }
        return this.container.getDefn().getSlot(this.containerSlotID).getName();
    }

    public DesignElement getElement() {
        return this.container;
    }

    public int getSlotID() {
        return this.containerSlotID;
    }

    public String getPropertyName() {
        if (!this.isSlot) {
            return this.containerProp;
        }
        return null;
    }

    public IContainerDefn getContainerDefn() {
        if (this.isSlot) {
            return this.container.getDefn().getSlot(this.containerSlotID);
        }
        ElementPropertyDefn defn = this.container.getPropertyDefn(this.containerProp);
        if (defn != null && defn.isElementType()) {
            return defn;
        }
        return null;
    }

    public int indexOf(Module module, DesignElement content) {
        if (this.isSlot) {
            return this.container.getSlot(this.containerSlotID).findPosn(content);
        }
        Object value = this.container.getProperty(module, this.containerProp);
        if (value == content) {
            return 0;
        }
        if (value instanceof List) {
            return ((List)value).indexOf(content);
        }
        return -1;
    }

    public int indexOf(DesignElement content) {
        return this.indexOf(this.container.getRoot(), content);
    }

    public boolean isManagedByNameSpace() {
        if (this.container.getRoot() == null) {
            return false;
        }
        ContainerContext containerInfo = this;
        while (containerInfo != null) {
            SlotDefn slotInfo;
            if (containerInfo.isSlot && (slotInfo = (SlotDefn)containerInfo.container.getDefn().getSlot(containerInfo.containerSlotID)) != null && !slotInfo.isManagedByNameSpace()) {
                return false;
            }
            containerInfo = containerInfo.container.getContainerInfo();
        }
        return true;
    }

    public String getSelector() {
        ElementDefn defn = (ElementDefn)this.container.getDefn();
        SlotDefn slotDefn = (SlotDefn)defn.getSlot(this.containerSlotID);
        if (slotDefn == null) {
            return null;
        }
        String slotSelector = slotDefn.getSelector();
        if (StringUtil.isBlank(slotSelector)) {
            return null;
        }
        if (this.container instanceof GroupElement) {
            int depth = ((GroupElement)this.container).getGroupLevel();
            if (depth > 9) {
                depth = 9;
            }
            return String.valueOf(slotSelector) + "-" + Integer.toString(depth);
        }
        return slotSelector;
    }

    public boolean canContainInRom(IElementDefn defn) {
        if (defn == null) {
            return false;
        }
        return this.getContainerDefn() == null ? false : this.getContainerDefn().canContain(defn);
    }

    public boolean isContainerMultipleCardinality() {
        IContainerDefn defn = this.getContainerDefn();
        if (defn instanceof PropertyDefn) {
            return ((PropertyDefn)defn).isList();
        }
        if (defn instanceof SlotDefn) {
            return ((SlotDefn)defn).isMultipleCardinality();
        }
        return false;
    }

    public List getContents(Module module) {
        if (this.getContainerDefn() == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.isSlot) {
            return this.container.getSlot(this.containerSlotID).getContents();
        }
        ElementPropertyDefn defn = this.container.getPropertyDefn(this.containerProp);
        Object value = this.container.getLocalProperty(module, defn);
        if (defn == null || value == null) {
            return Collections.EMPTY_LIST;
        }
        if (defn.isList()) {
            return (List)value;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(value);
        return result;
    }

    public DesignElement getContent(Module module, int posn) {
        if (this.isSlot) {
            return this.container.getSlot(this.containerSlotID).getContent(posn);
        }
        return this.getContent(module, this.containerProp, posn);
    }

    private DesignElement getContent(Module module, String propName, int posn) {
        ElementPropertyDefn defn = this.container.getPropertyDefn(propName);
        if (defn == null) {
            return null;
        }
        if (defn.isList()) {
            List value = this.container.getListProperty(module, propName);
            return value == null ? null : value.get(posn);
        }
        return (DesignElement)(posn == 0 ? this.container.getProperty(module, defn) : null);
    }

    public int getContentCount(Module module) {
        if (this.isSlot) {
            return this.container.getSlot(this.containerSlotID) == null ? 0 : this.container.getSlot(this.containerSlotID).getCount();
        }
        return this.getContentCount(module, this.containerProp);
    }

    private int getContentCount(Module module, String propName) {
        ElementPropertyDefn defn = this.container.getPropertyDefn(propName);
        if (defn == null) {
            return 0;
        }
        if (defn.isList()) {
            List value = this.container.getListProperty(module, propName);
            return value == null ? 0 : value.size();
        }
        return this.container.getProperty(module, defn) == null ? 0 : 1;
    }

    public void add(Module module, DesignElement content, int posn) {
        if (this.isSlot) {
            this.container.add(content, this.containerSlotID, posn);
        } else {
            this.container.add(module, content, this.containerProp, posn);
        }
    }

    public void add(Module module, DesignElement content) {
        if (this.isSlot) {
            this.container.add(content, this.containerSlotID);
        } else {
            this.container.add(module, content, this.containerProp);
        }
    }

    public void remove(Module module, DesignElement content) {
        if (this.isSlot) {
            this.container.remove(content, this.containerSlotID);
        } else {
            this.container.remove(module, content, this.containerProp);
        }
    }

    public boolean contains(Module module, DesignElement content) {
        return this.indexOf(module, content) != -1;
    }

    public SemanticTriggerDefnSet getTriggerSetForContainerDefn() {
        IContainerDefn defn = this.getContainerDefn();
        if (defn instanceof PropertyDefn) {
            return ((PropertyDefn)defn).getTriggerDefnSet();
        }
        if (defn instanceof SlotDefn) {
            return ((SlotDefn)defn).getTriggerDefnSet();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContainerContext)) {
            return false;
        }
        ContainerContext infoObj = (ContainerContext)obj;
        if (this.container.equals(infoObj.container)) {
            if (this.isSlot && infoObj.isSlot && infoObj.containerSlotID == this.containerSlotID) {
                return true;
            }
            if (!this.isSlot && !infoObj.isSlot && this.containerProp.equals(infoObj.containerProp)) {
                return true;
            }
        }
        return false;
    }

    public boolean canContain(Module module, DesignElement content) {
        return new ContainerContextProvider(this).canContain(module, content);
    }

    public boolean canContain(Module module, String type) {
        return new ContainerContextProvider(this).canContain(module, type);
    }

    public final boolean canContain(Module module, IElementDefn defn) {
        return new ContainerContextProvider(this).canContain(module, defn);
    }

    public final List checkContainmentContext(Module module, DesignElement element) {
        return new ContainerContextProvider(this).checkContainmentContext(module, element);
    }

    public void move(Module module, int from, int to) {
        if (this.isSlot) {
            this.container.getSlot(this.containerSlotID).moveContent(from, to);
        } else {
            this.move(module, this.containerProp, from, to);
        }
    }

    private void move(Module module, String propName, int from, int to) {
        ElementPropertyDefn defn = this.container.getPropertyDefn(propName);
        if (!($assertionsDisabled || defn.isList() && defn.getTypeCode() == 23)) {
            throw new AssertionError();
        }
        List items = this.container.getListProperty(module, propName);
        if (!$assertionsDisabled && items == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || from >= 0 && from < items.size())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || to >= 0 && to < items.size())) {
            throw new AssertionError();
        }
        if (from == to) {
            return;
        }
        Object obj = items.remove(from);
        items.add(to, obj);
    }

    public void clearContents() {
        if (this.isSlot) {
            ContainerSlot slot = this.container.getSlot(this.containerSlotID);
            if (slot != null) {
                slot.clear();
            }
        } else {
            this.container.clearProperty(this.containerProp);
        }
    }

    public ContainerContext createContext(DesignElement newElement) {
        if (newElement.getDefn() != this.container.getDefn()) {
            return null;
        }
        ContainerContext newContext = null;
        newContext = this.isSlot ? new ContainerContext(newElement, this.containerSlotID) : new ContainerContext(newElement, this.containerProp);
        return newContext;
    }

    class ContainerContextProvider {
        protected ContainerContext focus = null;

        public ContainerContextProvider(ContainerContext containerInfo) {
            if (containerInfo == null) {
                throw new IllegalArgumentException("The containerInfo of this context should not be null");
            }
            this.focus = containerInfo;
        }

        public boolean canContain(Module module, String type) {
            if (type == null) {
                return false;
            }
            return this.canContain(module, MetaDataDictionary.getInstance().getElement(type));
        }

        public final boolean canContain(Module module, DesignElement element) {
            if (module != null && module.isReadOnly()) {
                return false;
            }
            List errors = this.checkContainmentContext(module, element);
            return errors.isEmpty();
        }

        public final boolean canContain(Module module, IElementDefn defn) {
            if (defn == null || module != null && module.isReadOnly()) {
                return false;
            }
            boolean retValue = this.canContainInRom(defn);
            if (!retValue) {
                return false;
            }
            if (this.focus.getElement().isRootIncludedByModule()) {
                return false;
            }
            if (!this.canContainTemplateElement(module, defn)) {
                return false;
            }
            if (this.focus.getElement().isVirtualElement() || this.focus.getElement().getExtendsName() != null) {
                return false;
            }
            ContainerContext containerInfo = this.focus;
            while (containerInfo != null) {
                DesignElement container = containerInfo.getElement();
                if (container instanceof ListingElement || container instanceof MasterPage) {
                    List errors = container.checkContent(module, this.focus, defn);
                    return errors.isEmpty();
                }
                containerInfo = container.getContainerInfo();
            }
            return retValue;
        }

        public final List checkContainmentContext(Module module, DesignElement element) {
            if (element == null) {
                return Collections.EMPTY_LIST;
            }
            boolean retValue = this.canContainInRom(element.getDefn());
            ContentException e = ContentExceptionFactory.createContentException(this.focus, element, "Error.ContentException.INVALID_CONTEXT_CONTAINMENT");
            List<ContentException> errors = new ArrayList<ContentException>();
            if (!retValue) {
                errors.add(e);
                return errors;
            }
            if (!this.canContainTemplateElement(module, element)) {
                errors.add(e);
                return errors;
            }
            if (this.focus.getElement().isRootIncludedByModule()) {
                errors.add(e);
                return errors;
            }
            if (this.focus.getElement().isVirtualElement() || this.focus.getElement().getExtendsName() != null) {
                errors.add(e);
                return errors;
            }
            ContainerContext containerInfor = this.focus;
            while (containerInfor != null) {
                DesignElement container = containerInfor.getElement();
                if (container == element) {
                    errors.add(e);
                    return errors;
                }
                if (container instanceof ListingElement || container instanceof Theme || container instanceof MasterPage) {
                    errors = container.checkContent(module, this.focus, element);
                    return errors;
                }
                containerInfor = container.getContainerInfo();
            }
            return Collections.EMPTY_LIST;
        }

        private boolean canContainInRom(IElementDefn defn) {
            if (!this.focus.canContainInRom(defn)) {
                return false;
            }
            String name = defn.getName();
            if ("TemplateDataSet".equals(name) || "TemplateReportItem".equals(name) || "TemplateElement".equals(name)) {
                return true;
            }
            return this.focus.getContentCount(this.focus.getElement().getRoot()) <= 0 || this.focus.isContainerMultipleCardinality();
        }

        private boolean canContainTemplateElement(Module module, DesignElement element) {
            IElementDefn defn = MetaDataDictionary.getInstance().getElement("TemplateElement");
            if (element instanceof TemplateElement) {
                return this.canContainTemplateElement(module, defn);
            }
            ContentIterator contents = new ContentIterator(module, element);
            while (contents.hasNext()) {
                DesignElement content = (DesignElement)contents.next();
                if (!(content instanceof TemplateElement)) continue;
                return this.canContainTemplateElement(module, defn);
            }
            return true;
        }

        private boolean canContainTemplateElement(Module module, IElementDefn defn) {
            if (defn != null && defn.isKindOf(MetaDataDictionary.getInstance().getElement("TemplateElement"))) {
                ContainerContext containerInfo = this.focus;
                while (containerInfo != null) {
                    DesignElement container = containerInfo.getElement();
                    if (container instanceof Module && containerInfo.getSlotID() == 5 || container instanceof Library) {
                        return false;
                    }
                    containerInfo = container.getContainerInfo();
                }
                if (module instanceof Library) {
                    return false;
                }
            }
            return true;
        }
    }
}

