/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IObjectDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public abstract class Structure
implements IStructure {
    private StructureContext context;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.Structure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Structure)) {
            return false;
        }
        Structure struct = (Structure)obj;
        if (struct.getDefn() != this.getDefn()) {
            return false;
        }
        Iterator iter = this.getDefn().getPropertyIterator();
        while (iter.hasNext()) {
            PropertyDefn defn = (PropertyDefn)iter.next();
            Object value = this.getLocalProperty(null, defn);
            if (!(value == null ? struct.getLocalProperty(null, defn) != null : !value.equals(struct.getLocalProperty(null, defn)))) continue;
            return false;
        }
        return true;
    }

    public final IStructure copy() {
        try {
            Structure retValue = (Structure)this.clone();
            retValue.context = null;
            return retValue;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public IStructureDefn getDefn() {
        return MetaDataDictionary.getInstance().getStructure(this.getStructName());
    }

    public IObjectDefn getObjectDefn() {
        return MetaDataDictionary.getInstance().getStructure(this.getStructName());
    }

    public final Object getProperty(Module module, String memberName) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(memberName);
        if (prop == null) {
            return null;
        }
        return this.getProperty(module, prop);
    }

    public Object getProperty(Module module, PropertyDefn propDefn) {
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        Object value = this.getLocalProperty(module, propDefn);
        if (value == null) {
            return propDefn.getDefault();
        }
        if (value instanceof ElementRefValue) {
            ElementRefValue refValue = (ElementRefValue)value;
            return ReferenceValueUtil.needTheNamespacePrefix(refValue, module);
        }
        return value;
    }

    public Object getLocalProperty(Module module, PropertyDefn propDefn) {
        Object value = null;
        if (propDefn.isIntrinsic()) {
            value = this.getIntrinsicProperty(propDefn.getName());
        }
        if (propDefn.getTypeCode() == 15) {
            return ReferenceValueUtil.resolveElementReference(this, module, (StructPropertyDefn)propDefn, value);
        }
        return value;
    }

    public Object getLocalProperty(Module module, String memberName) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(memberName);
        if (prop == null) {
            return null;
        }
        return this.getLocalProperty(module, prop);
    }

    public final void setProperty(String propName, Object value) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(propName);
        if (prop == null) {
            return;
        }
        this.setProperty(prop, value);
    }

    public void setProperty(PropertyDefn prop, Object value) {
        this.updateReference(prop, value);
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(prop.getName(), value);
        }
    }

    protected void updateReference(PropertyDefn prop, Object value) {
        if (value instanceof ElementRefValue && prop.getTypeCode() == 15) {
            ElementRefValue oldRef = (ElementRefValue)this.getLocalProperty(null, prop.getName());
            this.doUpdateReference(oldRef, (ElementRefValue)value, prop);
        }
    }

    private void doUpdateReference(ElementRefValue oldRef, ElementRefValue newRef, PropertyDefn prop) {
        IReferencableElement target;
        DesignElement me = this.getContextElement();
        String propName = this.getContextPropertyName();
        CachedMemberRef memberRef = this.getContextCachedMemberRef();
        if (oldRef != null && (target = oldRef.getTargetElement()) != null && me != null) {
            if (memberRef != null) {
                target.dropClient(me, memberRef);
            } else if (propName != null) {
                target.dropClient(me, propName);
            }
        }
        if (newRef != null && (target = newRef.getTargetElement()) != null && me != null) {
            if (memberRef != null) {
                target.addClient(me, memberRef);
            } else if (propName != null) {
                target.addClient(me, propName);
            }
        }
    }

    protected abstract Object getIntrinsicProperty(String var1);

    protected abstract void setIntrinsicProperty(String var1, Object var2);

    public List validate(Module module, DesignElement element) {
        return new ArrayList();
    }

    public StructureHandle getHandle(SimpleValueHandle valueHandle, int index) {
        if (valueHandle == null || valueHandle.getListValue() == null) {
            return null;
        }
        if (index < 0 || index >= valueHandle.getListValue().size()) {
            return null;
        }
        return this.handle(valueHandle, index);
    }

    protected abstract StructureHandle handle(SimpleValueHandle var1, int var2);

    public StructureHandle getHandle(SimpleValueHandle valueHandle) {
        if (valueHandle == null || valueHandle.getListValue() == null) {
            return null;
        }
        int posn = valueHandle.getListValue().indexOf(this);
        if (posn == -1) {
            return null;
        }
        return this.handle(valueHandle, posn);
    }

    public boolean isReferencable() {
        return false;
    }

    public String getReferencableProperty() {
        return null;
    }

    public DesignElement getContextElement() {
        if (this.context != null) {
            return this.context.element;
        }
        return null;
    }

    public String getContextPropertyName() {
        if (this.context != null) {
            return this.context.elementPropName;
        }
        return null;
    }

    public CachedMemberRef getContextCachedMemberRef() {
        if (this.context != null) {
            return this.context.cachedMemberRef;
        }
        return null;
    }

    public void setContext(StructureContext context) {
        this.context = context;
    }

    public boolean isDesignTime() {
        return true;
    }

    public static class StructureContext {
        private DesignElement element;
        private String elementPropName;
        private CachedMemberRef cachedMemberRef;

        public StructureContext(DesignElement element, String elementPropName) {
            this.element = element;
            this.elementPropName = elementPropName;
        }

        public StructureContext(DesignElement element, CachedMemberRef cachedMemberRef) {
            this.element = element;
            this.cachedMemberRef = cachedMemberRef;
        }
    }
}

