/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.AbstractNameHelper;
import org.eclipse.birt.report.model.core.namespace.INameContext;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameContextFactory;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;

public class ModuleNameHelper
extends AbstractNameHelper {
    protected Module module = null;
    private List[] cachedContentNames = new ArrayList[9];
    private Map cachedLevelNames = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.namespace.ModuleNameHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ModuleNameHelper(Module module) {
        this.module = module;
        this.initialize();
    }

    protected void initialize() {
        int count = this.getNameSpaceCount();
        this.nameContexts = new INameContext[count];
        int i = 0;
        while (i < count) {
            this.nameContexts[i] = NameContextFactory.createModuleNameContext(this.module, i);
            this.cachedContentNames[i] = new ArrayList();
            ++i;
        }
    }

    public int getNameSpaceCount() {
        return 9;
    }

    public String getUniqueName(DesignElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof GroupElement) {
            String groupName = this.getUniqueGroupName((GroupElement)element);
            return groupName;
        }
        ElementDefn eDefn = (ElementDefn)element.getDefn();
        if (!this.module.getDefn().isKindOf(eDefn.getNameConfig().getNameContainer())) {
            INameHelper nameHelper = new NameExecutor(element).getNameHelper(this.module);
            return nameHelper == null ? null : nameHelper.getUniqueName(element);
        }
        String name = StringUtil.trimString(element.getName());
        name = NamePropertyType.validateName(name);
        if (eDefn.getNameOption() == 0) {
            return null;
        }
        if (eDefn.getNameOption() == 1 && name == null && this.module instanceof ReportDesign) {
            return null;
        }
        if (this.module instanceof Library && element instanceof StyleElement && element.getContainer() == null && name != null) {
            return name;
        }
        int nameSpaceID = eDefn.getNameSpaceID();
        NameSpace nameSpace = this.getCachedNameSpace(nameSpaceID);
        List cachedContentNames = this.getCachedContentNames(nameSpaceID);
        NameSpace moduleNameSpace = this.nameContexts[nameSpaceID].getNameSpace();
        if (name != null && ModuleNameHelper.isValidInNameSpace(nameSpace, element, name) && ModuleNameHelper.isValidInNameSpace(moduleNameSpace, element, name) && !cachedContentNames.contains(name)) {
            return name;
        }
        if (name == null) {
            if (element instanceof ExtendedItem) {
                ExtensionElementDefn extDefn = ((ExtendedItem)element).getExtDefn();
                PeerExtensionElementDefn peerDefn = (PeerExtensionElementDefn)extDefn;
                IReportItemFactory peerFactory = peerDefn.getReportItemFactory();
                if (!$assertionsDisabled && peerFactory == null) {
                    throw new AssertionError();
                }
                String extensionDefaultName = null;
                IMessages msgs = peerFactory.getMessages();
                if (msgs != null) {
                    extensionDefaultName = msgs.getMessage((String)extDefn.getDisplayNameKey(), ThreadResources.getLocale());
                }
                if (StringUtil.isBlank(extensionDefaultName)) {
                    extensionDefaultName = peerDefn.getName();
                }
                name = ModelMessages.getMessage("Message.NamePrefixNew");
                name = String.valueOf(name) + extensionDefaultName;
            } else {
                name = ModelMessages.getMessage("New." + element.getDefn().getName());
                name = name.trim();
            }
        }
        int index = 0;
        String baseName = name;
        while (nameSpace.contains(name) || moduleNameSpace.contains(name) || cachedContentNames.contains(name)) {
            name = String.valueOf(baseName) + ++index;
        }
        return name;
    }

    private static boolean isValidInNameSpace(NameSpace namespace, DesignElement element, String name) {
        DesignElement tmpElement = namespace.getElement(name);
        return tmpElement == null || tmpElement == element;
    }

    public void makeUniqueName(DesignElement element) {
        if (element instanceof GroupElement) {
            String name = this.getUniqueName(element);
            if (name != null) {
                this.setUniqueGroupName((GroupElement)element, name);
            }
            return;
        }
        super.makeUniqueName(element);
    }

    List getCachedContentNames(int id) {
        if (!($assertionsDisabled || id >= 0 && id < 9)) {
            throw new AssertionError();
        }
        return this.cachedContentNames[id];
    }

    public void dropElement(DesignElement element) {
        if (element == null) {
            return;
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        int id = defn.getNameSpaceID();
        NameSpace ns = this.getCachedNameSpace(id);
        if (ns.getElement(element.getName()) == element) {
            ns.remove(element);
        }
    }

    private String getUniqueGroupName(GroupElement group) {
        if (group == null || group.getContainer() == null) {
            return null;
        }
        ListingHandle listing = (ListingHandle)group.getContainer().getHandle(this.module);
        String groupName = (String)group.getLocalProperty(this.module, "groupName");
        if (StringUtil.isBlank(groupName = NamePropertyType.validateName(groupName))) {
            GroupElement virtualGroup = (GroupElement)group.getVirtualParent();
            while (virtualGroup != null) {
                groupName = (String)virtualGroup.getLocalProperty(virtualGroup.getRoot(), "groupName");
                if (!StringUtil.isBlank(groupName)) break;
                virtualGroup = (GroupElement)virtualGroup.getVirtualParent();
            }
        }
        String namePrefix = groupName;
        int level = group.getGroupLevel();
        if (StringUtil.isBlank(namePrefix)) {
            namePrefix = ModelMessages.getMessage("New." + group.getDefn().getName());
            namePrefix = namePrefix.trim();
            groupName = String.valueOf(namePrefix) + level;
        }
        while (GroupNameValidator.getInstance().validateForRenamingGroup(listing, (GroupHandle)group.getHandle(this.module), groupName).size() != 0) {
            groupName = String.valueOf(namePrefix) + level;
            ++level;
        }
        return groupName;
    }

    private void setUniqueGroupName(GroupElement group, String groupName) {
        if (!$assertionsDisabled && groupName == null) {
            throw new AssertionError();
        }
        String localGroupName = (String)group.getLocalProperty(this.module, "groupName");
        if (groupName.equals(localGroupName)) {
            return;
        }
        group.setProperty("groupName", (Object)groupName);
    }

    public void addContentName(int id, String name) {
        if (id >= 0 && id < 9 && !this.cachedContentNames[id].contains(name)) {
            this.cachedContentNames[id].add(name);
        }
    }

    public DesignElement getElement() {
        return this.module;
    }

    public boolean addCachedLevel(DesignElement level) {
        if (!(level instanceof Level)) {
            return true;
        }
        String name = level.getName();
        if (name == null) {
            return true;
        }
        if (this.cachedLevelNames.get(name) != null && this.cachedLevelNames.get(name) != level) {
            return false;
        }
        this.cachedLevelNames.put(level.getName(), level);
        return true;
    }

    public Level findCachedLevel(String elementName) {
        if (elementName == null) {
            return null;
        }
        String namespace = StringUtil.extractNamespace(elementName);
        String name = StringUtil.extractName(elementName);
        if (namespace == null) {
            return (Level)this.cachedLevelNames.get(name);
        }
        Library lib = this.module.getLibraryWithNamespace(namespace);
        return lib == null ? null : ((ModuleNameHelper)lib.getNameHelper()).findCachedLevel(name);
    }

    public void clearCachedLevels() {
        this.cachedLevelNames = null;
        List libs = this.module.getAllLibraries();
        if (libs == null) {
            return;
        }
        int i = 0;
        while (i < libs.size()) {
            Library lib = (Library)libs.get(i);
            ((ModuleNameHelper)lib.getNameHelper()).cachedLevelNames = null;
            ++i;
        }
    }
}

