/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabCellConstants;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class CrosstabCellHandle
extends AbstractCrosstabItemHandle
implements ICrosstabCellConstants,
ICrosstabConstants {
    protected CrosstabCellHandle(DesignElementHandle handle) {
        super(handle);
    }

    PropertyHandle getContentProperty() {
        return this.handle.getPropertyHandle("content");
    }

    public List getContents() {
        return Collections.unmodifiableList(this.getContentProperty().getContents());
    }

    public void addContent(DesignElementHandle content) throws SemanticException {
        PropertyHandle ph = this.getContentProperty();
        if (ph != null) {
            ph.add(content);
        }
    }

    public void addContent(DesignElementHandle content, int newPos) throws SemanticException {
        PropertyHandle ph = this.getContentProperty();
        if (ph != null) {
            ph.add(content, newPos);
        }
    }

    public DimensionHandle getWidth() {
        return this.handle.getDimensionProperty("width");
    }

    public DimensionHandle getHeight() {
        return this.handle.getDimensionProperty("height");
    }

    public List getPredefinedStyles() {
        AbstractCrosstabItemHandle container = this.getContainer();
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> styles = new ArrayList<String>();
        if (container instanceof MeasureViewHandle) {
            String propName = this.handle.getContainerPropertyHandle().getDefn().getName();
            if ("detail".equals(propName) || "aggregations".equals(propName)) {
                styles.add("crosstab-detail");
            } else {
                styles.add("crosstab-header");
            }
        } else {
            styles.add("crosstab-header");
        }
        return styles;
    }
}

