/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.AbstractCrosstabModelTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class DimensionViewTask
extends AbstractCrosstabModelTask {
    protected DimensionViewHandle dimensionView = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.de.internal.DimensionViewTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DimensionViewTask(DimensionViewHandle focus) {
        super(focus);
        this.dimensionView = focus;
    }

    public LevelViewHandle insertLevel(LevelHandle levelHandle, int index) throws SemanticException {
        if (levelHandle != null) {
            if (!levelHandle.getContainer().getContainer().getQualifiedName().equals(this.dimensionView.getCubeDimensionName())) {
                this.dimensionView.getLogger().log(Level.WARNING, "");
                return null;
            }
            if (this.dimensionView.getLevel(levelHandle.getQualifiedName()) != null) {
                this.dimensionView.getLogger().log(Level.SEVERE, "Error.CrosstabException.DUPLICATE_LEVEL", levelHandle.getQualifiedName());
                throw new CrosstabException(this.dimensionView.getModelHandle().getElement(), new String[]{levelHandle.getQualifiedName(), this.dimensionView.getModelHandle().getElement().getIdentifier()}, "Error.CrosstabException.DUPLICATE_LEVEL");
            }
        }
        CommandStack stack = this.dimensionView.getCommandStack();
        stack.startTrans(Messages.getString("DimensionViewTask.msg.insert.level"));
        LevelViewHandle levelView = null;
        try {
            ExtendedItemHandle extendedItemHandle = CrosstabExtendedItemFactory.createLevelView(this.dimensionView.getModuleHandle(), levelHandle);
            if (extendedItemHandle != null) {
                this.dimensionView.getLevelsProperty().add((DesignElementHandle)extendedItemHandle, index);
                levelView = (LevelViewHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedItemHandle, "LevelView");
                if (levelHandle != null && this.crosstab != null) {
                    this.doPostInsert(levelView);
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return levelView;
    }

    private void doPostInsert(LevelViewHandle levelView) throws SemanticException {
        int axisType = this.dimensionView.getAxisType();
        if (levelView.isInnerMost()) {
            if (CrosstabModelUtil.getAllLevelCount(this.crosstab, axisType) <= 1) {
                this.addAggregationForLevel(levelView, axisType);
                if (this.crosstab.getGrandTotal(axisType) == null) {
                    this.removeMeasureAggregations(axisType);
                }
            } else {
                this.addAggregationForLevel(levelView, axisType);
                LevelViewHandle precedingLevel = CrosstabModelUtil.getPrecedingLevel(levelView);
                int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
                if (!$assertionsDisabled && precedingLevel == null) {
                    throw new AssertionError();
                }
                LevelViewHandle innerMostLevelView = CrosstabModelUtil.getInnerMostLevel(this.crosstab, counterAxisType);
                if (precedingLevel.getAggregationHeader() != null) {
                    if (innerMostLevelView != null) {
                        String dimensionName = ((DimensionViewHandle)innerMostLevelView.getContainer()).getCubeDimensionName();
                        String levelName = innerMostLevelView.getCubeLevelName();
                        List measureList = precedingLevel.getAggregationMeasures();
                        ArrayList<String> functionList = new ArrayList<String>();
                        int i = 0;
                        while (i < measureList.size()) {
                            MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                            String function = precedingLevel.getAggregationFunction(measureView);
                            functionList.add(function);
                            ++i;
                        }
                        CrosstabModelUtil.addMeasureAggregations(this.crosstab, dimensionName, levelName, counterAxisType, ((DimensionViewHandle)precedingLevel.getContainer()).getCubeDimensionName(), precedingLevel.getCubeLevelName(), measureList, functionList);
                    }
                } else {
                    this.removeMeasureAggregations(precedingLevel);
                }
            }
        } else if (levelView.getAggregationHeader() != null) {
            this.addAggregationForLevel(levelView, axisType);
        }
    }

    private void addAggregationForLevel(LevelViewHandle levelView, int axisType) throws SemanticException {
        if (!$assertionsDisabled && !CrosstabModelUtil.isValidAxisType(axisType)) {
            throw new AssertionError();
        }
        if (levelView != null && levelView.getAxisType() != axisType) {
            return;
        }
        int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
        int dimension = 0;
        while (dimension < this.crosstab.getDimensionCount(counterAxisType)) {
            DimensionViewHandle tempDimensionView = this.crosstab.getDimension(counterAxisType, dimension);
            int level = 0;
            while (level < tempDimensionView.getLevelCount()) {
                boolean isInnerMost;
                LevelViewHandle tempLevelView = tempDimensionView.getLevel(level);
                if (!(levelView != null && (isInnerMost = levelView.isInnerMost()) && tempLevelView.isInnerMost() || tempLevelView.getAggregationHeader() == null)) {
                    List measureList = tempLevelView.getAggregationMeasures();
                    AbstractCrosstabModelTask.AggregationInfo infor = this.getAggregationInfo(levelView, tempLevelView);
                    int i = 0;
                    while (i < measureList.size()) {
                        MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                        String function = tempLevelView.getAggregationFunction(measureView);
                        CrosstabModelUtil.addDataItem(this.crosstab, measureView, function, infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
                        ++i;
                    }
                }
                ++level;
            }
            ++dimension;
        }
        if (this.crosstab.getGrandTotal(counterAxisType) != null || CrosstabModelUtil.getAllLevelCount(this.crosstab, counterAxisType) == 0) {
            List measureList = this.crosstab.getAggregationMeasures(counterAxisType);
            AbstractCrosstabModelTask.AggregationInfo infor = this.getAggregationInfo(levelView, null);
            int i = 0;
            while (i < measureList.size()) {
                MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(i);
                String function = this.crosstab.getAggregationFunction(counterAxisType, measureView);
                CrosstabModelUtil.addDataItem(this.crosstab, measureView, function, infor.getRowDimension(), infor.getRowLevel(), infor.getColDimension(), infor.getColLevel());
                ++i;
            }
        }
    }

    public void removeLevel(String name) throws SemanticException {
        LevelViewHandle levelView = this.dimensionView.getLevel(name);
        if (levelView != null) {
            this.removeLevel(levelView, true);
        }
    }

    void removeLevel(LevelViewHandle levelView, boolean needTransaction) throws SemanticException {
        if (!$assertionsDisabled && levelView == null) {
            throw new AssertionError();
        }
        CommandStack stack = null;
        if (needTransaction) {
            stack = this.dimensionView.getCommandStack();
            stack.startTrans(Messages.getString("DimensionViewTask.msg.remove.level"));
        }
        try {
            if (this.crosstab != null) {
                this.doPreRemove(levelView);
            }
            levelView.getModelHandle().drop();
        }
        catch (SemanticException e) {
            if (needTransaction) {
                stack.rollback();
            }
            throw e;
        }
        if (needTransaction) {
            stack.commit();
        }
    }

    public void removeLevel(int index) throws SemanticException {
        LevelViewHandle levelView = this.dimensionView.getLevel(index);
        if (levelView != null) {
            this.removeLevel(levelView, true);
        }
    }

    private void doPreRemove(LevelViewHandle levelView) throws SemanticException {
        if (this.crosstab == null) {
            return;
        }
        int axisType = this.dimensionView.getAxisType();
        if (levelView.isInnerMost()) {
            if (CrosstabModelUtil.getAllLevelCount(this.crosstab, axisType) <= 1) {
                if (this.crosstab.getGrandTotal(axisType) == null) {
                    this.addAggregationForLevel(null, axisType);
                }
                this.removeMeasureAggregations(levelView);
            } else {
                LevelViewHandle precedingLevel = CrosstabModelUtil.getPrecedingLevel(levelView);
                if (!$assertionsDisabled && precedingLevel == null) {
                    throw new AssertionError();
                }
                if (precedingLevel.getAggregationHeader() != null) {
                    int counterAxisType = CrosstabModelUtil.getOppositeAxisType(axisType);
                    LevelViewHandle innerMostLevelView = CrosstabModelUtil.getInnerMostLevel(this.crosstab, counterAxisType);
                    if (innerMostLevelView != null) {
                        this.removeMeasureAggregation(precedingLevel, innerMostLevelView);
                        precedingLevel.getAggregationHeaderProperty().drop(0);
                    } else {
                        precedingLevel.removeSubTotal();
                    }
                } else {
                    this.addAggregationForLevel(precedingLevel, axisType);
                }
                this.removeMeasureAggregations(levelView);
            }
        } else if (levelView.getAggregationHeader() != null) {
            this.removeMeasureAggregations(levelView);
        }
    }
}

