/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCellExecutor;

public class CrosstabMeasureHeaderRowExecutor
extends BaseCrosstabExecutor {
    private static Logger logger;
    private int rowSpan;
    private int colSpan;
    private int currentChangeType;
    private int currentColIndex;
    private int lastMeasureIndex;
    private boolean hasColumnGroups;
    private boolean blankStarted;
    private boolean hasLast;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabMeasureHeaderRowExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public CrosstabMeasureHeaderRowExecutor(BaseCrosstabExecutor parent) {
        super(parent);
    }

    public IContent execute() {
        IRowContent content = this.context.getReportContent().createRowContent();
        this.initializeContent((IContent)content, null);
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.currentChangeType = -1;
        this.currentColIndex = -1;
        this.blankStarted = false;
        this.hasColumnGroups = this.columnGroups != null && this.columnGroups.size() > 0;
        this.rowSpan = 1;
        this.colSpan = 0;
        this.lastMeasureIndex = -1;
        this.hasLast = false;
        this.walker.reload();
    }

    public IReportItemExecutor getNextChild() {
        CrosstabCellExecutor nextExecutor = null;
        try {
            while (this.walker.hasNext()) {
                ColumnEvent ev = this.walker.next();
                switch (this.currentChangeType) {
                    case 1: 
                    case 5: {
                        if (!this.blankStarted || ev.type == 1 || ev.type == 5) break;
                        nextExecutor = new CrosstabCellExecutor(this, null, this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        this.blankStarted = false;
                        this.hasLast = false;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.lastMeasureIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        this.hasLast = false;
                    }
                }
                if (ev.type == 6 || ev.type == 3 || ev.type == 2 || ev.type == 4) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.hasLast = true;
                } else if (!(this.blankStarted || this.hasColumnGroups || ev.type != 1 && ev.type != 5)) {
                    this.blankStarted = true;
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                }
                this.currentChangeType = ev.type;
                ++this.colSpan;
                ++this.currentColIndex;
                if (nextExecutor == null) continue;
                return nextExecutor;
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabMeasureHeaderRowExecutor.error.generate.child.executor"), e);
        }
        if (this.hasLast) {
            this.hasLast = false;
            switch (this.currentChangeType) {
                case 1: 
                case 5: {
                    if (!this.blankStarted) break;
                    nextExecutor = new CrosstabCellExecutor(this, null, this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.lastMeasureIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                }
            }
        }
        return nextExecutor;
    }

    public boolean hasNextChild() {
        try {
            return this.walker.hasNext() || this.hasLast;
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabMeasureHeaderRowExecutor.error.check.child.executor"), e);
            return false;
        }
    }
}

