/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCellExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;

public class CrosstabRowExecutor
extends BaseCrosstabExecutor {
    private static Logger logger;
    private int rowIndex;
    private int dimensionIndex;
    private int levelIndex;
    private int rowSpan;
    private int colSpan;
    private int currentChangeType;
    private int currentColIndex;
    private int lastMeasureIndex;
    private int lastDimensionIndex;
    private int lastLevelIndex;
    private int totalMeasureCount;
    private boolean rowEdgeStarted;
    private boolean hasLast;
    private long currentEdgePosition;
    private boolean isLayoutDownThenOver;
    private boolean isFirst;
    private IReportItemExecutor nextExecutor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabRowExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public CrosstabRowExecutor(BaseCrosstabExecutor parent, int rowIndex, int dimensionIndex, int levelIndex) {
        super(parent);
        this.rowIndex = rowIndex;
        this.dimensionIndex = dimensionIndex;
        this.levelIndex = levelIndex;
    }

    public void close() {
        super.close();
        this.nextExecutor = null;
    }

    public IContent execute() {
        IRowContent content = this.context.getReportContent().createRowContent();
        this.initializeContent((IContent)content, null);
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.currentChangeType = -1;
        this.currentColIndex = -1;
        this.isFirst = true;
        this.rowSpan = 1;
        this.colSpan = 0;
        this.lastMeasureIndex = -1;
        this.totalMeasureCount = this.crosstabItem.getMeasureCount();
        this.isLayoutDownThenOver = "down then over".equals(this.crosstabItem.getPageLayout());
        this.hasLast = false;
        this.walker.reload();
    }

    private AggregationCellHandle getRowSubTotalCell(int colDimensionIndex, int colLevelIndex, int measureIndex) {
        if (measureIndex >= 0 && measureIndex < this.totalMeasureCount) {
            DimensionViewHandle rdv = this.crosstabItem.getDimension(0, this.dimensionIndex);
            LevelViewHandle rlv = rdv.getLevel(this.levelIndex);
            if (colDimensionIndex < 0 || colLevelIndex < 0) {
                return this.crosstabItem.getMeasure(measureIndex).getAggregationCell(rdv.getCubeDimensionName(), rlv.getCubeLevelName(), null, null);
            }
            DimensionViewHandle cdv = this.crosstabItem.getDimension(1, colDimensionIndex);
            LevelViewHandle clv = cdv.getLevel(colLevelIndex);
            return this.crosstabItem.getMeasure(measureIndex).getAggregationCell(rdv.getCubeDimensionName(), rlv.getCubeLevelName(), cdv.getCubeDimensionName(), clv.getCubeLevelName());
        }
        return null;
    }

    private boolean isForceEmpty() {
        try {
            EdgeCursor rowEdgeCursor = this.getRowEdgeCursor();
            if (rowEdgeCursor != null) {
                int groupIndex = GroupUtil.getGroupIndex(this.rowGroups, this.lastDimensionIndex, this.lastLevelIndex);
                DimensionCursor dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(groupIndex);
                return GroupUtil.isDummyGroup(dc);
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabRowExecutor.error.check.force.empty"), e);
        }
        return false;
    }

    private boolean isRowEdgeNeedStart(ColumnEvent ev) throws OLAPException {
        if (this.rowEdgeStarted || ev.type != 1) {
            return false;
        }
        EdgeCursor rowEdgeCursor = this.getRowEdgeCursor();
        if (rowEdgeCursor == null) {
            return false;
        }
        boolean groupFound = false;
        int i = 0;
        while (i < this.rowGroups.size() - 1) {
            DimensionViewHandle dv;
            LevelViewHandle lv;
            EdgeGroup gp = (EdgeGroup)this.rowGroups.get(i);
            if (!groupFound && gp.dimensionIndex == ev.dimensionIndex && gp.levelIndex == ev.levelIndex) {
                groupFound = true;
            }
            if (!(this.isLayoutDownThenOver && groupFound && gp.dimensionIndex == ev.dimensionIndex && gp.levelIndex == ev.levelIndex || !groupFound || GroupUtil.isLeafGroup(rowEdgeCursor.getDimensionCursor(), i) || (lv = (dv = this.crosstabItem.getDimension(0, gp.dimensionIndex)).getLevel(gp.levelIndex)).getAggregationHeader() == null || !"before".equals(lv.getAggregationHeaderLocation()))) {
                return false;
            }
            ++i;
        }
        int gdx = GroupUtil.getGroupIndex(this.rowGroups, ev.dimensionIndex, ev.levelIndex);
        if (gdx != -1) {
            try {
                DimensionCursor dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(gdx);
                if (!GroupUtil.isDummyGroup(dc) && rowEdgeCursor.getPosition() != dc.getEdgeStart()) {
                    return false;
                }
            }
            catch (OLAPException e) {
                logger.log(Level.SEVERE, Messages.getString("CrosstabRowExecutor.error.check.edge.start"), e);
            }
        }
        return this.rowIndex == 0;
    }

    private void advance() {
        int mx;
        try {
            while (this.walker.hasNext()) {
                ColumnEvent ev = this.walker.next();
                switch (this.currentChangeType) {
                    case 1: {
                        if (!this.rowEdgeStarted) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.lastDimensionIndex).getLevel(this.lastLevelIndex).getCell(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setForceEmpty(this.isForceEmpty());
                        this.rowEdgeStarted = false;
                        this.hasLast = false;
                        break;
                    }
                    case 5: {
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.rowIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        this.hasLast = false;
                        break;
                    }
                    case 2: 
                    case 6: {
                        mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.totalMeasureCount > 0 ? this.crosstabItem.getMeasure(mx).getCell() : null, this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                        break;
                    }
                    case 3: 
                    case 4: {
                        mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                    }
                }
                if (this.isRowEdgeNeedStart(ev)) {
                    this.rowEdgeStarted = true;
                    this.rowSpan = GroupUtil.computeRowSpan(this.crosstabItem, this.rowGroups, ev.dimensionIndex, ev.levelIndex, this.getRowEdgeCursor(), this.isLayoutDownThenOver);
                    this.colSpan = 0;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (ev.type == 6 || ev.type == 3 || ev.type == 2 || ev.type == 4) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (ev.type == 5) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                }
                this.currentChangeType = ev.type;
                this.currentEdgePosition = ev.dataPosition;
                ++this.colSpan;
                ++this.currentColIndex;
                if (this.nextExecutor == null) continue;
                return;
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabRowExecutor.error.retrieve.child.executor"), e);
        }
        if (this.hasLast) {
            this.hasLast = false;
            switch (this.currentChangeType) {
                case 1: {
                    if (!this.rowEdgeStarted) break;
                    this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.lastDimensionIndex).getLevel(this.lastLevelIndex).getCell(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setForceEmpty(this.isForceEmpty());
                    this.rowEdgeStarted = false;
                    break;
                }
                case 5: {
                    this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.rowIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    break;
                }
                case 2: 
                case 6: {
                    mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                    this.nextExecutor = new CrosstabCellExecutor(this, this.totalMeasureCount > 0 ? this.crosstabItem.getMeasure(mx).getCell() : null, this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
                case 3: 
                case 4: {
                    mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                    this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                }
            }
        }
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor childExecutor = this.nextExecutor;
        this.nextExecutor = null;
        this.advance();
        return childExecutor;
    }

    public boolean hasNextChild() {
        if (this.isFirst) {
            this.isFirst = false;
            this.advance();
        }
        return this.nextExecutor != null;
    }
}

