/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript.device;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.report.engine.emitter.postscript.PostscriptWriter;
import org.eclipse.birt.report.engine.layout.TextStyle;
import org.eclipse.birt.report.engine.layout.emitter.IPage;

public class PostscriptPage
implements IPage {
    private PostscriptWriter writer;
    private boolean isDisposed;

    public PostscriptPage(PostscriptWriter writer) {
        this.writer = writer;
        this.isDisposed = false;
    }

    void setPageSize(int pageWidth, int pageHeight) {
        this.writer.startPage(this.convertToPoint(pageWidth), this.convertToPoint(pageHeight));
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.writer.endPage();
            this.isDisposed = true;
        }
    }

    public void drawText(String text, int textX, int textY, int width, int height, TextStyle fontStyle) {
        this.writer.drawString(text, this.convertToPoint(textX), this.convertToPoint(textY), fontStyle.getFontInfo(), this.convertToPoint(fontStyle.getLetterSpacing()), this.convertToPoint(fontStyle.getWordSpacing()), fontStyle.getColor(), fontStyle.isLinethrough(), fontStyle.isOverline(), fontStyle.isUnderline(), fontStyle.getAlign());
    }

    public void drawImage(InputStream input, int imageX, int imageY, int height, int width, String helpText) throws Exception {
        this.writer.drawImage(input, this.convertToPoint(imageX), this.convertToPoint(imageY), this.convertToPoint(width), this.convertToPoint(height));
    }

    public void drawImage(byte[] imageData, int imageX, int imageY, int height, int width, String helpText) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(imageData);
        this.drawImage(input, imageX, imageY, height, width, helpText);
    }

    public void drawImage(String uri, int imageX, int imageY, int height, int width, String helpText) throws Exception {
        if (uri == null) {
            return;
        }
        this.drawImage(new URL(uri).openStream(), imageX, imageY, height, width, helpText);
    }

    public void drawLine(int startX, int startY, int endX, int endY, int width, Color color, String lineStyle) {
        this.writer.drawLine(this.convertToPoint(startX), this.convertToPoint(startY), this.convertToPoint(endX), this.convertToPoint(endY), this.convertToPoint(width), color, lineStyle);
    }

    public void drawBackgroundColor(Color color, int x, int y, int width, int height) {
        if (color != null) {
            this.writer.fillRect(this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height), color);
        }
    }

    public void drawPageBackgroundColor(Color color) {
        this.writer.fillPage(color);
    }

    public void drawBackgroundImage(int x, int y, int width, int height, String repeat, String imageUrl, int absPosX, int absPosY) throws IOException {
        this.writer.drawBackgroundImage(imageUrl, this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height), this.convertToPoint(absPosX), this.convertToPoint(absPosY), repeat);
    }

    public void clip(int startX, int startY, int width, int height) {
        this.writer.clipRect(this.convertToPoint(startX), this.convertToPoint(startY), this.convertToPoint(width), this.convertToPoint(height));
    }

    public void clipSave() {
        this.writer.clipSave();
    }

    public void clipRestore() {
        this.writer.clipRestore();
    }

    private float convertToPoint(int value) {
        return (float)value / 1000.0f;
    }
}

