/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript.truetypefont;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.engine.emitter.postscript.truetypefont.ITrueTypeWriter;
import org.eclipse.birt.report.engine.emitter.postscript.truetypefont.Util;

public class TrueTypeFont {
    private static final int MAX_STRING_LENGTH = 16382;
    private static final int HEAD_LOCA_FORMAT_OFFSET = 51;
    private static final String WINANSI = "Cp1252";
    private boolean embedded;
    private boolean fontSpecific = true;
    private boolean justNames = false;
    private HashMap positionTables;
    private RandomAccessFileOrArray rf;
    private String fileName;
    private int directoryOffset;
    private String ttcIndex;
    private String style = "";
    private FontHeader head = new FontHeader();
    private HorizontalHeader hhea = new HorizontalHeader();
    private WindowsMetrics os_2 = new WindowsMetrics();
    private int[] GlyphWidths;
    private int[][] bboxes;
    private HashMap cmap10;
    private HashMap cmap31;
    private IntHashtable kerning = new IntHashtable();
    private String fontName;
    private String[][] fullName;
    private String[][] familyName;
    private double italicAngle;
    private double underlineThickness;
    private double underlinePosition;
    private boolean isFixedPitch = false;
    static final int ARG_1_AND_2_ARE_WORDS = 1;
    static final int WE_HAVE_A_SCALE = 8;
    static final int MORE_COMPONENTS = 32;
    static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    static final int WE_HAVE_A_TWO_BY_TWO = 128;
    private byte[] directoryRawData = new byte[12];
    private HashMap metadataTables;
    private String[][] notice;
    private String[][] version;
    private static Map fonts;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.postscript.truetypefont.TrueTypeFont");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        fonts = new HashMap();
    }

    protected TrueTypeFont() {
    }

    TrueTypeFont(String ttFile) throws DocumentException, IOException {
        this(ttFile, false);
    }

    TrueTypeFont(String ttFile, boolean justNames) throws DocumentException, IOException {
        this.justNames = justNames;
        String nameBase = TrueTypeFont.getBaseName(ttFile);
        String ttcName = TrueTypeFont.getTTCName(nameBase);
        if (nameBase.length() < ttFile.length()) {
            this.style = ttFile.substring(nameBase.length());
        }
        this.embedded = false;
        this.fileName = ttcName;
        this.ttcIndex = "";
        if (ttcName.length() < nameBase.length()) {
            this.ttcIndex = nameBase.substring(ttcName.length() + 1);
        }
        if (!(this.fileName.toLowerCase().endsWith(".ttf") || this.fileName.toLowerCase().endsWith(".otf") || this.fileName.toLowerCase().endsWith(".ttc"))) {
            throw new DocumentException(String.valueOf(this.fileName) + this.style + " is not a TTF, OTF or TTC font file.");
        }
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrueTypeFont getInstance(String fileName) throws DocumentException, IOException {
        File file = new File(fileName);
        if (fonts.containsKey(file)) {
            return (TrueTypeFont)fonts.get(file);
        }
        Map map = fonts;
        synchronized (map) {
            if (fonts.containsKey(file)) {
                return (TrueTypeFont)fonts.get(file);
            }
            TrueTypeFont font = new TrueTypeFont(fileName);
            fonts.put(new File(fileName), font);
            return font;
        }
    }

    protected static String getBaseName(String name) {
        if (name.endsWith(",Bold")) {
            return name.substring(0, name.length() - 5);
        }
        if (name.endsWith(",Italic")) {
            return name.substring(0, name.length() - 7);
        }
        if (name.endsWith(",BoldItalic")) {
            return name.substring(0, name.length() - 11);
        }
        return name;
    }

    protected static String getTTCName(String name) {
        int idx = name.toLowerCase().indexOf(".ttc,");
        if (idx < 0) {
            return name;
        }
        return name.substring(0, idx + 4);
    }

    void fillTables() throws DocumentException, IOException {
        this.fillHead();
        this.fillHHea();
        this.fillOS();
        this.processPost();
    }

    private void processPost() throws DocumentException, IOException {
        int[] tableLocation = this.getTableLocation("post");
        if (tableLocation == null) {
            this.italicAngle = -Math.atan2(this.hhea.caretSlopeRun, this.hhea.caretSlopeRise) * 180.0 / Math.PI;
            return;
        }
        this.rf.seek(tableLocation[0] + 4);
        short mantissa = this.rf.readShort();
        int fraction = this.rf.readUnsignedShort();
        this.italicAngle = (double)mantissa + (double)fraction / 16384.0;
        this.underlinePosition = (double)this.rf.readShort() / (double)this.head.unitsPerEm;
        this.underlineThickness = (double)this.rf.readShort() / (double)this.head.unitsPerEm;
        this.isFixedPitch = this.rf.readInt() != 0;
    }

    private void fillOS() throws DocumentException, IOException {
        int[] tableLocation = this.getTableLocation("OS/2");
        this.rf.seek(tableLocation[0]);
        int version = this.rf.readUnsignedShort();
        this.os_2.xAvgCharWidth = this.rf.readShort();
        this.os_2.usWeightClass = this.rf.readUnsignedShort();
        this.os_2.usWidthClass = this.rf.readUnsignedShort();
        this.os_2.fsType = this.rf.readShort();
        this.os_2.ySubscriptXSize = this.rf.readShort();
        this.os_2.ySubscriptYSize = this.rf.readShort();
        this.os_2.ySubscriptXOffset = this.rf.readShort();
        this.os_2.ySubscriptYOffset = this.rf.readShort();
        this.os_2.ySuperscriptXSize = this.rf.readShort();
        this.os_2.ySuperscriptYSize = this.rf.readShort();
        this.os_2.ySuperscriptXOffset = this.rf.readShort();
        this.os_2.ySuperscriptYOffset = this.rf.readShort();
        this.os_2.yStrikeoutSize = this.rf.readShort();
        this.os_2.yStrikeoutPosition = this.rf.readShort();
        this.os_2.sFamilyClass = this.rf.readShort();
        this.rf.readFully(this.os_2.panose);
        this.rf.skipBytes(16);
        this.rf.readFully(this.os_2.achVendID);
        this.os_2.fsSelection = this.rf.readUnsignedShort();
        this.os_2.usFirstCharIndex = this.rf.readUnsignedShort();
        this.os_2.usLastCharIndex = this.rf.readUnsignedShort();
        this.os_2.sTypoAscender = this.rf.readShort();
        this.os_2.sTypoDescender = this.rf.readShort();
        if (this.os_2.sTypoDescender > 0) {
            this.os_2.sTypoDescender = -this.os_2.sTypoDescender;
        }
        this.os_2.sTypoLineGap = this.rf.readShort();
        this.os_2.usWinAscent = this.rf.readUnsignedShort();
        this.os_2.usWinDescent = this.rf.readUnsignedShort();
        this.os_2.ulCodePageRange1 = 0;
        this.os_2.ulCodePageRange2 = 0;
        if (version > 0) {
            this.os_2.ulCodePageRange1 = this.rf.readInt();
            this.os_2.ulCodePageRange2 = this.rf.readInt();
        }
        if (version > 1) {
            this.rf.skipBytes(2);
            this.os_2.sCapHeight = this.rf.readShort();
        } else {
            this.os_2.sCapHeight = (int)(0.7 * (double)this.head.unitsPerEm);
        }
    }

    private void fillHHea() throws DocumentException, IOException {
        int[] tableLocation = this.getTableLocation("hhea");
        this.rf.seek(tableLocation[0] + 4);
        this.hhea.Ascender = this.rf.readShort();
        this.hhea.Descender = this.rf.readShort();
        this.hhea.LineGap = this.rf.readShort();
        this.hhea.advanceWidthMax = this.rf.readUnsignedShort();
        this.hhea.minLeftSideBearing = this.rf.readShort();
        this.hhea.minRightSideBearing = this.rf.readShort();
        this.hhea.xMaxExtent = this.rf.readShort();
        this.hhea.caretSlopeRise = this.rf.readShort();
        this.hhea.caretSlopeRun = this.rf.readShort();
        this.rf.skipBytes(12);
        this.hhea.numberOfHMetrics = this.rf.readUnsignedShort();
    }

    private void fillHead() throws DocumentException, IOException {
        int[] tableLocation = this.getTableLocation("head");
        this.rf.seek(tableLocation[0] + 16);
        this.head.flags = this.rf.readUnsignedShort();
        this.head.unitsPerEm = this.rf.readUnsignedShort();
        this.rf.skipBytes(16);
        this.head.xMin = this.rf.readShort();
        this.head.yMin = this.rf.readShort();
        this.head.xMax = this.rf.readShort();
        this.head.yMax = this.rf.readShort();
        this.head.macStyle = this.rf.readUnsignedShort();
        this.rf.skip(4L);
        int indexToLocFormat = this.rf.readUnsignedShort();
        this.head.locaBytesPerEntry = indexToLocFormat == 0 ? 2 : 4;
    }

    private int[] getTableLocation(String name) throws DocumentException {
        int[] table_location = (int[])this.positionTables.get(name);
        if (table_location == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName + this.style);
        }
        return table_location;
    }

    String getBaseFont() throws DocumentException, IOException {
        int[] table_location = (int[])this.positionTables.get("name");
        if (table_location == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(table_location[0] + 2);
        int numRecords = this.rf.readUnsignedShort();
        int startOfStorage = this.rf.readUnsignedShort();
        int k = 0;
        while (k < numRecords) {
            int platformID = this.rf.readUnsignedShort();
            int nameID = this.rf.readUnsignedShort();
            int length = this.rf.readUnsignedShort();
            int offset = this.rf.readUnsignedShort();
            if (nameID == 6) {
                this.rf.seek(table_location[0] + startOfStorage + offset);
                if (platformID != 0 && platformID != 3) {
                    String name = this.readStandardString(length);
                    name = name.replace(' ', '_');
                    return name.replace('\u0000', '_');
                }
            }
            ++k;
        }
        File file = new File(this.fileName);
        return file.getName().replace(' ', '_');
    }

    String[][] getNames(int id) throws DocumentException, IOException {
        int[] table_location = (int[])this.positionTables.get("name");
        if (table_location == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(table_location[0] + 2);
        int numRecords = this.rf.readUnsignedShort();
        int startOfStorage = this.rf.readUnsignedShort();
        ArrayList<String[]> names = new ArrayList<String[]>();
        int k = 0;
        while (k < numRecords) {
            int platformID = this.rf.readUnsignedShort();
            int platformEncodingID = this.rf.readUnsignedShort();
            int languageID = this.rf.readUnsignedShort();
            int nameID = this.rf.readUnsignedShort();
            int length = this.rf.readUnsignedShort();
            int offset = this.rf.readUnsignedShort();
            if (nameID == id) {
                int pos = this.rf.getFilePointer();
                this.rf.seek(table_location[0] + startOfStorage + offset);
                String name = platformID == 0 || platformID == 3 || platformID == 2 && platformEncodingID == 1 ? this.readUnicodeString(length) : this.readStandardString(length);
                names.add(new String[]{String.valueOf(platformID), String.valueOf(platformEncodingID), String.valueOf(languageID), name});
                this.rf.seek(pos);
            }
            ++k;
        }
        String[][] thisName = new String[names.size()][];
        int k2 = 0;
        while (k2 < names.size()) {
            thisName[k2] = (String[])names.get(k2);
            ++k2;
        }
        return thisName;
    }

    /*
     * Exception decompiling
     */
    void process() throws DocumentException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 531->535)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ITrueTypeWriter getTrueTypeWriter(PrintStream out) throws IOException {
        return new TrueTypeWriter(out);
    }

    protected String readStandardString(int length) throws IOException {
        byte[] buf = new byte[length];
        this.rf.readFully(buf);
        try {
            return new String(buf, WINANSI);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    protected String readUnicodeString(int length) throws IOException {
        StringBuffer buf = new StringBuffer();
        length /= 2;
        int k = 0;
        while (k < length) {
            buf.append(this.rf.readChar());
            ++k;
        }
        return buf.toString();
    }

    protected void readGlyphWidths() throws DocumentException, IOException {
        int[] table_location = (int[])this.positionTables.get("hmtx");
        if (table_location == null) {
            throw new DocumentException("Table 'hmtx' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(table_location[0]);
        this.GlyphWidths = new int[this.hhea.numberOfHMetrics];
        int k = 0;
        while (k < this.hhea.numberOfHMetrics) {
            this.GlyphWidths[k] = this.rf.readUnsignedShort() * 1000 / this.head.unitsPerEm;
            this.rf.readUnsignedShort();
            ++k;
        }
    }

    protected int getGlyphWidth(int glyph) {
        if (glyph >= this.GlyphWidths.length) {
            glyph = this.GlyphWidths.length - 1;
        }
        return this.GlyphWidths[glyph];
    }

    private void readBbox() throws DocumentException, IOException {
        int k;
        int[] locaTable;
        int entries;
        int[] tableLocation = (int[])this.positionTables.get("head");
        if (tableLocation == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(tableLocation[0] + 51);
        boolean locaShortTable = this.rf.readUnsignedShort() == 0;
        tableLocation = (int[])this.positionTables.get("loca");
        if (tableLocation == null) {
            return;
        }
        this.rf.seek(tableLocation[0]);
        if (locaShortTable) {
            entries = tableLocation[1] / 2;
            locaTable = new int[entries];
            k = 0;
            while (k < entries) {
                locaTable[k] = this.rf.readUnsignedShort() * 2;
                ++k;
            }
        } else {
            entries = tableLocation[1] / 4;
            locaTable = new int[entries];
            k = 0;
            while (k < entries) {
                locaTable[k] = this.rf.readInt();
                ++k;
            }
        }
        tableLocation = (int[])this.positionTables.get("glyf");
        if (tableLocation == null) {
            throw new DocumentException("Table 'glyf' does not exist in " + this.fileName + this.style);
        }
        int tableGlyphOffset = tableLocation[0];
        this.bboxes = new int[locaTable.length - 1][];
        int glyph = 0;
        while (glyph < locaTable.length - 1) {
            int start = locaTable[glyph];
            if (start != locaTable[glyph + 1]) {
                this.rf.seek(tableGlyphOffset + start + 2);
                this.bboxes[glyph] = new int[]{this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm};
            }
            ++glyph;
        }
    }

    public void readCMaps() throws DocumentException, IOException {
        int format;
        int[] table_location = (int[])this.positionTables.get("cmap");
        if (table_location == null) {
            throw new DocumentException("Table 'cmap' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(table_location[0]);
        this.rf.skipBytes(2);
        int num_tables = this.rf.readUnsignedShort();
        this.fontSpecific = false;
        int map10 = 0;
        int map31 = 0;
        int map30 = 0;
        int k = 0;
        while (k < num_tables) {
            int platId = this.rf.readUnsignedShort();
            int platSpecId = this.rf.readUnsignedShort();
            int offset = this.rf.readInt();
            if (platId == 3 && platSpecId == 0) {
                this.fontSpecific = true;
                map30 = offset;
            } else if (platId == 3 && platSpecId == 1) {
                map31 = offset;
            }
            if (platId == 1 && platSpecId == 0) {
                map10 = offset;
            }
            ++k;
        }
        if (map10 > 0) {
            this.rf.seek(table_location[0] + map10);
            format = this.rf.readUnsignedShort();
            switch (format) {
                case 0: {
                    this.cmap10 = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmap10 = this.readFormat4();
                    break;
                }
                case 6: {
                    this.cmap10 = this.readFormat6();
                }
            }
        }
        if (map31 > 0) {
            this.rf.seek(table_location[0] + map31);
            format = this.rf.readUnsignedShort();
            if (format == 4) {
                this.cmap31 = this.readFormat4();
            }
        }
        if (map30 > 0) {
            this.rf.seek(table_location[0] + map30);
            format = this.rf.readUnsignedShort();
            if (format == 4) {
                this.cmap10 = this.readFormat4();
            }
        }
    }

    HashMap readFormat0() throws IOException {
        HashMap<Integer, int[]> h = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int k = 0;
        while (k < 256) {
            int[] r;
            r = new int[]{this.rf.readUnsignedByte(), this.getGlyphWidth(r[0])};
            h.put(new Integer(k), r);
            ++k;
        }
        return h;
    }

    HashMap readFormat4() throws IOException {
        HashMap<Integer, int[]> h = new HashMap<Integer, int[]>();
        int table_lenght = this.rf.readUnsignedShort();
        this.rf.skipBytes(2);
        int segCount = this.rf.readUnsignedShort() / 2;
        this.rf.skipBytes(6);
        int[] endCount = new int[segCount];
        int k = 0;
        while (k < segCount) {
            endCount[k] = this.rf.readUnsignedShort();
            ++k;
        }
        this.rf.skipBytes(2);
        int[] startCount = new int[segCount];
        int k2 = 0;
        while (k2 < segCount) {
            startCount[k2] = this.rf.readUnsignedShort();
            ++k2;
        }
        int[] idDelta = new int[segCount];
        int k3 = 0;
        while (k3 < segCount) {
            idDelta[k3] = this.rf.readUnsignedShort();
            ++k3;
        }
        int[] idRO = new int[segCount];
        int k4 = 0;
        while (k4 < segCount) {
            idRO[k4] = this.rf.readUnsignedShort();
            ++k4;
        }
        int[] glyphId = new int[table_lenght / 2 - 8 - segCount * 4];
        int k5 = 0;
        while (k5 < glyphId.length) {
            glyphId[k5] = this.rf.readUnsignedShort();
            ++k5;
        }
        k5 = 0;
        while (k5 < segCount) {
            int j = startCount[k5];
            while (j <= endCount[k5] && j != 65535) {
                block12: {
                    int[] r;
                    int glyph;
                    block11: {
                        block10: {
                            if (idRO[k5] != 0) break block10;
                            glyph = j + idDelta[k5] & 0xFFFF;
                            break block11;
                        }
                        int idx = k5 + idRO[k5] / 2 - segCount + j - startCount[k5];
                        if (idx >= glyphId.length) break block12;
                        glyph = glyphId[idx] + idDelta[k5] & 0xFFFF;
                    }
                    r = new int[]{glyph, this.getGlyphWidth(r[0])};
                    h.put(new Integer(this.fontSpecific ? ((j & 0xFF00) == 61440 ? j & 0xFF : j) : j), r);
                }
                ++j;
            }
            ++k5;
        }
        return h;
    }

    HashMap readFormat6() throws IOException {
        HashMap<Integer, int[]> h = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int start_code = this.rf.readUnsignedShort();
        int code_count = this.rf.readUnsignedShort();
        int k = 0;
        while (k < code_count) {
            int[] r;
            r = new int[]{this.rf.readUnsignedShort(), this.getGlyphWidth(r[0])};
            h.put(new Integer(k + start_code), r);
            ++k;
        }
        return h;
    }

    void readKerning() throws IOException {
        int[] table_location = (int[])this.positionTables.get("kern");
        if (table_location == null) {
            return;
        }
        this.rf.seek(table_location[0] + 2);
        int nTables = this.rf.readUnsignedShort();
        int checkpoint = table_location[0] + 4;
        int length = 0;
        int k = 0;
        while (k < nTables) {
            this.rf.seek(checkpoint += length);
            this.rf.skipBytes(2);
            length = this.rf.readUnsignedShort();
            int coverage = this.rf.readUnsignedShort();
            if ((coverage & 0xFFF7) == 1) {
                int nPairs = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                int j = 0;
                while (j < nPairs) {
                    int pair = this.rf.readInt();
                    int value = this.rf.readShort() * 1000 / this.head.unitsPerEm;
                    this.kerning.put(pair, value);
                    ++j;
                }
            }
            ++k;
        }
    }

    public int[] getMetricsTT(int c) {
        if (!this.fontSpecific && this.cmap31 != null) {
            return (int[])this.cmap31.get(new Integer(c));
        }
        if (this.fontSpecific && this.cmap10 != null) {
            return (int[])this.cmap10.get(new Integer(c));
        }
        if (this.cmap31 != null) {
            return (int[])this.cmap31.get(new Integer(c));
        }
        if (this.cmap10 != null) {
            return (int[])this.cmap10.get(new Integer(c));
        }
        return null;
    }

    public String getPostscriptFontName() {
        return this.fontName;
    }

    public String[][] getFullFontName() {
        return this.fullName;
    }

    public String[][] getFamilyFontName() {
        return this.familyName;
    }

    public void setPostscriptFontName(String name) {
        this.fontName = name;
    }

    public HashMap getCMap() {
        if (!this.fontSpecific && this.cmap31 != null) {
            return this.cmap31;
        }
        if (this.fontSpecific && this.cmap10 != null) {
            return this.cmap10;
        }
        if (this.cmap31 != null) {
            return this.cmap31;
        }
        if (this.cmap10 != null) {
            return this.cmap10;
        }
        return null;
    }

    private String getStandardString(byte[] source, int index, int length) {
        if (!$assertionsDisabled && source.length < index + length) {
            throw new AssertionError();
        }
        try {
            return new String(source, index, length, WINANSI);
        }
        catch (UnsupportedEncodingException e) {
            throw new ExceptionConverter((Exception)e);
        }
    }

    private String getName(String[][] names) {
        if (names.length > 0 && names[0].length > 0) {
            return this.toPSString(names[0][names[0].length - 1]);
        }
        return null;
    }

    private String toPSString(String data) {
        return "(" + data + ")";
    }

    protected static class FontHeader {
        int flags;
        int unitsPerEm;
        short xMin;
        short yMin;
        short xMax;
        short yMax;
        int macStyle;
        int locaBytesPerEntry;

        protected FontHeader() {
        }
    }

    protected static class HorizontalHeader {
        short Ascender;
        short Descender;
        short LineGap;
        int advanceWidthMax;
        short minLeftSideBearing;
        short minRightSideBearing;
        short xMaxExtent;
        short caretSlopeRise;
        short caretSlopeRun;
        int numberOfHMetrics;

        protected HorizontalHeader() {
        }
    }

    class TrueTypeWriter
    implements ITrueTypeWriter {
        private PrintStream out;
        private RandomAccessFileOrArray rf;
        private Set glyphDefined = new HashSet();

        public TrueTypeWriter(PrintStream out) throws IOException {
            this.out = out;
        }

        public void initialize() throws IOException {
            this.rf = new RandomAccessFileOrArray(TrueTypeFont.this.fileName);
            this.out.println("mark");
            this.out.println("/FontMatrix matrix");
            this.out.println("/FontBBox [" + Util.div(((TrueTypeFont)TrueTypeFont.this).head.xMin, ((TrueTypeFont)TrueTypeFont.this).head.unitsPerEm) + " " + Util.div(((TrueTypeFont)TrueTypeFont.this).head.yMin, ((TrueTypeFont)TrueTypeFont.this).head.unitsPerEm) + " " + Util.div(((TrueTypeFont)TrueTypeFont.this).head.xMax, ((TrueTypeFont)TrueTypeFont.this).head.unitsPerEm) + " " + Util.div(((TrueTypeFont)TrueTypeFont.this).head.yMax, ((TrueTypeFont)TrueTypeFont.this).head.unitsPerEm) + "]");
            this.out.println("nextxuid");
            String psFontName = TrueTypeFont.this.toPSString(TrueTypeFont.this.fontName);
            this.out.println("/FontName " + psFontName);
            this.out.println("/Encoding 256 array  0 1 255 {1 index exch /.notdef put} for");
            this.out.println("/GlyphDirectory 16 dict");
            this.out.println("/FontInfo mark");
            if (this.hasTable("name")) {
                this.output(this.out, "/Notice", TrueTypeFont.this.getName(TrueTypeFont.this.notice));
                this.output(this.out, "/FamilyName", TrueTypeFont.this.getName(TrueTypeFont.this.familyName));
                this.output(this.out, "/FullName", TrueTypeFont.this.getName(TrueTypeFont.this.fullName));
                this.output(this.out, "/Version", TrueTypeFont.this.getName(TrueTypeFont.this.version));
            }
            if (this.hasTable("post")) {
                this.out.println("/ItalicAngle " + TrueTypeFont.this.italicAngle);
                this.out.println("/isFixedPitch " + TrueTypeFont.this.isFixedPitch);
                this.out.println("/UnderlinePosition " + TrueTypeFont.this.underlinePosition);
                this.out.println("/UnderlineThickness " + TrueTypeFont.this.underlineThickness);
            }
            this.out.println(">>");
            this.out.println("/XUID [107 42 curxuid]");
            this.outputSfnts(this.out);
            this.out.println("/CIDFontName " + psFontName);
            this.out.println("/CIDFontType 2");
            this.out.println("/CIDSystemInfo mark");
            this.out.println("  /Registry (Actuate)");
            this.out.println("  /Ordering (China)");
            this.out.println("  /Supplement 0");
            this.out.println(">>");
            this.out.println("/CharStrings mark /.notdef 0 >>");
            int[] tableLocation = (int[])TrueTypeFont.this.positionTables.get("loca");
            int locaLength = tableLocation[1];
            int glyphCount = locaLength / ((TrueTypeFont)TrueTypeFont.this).head.locaBytesPerEntry + 1;
            this.out.println("/CIDCount " + glyphCount);
            this.out.println("/CIDMap " + glyphCount + " dict");
            this.out.println("/PaintType 0");
            this.out.println("/FontType 42");
            this.out.println("/GDBytes 2");
            this.out.println(">>");
            this.out.println("dup /CIDFontName get cvn exch /CIDFont defineresource pop");
        }

        public void useDisplayName(String displayName) {
            this.out.println("/" + displayName + " /PeerCMap [/" + TrueTypeFont.this.fontName + "] composefont pop");
        }

        public void ensureGlyphAvailable(char c) throws IOException {
            List charactersToOutput = this.getCharactersToOutput(c);
            int i = 0;
            while (i < charactersToOutput.size()) {
                this.ensureRawDataAvailable(((Character)charactersToOutput.get(i)).charValue());
                ++i;
            }
            this.ensureRawDataAvailable(c);
        }

        private void ensureRawDataAvailable(char c) throws IOException {
            Character character = new Character(c);
            if (!this.glyphDefined.contains(character)) {
                this.glyphDefined.add(character);
                this.out.print(String.valueOf((int)c) + " ");
                this.out.print(this.getGlyphIndex(c));
                this.outputAsPsString(this.out, this.getGlyphData(c));
                this.out.println(" /" + TrueTypeFont.this.fontName + " AddT42Char");
            }
        }

        private byte[] getGlyphData(char c) throws IOException {
            int[] glyphDataPosition = this.getGlyphDataPosition(c);
            int dataOffsetRelativeToGlyfTable = glyphDataPosition[0];
            int dataLength = glyphDataPosition[1];
            int[] glyphLocation = (int[])TrueTypeFont.this.positionTables.get("glyf");
            int dataOffset = dataOffsetRelativeToGlyfTable + glyphLocation[0];
            byte[] result = new byte[dataLength];
            this.rf.seek(dataOffset);
            this.rf.readFully(result);
            return result;
        }

        private int[] getGlyphDataPosition(char c) throws IOException {
            int glyphIndex = this.getGlyphIndex(c);
            return this.getGlyphDataPosition(glyphIndex);
        }

        private int[] getGlyphDataPosition(int glyphIndex) throws IOException {
            int[] glyphDataPosition = new int[2];
            int[] tableLocation = (int[])TrueTypeFont.this.positionTables.get("loca");
            int offset = tableLocation[0] + ((TrueTypeFont)TrueTypeFont.this).head.locaBytesPerEntry * glyphIndex;
            this.rf.seek(offset);
            if (((TrueTypeFont)TrueTypeFont.this).head.locaBytesPerEntry == 4) {
                glyphDataPosition[0] = this.rf.readInt();
                glyphDataPosition[1] = this.rf.readInt() - glyphDataPosition[0];
            } else {
                glyphDataPosition[0] = this.rf.readUnsignedShort() * 2;
                glyphDataPosition[1] = this.rf.readUnsignedShort() * 2 - glyphDataPosition[0];
            }
            return glyphDataPosition;
        }

        public void ensureGlyphsAvailable(String string) throws IOException {
            int i = 0;
            while (i < string.length()) {
                this.ensureGlyphAvailable(string.charAt(i));
                ++i;
            }
        }

        protected List getCharactersToOutput(char c) throws IOException {
            int glyph = this.getGlyphIndex(c);
            List result = this.getCharactersToOutput(glyph);
            return result;
        }

        protected List getCharactersToOutput(int glyph) throws IOException {
            ArrayList<Character> characters = new ArrayList<Character>();
            int[] glyphDataPosition = this.getGlyphDataPosition(glyph);
            int glyphDataOffset = glyphDataPosition[0];
            int glyphDataLength = glyphDataPosition[1];
            if (glyphDataLength == 0) {
                return characters;
            }
            int tableGlyphOffset = ((int[])TrueTypeFont.this.positionTables.get("glyf"))[0];
            this.rf.seek(tableGlyphOffset + glyphDataOffset);
            short numContours = this.rf.readShort();
            if (numContours >= 0) {
                return characters;
            }
            this.rf.skipBytes(8);
            while (true) {
                int flags = this.rf.readUnsignedShort();
                Integer cGlyph = new Integer(this.rf.readUnsignedShort());
                char character = this.getChar(cGlyph);
                Character charObject = new Character(character);
                if (!this.glyphDefined.contains(charObject)) {
                    characters.add(charObject);
                }
                if ((flags & 0x20) == 0) {
                    return characters;
                }
                int skip = (flags & 1) != 0 ? 4 : 2;
                if ((flags & 8) != 0) {
                    skip += 2;
                } else if ((flags & 0x40) != 0) {
                    skip += 4;
                }
                if ((flags & 0x80) != 0) {
                    skip += 8;
                }
                this.rf.skipBytes(skip);
            }
        }

        private char getChar(int glyph) {
            HashMap cmap = TrueTypeFont.this.getCMap();
            Iterator iterator = cmap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int[] glyphIndice = (int[])entry.getValue();
                if (glyphIndice[0] != glyph) continue;
                return (char)((Integer)entry.getKey()).intValue();
            }
            return '\uffff';
        }

        public void close() throws IOException {
            this.rf.close();
        }

        private void output(PrintStream out, String key, String value) {
            if (value != null) {
                out.println(String.valueOf(key) + " " + value);
            }
        }

        private int getGlyphIndex(char c) {
            int[] glyphIndexs = (int[])TrueTypeFont.this.getCMap().get(new Integer(c));
            return glyphIndexs[0];
        }

        private String toPSDataString(String data) {
            return "<" + data + ">";
        }

        private boolean isBigTable(String name, String[] bigTables) {
            int i = 0;
            while (i < bigTables.length) {
                if (name.equals(bigTables[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private void addExistedTables(List tablesToAdd, String[] tablesDesired) {
            int i = 0;
            while (i < tablesDesired.length) {
                String name = tablesDesired[i];
                int[] position = (int[])TrueTypeFont.this.positionTables.get(name);
                if (position != null) {
                    this.addTableNameInOrder(name, tablesToAdd, position);
                }
                ++i;
            }
        }

        private void addTableNameInOrder(String name, List arrayList, int[] position) {
            int j = 0;
            while (j < arrayList.size()) {
                String tableName = (String)arrayList.get(j);
                int[] position1 = (int[])TrueTypeFont.this.positionTables.get(tableName);
                if (position[0] < position1[0]) {
                    arrayList.add(j, name);
                    return;
                }
                ++j;
            }
            arrayList.add(name);
        }

        private void outputGdirTable(PrintStream out) {
            byte[] gdirMetadata = new byte[16];
            gdirMetadata[0] = 103;
            gdirMetadata[2] = 100;
            gdirMetadata[4] = 105;
            gdirMetadata[6] = 114;
            out.print(Util.toHexString(gdirMetadata));
        }

        private int addTable(PrintStream out, int offset, String name, StringBuffer tableContent) {
            int result = 0;
            try {
                int[] tableLocation = TrueTypeFont.this.getTableLocation(name);
                if (tableLocation != null) {
                    byte[] tableMetadata = (byte[])TrueTypeFont.this.metadataTables.get(name);
                    Util.putInt32(tableMetadata, 8, offset);
                    result = offset + this.getEvenLength(tableLocation[1]);
                    out.println(Util.toHexString(tableMetadata));
                    byte[] data = this.readTable(name);
                    tableContent.append("\n" + this.toPSDataString(Util.toHexString(data)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }

        private int getEvenLength(int length) {
            return (length & 1) == 0 ? length : length + 1;
        }

        private int addBigTable(PrintStream out, int offset, String name, StringBuffer tableContent) {
            int result = 0;
            try {
                int[] tableLocation = TrueTypeFont.this.getTableLocation(name);
                if (tableLocation != null) {
                    byte[] tableMetadata = (byte[])TrueTypeFont.this.metadataTables.get(name);
                    if ("loca".equals(name) || "glyf".equals(name)) {
                        tableMetadata[3] = 120;
                        Util.putInt32(tableMetadata, 8, 0);
                        Util.putInt32(tableMetadata, 12, 0);
                        result = offset;
                        out.println(Util.toHexString(tableMetadata));
                    } else {
                        Util.putInt32(tableMetadata, 8, offset);
                        out.println(Util.toHexString(tableMetadata));
                        result = offset + this.getEvenLength(tableLocation[1]);
                        List datas = this.readBigTable(name);
                        int i = 0;
                        while (i < datas.size()) {
                            tableContent.append("\n" + this.toPSDataString(Util.toHexString((byte[])datas.get(i))));
                            ++i;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }

        private void outputAsPsString(PrintStream out, byte[] data) {
            out.println(this.toPSDataString(Util.toHexString(data)));
        }

        private byte[] readDataWithPadding(int length) throws IOException {
            byte[] value = null;
            value = (length & 1) != 0 ? new byte[length + 1] : new byte[length];
            this.rf.readFully(value, 0, length);
            return value;
        }

        private boolean hasTable(String tableName) {
            return TrueTypeFont.this.positionTables.get(tableName) != null;
        }

        private void outputSfnts(PrintStream out) {
            out.println("/sfnts [");
            String[] tablesDesired = new String[]{"cmap", "head", "hhea", "maxp", "name", "OS/2", "cvt ", "fpgm", "prep"};
            String[] bigTablesDesired = new String[]{"post", "hmtx"};
            ArrayList tablesToAdd = new ArrayList();
            this.addExistedTables(tablesToAdd, tablesDesired);
            this.addExistedTables(tablesToAdd, bigTablesDesired);
            Util.putInt16(TrueTypeFont.this.directoryRawData, 4, tablesToAdd.size() + 1);
            out.print("<");
            out.println(Util.toHexString(TrueTypeFont.this.directoryRawData));
            int offset = 12 + (tablesToAdd.size() + 1) * 16;
            StringBuffer tableContent = new StringBuffer();
            int i = 0;
            while (i < tablesToAdd.size()) {
                String name = (String)tablesToAdd.get(i);
                offset = this.isBigTable(name, bigTablesDesired) ? this.addBigTable(out, offset, name, tableContent) : this.addTable(out, offset, name, tableContent);
                ++i;
            }
            this.outputGdirTable(out);
            out.print(">");
            out.println(tableContent.toString());
            out.println("]");
        }

        private byte[] readTable(String name) throws DocumentException, IOException {
            int[] tableLocation = TrueTypeFont.this.getTableLocation(name);
            if (tableLocation == null) {
                return null;
            }
            this.rf.seek(tableLocation[0]);
            byte[] data = this.readDataWithPadding(tableLocation[1]);
            return data;
        }

        private List readBigTable(String name) throws DocumentException, IOException {
            ArrayList<byte[]> result = new ArrayList<byte[]>();
            int[] tableLocation = TrueTypeFont.this.getTableLocation(name);
            if (tableLocation == null) {
                return null;
            }
            int limitation = 32700;
            int maxString = 16382;
            if (tableLocation[1] < limitation) {
                this.rf.seek(tableLocation[0]);
                byte[] value = this.readDataWithPadding(tableLocation[1]);
                result.add(value);
            } else {
                int length = tableLocation[1];
                this.rf.seek(tableLocation[0]);
                while (length > maxString) {
                    length -= maxString;
                    result.add(this.readDataWithPadding(maxString));
                }
                result.add(this.readDataWithPadding(length));
            }
            return result;
        }
    }

    protected static class WindowsMetrics {
        short xAvgCharWidth;
        int usWeightClass;
        int usWidthClass;
        short fsType;
        short ySubscriptXSize;
        short ySubscriptYSize;
        short ySubscriptXOffset;
        short ySubscriptYOffset;
        short ySuperscriptXSize;
        short ySuperscriptYSize;
        short ySuperscriptXOffset;
        short ySuperscriptYOffset;
        short yStrikeoutSize;
        short yStrikeoutPosition;
        short sFamilyClass;
        byte[] panose = new byte[10];
        byte[] achVendID = new byte[4];
        int fsSelection;
        int usFirstCharIndex;
        int usLastCharIndex;
        short sTypoAscender;
        short sTypoDescender;
        short sTypoLineGap;
        int usWinAscent;
        int usWinDescent;
        int ulCodePageRange1;
        int ulCodePageRange2;
        int sCapHeight;

        protected WindowsMetrics() {
        }
    }
}

