/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.html.AttributeBuilder;
import org.eclipse.birt.report.engine.emitter.html.HTMLEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLWriter;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class HTMLPerformanceOptimize
extends HTMLEmitter {
    private Stack cellDisplayStack = new Stack();

    public HTMLPerformanceOptimize(HTMLReportEmitter parentEmitter, HTMLWriter writer, boolean isEmbeddable) {
        super(parentEmitter, writer, isEmbeddable);
    }

    public void buildTableStyle(ITableContent table, StringBuffer styleBuffer, String layoutPreference) {
        DimensionType width;
        IStyle style = table.getStyle();
        this.addDefaultTableStyles(styleBuffer);
        DimensionType height = table.getHeight();
        if (height != null) {
            this.buildSize(styleBuffer, "height", height);
        }
        if ((width = table.getWidth()) != null) {
            this.buildSize(styleBuffer, "width", width);
        } else {
            styleBuffer.append(" width: 100%;");
        }
        if ("fixed".equals(layoutPreference) && (style == null || !"true".equalsIgnoreCase(style.getCanShrink()))) {
            styleBuffer.append(" table-layout:fixed;");
        }
        this.buildStyle((IContent)table, styleBuffer);
    }

    public void buildColumnStyle(IColumn column, StringBuffer styleBuffer) {
        this.buildSize(styleBuffer, "width", column.getWidth());
        IStyle style = this.isEmbeddable ? column.getStyle() : column.getInlineStyle();
        this.buildStyle(style, styleBuffer);
    }

    public void buildRowStyle(IRowContent row, StringBuffer styleBuffer) {
        this.buildSize(styleBuffer, "height", row.getHeight());
        this.buildStyle((IContent)row, styleBuffer);
    }

    public void buildCellStyle(ICellContent cell, StringBuffer styleBuffer, boolean isInTableHead) {
        styleBuffer.append("overflow:hidden;");
        this.buildStyle((IContent)cell, styleBuffer);
    }

    public void handleCellAlign(ICellContent cell) {
    }

    public void openContainerTag(IContainerContent container) {
        DimensionType x = container.getX();
        DimensionType y = container.getY();
        DimensionType width = container.getWidth();
        DimensionType height = container.getHeight();
        int display = this.getElementType(x, y, width, height, container.getStyle());
        this.cellDisplayStack.push(new Integer(display));
        if ((display & 2) > 0 || (display & 4) > 0) {
            this.openInlineBoxTag();
        }
        this.writer.openTag("div");
    }

    public void closeContainerTag() {
        this.writer.closeTag("div");
        int display = (Integer)this.cellDisplayStack.pop();
        if ((display & 2) > 0 || (display & 4) > 0) {
            this.closeInlineBoxTag();
        }
    }

    public void buildContainerStyle(IContainerContent container, StringBuffer styleBuffer) {
        IStyle style = container.getStyle();
        DimensionType x = container.getX();
        DimensionType y = container.getY();
        DimensionType width = container.getWidth();
        DimensionType height = container.getHeight();
        int display = this.getElementType(x, y, width, height, style);
        this.handleShrink(display, style, height, width, styleBuffer);
        this.buildStyle((IContent)container, styleBuffer);
    }

    public void buildTextStyle(ITextContent text, StringBuffer styleBuffer, int display, String url) {
        IStyle style = text.getStyle();
        this.handleShrink(display, style, text.getHeight(), text.getWidth(), styleBuffer);
        this.buildStyle((IContent)text, styleBuffer);
        String value = style.getDisplay();
        if (value == null) {
            styleBuffer.append(" display: block;");
        }
    }

    public void buildForeignStyle(IForeignContent foreign, StringBuffer styleBuffer, int display, String url) {
        IStyle style = foreign.getStyle();
        this.handleShrink(display, style, foreign.getHeight(), foreign.getWidth(), styleBuffer);
        this.buildStyle((IContent)foreign, styleBuffer);
    }

    public void buildImageStyle(IImageContent image, StringBuffer styleBuffer, int display) {
        this.buildSize(styleBuffer, "width", image.getWidth());
        this.buildSize(styleBuffer, "height", image.getHeight());
        this.buildStyle((IContent)image, styleBuffer);
    }

    public void handleHorizontalAlign(IStyle style) {
    }

    public void handleVerticalAlign(IStyle style) {
    }

    public void handleVerticalAlignBegine(IContent element) {
    }

    public void handleVerticalAlignEnd(IContent element) {
    }

    public void buildStyle(IContent element, StringBuffer styleBuffer) {
        IStyle style = element.getStyle();
        if (this.isEmbeddable) {
            this.buildStyle(style, styleBuffer);
        } else {
            IStyle inlineStyle = element.getInlineStyle();
            this.buildStyle(inlineStyle, styleBuffer);
        }
        AttributeBuilder.checkHyperlinkTextDecoration(style, styleBuffer);
        String value = style.getDisplay();
        if (value != null) {
            styleBuffer.append(" display:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
    }

    protected void buildStyle(IStyle style, StringBuffer styleBuffer) {
        if (style == null) {
            return;
        }
        AttributeBuilder.buildStyle(styleBuffer, style, this.parentEmitter);
        String value = style.getVerticalAlign();
        if (value != null) {
            styleBuffer.append(" vertical-align:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
        if ((value = style.getTextAlign()) != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
    }
}

