/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.dom.CellMergedStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.html.AttributeBuilder;
import org.eclipse.birt.report.engine.emitter.html.HTMLEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLWriter;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.w3c.dom.css.CSSValue;

public class HTMLVisionOptimize
extends HTMLEmitter {
    private static HashMap borderStyleMap = null;
    private Stack cellDisplayStack = new Stack();

    static {
        borderStyleMap = new HashMap();
        borderStyleMap.put("none", new Integer(0));
        borderStyleMap.put("inset", new Integer(1));
        borderStyleMap.put("groove", new Integer(2));
        borderStyleMap.put("outset", new Integer(3));
        borderStyleMap.put("ridge", new Integer(4));
        borderStyleMap.put("dotted", new Integer(5));
        borderStyleMap.put("dashed", new Integer(6));
        borderStyleMap.put("solid", new Integer(7));
        borderStyleMap.put("double", new Integer(8));
    }

    public HTMLVisionOptimize(HTMLReportEmitter parentEmitter, HTMLWriter writer, boolean isEmbeddable) {
        super(parentEmitter, writer, isEmbeddable);
    }

    public void buildTableStyle(ITableContent table, StringBuffer styleBuffer, String layoutPreference) {
        DimensionType width;
        IStyle style = table.getStyle();
        this.addDefaultTableStyles(styleBuffer);
        DimensionType x = table.getX();
        DimensionType y = table.getY();
        int display = this.getElementType(x, y, null, null, style);
        this.setDisplayProperty(display, 2, styleBuffer);
        DimensionType height = table.getHeight();
        if (height != null) {
            this.buildSize(styleBuffer, "height", height);
        }
        if ((width = table.getWidth()) != null) {
            this.buildSize(styleBuffer, "width", width);
        } else {
            styleBuffer.append(" width: 100%;");
        }
        if ("fixed".equals(layoutPreference) && (style == null || !"true".equalsIgnoreCase(style.getCanShrink()))) {
            styleBuffer.append(" table-layout:fixed;");
        }
        this.buildStyle((IContent)table, styleBuffer);
    }

    public void buildColumnStyle(IColumn column, StringBuffer styleBuffer) {
        this.buildSize(styleBuffer, "width", column.getWidth());
    }

    public void buildRowStyle(IRowContent row, StringBuffer styleBuffer) {
        this.buildSize(styleBuffer, "height", row.getHeight());
        this.buildStyle((IContent)row, styleBuffer);
    }

    public void buildCellStyle(ICellContent cell, StringBuffer styleBuffer, boolean isInTableHead) {
        CellMergedStyle style = new CellMergedStyle(cell);
        AttributeBuilder.buildStyle(styleBuffer, (IStyle)style, this.parentEmitter);
        if (isInTableHead) {
            this.handleCellFont(cell, styleBuffer);
        }
        styleBuffer.append("overflow:hidden;");
        this.buildCellBaseStyle(cell, styleBuffer);
    }

    public void handleCellAlign(ICellContent cell) {
        IStyle cellStyle = cell.getComputedStyle();
        CSSValue vAlign = cellStyle.getProperty(30);
        if (vAlign == null || IStyle.BASELINE_VALUE == vAlign) {
            vAlign = IStyle.TOP_VALUE;
        }
        this.writer.attribute("valign", vAlign.getCssText());
        this.handleHorizontalAlign(cellStyle);
    }

    public void openContainerTag(IContainerContent container) {
        DimensionType x = container.getX();
        DimensionType y = container.getY();
        DimensionType width = container.getWidth();
        DimensionType height = container.getHeight();
        int display = this.getElementType(x, y, width, height, container.getStyle());
        this.cellDisplayStack.push(new Integer(display));
        if ((display & 2) > 0 || (display & 4) > 0) {
            this.openInlineBoxTag();
        }
        this.writer.openTag("div");
    }

    public void closeContainerTag() {
        this.writer.closeTag("div");
        int display = (Integer)this.cellDisplayStack.pop();
        if ((display & 2) > 0 || (display & 4) > 0) {
            this.closeInlineBoxTag();
        }
    }

    public void buildContainerStyle(IContainerContent container, StringBuffer styleBuffer) {
        int display = (Integer)this.cellDisplayStack.peek();
        this.handleShrink(display, container.getStyle(), container.getHeight(), container.getWidth(), styleBuffer);
        this.setDisplayProperty(display, 4, styleBuffer);
        this.buildStyle((IContent)container, styleBuffer);
    }

    public void buildTextStyle(ITextContent text, StringBuffer styleBuffer, int display, String url) {
        IStyle style = text.getStyle();
        this.handleShrink(display, style, text.getHeight(), text.getWidth(), styleBuffer);
        if (url != null) {
            this.setDisplayProperty(display, 5, styleBuffer);
        } else {
            this.setDisplayProperty(display, 4, styleBuffer);
        }
        String textAlign = text.getComputedStyle().getTextAlign();
        if (textAlign != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(textAlign);
            styleBuffer.append(";");
        }
        this.buildSimpleStyle((IContent)text, styleBuffer);
        AttributeBuilder.checkHyperlinkTextDecoration(text.getComputedStyle(), styleBuffer);
    }

    public void buildForeignStyle(IForeignContent foreign, StringBuffer styleBuffer, int display, String url) {
        IStyle style = foreign.getStyle();
        this.handleShrink(display, style, foreign.getHeight(), foreign.getWidth(), styleBuffer);
        if (url != null) {
            this.setDisplayProperty(display, 5, styleBuffer);
        } else {
            this.setDisplayProperty(display, 4, styleBuffer);
        }
        String textAlign = foreign.getComputedStyle().getTextAlign();
        if (textAlign != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(textAlign);
            styleBuffer.append(";");
        }
        this.buildSimpleStyle((IContent)foreign, styleBuffer);
        AttributeBuilder.checkHyperlinkTextDecoration(foreign.getComputedStyle(), styleBuffer);
    }

    public void buildImageStyle(IImageContent image, StringBuffer styleBuffer, int display) {
        this.buildSize(styleBuffer, "width", image.getWidth());
        this.buildSize(styleBuffer, "height", image.getHeight());
        this.setDisplayProperty(display, 0, styleBuffer);
        this.buildStyle((IContent)image, styleBuffer);
    }

    public void handleHorizontalAlign(IStyle style) {
        CSSValue hAlign = style.getProperty(26);
        if (hAlign != null) {
            this.writer.attribute("align", hAlign.getCssText());
        }
    }

    public void handleVerticalAlign(IStyle style) {
        CSSValue vAlign = style.getProperty(30);
        if (vAlign != null) {
            this.writer.attribute("valign", vAlign.getCssText());
        }
    }

    public void handleVerticalAlignBegine(IContent element) {
        IStyle style = element.getStyle();
        CSSValue vAlign = style.getProperty(30);
        CSSValue canShrink = style.getProperty(6);
        DimensionType height = element.getHeight();
        if (vAlign != null && vAlign != IStyle.BASELINE_VALUE && height != null && canShrink != IStyle.TRUE_VALUE) {
            this.writer.openTag("table");
            StringBuffer nestingTableStyleBuffer = new StringBuffer();
            nestingTableStyleBuffer.append(" width:100%; height:");
            nestingTableStyleBuffer.append(height.toString());
            this.writer.attribute("style", nestingTableStyleBuffer);
            this.writer.openTag("tr");
            this.writer.openTag("td");
            StringBuffer textStyleBuffer = new StringBuffer();
            textStyleBuffer.append(" vertical-align:");
            textStyleBuffer.append(vAlign.getCssText());
            textStyleBuffer.append(";");
            this.writer.attribute("style", textStyleBuffer);
        }
    }

    public void handleVerticalAlignEnd(IContent element) {
        IStyle style = element.getStyle();
        CSSValue vAlign = style.getProperty(30);
        CSSValue canShrink = style.getProperty(6);
        DimensionType height = element.getHeight();
        if (vAlign != null && vAlign != IStyle.BASELINE_VALUE && height != null && canShrink != IStyle.TRUE_VALUE) {
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
            this.writer.closeTag("table");
        }
    }

    protected void setDisplayProperty(int display, int mask, StringBuffer styleBuffer) {
        int flag = display & mask;
        if ((display & 8) > 0) {
            styleBuffer.append("display: none;");
        } else if (flag > 0) {
            if ((flag & 1) > 0) {
                styleBuffer.append("display: block;");
            } else if ((flag & 4) > 0) {
                styleBuffer.append("display: inline-block;");
            } else if ((flag & 2) > 0) {
                styleBuffer.append("display: inline;");
            }
        }
    }

    public void buildSize(StringBuffer content, String name, DimensionType value) {
        if (value != null) {
            if ("min-height".equals(name)) {
                content.append(" height: auto !important; height: ");
                content.append(value.toString());
                content.append("; min-height: ");
                content.append(value.toString());
                content.append(';');
            } else {
                super.buildSize(content, name, value);
            }
        }
    }

    public void buildStyle(IContent element, StringBuffer styleBuffer) {
        this.buildSimpleStyle(element, styleBuffer);
        AttributeBuilder.checkHyperlinkTextDecoration(element.getComputedStyle(), styleBuffer);
    }

    private void buildSimpleStyle(IContent element, StringBuffer styleBuffer) {
        IStyle style = this.isEmbeddable ? element.getStyle() : element.getInlineStyle();
        AttributeBuilder.buildStyle(styleBuffer, style, this.parentEmitter);
    }

    protected void buildCellBaseStyle(ICellContent cell, StringBuffer styleBuffer) {
        IStyle style = null;
        style = this.isEmbeddable ? cell.getStyle() : cell.getInlineStyle();
        AttributeBuilder.buildCellStyle(styleBuffer, style, this.parentEmitter);
        int columnCount = -1;
        IStyle cellStyle = null;
        IStyle cellComputedStyle = null;
        IStyle rowStyle = null;
        IStyle rowComputedStyle = null;
        cellStyle = cell.getStyle();
        cellComputedStyle = cell.getComputedStyle();
        IRowContent row = (IRowContent)cell.getParent();
        if (row != null) {
            rowStyle = row.getStyle();
            rowComputedStyle = row.getComputedStyle();
            ITableContent table = row.getTable();
            if (table != null) {
                columnCount = table.getColumnCount();
            }
        }
        if (rowStyle == null || cell.getColumn() < 0 || columnCount < 1) {
            if (cellStyle != null) {
                this.buildCellRowBorder(styleBuffer, "border-top", cellStyle.getBorderTopWidth(), cellStyle.getBorderTopStyle(), cellStyle.getBorderTopColor(), 0, null, null, null, 0);
                this.buildCellRowBorder(styleBuffer, "border-right", cellStyle.getBorderRightWidth(), cellStyle.getBorderRightStyle(), cellStyle.getBorderRightColor(), 0, null, null, null, 0);
                this.buildCellRowBorder(styleBuffer, "border-bottom", cellStyle.getBorderBottomWidth(), cellStyle.getBorderBottomStyle(), cellStyle.getBorderBottomColor(), 0, null, null, null, 0);
                this.buildCellRowBorder(styleBuffer, "border-left", cellStyle.getBorderLeftWidth(), cellStyle.getBorderLeftStyle(), cellStyle.getBorderLeftColor(), 0, null, null, null, 0);
            }
        } else if (cellStyle == null) {
            this.buildCellRowBorder(styleBuffer, "border-top", null, null, null, 0, rowStyle.getBorderTopWidth(), rowStyle.getBorderTopStyle(), rowStyle.getBorderTopColor(), 0);
            this.buildCellRowBorder(styleBuffer, "border-right", null, null, null, 0, rowStyle.getBorderRightWidth(), rowStyle.getBorderRightStyle(), rowStyle.getBorderRightColor(), 0);
            this.buildCellRowBorder(styleBuffer, "border-bottom", null, null, null, 0, rowStyle.getBorderBottomWidth(), rowStyle.getBorderBottomStyle(), rowStyle.getBorderBottomColor(), 0);
            this.buildCellRowBorder(styleBuffer, "border-left", null, null, null, 0, rowStyle.getBorderLeftWidth(), rowStyle.getBorderLeftStyle(), rowStyle.getBorderLeftColor(), 0);
        } else {
            int cellWidthValue = this.getBorderWidthValue(cellComputedStyle, 15);
            int rowWidthValue = this.getBorderWidthValue(rowComputedStyle, 15);
            this.buildCellRowBorder(styleBuffer, "border-top", cellStyle.getBorderTopWidth(), cellStyle.getBorderTopStyle(), cellStyle.getBorderTopColor(), cellWidthValue, rowStyle.getBorderTopWidth(), rowStyle.getBorderTopStyle(), rowStyle.getBorderTopColor(), rowWidthValue);
            if (cell.getColumn() + cell.getColSpan() == columnCount) {
                cellWidthValue = this.getBorderWidthValue(cellComputedStyle, 18);
                rowWidthValue = this.getBorderWidthValue(rowComputedStyle, 18);
                this.buildCellRowBorder(styleBuffer, "border-right", cellStyle.getBorderRightWidth(), cellStyle.getBorderRightStyle(), cellStyle.getBorderRightColor(), cellWidthValue, rowStyle.getBorderRightWidth(), rowStyle.getBorderRightStyle(), rowStyle.getBorderRightColor(), rowWidthValue);
            } else {
                this.buildCellRowBorder(styleBuffer, "border-right", cellStyle.getBorderRightWidth(), cellStyle.getBorderRightStyle(), cellStyle.getBorderRightColor(), 0, null, null, null, 0);
            }
            cellWidthValue = this.getBorderWidthValue(cellComputedStyle, 19);
            rowWidthValue = this.getBorderWidthValue(rowComputedStyle, 19);
            this.buildCellRowBorder(styleBuffer, "border-bottom", cellStyle.getBorderBottomWidth(), cellStyle.getBorderBottomStyle(), cellStyle.getBorderBottomColor(), cellWidthValue, rowStyle.getBorderBottomWidth(), rowStyle.getBorderBottomStyle(), rowStyle.getBorderBottomColor(), rowWidthValue);
            if (cell.getColumn() == 0) {
                cellWidthValue = this.getBorderWidthValue(cellComputedStyle, 17);
                rowWidthValue = this.getBorderWidthValue(rowComputedStyle, 17);
                this.buildCellRowBorder(styleBuffer, "border-left", cellStyle.getBorderLeftWidth(), cellStyle.getBorderLeftStyle(), cellStyle.getBorderLeftColor(), cellWidthValue, rowStyle.getBorderLeftWidth(), rowStyle.getBorderLeftStyle(), rowStyle.getBorderLeftColor(), rowWidthValue);
            } else {
                this.buildCellRowBorder(styleBuffer, "border-left", cellStyle.getBorderLeftWidth(), cellStyle.getBorderLeftStyle(), cellStyle.getBorderLeftColor(), 0, null, null, null, 0);
            }
        }
    }

    private int getBorderWidthValue(IStyle style, int borderNum) {
        if (style == null) {
            return 0;
        }
        if (15 != borderNum && 18 != borderNum && 19 != borderNum && 17 != borderNum) {
            return 0;
        }
        CSSValue value = style.getProperty(borderNum);
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72000.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72000.0f);
                }
                case 7: {
                    return (int)((double)(v * 7200.0f) / 2.54);
                }
                case 9: {
                    return (int)(v * 1000.0f);
                }
                case 1: {
                    return (int)v;
                }
            }
        }
        return 0;
    }

    private void buildCellRowBorder(StringBuffer content, String borderName, String cellBorderWidth, String cellBorderStyle, String cellBorderColor, int cellWidthValue, String rowBorderWidth, String rowBorderStyle, String rowBorderColor, int rowWidthValue) {
        boolean bUseCellBorder = true;
        if (rowBorderStyle != null) {
            if (cellBorderStyle == null) {
                bUseCellBorder = false;
            } else if (!cellBorderStyle.matches("hidden")) {
                if (rowBorderStyle.matches("hidden")) {
                    bUseCellBorder = false;
                } else if (!rowBorderStyle.matches("none")) {
                    if (cellBorderStyle.matches("none")) {
                        bUseCellBorder = false;
                    } else if (rowWidthValue >= cellWidthValue) {
                        if (rowWidthValue > cellWidthValue) {
                            bUseCellBorder = false;
                        } else if (!cellBorderStyle.matches(rowBorderStyle)) {
                            Integer iCellBorderLevel = (Integer)borderStyleMap.get(cellBorderStyle);
                            Integer iRowBorderLevel = (Integer)borderStyleMap.get(rowBorderStyle);
                            if (iCellBorderLevel == null) {
                                iCellBorderLevel = new Integer(-1);
                            }
                            if (iRowBorderLevel == null) {
                                iRowBorderLevel = new Integer(-1);
                            }
                            if (iRowBorderLevel > iCellBorderLevel) {
                                bUseCellBorder = false;
                            }
                        }
                    }
                }
            }
        }
        if (bUseCellBorder) {
            AttributeBuilder.buildBorder(content, borderName, cellBorderWidth, cellBorderStyle, cellBorderColor);
        } else {
            AttributeBuilder.buildBorder(content, borderName, rowBorderWidth, rowBorderStyle, rowBorderColor);
        }
    }

    protected void handleCellFont(ICellContent element, StringBuffer styleBuffer) {
        IStyle style = element.getStyle();
        String fontWeight = style.getFontWeight();
        if (fontWeight == null) {
            style = element.getComputedStyle();
            fontWeight = style.getFontWeight();
            if (fontWeight == null) {
                fontWeight = "normal";
            }
            styleBuffer.append("font-weight: ");
            styleBuffer.append(fontWeight);
            styleBuffer.append(";");
        }
    }
}

