/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common.api.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataQueryComponent;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.spi.IWireSource;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.mgmt.annotations.CreateManagedRelation;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;

public abstract class AbstractFilter
implements IDataFilterService,
IDataQueryComponent,
IWireTarget,
IWireSource {
    protected IDataFilterService _proxy;
    private static Class[] EMPTY_LIST = new Class[0];
    private static Class[] supportedTypes = EMPTY_LIST;
    private static HashMap<Class, Method> methodMap = new HashMap();
    private IWireSource wireSource;
    private Method wireMethod;
    protected ArrayList<IWireTarget> targetList = new ArrayList();
    private ThreadLocal active = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private boolean queryMode = false;

    protected abstract Class[] getSupportedTypes();

    public AbstractFilter(ContributionManager manager) {
        Method[] methods;
        supportedTypes = this.getSupportedTypes();
        Method[] methodArray = methods = this.getClass().getMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Method method = methodArray[n];
            if (method.getName().equals("filter") && method.getParameterTypes().length <= 1 && Modifier.isPublic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
                Class returnType = null;
                Class[] classArray = supportedTypes;
                int n3 = 0;
                int n4 = classArray.length;
                while (n3 < n4) {
                    Class supportedType = classArray[n3];
                    if (method.getReturnType().equals(supportedType)) {
                        returnType = supportedType;
                    }
                    ++n3;
                }
                if (returnType != null && method.getParameterTypes()[0].isAssignableFrom(returnType)) {
                    methodMap.put(returnType, method);
                }
            }
            ++n;
        }
        this._proxy = (IDataFilterService)manager.manage((Object)this);
    }

    public boolean acceptType(Class type) {
        Class[] classArray = supportedTypes;
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class supportedType = classArray[n];
            if (supportedType.isAssignableFrom(type)) {
                Method method = methodMap.get(type);
                if (method == null) {
                    method = methodMap.get(supportedType);
                    if (method == null) {
                        System.out.println("Hmmmm... " + this.getClass().getName() + " claimed support for " + supportedType.getName() + " but provided no store method");
                        return false;
                    }
                    methodMap.put(type, method);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    public Method getFilterMethod(Class type) {
        return methodMap.get(type);
    }

    @CreateManagedRelation(type="WireSource", namespace="http://www.eclipse.org/xmlns/cosmos/1.0")
    public void setWireSource(IWireSource source) throws Exception {
        if (this.wireSource != null) {
            throw new Exception("Invalid wire source - already set");
        }
        this.wireSource = source;
    }

    public abstract boolean acceptWireTarget(IWireTarget var1) throws Exception;

    @CreateManagedRelation(type="WireTarget", namespace="http://www.eclipse.org/xmlns/cosmos/1.0")
    public void addWireTarget(IWireTarget target) throws Exception {
        if (!(target instanceof IDataFilterService || target instanceof IDataTransformService || target instanceof IDataSinkService)) {
            throw new Exception("Invalid wire target type for DataSource");
        }
        this.targetList.add(target);
        target.setWireSource(this);
    }

    public IWireSource getWireSource() {
        return this.wireSource;
    }

    public IWireTarget[] getWireTargets() {
        return this.targetList.toArray(new IWireTarget[0]);
    }

    public void setWireMethod(Method wireMethod) {
        this.wireMethod = wireMethod;
    }

    public Method getWireMethod() {
        return this.wireMethod;
    }

    public void dispatch(Object obj) {
        Object[] args = new Object[]{obj};
        for (IWireTarget target : this.targetList) {
            Method targetMethod = target.getWireMethod();
            if (targetMethod == null) continue;
            try {
                targetMethod.invoke((Object)target, args);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public Class[] getOutputTypes() {
        return this.getSupportedTypes();
    }

    public Class[] getAcceptableTypes() {
        return this.getSupportedTypes();
    }

    public void setQueryMode(boolean inQuery) {
        this.queryMode = inQuery;
    }

    public boolean getQueryMode() {
        return this.queryMode;
    }

    public void setActive(boolean active) {
        this.active.set(active);
    }

    public boolean isActive() {
        return (Boolean)this.active.get();
    }
}

