/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.adapter.oda.ODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.impl.NativeDataTypeUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.ReportParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.util.IdentifierUtility;
import org.eclipse.birt.report.model.adapter.oda.util.ParameterValueUtil;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

class DataSetParameterAdapter {
    static final String BIRT_JS_EXPR = "JS_EXPR";
    private OdaDataSetHandle setHandle = null;
    private DataSetDesign setDesign = null;
    private List userDefinedParams = null;
    private List setDefinedParams = null;

    DataSetParameterAdapter(OdaDataSetHandle setHandle, DataSetDesign setDesign) {
        this.setHandle = setHandle;
        this.setDesign = setDesign;
        Iterator tmpParams = setHandle.parametersIterator();
        this.setDefinedParams = new ArrayList();
        while (tmpParams.hasNext()) {
            this.setDefinedParams.add(tmpParams.next());
        }
    }

    private ParameterDefinition newParameterDefinition(OdaDataSetParameterHandle paramHandle, ParameterDefinition lastOdaParamDefn) {
        if (paramHandle == null) {
            return null;
        }
        String rptParamName = paramHandle.getParamName();
        ParameterDefinition paramDefn = this.newParameterDefinitionFromDataSetParam(paramHandle, lastOdaParamDefn);
        if (StringUtil.isBlank((String)rptParamName)) {
            return paramDefn;
        }
        ModuleHandle module = paramHandle.getElementHandle().getModuleHandle();
        ScalarParameterHandle reportParam = (ScalarParameterHandle)module.findParameter(rptParamName);
        if (reportParam != null) {
            paramDefn = new ReportParameterAdapter().updateParameterDefinitionFromReportParam(paramDefn, reportParam, this.setDesign);
        }
        return paramDefn;
    }

    private ParameterDefinition newParameterDefinitionFromDataSetParam(OdaDataSetParameterHandle paramHandle, ParameterDefinition lastOdaParamDefn) {
        ParameterDefinition odaParamDefn = null;
        odaParamDefn = lastOdaParamDefn == null ? ODADesignFactory.getFactory().createParameterDefinition() : (ParameterDefinition)EcoreUtil.copy((EObject)lastOdaParamDefn);
        odaParamDefn.setInOutMode(DataSetParameterAdapter.newParameterMode(paramHandle.isInput(), paramHandle.isOutput()));
        odaParamDefn.setAttributes(this.newDataElementAttrs(paramHandle, odaParamDefn.getAttributes()));
        InputParameterAttributes inputAttrs = odaParamDefn.getInputAttributes();
        if (inputAttrs == null) {
            inputAttrs = ODADesignFactory.getFactory().createInputParameterAttributes();
            odaParamDefn.setInputAttributes(inputAttrs);
        }
        inputAttrs.setElementAttributes(this.newInputElementAttrs((DataSetParameterHandle)paramHandle, inputAttrs.getElementAttributes()));
        return odaParamDefn;
    }

    private static ParameterMode newParameterMode(boolean isInput, boolean isOutput) {
        int mode = 0;
        if (isOutput && isInput) {
            mode = 2;
        } else if (isOutput) {
            mode = 1;
        } else if (isInput) {
            mode = 0;
        }
        return ParameterMode.get((int)mode);
    }

    private DataElementAttributes newDataElementAttrs(OdaDataSetParameterHandle paramDefn, DataElementAttributes lastDataAttrs) {
        Integer nativeDataType;
        DataElementAttributes dataAttrs = lastDataAttrs;
        if (dataAttrs == null) {
            dataAttrs = ODADesignFactory.getFactory().createDataElementAttributes();
        }
        dataAttrs.setNullability(DataSetParameterAdapter.newElementNullability(paramDefn.allowNull()));
        Integer position = paramDefn.getPosition();
        if (position != null) {
            dataAttrs.setPosition(position.intValue());
        }
        if ((nativeDataType = paramDefn.getNativeDataType()) != null) {
            dataAttrs.setNativeDataTypeCode(nativeDataType.intValue());
        }
        dataAttrs.setName(paramDefn.getNativeName());
        return dataAttrs;
    }

    static ElementNullability newElementNullability(boolean isNullable) {
        int nullAbility = 0;
        if (isNullable) {
            nullAbility = 1;
        }
        return ElementNullability.get((int)nullAbility);
    }

    private void updateROMDataSetParameterDirection(ParameterMode paramMode, ParameterMode cachedParamMode, OdaDataSetParameter setParam) {
        int oldDirection;
        if (cachedParamMode == null) {
            this.updateROMParameterMode((DataSetParameter)setParam, paramMode);
            return;
        }
        int newDirerction = paramMode.getValue();
        if (newDirerction != (oldDirection = cachedParamMode.getValue())) {
            this.updateROMParameterMode((DataSetParameter)setParam, paramMode);
        }
        if ((oldDirection == 0 || oldDirection == 2) && newDirerction == 1) {
            setParam.setParamName(null);
        }
    }

    private void updateROMDataSetParameterFromDataAttrs(DataElementAttributes dataAttrs, DataElementAttributes cachedDataAttrs, OdaDataSetParameter setParam, String dataSourceId, String dataSetId) {
        String dataType;
        if (dataAttrs == null) {
            return;
        }
        this.updateROMNullability((DataSetParameter)setParam, dataAttrs.getNullability(), cachedDataAttrs == null ? null : cachedDataAttrs.getNullability());
        Object oldValue = cachedDataAttrs == null ? null : cachedDataAttrs.getName();
        Object newValue = dataAttrs.getName();
        if (oldValue == null || !oldValue.equals(newValue)) {
            setParam.setNativeName((String)newValue);
        }
        oldValue = cachedDataAttrs == null ? null : new Integer(cachedDataAttrs.getPosition());
        newValue = new Integer(dataAttrs.getPosition());
        if (oldValue == null || !oldValue.equals(newValue)) {
            setParam.setPosition((Integer)newValue);
        }
        oldValue = cachedDataAttrs == null ? null : new Integer(cachedDataAttrs.getNativeDataTypeCode());
        newValue = new Integer(dataAttrs.getNativeDataTypeCode());
        if (oldValue == null || !oldValue.equals(newValue) || setParam.getNativeDataType() == null) {
            setParam.setNativeDataType((Integer)newValue);
        }
        if ((dataType = DataSetParameterAdapter.getROMDataType(dataSourceId, dataSetId, setParam, this.setDefinedParams.iterator())) == null || !"boolean".equalsIgnoreCase(dataType)) {
            setParam.setParameterDataType(dataType);
        }
    }

    private void updateROMDataSetParameterName(DataElementAttributes dataAttrs, OdaDataSetParameter setParam, List retList) {
        if (dataAttrs == null) {
            return;
        }
        String nativeName = dataAttrs.getName();
        String name = setParam.getName();
        if (StringUtil.isBlank((String)name)) {
            setParam.setName(nativeName);
        }
        setParam.setNativeName(nativeName);
    }

    private void updateROMDataSetParameterFromInputParamAttrs(InputParameterAttributes paramAttrs, InputParameterAttributes cachedParamAttrs, OdaDataSetParameter setParam) {
        if (paramAttrs == null) {
            return;
        }
        InputElementAttributes inputElementAttrs = paramAttrs.getElementAttributes();
        if (inputElementAttrs == null) {
            return;
        }
        this.updateROMDataSetParameterFromInputElementAttrs(inputElementAttrs, cachedParamAttrs == null ? null : cachedParamAttrs.getElementAttributes(), setParam);
    }

    private void updateROMDataSetParameterFromInputElementAttrs(InputElementAttributes elementAttrs, InputElementAttributes cachedElementAttrs, OdaDataSetParameter setParam) {
        boolean withLinkedParameter;
        if (elementAttrs == null) {
            return;
        }
        String oldValue = cachedElementAttrs == null ? null : cachedElementAttrs.getDefaultScalarValue();
        Object newValue = elementAttrs.getDefaultScalarValue();
        boolean bl = withLinkedParameter = !StringUtil.isBlank((String)setParam.getParamName());
        if (!(oldValue != null && oldValue.equals(newValue) || withLinkedParameter)) {
            this.setROMDefaultValue((DataSetParameter)setParam, (String)newValue);
        }
        oldValue = cachedElementAttrs == null ? null : Boolean.valueOf(cachedElementAttrs.isOptional());
        newValue = elementAttrs.isOptional();
        if (oldValue == null || !oldValue.equals(newValue)) {
            setParam.setIsOptional(((Boolean)newValue).booleanValue());
        }
    }

    private void updateReportParameter(ParameterDefinition odaParamDefn, ParameterDefinition cachedParamDefn, String dataType) throws SemanticException {
        ScalarParameterHandle paramHandle;
        String reportParamName;
        DataElementAttributes dataAttrs = odaParamDefn.getAttributes();
        if (dataAttrs == null) {
            return;
        }
        ModuleHandle module = this.setHandle.getModuleHandle();
        OdaDataSetParameterHandle paramDefn = DataSetParameterAdapter.findDataSetParameterByName(dataAttrs.getName(), new Integer(dataAttrs.getPosition()), new Integer(dataAttrs.getNativeDataTypeCode()), this.setDefinedParams.iterator());
        if (paramDefn != null && !StringUtil.isBlank((String)(reportParamName = paramDefn.getParamName())) && (paramHandle = (ScalarParameterHandle)module.findParameter(reportParamName)) != null) {
            new ReportParameterAdapter().updateLinkedReportParameter(paramHandle, odaParamDefn, cachedParamDefn, dataType, this.setHandle);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static OdaDataSetParameterHandle findDataSetParameterByName(String dataSetParamName, Integer position, Integer nativeDataType, Iterator params) {
        if (position != null) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            param = (OdaDataSetParameterHandle)params.next();
            tmpNativeDataType = param.getNativeDataType();
            tmpNativeName = param.getNativeName();
            if (!StringUtil.isBlank((String)tmpNativeName) && (tmpNativeName == null || !tmpNativeName.equals(dataSetParamName)) || !position.equals(param.getPosition()) || tmpNativeDataType != null && !tmpNativeDataType.equals(nativeDataType)) continue;
            return param;
lbl8:
            // 2 sources

            ** while (params.hasNext())
        }
lbl9:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static OdaDataSetParameter findDataSetParameterByPosition(Iterator params, Integer position) {
        if (position != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            param = (OdaDataSetParameter)params.next();
            pos = param.getPosition();
            if (!position.equals(pos)) continue;
            return param;
lbl7:
            // 2 sources

            ** while (params.hasNext())
        }
lbl8:
        // 1 sources

        return null;
    }

    static String getROMDataType(String dataSourceId, String dataSetId, OdaDataSetParameter param, Iterator setHandleParams) {
        String name = param.getNativeName();
        Integer position = param.getPosition();
        Integer nativeType = param.getNativeDataType();
        if (nativeType == null) {
            return param.getParameterDataType();
        }
        OdaDataSetParameterHandle tmpParam = DataSetParameterAdapter.findDataSetParameterByName(name, position, nativeType, setHandleParams);
        if (tmpParam == null) {
            return DataSetParameterAdapter.convertNativeTypeToROMDataType(dataSourceId, dataSetId, nativeType);
        }
        Integer tmpPosition = tmpParam.getPosition();
        if (tmpPosition == null) {
            return DataSetParameterAdapter.convertNativeTypeToROMDataType(dataSourceId, dataSetId, nativeType);
        }
        if (!tmpPosition.equals(param.getPosition())) {
            return DataSetParameterAdapter.convertNativeTypeToROMDataType(dataSourceId, dataSetId, nativeType);
        }
        Integer tmpNativeCodeType = tmpParam.getNativeDataType();
        if (tmpNativeCodeType == null || tmpNativeCodeType.equals(nativeType)) {
            return tmpParam.getParameterDataType();
        }
        String oldDataType = tmpParam.getParameterDataType();
        return DataSetParameterAdapter.convertNativeTypeToROMDataType(dataSourceId, dataSetId, nativeType, oldDataType);
    }

    private static String convertNativeTypeToROMDataType(String dataSourceId, String dataSetId, int nativeDataTypeCode) {
        return DataSetParameterAdapter.convertNativeTypeToROMDataType(dataSourceId, dataSetId, nativeDataTypeCode, null);
    }

    private static String convertNativeTypeToROMDataType(String dataSourceId, String dataSetId, int nativeDataTypeCode, String romDataType) {
        String romNewDataType = null;
        try {
            romNewDataType = NativeDataTypeUtil.getUpdatedDataType(dataSourceId, dataSetId, nativeDataTypeCode, romDataType, "paramType");
        }
        catch (BirtException birtException) {}
        return romNewDataType;
    }

    private void updateROMParameterMode(DataSetParameter romParamDefn, ParameterMode odaMode) {
        if (odaMode == null) {
            return;
        }
        switch (odaMode.getValue()) {
            case 2: {
                romParamDefn.setIsInput(true);
                romParamDefn.setIsOutput(true);
                break;
            }
            case 0: {
                romParamDefn.setIsInput(true);
                break;
            }
            case 1: {
                romParamDefn.setIsOutput(true);
            }
        }
    }

    private void updateROMNullability(DataSetParameter romParamDefn, ElementNullability nullability, ElementNullability cachedNullability) {
        if (nullability == null) {
            return;
        }
        if (cachedNullability != null && cachedNullability.getValue() == nullability.getValue()) {
            return;
        }
        switch (nullability.getValue()) {
            case 1: {
                romParamDefn.setAllowNull(true);
                break;
            }
            case 2: {
                romParamDefn.setAllowNull(false);
                break;
            }
        }
    }

    private InputElementAttributes newInputElementAttrs(DataSetParameterHandle paramDefn, InputElementAttributes lastInputAttrs) {
        InputElementAttributes inputAttrs = lastInputAttrs;
        if (inputAttrs == null) {
            inputAttrs = ODADesignFactory.getFactory().createInputElementAttributes();
        }
        this.setDefaultScalarValue(inputAttrs, paramDefn.getParameterDataType(), paramDefn.getDefaultValue());
        inputAttrs.setOptional(paramDefn.isOptional());
        return inputAttrs;
    }

    List newROMSetParams(DataSetParameters cachedDataSetParameters) throws SemanticException {
        if (this.setDesign == null) {
            return null;
        }
        List definedParamList = this.newRomSetParams(cachedDataSetParameters);
        if (this.setDefinedParams.isEmpty() && this.userDefinedParams == null) {
            return definedParamList;
        }
        return this.mergeUserDefindAndDriverDefinedParameter(definedParamList);
    }

    private List newRomSetParams(DataSetParameters cachedDataSetParameters) throws SemanticException {
        ArrayList<OdaDataSetParameter> retList = new ArrayList<OdaDataSetParameter>();
        DataSetParameters odaSetParams = this.setDesign.getParameters();
        if (odaSetParams == null) {
            return null;
        }
        EList odaParams = odaSetParams.getParameterDefinitions();
        if (odaParams == null || odaParams.isEmpty()) {
            return null;
        }
        ArrayList positions = new ArrayList();
        int i = 0;
        while (i < odaParams.size()) {
            ParameterDefinition odaParamDefn = (ParameterDefinition)odaParams.get(i);
            DataElementAttributes dataAttrs = odaParamDefn.getAttributes();
            ParameterDefinition cachedParamDefn = null;
            OdaDataSetParameterHandle oldSetParam = null;
            if (dataAttrs != null) {
                cachedParamDefn = DataSetParameterAdapter.findParameterDefinition(cachedDataSetParameters, dataAttrs.getName(), new Integer(dataAttrs.getPosition()));
                oldSetParam = DataSetParameterAdapter.findDataSetParameterByName(dataAttrs.getName(), new Integer(dataAttrs.getPosition()), new Integer(dataAttrs.getNativeDataTypeCode()), this.setDefinedParams.iterator());
            }
            OdaDataSetParameter setParam = null;
            if (oldSetParam == null) {
                setParam = StructureFactory.createOdaDataSetParameter();
                cachedParamDefn = null;
            } else {
                setParam = (OdaDataSetParameter)oldSetParam.getStructure().copy();
            }
            this.updateROMDataSetParameterDirection(odaParamDefn.getInOutMode(), cachedParamDefn == null ? null : cachedParamDefn.getInOutMode(), setParam);
            this.updateROMDataSetParameterName(dataAttrs, setParam, retList);
            this.updateROMDataSetParameterFromDataAttrs(dataAttrs, cachedParamDefn == null ? null : cachedParamDefn.getAttributes(), setParam, this.setDesign.getOdaExtensionDataSourceId(), this.setDesign.getOdaExtensionDataSetId());
            this.updateAndCheckPosition(positions, (DataSetParameter)setParam, i + 1);
            this.updateROMDataSetParameterFromInputParamAttrs(odaParamDefn.getInputAttributes(), cachedParamDefn == null ? null : cachedParamDefn.getInputAttributes(), setParam);
            if (setParam.getParamName() == null) {
                retList.add(setParam);
            } else {
                this.updateReportParameter(odaParamDefn, cachedParamDefn, setParam.getParameterDataType());
                retList.add(setParam);
            }
            ++i;
        }
        IdentifierUtility.updateParams2UniqueName(retList);
        return retList;
    }

    private void updateAndCheckPosition(List positions, DataSetParameter setParam, int newPos) throws SemanticException {
        Integer pos = setParam.getPosition();
        if (pos == null || pos <= 0) {
            pos = new Integer(newPos);
            setParam.setPosition(pos);
        }
        if (positions.contains(pos)) {
            throw new PropertyValueException(this.setHandle.getElement(), "parameters", (Object)pos, "Error.PropertyValueException.VALUE_EXISTS");
        }
        positions.add(pos);
    }

    static ParameterDefinition findParameterDefinition(DataSetParameters params, String paramName, Integer position) {
        if (params == null) {
            return null;
        }
        if (StringUtil.isBlank((String)paramName) && position == null) {
            return null;
        }
        EList odaParams = params.getParameterDefinitions();
        if (odaParams == null || odaParams.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < odaParams.size()) {
            ParameterDefinition odaParamDefn = (ParameterDefinition)odaParams.get(i);
            DataElementAttributes dataAttrs = odaParamDefn.getAttributes();
            if (dataAttrs != null && (StringUtil.isBlank((String)paramName) ? ReportParameterAdapter.isEquals(paramName, dataAttrs.getName()) && position.intValue() == dataAttrs.getPosition() : paramName.equals(dataAttrs.getName()))) {
                return odaParamDefn;
            }
            ++i;
        }
        return null;
    }

    static ParameterDefinition findParameterDefinition(DataSetParameters params, Integer position) {
        if (params == null) {
            return null;
        }
        if (position == null) {
            return null;
        }
        EList odaParams = params.getParameterDefinitions();
        if (odaParams == null || odaParams.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < odaParams.size()) {
            ParameterDefinition odaParamDefn = (ParameterDefinition)odaParams.get(i);
            DataElementAttributes dataAttrs = odaParamDefn.getAttributes();
            if (dataAttrs != null && position.intValue() == dataAttrs.getPosition()) {
                return odaParamDefn;
            }
            ++i;
        }
        return null;
    }

    DataSetParameters newOdaDataSetParams(DataSetParameters lastParameters) {
        if (this.setDefinedParams.isEmpty()) {
            return null;
        }
        DataSetParameters odaSetParams = ODADesignFactory.getFactory().createDataSetParameters();
        EList params = odaSetParams.getParameterDefinitions();
        int i = 0;
        while (i < this.setDefinedParams.size()) {
            OdaDataSetParameterHandle paramDefn = (OdaDataSetParameterHandle)this.setDefinedParams.get(i);
            String nativeName = paramDefn.getNativeName();
            ParameterDefinition lastOdaParamDefn = DataSetParameterAdapter.findParameterDefinition(lastParameters, nativeName, paramDefn.getPosition());
            ParameterDefinition odaParamDefn = this.newParameterDefinition(paramDefn, lastOdaParamDefn);
            if (nativeName == null) {
                nativeName = "";
            }
            odaParamDefn.getAttributes().setName(nativeName);
            params.add((Object)odaParamDefn);
            ++i;
        }
        return odaSetParams;
    }

    private void setROMDefaultValue(DataSetParameter setParam, String literalValue) {
        if (BIRT_JS_EXPR.equalsIgnoreCase(literalValue)) {
            return;
        }
        String romDefaultValue = DataSetParameterAdapter.needsQuoteDelimiters(setParam.getParameterDataType()) ? ParameterValueUtil.toJsExprValue(literalValue) : literalValue;
        setParam.setDefaultValue(romDefaultValue);
    }

    private void setDefaultScalarValue(InputElementAttributes elementAttrs, String dataType, String value) {
        String literalValue = value;
        if (DataSetParameterAdapter.needsQuoteDelimiters(dataType)) {
            literalValue = ParameterValueUtil.isQuoted(value) ? ParameterValueUtil.toLiteralValue(value) : BIRT_JS_EXPR;
        }
        elementAttrs.setDefaultScalarValue(literalValue);
    }

    static boolean needsQuoteDelimiters(String romDataType) {
        boolean needs = false;
        if ("string".equals(romDataType)) {
            needs = true;
        } else if ("dateTime".equals(romDataType)) {
            needs = true;
        } else if ("date".equals(romDataType)) {
            needs = true;
        } else if ("time".equals(romDataType)) {
            needs = true;
        } else if ("any".equals(romDataType)) {
            needs = true;
        }
        return needs;
    }

    private List mergeUserDefindAndDriverDefinedParameter(List paramList) throws SemanticException {
        ArrayList<OdaDataSetParameter> resultList = new ArrayList<OdaDataSetParameter>();
        if (paramList == null && this.userDefinedParams == null) {
            return resultList;
        }
        if (paramList == null) {
            return this.userDefinedParams;
        }
        if (this.userDefinedParams == null) {
            return paramList;
        }
        Iterator iterator = paramList.iterator();
        ArrayList<Integer> positionList = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            OdaDataSetParameter param = (OdaDataSetParameter)iterator.next();
            Integer pos = param.getPosition();
            OdaDataSetParameter userParam = DataSetParameterAdapter.findDataSetParameterByPosition(this.userDefinedParams.iterator(), pos);
            positionList.add(pos);
            if (userParam == null) {
                resultList.add(param);
                continue;
            }
            if (userParam.getNativeDataType() != null && !userParam.getNativeDataType().equals(param.getNativeDataType())) {
                userParam.setParameterDataType(param.getParameterDataType());
                userParam.setNativeDataType(param.getNativeDataType());
            }
            resultList.add(userParam);
        }
        Iterator userIterator = this.userDefinedParams.iterator();
        while (userIterator.hasNext()) {
            OdaDataSetParameter userParam = (OdaDataSetParameter)userIterator.next();
            Integer pos = userParam.getPosition();
            if (positionList.contains(pos)) continue;
            resultList.add(userParam);
        }
        return resultList;
    }

    private List getPositions(DataSetParameters params) {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        if (params == null) {
            return resultList;
        }
        EList odaDefns = params.getParameterDefinitions();
        int i = 0;
        while (odaDefns != null && i < odaDefns.size()) {
            ParameterDefinition paramDefn = (ParameterDefinition)odaDefns.get(i);
            DataElementAttributes dataAttrs = paramDefn.getAttributes();
            if (dataAttrs != null) {
                resultList.add(new Integer(dataAttrs.getPosition()));
            }
            ++i;
        }
        return resultList;
    }

    static List getDriverDefinedParameters(EList designParams, List userDefinedList) throws SemanticException {
        ArrayList<EObject> resultList = new ArrayList<EObject>();
        List posList = DataSetParameterAdapter.getPositions(userDefinedList);
        int i = 0;
        while (designParams != null && i < designParams.size()) {
            int pos;
            ParameterDefinition definition = (ParameterDefinition)designParams.get(i);
            DataElementAttributes dataAttrs = definition.getAttributes();
            if (dataAttrs != null && !posList.contains(new Integer(pos = dataAttrs.getPosition()))) {
                resultList.add(EcoreUtil.copy((EObject)definition));
            }
            ++i;
        }
        return resultList;
    }

    private static List getPositions(List paramList) {
        ArrayList<Integer> posList = new ArrayList<Integer>();
        if (paramList == null) {
            return posList;
        }
        Iterator paramIterator = paramList.iterator();
        while (paramIterator.hasNext()) {
            OdaDataSetParameter parameter = (OdaDataSetParameter)paramIterator.next();
            posList.add(parameter.getPosition());
        }
        return posList;
    }

    public void updateRomDataSetParamsWithNewParams(List newParams) throws SemanticException {
        PropertyHandle propertyHandle = this.setHandle.getPropertyHandle("parameters");
        Iterator iterator = this.setDefinedParams.iterator();
        ArrayList<OdaDataSetParameter> nameList = new ArrayList<OdaDataSetParameter>();
        ArrayList propList = null;
        while (iterator.hasNext()) {
            DataSetParameterHandle dsParamHandle = (DataSetParameterHandle)iterator.next();
            if (propList == null) {
                Iterator propIterator = dsParamHandle.getDefn().getPropertyIterator();
                propList = new ArrayList();
                while (propIterator.hasNext()) {
                    propList.add(propIterator.next());
                }
            }
            String name = dsParamHandle.getName();
            OdaDataSetParameter odaDsParam = null;
            int i = 0;
            while (i < newParams.size()) {
                odaDsParam = (OdaDataSetParameter)newParams.get(i);
                String odaName = odaDsParam.getName();
                if (name.equalsIgnoreCase(odaName)) {
                    nameList.add(odaDsParam);
                    break;
                }
                odaDsParam = null;
                ++i;
            }
            if (odaDsParam != null) {
                this.updateROMDataSetParamWithNewParam(odaDsParam, dsParamHandle, propList);
                continue;
            }
            propertyHandle.removeItem((Object)dsParamHandle.getStructure());
        }
        int i = 0;
        while (i < newParams.size()) {
            OdaDataSetParameter odaDsParam = (OdaDataSetParameter)newParams.get(i);
            if (!nameList.contains(odaDsParam)) {
                propertyHandle.addItem((IStructure)odaDsParam);
            }
            ++i;
        }
    }

    private void updateROMDataSetParamWithNewParam(OdaDataSetParameter odaDsParam, DataSetParameterHandle dsParamHandle, List propList) throws SemanticException {
        int i = 0;
        while (i < propList.size()) {
            PropertyDefn propDefn = (PropertyDefn)propList.get(i);
            String memberName = propDefn.getName();
            if (!"name".equals(memberName)) {
                Object value = odaDsParam.getLocalProperty(null, memberName);
                dsParamHandle.setProperty(memberName, value);
            }
            ++i;
        }
    }

    void updateUserDefinedParameter(DataSetParameters parameters) {
        this.userDefinedParams = new ArrayList();
        if (parameters == null) {
            int i = 0;
            while (i < this.setDefinedParams.size()) {
                this.userDefinedParams.add(((OdaDataSetParameterHandle)this.setDefinedParams.get(i)).getStructure());
                ++i;
            }
        } else {
            List posList = this.getPositions(parameters);
            int i = 0;
            while (i < this.setDefinedParams.size()) {
                OdaDataSetParameterHandle paramHandle = (OdaDataSetParameterHandle)this.setDefinedParams.get(i);
                Integer position = paramHandle.getPosition();
                if (position != null && !posList.contains(position)) {
                    this.userDefinedParams.add(paramHandle.getStructure());
                }
                ++i;
            }
        }
    }

    OdaDataSetHandle getSetHandle() {
        return this.setHandle;
    }

    List getUserDefinedParams() {
        return this.userDefinedParams;
    }
}

