/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DateFormatFactory;
import org.eclipse.birt.core.data.DateFormatISO8601;
import org.eclipse.birt.core.data.DateUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.i18n.ResourceHandle;
import org.eclipse.birt.core.script.JavascriptEvalUtil;

public final class DataTypeUtil {
    private static ULocale DEFAULT_LOCALE = ULocale.US;
    private static Map dfMap = new HashMap();
    private static int DEFAULT_DATE_STYLE = 0;
    public static ResourceBundle resourceBundle = new ResourceHandle(ULocale.getDefault()).getUResourceBundle();
    public static long count = 0L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    public static Object convert(Object source, int toType) throws BirtException {
        if (source == null) {
            return null;
        }
        source = JavascriptEvalUtil.convertJavascriptValue(source);
        if (toType == -1 || toType == 0) {
            return source;
        }
        switch (toType) {
            case 2: {
                return DataTypeUtil.toInteger(source);
            }
            case 4: {
                return DataTypeUtil.toBigDecimal(source);
            }
            case 1: {
                return DataTypeUtil.toBoolean(source);
            }
            case 6: {
                return DataTypeUtil.toDate(source);
            }
            case 3: {
                return DataTypeUtil.toDouble(source);
            }
            case 5: {
                return DataTypeUtil.toString(source);
            }
            case 7: {
                return DataTypeUtil.toBlob(source);
            }
            case 8: {
                return DataTypeUtil.toBytes(source);
            }
            case 9: {
                return DataTypeUtil.toSqlDate(source);
            }
            case 10: {
                return DataTypeUtil.toSqlTime(source);
            }
        }
        throw new CoreException("INVALID_TYPE", (Object)resourceBundle);
    }

    public static Object convert(Object source, Class toTypeClass) throws BirtException {
        if (toTypeClass == DataType.getClass(0)) {
            return source;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (toTypeClass == clazz) {
            return DataTypeUtil.toInteger(source);
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (toTypeClass == clazz2) {
            return DataTypeUtil.toBigDecimal(source);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (toTypeClass == clazz3) {
            return DataTypeUtil.toBoolean(source);
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (toTypeClass == clazz4) {
            return DataTypeUtil.toSqlTime(source);
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (toTypeClass == clazz5) {
            return DataTypeUtil.toSqlDate(source);
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (toTypeClass == clazz6) {
            return DataTypeUtil.toDate(source);
        }
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (toTypeClass == clazz7) {
            return DataTypeUtil.toDate(source);
        }
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (toTypeClass == clazz8) {
            return DataTypeUtil.toDouble(source);
        }
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (toTypeClass == clazz9) {
            return DataTypeUtil.toString(source);
        }
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("java.sql.Blob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (toTypeClass == clazz10) {
            return DataTypeUtil.toBlob(source);
        }
        throw new CoreException("INVALID_TYPE", (Object)resourceBundle);
    }

    public static Integer toInteger(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Integer) {
            return (Integer)source;
        }
        if (source instanceof Number) {
            int intValue = ((Number)source).intValue();
            return new Integer(intValue);
        }
        if (source instanceof Boolean) {
            if (((Boolean)source).booleanValue()) {
                return new Integer(1);
            }
            return new Integer(0);
        }
        if (source instanceof java.util.Date) {
            long longValue = ((java.util.Date)source).getTime();
            return new Integer((int)longValue);
        }
        if (source instanceof String) {
            try {
                return new Integer(Double.valueOf((String)source).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Integer"});
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Integer"});
    }

    public static BigDecimal toBigDecimal(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof BigDecimal) {
            return (BigDecimal)source;
        }
        if (source instanceof Number) {
            String str = ((Number)source).toString();
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException("CONVERT_FAILS", new Object[]{str, "BigDecimal"});
            }
        }
        if (source instanceof Boolean) {
            if (((Boolean)source).booleanValue()) {
                return new BigDecimal(1.0);
            }
            return new BigDecimal(0.0);
        }
        if (source instanceof java.util.Date) {
            long longValue = ((java.util.Date)source).getTime();
            return new BigDecimal((double)longValue);
        }
        if (source instanceof String) {
            try {
                return new BigDecimal((String)source);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "BigDecimal"});
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "BigDecimal"});
    }

    public static Boolean toBoolean(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Boolean) {
            return (Boolean)source;
        }
        if (source instanceof Number) {
            if (((Number)source).doubleValue() == 0.0) {
                return new Boolean(false);
            }
            return new Boolean(true);
        }
        if (source instanceof String) {
            if (((String)source).equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (((String)source).equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            try {
                if (Integer.parseInt((String)source) == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Boolean"});
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Boolean"});
    }

    public static java.util.Date toDate(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof java.util.Date) {
            return new java.util.Date(((java.util.Date)source).getTime());
        }
        if (source instanceof String) {
            return DataTypeUtil.toDate((String)source);
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
    }

    public static Time toSqlTime(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof java.util.Date) {
            return new Time(((java.util.Date)source).getTime());
        }
        if (source instanceof String) {
            try {
                return new Time(DataTypeUtil.toDate((String)source).getTime());
            }
            catch (Exception exception) {
                try {
                    return Time.valueOf((String)source);
                }
                catch (Exception exception2) {}
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Time"});
    }

    public static Date toSqlDate(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof java.util.Date) {
            return new Date(((java.util.Date)source).getTime());
        }
        if (source instanceof String) {
            try {
                return new Date(DataTypeUtil.toDate((String)source).getTime());
            }
            catch (Exception exception) {
                try {
                    return Date.valueOf((String)source);
                }
                catch (Exception exception2) {}
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "java.sql.Date"});
    }

    public static java.util.Date toDate(String source, Locale locale) throws BirtException {
        return DataTypeUtil.toDate(source, ULocale.forLocale((Locale)locale));
    }

    public static java.util.Date toDate(String source, ULocale locale) throws BirtException {
        if (source == null) {
            return null;
        }
        DateFormat dateFormat = null;
        java.util.Date resultDate = null;
        boolean existTime = source.matches(".*[0-9]+:[0-9]+:[0-9]+.*") || source.matches(".*[0-9]+:[0-9]+.*");
        int i = DEFAULT_DATE_STYLE;
        while (i <= 3) {
            int j = DEFAULT_DATE_STYLE;
            while (j <= 3) {
                dateFormat = DateFormatFactory.getDateTimeInstance(i, j, locale);
                try {
                    resultDate = dateFormat.parse(source);
                    return resultDate;
                }
                catch (ParseException parseException) {
                    ++j;
                }
            }
            if (!existTime) {
                dateFormat = DateFormatFactory.getDateInstance(i, locale);
                try {
                    resultDate = dateFormat.parse(source);
                    return resultDate;
                }
                catch (ParseException parseException) {}
            }
            ++i;
        }
        if (resultDate == null) {
            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
        }
        return resultDate;
    }

    public static java.util.Date toDateWithCheck(String source, Locale locale) throws BirtException {
        return DataTypeUtil.toDateWithCheck(source, ULocale.forLocale((Locale)locale));
    }

    public static java.util.Date toDateWithCheck(String source, ULocale locale) throws BirtException {
        DateFormat dateFormat = DateFormatFactory.getDateInstance(3, locale);
        java.util.Date resultDate = null;
        try {
            resultDate = dateFormat.parse(source);
        }
        catch (ParseException parseException) {
            return DataTypeUtil.toDate(source, locale);
        }
        if (!DateUtil.checkValid(dateFormat, source)) {
            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
        }
        return resultDate;
    }

    public static Double toDouble(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Double) {
            return (Double)source;
        }
        if (source instanceof Number) {
            double doubleValue = ((Number)source).doubleValue();
            return new Double(doubleValue);
        }
        if (source instanceof Boolean) {
            if (((Boolean)source).booleanValue()) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        if (source instanceof java.util.Date) {
            double doubleValue = ((java.util.Date)source).getTime();
            return new Double(doubleValue);
        }
        if (source instanceof String) {
            try {
                return Double.valueOf((String)source);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Double"});
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Double"});
    }

    public static String toString(Object source) throws BirtException {
        return DataTypeUtil.toString(source, ULocale.getDefault());
    }

    public static String toString(Object source, Locale locale) throws BirtException {
        return DataTypeUtil.toString(source, ULocale.forLocale((Locale)locale));
    }

    public static String toString(Object source, ULocale locale) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Time) {
            return ((Time)source).toString();
        }
        if (source instanceof Date) {
            return ((Date)source).toString();
        }
        if (source instanceof Timestamp) {
            return ((Timestamp)source).toString();
        }
        if (source instanceof java.util.Date) {
            return DataTypeUtil.toString((java.util.Date)source, locale);
        }
        String str = "";
        if (source instanceof byte[]) {
            byte[] sourceValue = (byte[])source;
            int length = Math.min(sourceValue.length, 8);
            int i = 0;
            while (i < length) {
                str = String.valueOf(str) + Integer.toHexString(sourceValue[i]).toUpperCase() + " ";
                ++i;
            }
            if (sourceValue.length > 8) {
                str = String.valueOf(str) + "...";
            }
        } else {
            str = source.toString();
        }
        return str;
    }

    public static Blob toBlob(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Blob) {
            return (Blob)source;
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Blob"});
    }

    public static byte[] toBytes(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Binary"});
    }

    public static int toApiDataType(Class clazz) {
        if (clazz == null) {
            return -1;
        }
        Class<?> clazz2 = class$10;
        if (clazz2 == null) {
            try {
                clazz2 = class$10 = Class.forName("org.eclipse.birt.core.data.DataType$AnyType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return 0;
        }
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(clazz)) {
            return 2;
        }
        Class<?> clazz4 = class$7;
        if (clazz4 == null) {
            try {
                clazz4 = class$7 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.isAssignableFrom(clazz)) {
            return 3;
        }
        Class<?> clazz5 = class$8;
        if (clazz5 == null) {
            try {
                clazz5 = class$8 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz5.isAssignableFrom(clazz)) {
            return 5;
        }
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz6.isAssignableFrom(clazz)) {
            return 4;
        }
        Class<?> clazz7 = class$4;
        if (clazz7 == null) {
            try {
                clazz7 = class$4 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz7) {
            return 9;
        }
        Class<?> clazz8 = class$3;
        if (clazz8 == null) {
            try {
                clazz8 = class$3 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz8) {
            return 10;
        }
        Class<?> clazz9 = class$6;
        if (clazz9 == null) {
            try {
                clazz9 = class$6 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz9.isAssignableFrom(clazz)) {
            return 6;
        }
        Class<?> clazz10 = class$11;
        if (clazz10 == null) {
            try {
                clazz10 = class$11 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz10.isAssignableFrom(clazz)) {
            return 8;
        }
        Class<?> clazz11 = class$12;
        if (clazz11 == null) {
            try {
                clazz11 = class$12 = Class.forName("java.sql.Clob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz11.isAssignableFrom(clazz) || clazz.getName().equals("org.eclipse.datatools.connectivity.oda.IClob")) {
            return 5;
        }
        Class<?> clazz12 = class$9;
        if (clazz12 == null) {
            try {
                clazz12 = class$9 = Class.forName("java.sql.Blob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz12.isAssignableFrom(clazz) || clazz.getName().equals("org.eclipse.datatools.connectivity.oda.IBlob")) {
            return 8;
        }
        Class<?> clazz13 = class$2;
        if (clazz13 == null) {
            try {
                clazz13 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz13) {
            return 1;
        }
        return -1;
    }

    public static int toApiDataType(int odaDataTypeCode) throws BirtException {
        Class odiTypeClass = DataTypeUtil.toOdiTypeClass(odaDataTypeCode);
        return DataTypeUtil.toApiDataType(odiTypeClass);
    }

    public static Object toAutoValue(Object evaValue) {
        if (evaValue == null) {
            return null;
        }
        Object value = null;
        if (evaValue instanceof String) {
            String stringValue = (String)evaValue;
            value = DataTypeUtil.toIntegerValue(evaValue);
            if (value == null) {
                try {
                    value = Double.valueOf(stringValue);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        value = new BigDecimal(stringValue);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        try {
                            value = DataTypeUtil.toDate(stringValue);
                        }
                        catch (BirtException birtException) {
                            value = evaValue;
                        }
                    }
                }
            }
        }
        return value;
    }

    public static Integer toIntegerValue(Object evaValue) {
        Integer value = null;
        if (evaValue instanceof String) {
            String stringValue = evaValue.toString();
            try {
                value = Integer.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double ddValue = Double.valueOf(stringValue);
                    int intValue = ddValue.intValue();
                    double doubleValue = ddValue;
                    value = Math.abs((double)intValue - doubleValue) < 1.0E-7 ? Integer.valueOf(String.valueOf(intValue)) : null;
                }
                catch (NumberFormatException numberFormatException2) {
                    value = null;
                }
            }
        }
        return value;
    }

    private static java.util.Date toDate(String source) throws BirtException {
        try {
            return DataTypeUtil.toDateISO8601(source);
        }
        catch (BirtException birtException) {
            try {
                return DataTypeUtil.toDate(source, ULocale.getDefault());
            }
            catch (BirtException birtException2) {
                return DataTypeUtil.toDate(source, DEFAULT_LOCALE);
            }
        }
    }

    private static java.util.Date toDateISO8601(String source) throws BirtException {
        java.util.Date resultDate = null;
        try {
            resultDate = DateFormatISO8601.parse(source);
            return resultDate;
        }
        catch (ParseException parseException) {
            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(java.util.Date source, ULocale locale) {
        DateFormatter df = null;
        df = (DateFormatter)dfMap.get(locale);
        if (df == null) {
            Map map = dfMap;
            synchronized (map) {
                df = (DateFormatter)dfMap.get(locale);
                if (df == null) {
                    df = new DateFormatter(locale);
                    dfMap.put(locale, df);
                }
            }
        }
        return df.format(source);
    }

    public static Class toOdiTypeClass(int odaDataTypeCode) throws BirtException {
        if (odaDataTypeCode != 1 && odaDataTypeCode != 4 && odaDataTypeCode != 8 && odaDataTypeCode != 3 && odaDataTypeCode != 91 && odaDataTypeCode != 92 && odaDataTypeCode != 93 && odaDataTypeCode != 2004 && odaDataTypeCode != 2005 && odaDataTypeCode != 16 && odaDataTypeCode != 0) {
            throw new CoreException("INVALID_TYPE");
        }
        Class<?> fieldClass = null;
        switch (odaDataTypeCode) {
            case 1: {
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = class$8 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fieldClass = clazz;
                break;
            }
            case 4: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fieldClass = clazz;
                break;
            }
            case 8: {
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fieldClass = clazz;
                break;
            }
            case 3: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fieldClass = clazz;
                break;
            }
            case 91: {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.sql.Date");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fieldClass = clazz;
                break;
            }
            case 92: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.sql.Time");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fieldClass = clazz;
                break;
            }
            case 93: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.sql.Timestamp");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fieldClass = clazz;
                break;
            }
            case 2004: {
                Class<?> clazz = class$9;
                if (clazz == null) {
                    try {
                        clazz = class$9 = Class.forName("java.sql.Blob");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fieldClass = clazz;
                break;
            }
            case 2005: {
                Class<?> clazz = class$12;
                if (clazz == null) {
                    try {
                        clazz = class$12 = Class.forName("java.sql.Clob");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fieldClass = clazz;
                break;
            }
            case 16: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fieldClass = clazz;
                break;
            }
            case 0: {
                fieldClass = null;
            }
        }
        return fieldClass;
    }

    public static int toOdaDataType(Class odiTypeClass) {
        int odaType = 1;
        if (odiTypeClass == null) {
            odaType = 1;
        } else {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (odiTypeClass == clazz) {
                odaType = 1;
            } else {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (odiTypeClass == clazz2) {
                    odaType = 4;
                } else {
                    Class<?> clazz3 = class$7;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$7 = Class.forName("java.lang.Double");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (odiTypeClass == clazz3) {
                        odaType = 8;
                    } else {
                        Class<?> clazz4 = class$1;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$1 = Class.forName("java.math.BigDecimal");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (odiTypeClass == clazz4) {
                            odaType = 3;
                        } else {
                            Class<?> clazz5 = class$3;
                            if (clazz5 == null) {
                                try {
                                    clazz5 = class$3 = Class.forName("java.sql.Time");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (odiTypeClass == clazz5) {
                                odaType = 92;
                            } else {
                                Class<?> clazz6 = class$5;
                                if (clazz6 == null) {
                                    try {
                                        clazz6 = class$5 = Class.forName("java.sql.Timestamp");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (odiTypeClass == clazz6) {
                                    odaType = 93;
                                } else {
                                    Class<?> clazz7 = class$4;
                                    if (clazz7 == null) {
                                        try {
                                            clazz7 = class$4 = Class.forName("java.sql.Date");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (odiTypeClass == clazz7) {
                                        odaType = 91;
                                    } else {
                                        Class<?> clazz8 = class$6;
                                        if (clazz8 == null) {
                                            try {
                                                clazz8 = class$6 = Class.forName("java.util.Date");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (odiTypeClass == clazz8) {
                                            odaType = 93;
                                        } else {
                                            Class<?> clazz9 = class$9;
                                            if (clazz9 == null) {
                                                try {
                                                    clazz9 = class$9 = Class.forName("java.sql.Blob");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (odiTypeClass == clazz9) {
                                                odaType = 2004;
                                            } else {
                                                Class<?> clazz10 = class$12;
                                                if (clazz10 == null) {
                                                    try {
                                                        clazz10 = class$12 = Class.forName("java.sql.Clob");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (odiTypeClass == clazz10) {
                                                    odaType = 2005;
                                                } else {
                                                    Class<?> clazz11 = class$2;
                                                    if (clazz11 == null) {
                                                        try {
                                                            clazz11 = class$2 = Class.forName("java.lang.Boolean");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (odiTypeClass == clazz11) {
                                                        odaType = 16;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return odaType;
    }
}

