/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import com.ibm.icu.text.Collator;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.bre.BreUtility;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class BirtComp
extends ScriptableObject {
    private static final long serialVersionUID = 29055295217417372L;
    private static Collator myCollator = Collator.getInstance();

    public BirtComp() {
        this.defineProperty("anyOf", (Object)new Function_AnyOf(), 0);
        this.defineProperty("between", (Object)new Function_Between(true), 0);
        this.defineProperty("notBetween", (Object)new Function_Between(false), 0);
        this.defineProperty("equalTo", (Object)new Function_Compare(0), 0);
        this.defineProperty("greaterThan", (Object)new Function_Compare(2), 0);
        this.defineProperty("lessThan", (Object)new Function_Compare(3), 0);
        this.defineProperty("greaterOrEqual", (Object)new Function_Compare(4), 0);
        this.defineProperty("lessOrEqual", (Object)new Function_Compare(5), 0);
        this.defineProperty("notEqual", (Object)new Function_Compare(1), 0);
        this.defineProperty("like", (Object)new Function_Compare(6), 0);
        this.defineProperty("notLike", (Object)new Function_Compare(8), 0);
        this.defineProperty("match", (Object)new Function_Compare(7), 0);
    }

    private static int compare(Object obj1, Object obj2) throws BirtException {
        if (obj1 == null || obj2 == null) {
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            return 0;
        }
        if (BirtComp.isSameType(obj1, obj2)) {
            if (obj1 instanceof Boolean) {
                if (obj1.equals(obj2)) {
                    return 0;
                }
                Boolean bool = (Boolean)obj1;
                if (bool.equals(Boolean.TRUE)) {
                    return 1;
                }
                return -1;
            }
            if (obj1 instanceof Comparable) {
                if (obj1 instanceof String) {
                    return myCollator.compare(obj1, obj2);
                }
                return ((Comparable)obj1).compareTo(obj2);
            }
            return myCollator.compare(obj1.toString(), obj2.toString());
        }
        if (BirtComp.isNumericOrString(obj1) && BirtComp.isNumericOrString(obj2)) {
            return DataTypeUtil.toDouble(obj1).compareTo(DataTypeUtil.toDouble(obj2));
        }
        if (BirtComp.isDateOrString(obj1) && BirtComp.isDateOrString(obj2)) {
            return DataTypeUtil.toDate(obj1).compareTo(DataTypeUtil.toDate(obj2));
        }
        throw new IllegalArgumentException();
    }

    private static boolean match(Object obj1, Object obj2) throws BirtException {
        if (obj2 == null) {
            throw new IllegalArgumentException("pattern value can not be null!");
        }
        if (obj1 == null) {
            return false;
        }
        String str = obj1.toString();
        String pattern = obj2.toString();
        return str.matches(pattern);
    }

    private static boolean like(Object obj1, Object obj2) {
        if (obj2 == null) {
            throw new IllegalArgumentException("pattern value can not be null!");
        }
        if (obj1 == null) {
            return false;
        }
        String str = obj1.toString();
        String pattern = obj2.toString();
        pattern = pattern.replaceAll("%", ".*");
        pattern = pattern.replaceAll("_", ".");
        return str.matches(pattern);
    }

    private static boolean isSameType(Object resultExpr, Object resultOp1) {
        return resultExpr.getClass().equals(resultOp1.getClass());
    }

    private static boolean isNumericOrString(Object result) {
        return result instanceof Number || result instanceof String;
    }

    private static boolean isDateOrString(Object result) {
        return result instanceof Date || result instanceof String;
    }

    public String getClassName() {
        return "BirtComp";
    }

    private class Function_AnyOf
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        private Function_AnyOf() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length < 2) {
                throw new IllegalArgumentException("The number of argument is incorrect.");
            }
            args = BreUtility.convertToJavaObjects(args);
            int i = 1;
            while (i < args.length) {
                try {
                    if (BirtComp.compare(args[0], args[i]) == 0) {
                        return Boolean.TRUE;
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            return Boolean.FALSE;
        }
    }

    private class Function_Between
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;
        private boolean mode;

        Function_Between(boolean mode) {
            this.mode = mode;
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length != 3) {
                throw new IllegalArgumentException("The number of argument is incorrect.");
            }
            args = BreUtility.convertToJavaObjects(args);
            try {
                Object max;
                Object min;
                if (BirtComp.compare(args[1], args[2]) <= 0) {
                    min = args[1];
                    max = args[2];
                } else {
                    min = args[2];
                    max = args[1];
                }
                return this.mode ? new Boolean(BirtComp.compare(args[0], min) >= 0 && BirtComp.compare(args[0], max) <= 0) : new Boolean(BirtComp.compare(args[0], min) < 0 || BirtComp.compare(args[0], max) > 0);
            }
            catch (BirtException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
        }
    }

    private class Function_Compare
    extends BaseFunction
    implements Function {
        public static final int MODE_EQUAL = 0;
        public static final int MODE_NOT_EQUAL = 1;
        public static final int MODE_GREATERTHAN = 2;
        public static final int MODE_LESSTHAN = 3;
        public static final int MODE_GREATEROREQUAL = 4;
        public static final int MODE_LESSOREQUAL = 5;
        public static final int MODE_LIKE = 6;
        public static final int MODE_MATCH = 7;
        public static final int MODE_NOT_LIKE = 8;
        private static final long serialVersionUID = 1L;
        private int mode;

        Function_Compare(int mode) {
            this.mode = mode;
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args == null || args.length != 2) {
                throw new IllegalArgumentException("The number of argument is incorrect.");
            }
            args = BreUtility.convertToJavaObjects(args);
            try {
                switch (this.mode) {
                    case 0: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) == 0);
                    }
                    case 1: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) != 0);
                    }
                    case 2: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) > 0);
                    }
                    case 3: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) < 0);
                    }
                    case 4: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) >= 0);
                    }
                    case 5: {
                        return new Boolean(BirtComp.compare(args[0], args[1]) <= 0);
                    }
                    case 6: {
                        return new Boolean(BirtComp.like(args[0], args[1]));
                    }
                    case 7: {
                        return new Boolean(BirtComp.match(args[0], args[1]));
                    }
                    case 8: {
                        return new Boolean(!BirtComp.like(args[0], args[1]));
                    }
                }
                return null;
            }
            catch (BirtException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
        }
    }
}

