/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.sql.Time;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DateFormatter {
    private static final String UNFORMATTED = "Unformatted";
    public static final String DATETIME_UNFORMATTED = "DateTimeUnformatted";
    public static final String DATE_UNFORMATTED = "DateUnformatted";
    public static final String TIME_UNFORMATTED = "TimeUnformatted";
    private String formatPattern;
    private DateFormat dateFormat;
    private ULocale locale = ULocale.getDefault();
    protected static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.format.DateFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public DateFormatter() {
        this.applyPattern(null);
    }

    public DateFormatter(String pattern) {
        this.applyPattern(pattern);
    }

    public DateFormatter(ULocale localeLoc) {
        if (localeLoc != null) {
            this.locale = localeLoc;
        }
        this.applyPattern(null);
    }

    public DateFormatter(Locale localeLoc) {
        this(ULocale.forLocale((Locale)localeLoc));
    }

    public DateFormatter(String pattern, ULocale localeLoc) {
        if (localeLoc != null) {
            this.locale = localeLoc;
        }
        this.applyPattern(pattern);
    }

    public DateFormatter(String pattern, Locale localeLoc) {
        this(pattern, ULocale.forLocale((Locale)localeLoc));
    }

    public String getPattern() {
        return this.formatPattern;
    }

    public void applyPattern(String formatString) {
        try {
            this.formatPattern = formatString;
            if (formatString == null || formatString.equals(DATETIME_UNFORMATTED)) {
                this.formatPattern = "";
                this.dateFormat = DateFormat.getDateTimeInstance((int)2, (int)3, (ULocale)this.locale);
                return;
            }
            if (formatString.equals(DATE_UNFORMATTED)) {
                this.formatPattern = "";
                this.dateFormat = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals(TIME_UNFORMATTED)) {
                this.formatPattern = "";
                this.dateFormat = DateFormat.getTimeInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.length() == 1) {
                char patternTemp = formatString.charAt(0);
                switch (patternTemp) {
                    case 'G': {
                        this.dateFormat = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
                        return;
                    }
                    case 'D': {
                        this.dateFormat = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
                        return;
                    }
                    case 'd': {
                        this.dateFormat = DateFormat.getDateInstance((int)3, (ULocale)this.locale);
                        return;
                    }
                    case 'T': {
                        this.dateFormat = DateFormat.getTimeInstance((int)1, (ULocale)this.locale);
                        return;
                    }
                    case 't': {
                        this.dateFormat = new SimpleDateFormat("HH:mm", this.locale);
                        return;
                    }
                    case 'f': {
                        this.dateFormat = DateFormat.getDateTimeInstance((int)1, (int)3, (ULocale)this.locale);
                        return;
                    }
                    case 'F': {
                        this.dateFormat = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
                        return;
                    }
                    case 'I': 
                    case 'i': {
                        int idx;
                        SimpleDateFormat factorySimpleFormat;
                        int timeForm = patternTemp == 'i' ? 2 : 1;
                        DateFormat factoryFormat = DateFormat.getDateTimeInstance((int)3, (int)timeForm, (ULocale)this.locale);
                        try {
                            factorySimpleFormat = (SimpleDateFormat)factoryFormat;
                        }
                        catch (ClassCastException classCastException) {
                            this.dateFormat = factoryFormat;
                            return;
                        }
                        String pattern = factorySimpleFormat.toPattern();
                        if (pattern.indexOf("yyyy") == -1 && (idx = pattern.indexOf("yy")) >= 0) {
                            StringBuffer strBuf = new StringBuffer(pattern);
                            strBuf.insert(idx, 'y');
                            pattern = strBuf.toString();
                        }
                        this.dateFormat = new SimpleDateFormat(pattern, this.locale);
                        return;
                    }
                    case 'g': {
                        this.dateFormat = DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)this.locale);
                        return;
                    }
                    case 'M': 
                    case 'm': {
                        this.dateFormat = new SimpleDateFormat("MM/dd", this.locale);
                        return;
                    }
                    case 'R': 
                    case 'r': {
                        this.dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss a", this.locale);
                        this.dateFormat.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                        return;
                    }
                    case 's': {
                        this.dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss", this.locale);
                        return;
                    }
                    case 'u': {
                        this.dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss  Z", this.locale);
                        return;
                    }
                    case 'Y': 
                    case 'y': {
                        this.dateFormat = new SimpleDateFormat("yyyy/mm", this.locale);
                        return;
                    }
                }
                this.dateFormat = new SimpleDateFormat(formatString, this.locale);
                return;
            }
            if (formatString.equals("General Date")) {
                this.dateFormat = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Long Date")) {
                this.dateFormat = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Medium Date")) {
                this.dateFormat = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Short Date")) {
                this.dateFormat = DateFormat.getDateInstance((int)3, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Long Time")) {
                this.dateFormat = DateFormat.getTimeInstance((int)1, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Medium Time")) {
                this.dateFormat = DateFormat.getTimeInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Short Time")) {
                this.dateFormat = new SimpleDateFormat("kk:mm", this.locale);
                return;
            }
            this.dateFormat = new SimpleDateFormat(formatString, this.locale);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public String format(Date date) {
        try {
            if (this.formatPattern == null || this.formatPattern.length() == 0) {
                if (date instanceof java.sql.Date) {
                    this.dateFormat = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
                    return this.dateFormat.format(date);
                }
                if (date instanceof Time) {
                    this.dateFormat = DateFormat.getTimeInstance((int)2, (ULocale)this.locale);
                    return this.dateFormat.format(date);
                }
            }
            return this.dateFormat.format(date);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public String getFormatCode() {
        SimpleDateFormat dateFormat;
        String formatCode = null;
        if (this.formatPattern.equals("General Date")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Long Date")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance((int)1, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Medium Date")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance((int)2, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Short Date")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance((int)3, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Long Time")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getTimeInstance((int)1, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Medium Time")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getTimeInstance((int)2, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Short Time")) {
            dateFormat = new SimpleDateFormat("kk:mm", this.locale);
            formatCode = dateFormat.toPattern();
        }
        return formatCode;
    }

    public Date parse(String date) throws ParseException {
        return this.dateFormat.parse(date);
    }
}

