/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.bre.Function_temp;
import org.mozilla.javascript.ScriptableObject;

public class BirtMath
extends ScriptableObject {
    private static final long serialVersionUID = 1L;

    public BirtMath() {
        this.defineProperty("add", (Object)new Function_Add(), 0);
        this.defineProperty("round", (Object)new Function_Round(), 0);
        this.defineProperty("roundUp", (Object)new Function_RoundUp(), 0);
        this.defineProperty("roundDown", (Object)new Function_RoundDown(), 0);
        this.defineProperty("ceiling", (Object)new Function_Ceiling(), 0);
        this.defineProperty("mod", (Object)new Function_Mod(), 0);
        this.defineProperty("safeDivide", (Object)new Function_SafeDivide(), 0);
    }

    private static double add(double value1, double value2) {
        return value1 + value2;
    }

    private static double round(double value) {
        return BirtMath.round(value, 0);
    }

    private static double round(double value, int dec) {
        double multiple = BirtMath.getMultiple(dec);
        return (double)Math.round(value * multiple) / multiple;
    }

    private static double roundUp(double value) {
        return BirtMath.roundUp(value, 0);
    }

    private static double roundUp(double value, int dec) {
        double multiple = BirtMath.getMultiple(dec);
        return (double)Math.round(Math.ceil(value * multiple)) / multiple;
    }

    private static double getMultiple(int dec) {
        double multiple = 1.0;
        if (dec >= 0) {
            int i = 0;
            while (i < dec) {
                multiple *= 10.0;
                ++i;
            }
        } else {
            double adjustment = 1.0;
            int i = dec;
            while (i < 0) {
                multiple *= 0.1;
                adjustment *= 10.0;
                ++i;
            }
            multiple = (double)Math.round(multiple * adjustment) / adjustment;
        }
        return multiple;
    }

    private static double roundDown(double value, int dec) {
        double multiple = BirtMath.getMultiple(dec);
        return (double)Math.round(Math.floor(value * multiple)) / multiple;
    }

    private static double roundDown(double value) {
        return BirtMath.roundDown(value, 0);
    }

    private static double ceiling(double n, double significance) {
        if (significance == 0.0 || n == 0.0) {
            return 0.0;
        }
        if (n * significance < 0.0) {
            throw new IllegalArgumentException("The given significance cannot be applied to the number");
        }
        if (Math.abs(n) < Math.abs(significance)) {
            return significance;
        }
        double multiple = Math.ceil(n / significance);
        return multiple * significance;
    }

    private static double mod(double n, double div) {
        if (div == 0.0) {
            throw new IllegalArgumentException("The divisor cannot be 0");
        }
        return n - div * Math.floor(n / div);
    }

    private static double safeDivide(double dividend, double divisor, double ifZero) {
        if (divisor == 0.0) {
            return ifZero;
        }
        return dividend / divisor;
    }

    private static double toDoubleValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return Double.valueOf(o.toString());
    }

    public String getClassName() {
        return "BirtMath";
    }

    private class Function_Add
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Add() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Double(BirtMath.add(BirtMath.toDoubleValue(args[0]), BirtMath.toDoubleValue(args[1])));
        }
    }

    private class Function_Ceiling
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Ceiling() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Double(BirtMath.ceiling(BirtMath.toDoubleValue(args[0]), BirtMath.toDoubleValue(args[1])));
        }
    }

    private class Function_Mod
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Mod() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Double(BirtMath.mod(BirtMath.toDoubleValue(args[0]), BirtMath.toDoubleValue(args[1])));
        }
    }

    private class Function_Round
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Round() {
            this.length = 2;
            this.isFixed = false;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (args.length == 1) {
                return new Double(BirtMath.round(BirtMath.toDoubleValue(args[0])));
            }
            return new Double(BirtMath.round(BirtMath.toDoubleValue(args[0]), (int)BirtMath.toDoubleValue(args[1])));
        }
    }

    private class Function_RoundDown
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_RoundDown() {
            this.length = 2;
            this.isFixed = false;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (args.length == 1) {
                return new Double(BirtMath.roundDown(BirtMath.toDoubleValue(args[0])));
            }
            return new Double(BirtMath.roundDown(BirtMath.toDoubleValue(args[0]), (int)BirtMath.toDoubleValue(args[1])));
        }
    }

    private class Function_RoundUp
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_RoundUp() {
            this.length = 2;
            this.isFixed = false;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (args.length == 1) {
                return new Double(BirtMath.roundUp(BirtMath.toDoubleValue(args[0])));
            }
            return new Double(BirtMath.roundUp(BirtMath.toDoubleValue(args[0]), (int)BirtMath.toDoubleValue(args[1])));
        }
    }

    private class Function_SafeDivide
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_SafeDivide() {
            this.length = 3;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return new Double(BirtMath.safeDivide(BirtMath.toDoubleValue(args[0]), BirtMath.toDoubleValue(args[1]), BirtMath.toDoubleValue(args[2])));
        }
    }
}

