/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;

public class IOUtil {
    public static final int INT_LENGTH = 4;
    public static final int RA_STREAM_BUFFER_LENGTH = 8192;
    public static final int MAX_NUMBER_OF_STREAM_BUFFER = 128;
    private static Map type2IndexMap;
    private static final int TYPE_NULL = 0;
    private static final int TYPE_INT = 1;
    private static final int TYPE_FLOAT = 2;
    private static final int TYPE_DOUBLE = 3;
    private static final int TYPE_BIG_DECIMAL = 4;
    private static final int TYPE_DATE = 5;
    private static final int TYPE_TIME = 6;
    private static final int TYPE_TIME_STAMP = 7;
    private static final int TYPE_BOOLEAN = 8;
    private static final int TYPE_STRING = 9;
    private static final int TYPE_BYTES = 10;
    private static final int TYPE_LIST = 11;
    private static final int TYPE_MAP = 12;
    private static final int TYPE_SERIALIZABLE = 13;
    private static final int TYPE_JSObject = 14;
    private static final int TYPE_LONG_STRING = 15;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;

    static {
        Class<?> clazz = class$14;
        if (clazz == null) {
            try {
                clazz = class$14 = Class.forName("org.eclipse.birt.core.util.IOUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        type2IndexMap = new HashMap();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz2, new Integer(1));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz3, new Integer(2));
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz4, new Integer(3));
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz5, new Integer(4));
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz6, new Integer(5));
        Class<?> clazz7 = class$5;
        if (clazz7 == null) {
            try {
                clazz7 = class$5 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz7, new Integer(6));
        Class<?> clazz8 = class$6;
        if (clazz8 == null) {
            try {
                clazz8 = class$6 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz8, new Integer(7));
        Class<?> clazz9 = class$7;
        if (clazz9 == null) {
            try {
                clazz9 = class$7 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz9, new Integer(8));
        Class<?> clazz10 = class$8;
        if (clazz10 == null) {
            try {
                clazz10 = class$8 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz10, new Integer(9));
        Class<?> clazz11 = class$9;
        if (clazz11 == null) {
            try {
                clazz11 = class$9 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz11, new Integer(10));
        Class<?> clazz12 = class$10;
        if (clazz12 == null) {
            try {
                clazz12 = class$10 = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz12, new Integer(11));
        Class<?> clazz13 = class$11;
        if (clazz13 == null) {
            try {
                clazz13 = class$11 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz13, new Integer(12));
        Class<?> clazz14 = class$12;
        if (clazz14 == null) {
            try {
                clazz14 = class$12 = Class.forName("java.io.Serializable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz14, new Integer(13));
        type2IndexMap.put(null, new Integer(0));
        Class<?> clazz15 = class$13;
        if (clazz15 == null) {
            try {
                clazz15 = class$13 = Class.forName("org.mozilla.javascript.IdScriptableObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        type2IndexMap.put(clazz15, new Integer(14));
    }

    public static final short readShort(InputStream inputStream) throws IOException {
        int ch1 = inputStream.read();
        int ch2 = inputStream.read();
        return (short)((ch1 << 8) + ch2);
    }

    public static final void writeShort(OutputStream outputStream, short value) throws IOException {
        outputStream.write(value >>> 8 & 0xFF);
        outputStream.write(value >>> 0 & 0xFF);
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        int ch1 = inputStream.read();
        int ch2 = inputStream.read();
        int ch3 = inputStream.read();
        int ch4 = inputStream.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static final void writeInt(OutputStream outputStream, int value) throws IOException {
        outputStream.write(value >>> 24 & 0xFF);
        outputStream.write(value >>> 16 & 0xFF);
        outputStream.write(value >>> 8 & 0xFF);
        outputStream.write(value >>> 0 & 0xFF);
    }

    public static final int getInt(byte[] bytes) {
        if (!$assertionsDisabled && bytes.length != 4) {
            throw new AssertionError();
        }
        int ch1 = bytes[0] & 0xFF;
        int ch2 = bytes[1] & 0xFF;
        int ch3 = bytes[2] & 0xFF;
        int ch4 = bytes[3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static final int bytesToInteger(byte[] b) {
        if (!$assertionsDisabled && b.length < 4) {
            throw new AssertionError();
        }
        return ((b[0] & 0xFF) << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + ((b[3] & 0xFF) << 0);
    }

    public static final long bytesToLong(byte[] b) {
        if (!$assertionsDisabled && b.length < 8) {
            throw new AssertionError();
        }
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + (((long)b[7] & 0xFFL) << 0);
    }

    public static final void integerToBytes(int v, byte[] b) {
        if (!$assertionsDisabled && b.length < 4) {
            throw new AssertionError();
        }
        b[0] = (byte)(v >>> 24 & 0xFF);
        b[1] = (byte)(v >>> 16 & 0xFF);
        b[2] = (byte)(v >>> 8 & 0xFF);
        b[3] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void longToBytes(long v, byte[] b) {
        if (!$assertionsDisabled && b.length < 8) {
            throw new AssertionError();
        }
        b[0] = (byte)(v >>> 56 & 0xFFL);
        b[1] = (byte)(v >>> 48 & 0xFFL);
        b[2] = (byte)(v >>> 40 & 0xFFL);
        b[3] = (byte)(v >>> 32 & 0xFFL);
        b[4] = (byte)(v >>> 24 & 0xFFL);
        b[5] = (byte)(v >>> 16 & 0xFFL);
        b[6] = (byte)(v >>> 8 & 0xFFL);
        b[7] = (byte)(v >>> 0 & 0xFFL);
    }

    public static final boolean readBool(InputStream inputStream) throws IOException {
        return inputStream.read() != 0;
    }

    public static final void writeBool(OutputStream outputStream, boolean bool) throws IOException {
        outputStream.write(!bool ? 0 : 1);
    }

    public static final float readFloat(DataInputStream inputStream) throws IOException {
        return inputStream.readFloat();
    }

    public static final void writeFloat(DataOutputStream outputStream, float value) throws IOException {
        outputStream.writeFloat(value);
    }

    public static final double readDouble(DataInputStream inputStream) throws IOException {
        return inputStream.readDouble();
    }

    public static final void writeDouble(DataOutputStream outputStream, double value) throws IOException {
        outputStream.writeDouble(value);
    }

    public static final long readLong(DataInputStream inputStream) throws IOException {
        return inputStream.readLong();
    }

    public static final void writeLong(DataOutputStream outputStream, long value) throws IOException {
        outputStream.writeLong(value);
    }

    public static final void writeRawBytes(DataOutputStream dos, byte[] bytes) throws IOException {
        if (!$assertionsDisabled && bytes == null) {
            throw new AssertionError();
        }
        dos.write(bytes);
    }

    private static int getTypeIndex(Object obValue) {
        if (obValue == null) {
            return 0;
        }
        if (obValue instanceof String) {
            if (IOUtil.isLongString((String)obValue)) {
                return 15;
            }
            return 9;
        }
        Integer indexOb = (Integer)type2IndexMap.get(obValue.getClass());
        if (indexOb == null) {
            if (obValue instanceof Map) {
                return 12;
            }
            if (obValue instanceof List) {
                return 11;
            }
            if (obValue instanceof Scriptable) {
                return 14;
            }
            if (obValue instanceof Serializable) {
                return 13;
            }
            return -1;
        }
        return indexOb;
    }

    public static final Object readObject(DataInputStream dis) throws IOException {
        int typeIndex = IOUtil.readInt(dis);
        Object obValue = null;
        switch (typeIndex) {
            case 0: {
                break;
            }
            case 1: {
                obValue = new Integer(dis.readInt());
                break;
            }
            case 2: {
                obValue = new Float(dis.readFloat());
                break;
            }
            case 3: {
                obValue = new Double(dis.readDouble());
                break;
            }
            case 4: {
                obValue = new BigDecimal(dis.readUTF());
                break;
            }
            case 5: {
                obValue = new Date(dis.readLong());
                break;
            }
            case 6: {
                obValue = new Time(dis.readLong());
                break;
            }
            case 7: {
                obValue = new Timestamp(dis.readLong());
                break;
            }
            case 8: {
                obValue = new Boolean(dis.readBoolean());
                break;
            }
            case 9: {
                obValue = dis.readUTF();
                break;
            }
            case 15: {
                obValue = IOUtil.readUTF(dis);
                break;
            }
            case 10: {
                int len = IOUtil.readInt(dis);
                byte[] bytes = new byte[len];
                if (len > 0) {
                    dis.readFully(bytes);
                }
                obValue = bytes;
                break;
            }
            case 11: {
                obValue = IOUtil.readList(dis);
                break;
            }
            case 12: {
                obValue = IOUtil.readMap(dis);
                break;
            }
            case 13: {
                int len = IOUtil.readInt(dis);
                if (len == 0) break;
                byte[] bytes = new byte[len];
                dis.readFully(bytes);
                try {
                    ObjectInputStream oo = new ObjectInputStream(new ByteArrayInputStream(bytes));
                    obValue = oo.readObject();
                }
                catch (Exception exception) {}
                break;
            }
            case 14: {
                Object ob = IOUtil.readObject(dis);
                obValue = JavascriptEvalUtil.convertToJavascriptValue(ob);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return obValue;
    }

    public static final void writeObject(DataOutputStream dos, Object obValue) throws IOException {
        int typeIndex = IOUtil.getTypeIndex(obValue);
        if (typeIndex == -1) {
            IOUtil.writeInt(dos, 0);
            throw new IOException("Data type of " + obValue.getClass().toString() + " is not supported to be serialized");
        }
        IOUtil.writeInt(dos, typeIndex);
        switch (typeIndex) {
            case 0: {
                break;
            }
            case 1: {
                dos.writeInt((Integer)obValue);
                break;
            }
            case 2: {
                dos.writeFloat(((Float)obValue).floatValue());
                break;
            }
            case 3: {
                dos.writeDouble((Double)obValue);
                break;
            }
            case 4: {
                dos.writeUTF(((BigDecimal)obValue).toString());
                break;
            }
            case 5: {
                dos.writeLong(((Date)obValue).getTime());
                break;
            }
            case 6: {
                dos.writeLong(((Time)obValue).getTime());
                break;
            }
            case 7: {
                dos.writeLong(((Timestamp)obValue).getTime());
                break;
            }
            case 8: {
                dos.writeBoolean((Boolean)obValue);
                break;
            }
            case 9: {
                dos.writeUTF(obValue.toString());
                break;
            }
            case 15: {
                IOUtil.writeUTF(dos, obValue.toString());
                break;
            }
            case 10: {
                byte[] bytes = (byte[])obValue;
                int length = bytes.length;
                IOUtil.writeInt(dos, length);
                if (length <= 0) break;
                dos.write(bytes);
                break;
            }
            case 11: {
                IOUtil.writeList(dos, (List)obValue);
                break;
            }
            case 12: {
                IOUtil.writeMap(dos, (Map)obValue);
                break;
            }
            case 13: {
                byte[] bytes = null;
                try {
                    ByteArrayOutputStream buff = new ByteArrayOutputStream();
                    ObjectOutputStream oo = new ObjectOutputStream(buff);
                    oo.writeObject(obValue);
                    oo.close();
                    bytes = buff.toByteArray();
                }
                catch (Exception exception) {}
                if (bytes == null || bytes.length == 0) {
                    IOUtil.writeInt(dos, 0);
                    break;
                }
                IOUtil.writeInt(dos, bytes.length);
                dos.write(bytes);
                break;
            }
            case 14: {
                if (obValue instanceof IdScriptableObject) {
                    IdScriptableObject jsObject = (IdScriptableObject)obValue;
                    if (jsObject.getClassName().equals("Date")) {
                        Date date = (Date)JavascriptEvalUtil.convertJavascriptValue(obValue);
                        IOUtil.writeObject(dos, date);
                        break;
                    }
                    IOUtil.writeObject(dos, null);
                    break;
                }
                if (obValue instanceof NativeJavaObject) {
                    obValue = JavascriptEvalUtil.convertJavascriptValue(obValue);
                    IOUtil.writeObject(dos, obValue);
                    break;
                }
                IOUtil.writeObject(dos, null);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public static final String readString(DataInputStream dis) throws IOException {
        int type = IOUtil.readInt(dis);
        if (type == 0) {
            return null;
        }
        if (type == 9) {
            return dis.readUTF();
        }
        return IOUtil.readUTF(dis);
    }

    public static final void writeString(DataOutputStream dos, String str) throws IOException {
        if (str == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        if (IOUtil.isLongString(str)) {
            IOUtil.writeInt(dos, 15);
            IOUtil.writeUTF(dos, str);
        } else {
            IOUtil.writeInt(dos, 9);
            dos.writeUTF(str);
        }
    }

    public static final byte[] readBytes(DataInputStream dis) throws IOException {
        if (IOUtil.readInt(dis) == 0) {
            return null;
        }
        int size = IOUtil.readInt(dis);
        byte[] bytes = new byte[size];
        if (size != 0) {
            dis.readFully(bytes);
        }
        return bytes;
    }

    public static final void writeBytes(DataOutputStream dos, byte[] bytes) throws IOException {
        if (bytes == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        IOUtil.writeInt(dos, 10);
        int size = bytes.length;
        IOUtil.writeInt(dos, size);
        if (size == 0) {
            return;
        }
        dos.write(bytes);
    }

    public static final List readList(DataInputStream dis) throws IOException {
        if (IOUtil.readInt(dis) == 0) {
            return null;
        }
        ArrayList<Object> dataList = new ArrayList<Object>();
        int size = IOUtil.readInt(dis);
        if (size == 0) {
            return dataList;
        }
        int i = 0;
        while (i < size) {
            dataList.add(IOUtil.readObject(dis));
            ++i;
        }
        return dataList;
    }

    public static final void writeList(DataOutputStream dos, List list) throws IOException {
        if (list == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        IOUtil.writeInt(dos, 12);
        int size = list.size();
        IOUtil.writeInt(dos, size);
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            IOUtil.writeObject(dos, list.get(i));
            ++i;
        }
    }

    public static final Map readMap(DataInputStream dis) throws IOException {
        if (IOUtil.readInt(dis) == 0) {
            return null;
        }
        HashMap<Object, Object> dataMap = new HashMap<Object, Object>();
        int size = IOUtil.readInt(dis);
        if (size == 0) {
            return dataMap;
        }
        int i = 0;
        while (i < size) {
            Object key = IOUtil.readObject(dis);
            Object value = IOUtil.readObject(dis);
            dataMap.put(key, value);
            ++i;
        }
        return dataMap;
    }

    public static final void writeMap(DataOutputStream dos, Map map) throws IOException {
        if (map == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        IOUtil.writeInt(dos, 12);
        int size = map.size();
        IOUtil.writeInt(dos, size);
        if (size == 0) {
            return;
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            IOUtil.writeObject(dos, key);
            IOUtil.writeObject(dos, value);
        }
    }

    private static boolean isLongString(String str) {
        int strlen = str.length();
        int utflen = 0;
        char c = '\u0000';
        int i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        return utflen > 65535;
    }

    private static void writeUTF(DataOutputStream dos, String str) throws IOException {
        byte[] longBytes = IOUtil.convertString2Bytes(str);
        dos.writeInt(longBytes.length);
        dos.write(longBytes, 0, longBytes.length);
    }

    private static String readUTF(DataInputStream dis) throws IOException {
        int length = dis.readInt();
        byte[] ret = new byte[length];
        dis.read(ret, 0, length);
        return IOUtil.convertBytes2String(ret);
    }

    private static byte[] convertString2Bytes(String str) {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        int i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        byte[] bytearr = null;
        bytearr = new byte[utflen];
        int i2 = 0;
        i2 = 0;
        while (i2 < strlen) {
            c = str.charAt(i2);
            if (c < '\u0001' || c > '\u007f') break;
            bytearr[count++] = (byte)c;
            ++i2;
        }
        while (i2 < strlen) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
        return bytearr;
    }

    private static String convertBytes2String(byte[] bytearr) throws UTFDataFormatException {
        int c;
        int utflen = bytearr.length;
        char[] chararr = new char[utflen];
        int count = 0;
        int chararr_count = 0;
        while (count < utflen) {
            c = bytearr[count] & 0xFF;
            if (c > 127) break;
            ++count;
            chararr[chararr_count++] = (char)c;
        }
        while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("malformed input around byte " + count);
                }
            }
        }
        return new String(chararr, 0, chararr_count);
    }
}

