/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.layout;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.BirtContext;
import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtExtractDataActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtGetReportletActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRenderImageActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRenderReportActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunAndRenderActionHandler;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class EngineFragment
extends BirtBaseFragment {
    protected void doPreService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = ParameterAccessor.getFormat(httpServletRequest);
        String string2 = ParameterAccessor.getOpenType(httpServletRequest);
        if ("/download".equalsIgnoreCase(httpServletRequest.getServletPath())) {
            httpServletResponse.setContentType("text/plain; charset=utf-8");
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=exportdata.csv");
        } else {
            String string3;
            if ("pdf".equalsIgnoreCase(string)) {
                httpServletResponse.setContentType("application/pdf");
            } else {
                string3 = ReportEngineService.getInstance().getMIMEType(string);
                if (string3 != null && string3.length() > 0) {
                    httpServletResponse.setContentType(string3);
                } else {
                    httpServletResponse.setContentType("application/octet-stream");
                }
            }
            if (!ParameterAccessor.isGetImageOperator(httpServletRequest)) {
                string3 = ParameterAccessor.generateFileName(httpServletRequest, string);
                httpServletResponse.setHeader("Content-Disposition", string2 + "; filename=\"" + string3 + "\"");
            }
        }
    }

    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block12: {
            BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
            Object object = httpServletResponse.getOutputStream();
            GetUpdatedObjectsResponse getUpdatedObjectsResponse = new GetUpdatedObjectsResponse();
            BirtContext birtContext = new BirtContext(httpServletRequest, httpServletResponse);
            Operation operation = null;
            try {
                if ("/download".equalsIgnoreCase(httpServletRequest.getServletPath())) {
                    BirtExtractDataActionHandler birtExtractDataActionHandler = new BirtExtractDataActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                    birtExtractDataActionHandler.execute();
                } else if (ParameterAccessor.isGetImageOperator(httpServletRequest)) {
                    BirtRenderImageActionHandler birtRenderImageActionHandler = new BirtRenderImageActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                    birtRenderImageActionHandler.execute();
                } else {
                    Object object2;
                    boolean bl = false;
                    if ("print".equalsIgnoreCase(baseAttributeBean.getAction())) {
                        bl = true;
                        object = new ByteArrayOutputStream();
                    }
                    if (ParameterAccessor.isGetReportlet(httpServletRequest)) {
                        object2 = new BirtGetReportletActionHandler(birtContext, operation, getUpdatedObjectsResponse, (OutputStream)object);
                        ((AbstractBaseActionHandler)object2).execute();
                    } else if (birtContext.getBean().documentInUrl) {
                        object2 = new BirtRenderReportActionHandler(birtContext, operation, getUpdatedObjectsResponse, (OutputStream)object);
                        ((AbstractBaseActionHandler)object2).execute();
                    } else {
                        object2 = new BirtRunAndRenderActionHandler(birtContext, operation, getUpdatedObjectsResponse, (OutputStream)object);
                        ((AbstractBaseActionHandler)object2).execute();
                    }
                    if (bl) {
                        object2 = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                        BirtUtility.doPrintAction((InputStream)object2, httpServletRequest, httpServletResponse);
                    }
                }
            }
            catch (RemoteException remoteException) {
                if (ParameterAccessor.isGetImageOperator(httpServletRequest)) break block12;
                httpServletResponse.setContentType("text/html; charset=utf-8");
                BirtUtility.appendErrorMessage((OutputStream)httpServletResponse.getOutputStream(), remoteException);
            }
        }
    }

    protected String doPostService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        return null;
    }
}

