/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.layout;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.BirtContext;
import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;
import org.eclipse.birt.report.presentation.aggregation.control.ToolbarFragment;
import org.eclipse.birt.report.presentation.aggregation.layout.ReportFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.actionhandler.BirtRenderReportActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunReportActionHandler;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class FramesetFragment
extends BirtBaseFragment {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void build() {
        this.addChild(new ToolbarFragment());
        this.addChild(new ReportFragment());
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, BirtException {
        BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
        if (baseAttributeBean != null && !baseAttributeBean.isShowParameterPage() && !this.__checkHTMLFormat(httpServletRequest)) {
            this.doPreService(httpServletRequest, httpServletResponse);
            this.doService(httpServletRequest, httpServletResponse);
            this.doPostService(httpServletRequest, httpServletResponse);
        } else {
            super.doPreService(httpServletRequest, httpServletResponse);
            super.doService(httpServletRequest, httpServletResponse);
            String string = super.doPostService(httpServletRequest, httpServletResponse);
            if (string != null && string.length() > 0) {
                RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string);
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
    }

    protected boolean __checkHTMLFormat(HttpServletRequest httpServletRequest) {
        BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
        if (!$assertionsDisabled && baseAttributeBean == null) {
            throw new AssertionError();
        }
        return "html".equalsIgnoreCase(baseAttributeBean.getFormat());
    }

    protected void doPreService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
        String string2 = baseAttributeBean.getFormat();
        String string3 = ParameterAccessor.getOpenType(httpServletRequest);
        if ("pdf".equalsIgnoreCase(string2)) {
            httpServletResponse.setContentType("application/pdf");
        } else {
            string = ReportEngineService.getInstance().getMIMEType(string2);
            if (string != null && string.length() > 0) {
                httpServletResponse.setContentType(string);
            } else {
                httpServletResponse.setContentType("application/octet-stream");
            }
        }
        string = ParameterAccessor.generateFileName(httpServletRequest, string2);
        httpServletResponse.setHeader("Content-Disposition", string3 + "; filename=\"" + string + "\"");
    }

    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, BirtException {
        BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
        if (!$assertionsDisabled && baseAttributeBean == null) {
            throw new AssertionError();
        }
        Object object = httpServletResponse.getOutputStream();
        BirtContext birtContext = new BirtContext(httpServletRequest, httpServletResponse);
        GetUpdatedObjectsResponse getUpdatedObjectsResponse = new GetUpdatedObjectsResponse();
        Operation operation = null;
        try {
            BirtRunReportActionHandler birtRunReportActionHandler;
            File file = new File(baseAttributeBean.getReportDocumentName());
            if (!file.exists()) {
                birtRunReportActionHandler = new BirtRunReportActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                birtRunReportActionHandler.execute();
            }
            if (baseAttributeBean.isDocumentProcessing()) {
                birtRunReportActionHandler = new AxisFault();
                birtRunReportActionHandler.setFaultReason(BirtResources.getMessage("birt.viewer.generalException.DOCUMENT_FILE_PROCESSING"));
                throw birtRunReportActionHandler;
            }
            boolean bl = false;
            if ("print".equalsIgnoreCase(baseAttributeBean.getAction())) {
                bl = true;
                object = new ByteArrayOutputStream();
            }
            BirtRenderReportActionHandler birtRenderReportActionHandler = new BirtRenderReportActionHandler(birtContext, operation, getUpdatedObjectsResponse, (OutputStream)object);
            birtRenderReportActionHandler.execute();
            if (bl) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                BirtUtility.doPrintAction(byteArrayInputStream, httpServletRequest, httpServletResponse);
            }
        }
        catch (RemoteException remoteException) {
            httpServletResponse.setContentType("text/html; charset=utf-8");
            BirtUtility.appendErrorMessage((OutputStream)httpServletResponse.getOutputStream(), remoteException);
        }
    }

    protected String doPostService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        return null;
    }

    static {
        $assertionsDisabled = !FramesetFragment.class.desiredAssertionStatus();
    }
}

