/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.framework.PlatformServletContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.IRequestInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IHTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ViewerHTMLActionHandler;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.soapengine.api.Column;
import org.eclipse.birt.report.soapengine.api.ResultSet;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ReportEngineService {
    private static ReportEngineService instance;
    private IReportEngine engine = null;
    private EngineConfig config = null;
    private String imageBaseUrl = null;
    private HTMLServerImageHandler imageHandler = null;
    private String contextPath = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ReportEngineService(ServletContext servletContext) {
        Object object;
        System.setProperty("RUN_UNDER_ECLIPSE", "false");
        if (servletContext == null) {
            return;
        }
        ParameterAccessor.initParameters(servletContext);
        this.config = new EngineConfig();
        HTMLRenderOption hTMLRenderOption = new HTMLRenderOption();
        hTMLRenderOption.setActionHandler((IHTMLActionHandler)new HTMLActionHandler());
        this.imageHandler = new HTMLServerImageHandler();
        hTMLRenderOption.setImageHandler((IHTMLImageHandler)this.imageHandler);
        this.config.getEmitterConfigs().put("html", hTMLRenderOption);
        this.imageBaseUrl = "/preview?__imageID=";
        String string = ParameterAccessor.logLevel;
        Level level = string != null && string.length() > 0 ? Level.parse(string) : Level.OFF;
        this.config.setLogConfig(ParameterAccessor.logFolder, level);
        String string2 = ParameterAccessor.scriptLibDir;
        ArrayList arrayList = new ArrayList();
        if (string2 != null) {
            object = new File(string2);
            this.getAllJarFiles((File)object, arrayList);
        }
        object = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)object + EngineConstants.PROPERTYSEPARATOR + ((File)arrayList.get(i)).getAbsolutePath();
        }
        if (((String)object).startsWith(EngineConstants.PROPERTYSEPARATOR)) {
            object = ((String)object).substring(EngineConstants.PROPERTYSEPARATOR.length());
        }
        this.config.setProperty("webapplication.projectclasspath", object);
        this.config.setEngineHome("");
    }

    public static ReportEngineService getInstance() {
        return instance;
    }

    public static synchronized void initEngineInstance(ServletConfig servletConfig) throws BirtException {
        ReportEngineService.initEngineInstance(servletConfig.getServletContext());
    }

    public static synchronized void initEngineInstance(ServletContext servletContext) throws BirtException {
        if (instance != null) {
            return;
        }
        instance = new ReportEngineService(servletContext);
    }

    private void getAllJarFiles(File file, ArrayList arrayList) {
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isFile()) {
                    if (!file2.getName().endsWith(".jar")) continue;
                    arrayList.add(file2);
                    continue;
                }
                if (!file2.isDirectory()) continue;
                this.getAllJarFiles(file2, arrayList);
            }
        }
    }

    public synchronized void setEngineContext(ServletContext servletContext, HttpServletRequest httpServletRequest) throws BirtException {
        if (this.engine == null) {
            PlatformServletContext platformServletContext = new PlatformServletContext(servletContext);
            this.config.setPlatformContext((IPlatformContext)platformServletContext);
            Platform.startup((PlatformConfig)this.config);
            IReportEngineFactory iReportEngineFactory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
            if (iReportEngineFactory == null) {
                throw new ViewerException("birt.viewer.reportServiceException.STARTUP_REPORTENGINE_ERROR");
            }
            this.engine = iReportEngineFactory.createReportEngine(this.config);
            ParameterAccessor.supportedFormats = this.engine.getSupportedFormats();
            this.contextPath = httpServletRequest.getContextPath();
        }
    }

    public IReportRunnable openReportDesign(String string, Map map) throws EngineException {
        File file = new File(string);
        if (!file.exists()) {
            throw new EngineException("Error.DesignFileNotFound", (Object)string);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            String string2 = string;
            try {
                string2 = file.toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                string2 = string;
            }
            return this.engine.openReportDesign(string2, (InputStream)fileInputStream, map);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new EngineException("Error.DesignFileNotFound", (Object)string);
        }
    }

    public IReportRunnable openReportDesign(String string, InputStream inputStream, Map map) throws EngineException {
        return this.engine.openReportDesign(string, inputStream, map);
    }

    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable iReportRunnable) {
        IGetParameterDefinitionTask iGetParameterDefinitionTask = null;
        try {
            iGetParameterDefinitionTask = this.engine.createGetParameterDefinitionTask(iReportRunnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iGetParameterDefinitionTask;
    }

    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable iReportRunnable, InputOptions inputOptions) {
        IGetParameterDefinitionTask iGetParameterDefinitionTask = null;
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
            iGetParameterDefinitionTask = this.engine.createGetParameterDefinitionTask(iReportRunnable);
            Map map = BirtUtility.getAppContext(httpServletRequest, ReportEngineService.class.getClassLoader());
            iGetParameterDefinitionTask.setAppContext(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iGetParameterDefinitionTask;
    }

    public IReportDocument openReportDocument(String string, String string2, Map map) {
        if (string2 == null) {
            return null;
        }
        IReportDocument iReportDocument = null;
        try {
            iReportDocument = this.engine.openReportDocument(string, string2, map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iReportDocument;
    }

    public void renderImage(String string, HttpServletRequest httpServletRequest, OutputStream outputStream) throws RemoteException {
        if (!$assertionsDisabled && this.imageHandler == null) {
            throw new AssertionError();
        }
        try {
            this.imageHandler.getImage(outputStream, ParameterAccessor.getImageTempFolder(httpServletRequest), string);
        }
        catch (EngineException engineException) {
            AxisFault axisFault = new AxisFault(engineException.getLocalizedMessage(), engineException.getCause());
            axisFault.setFaultCode(new QName("ReportEngineService.renderImage( )"));
            throw axisFault;
        }
    }

    private HTMLRenderOption createHTMLRenderOption(boolean bl, String string, HttpServletRequest httpServletRequest) {
        String string2 = null;
        boolean bl2 = ParameterAccessor.isDesigner(httpServletRequest);
        if (!bl2) {
            string2 = ParameterAccessor.getBaseURL();
        }
        if (string2 == null) {
            string2 = "";
        }
        string2 = string2 + this.contextPath;
        HTMLRenderOption hTMLRenderOption = new HTMLRenderOption();
        hTMLRenderOption.setImageDirectory(ParameterAccessor.getImageTempFolder(httpServletRequest));
        hTMLRenderOption.setBaseImageURL(string2 + this.imageBaseUrl);
        if (string != null && string.length() > 0) {
            hTMLRenderOption.setBaseURL(string2 + string);
        } else {
            hTMLRenderOption.setBaseURL(string2 + "/run");
        }
        hTMLRenderOption.setEnableAgentStyleEngine(ParameterAccessor.isAgentStyle(httpServletRequest));
        hTMLRenderOption.setSupportedImageFormats(bl ? "PNG;GIF;JPG;BMP;SVG" : "PNG;GIF;JPG;BMP");
        return hTMLRenderOption;
    }

    private PDFRenderOption createPDFRenderOption(String string, HttpServletRequest httpServletRequest, boolean bl) {
        String string2 = null;
        if (!bl) {
            string2 = ParameterAccessor.getBaseURL();
        }
        if (string2 == null) {
            string2 = "";
        }
        string2 = string2 + this.contextPath;
        PDFRenderOption pDFRenderOption = new PDFRenderOption();
        if (string != null && string.length() > 0) {
            pDFRenderOption.setBaseURL(string2 + string);
        } else {
            pDFRenderOption.setBaseURL(string2 + "/run");
        }
        pDFRenderOption.setSupportedImageFormats("PNG;GIF;JPG;BMP");
        pDFRenderOption.setOption("pdfRenderOption.fitToPage", (Object)new Boolean(ParameterAccessor.isFitToPage(httpServletRequest)));
        pDFRenderOption.setOption("pdfRenderOption.pagebreakPaginationOnly", (Object)new Boolean(ParameterAccessor.isPagebreakOnly(httpServletRequest)));
        return pDFRenderOption;
    }

    public void runAndRenderReport(HttpServletRequest httpServletRequest, IReportRunnable iReportRunnable, OutputStream outputStream, String string, Locale locale, boolean bl, Map map, boolean bl2, boolean bl3) throws RemoteException {
        this.runAndRenderReport(httpServletRequest, iReportRunnable, outputStream, string, locale, bl, map, bl2, bl3, null, null, null, null, null, null);
    }

    public void runAndRenderReport(HttpServletRequest httpServletRequest, IReportRunnable iReportRunnable, OutputStream outputStream, String string, Locale locale, boolean bl, Map map, boolean bl2, boolean bl3, Map map2, String string2, String string3) throws RemoteException {
        this.runAndRenderReport(httpServletRequest, iReportRunnable, outputStream, string, locale, bl, map, bl2, bl3, null, null, null, map2, string2, string3);
    }

    public void runAndRenderReport(HttpServletRequest httpServletRequest, IReportRunnable iReportRunnable, OutputStream outputStream, String string, Locale locale, boolean bl, Map map, boolean bl2, boolean bl3, Boolean bl4, List list, RenderOption object, Map map2, String string2, String string3) throws RemoteException {
        String string4;
        Object object2;
        Object object3;
        if (!$assertionsDisabled && iReportRunnable == null) {
            throw new AssertionError();
        }
        String string5 = string2;
        if (string5 == null) {
            string5 = httpServletRequest.getServletPath();
        }
        IRunAndRenderTask iRunAndRenderTask = this.engine.createRunAndRenderTask(iReportRunnable);
        iRunAndRenderTask.setLocale(locale);
        if (map != null) {
            iRunAndRenderTask.setParameterValues(map);
        }
        if (map2 != null) {
            object3 = map2.keySet().iterator();
            while (object3.hasNext()) {
                object2 = DataUtil.getString(object3.next());
                string4 = DataUtil.getString(map2.get(object2));
                iRunAndRenderTask.setParameterDisplayText((String)object2, string4);
            }
        }
        object3 = BirtUtility.getAppContext(httpServletRequest, ReportEngineService.class.getClassLoader());
        iRunAndRenderTask.setAppContext((Map)object3);
        if (object == null) {
            object = "pdf".equalsIgnoreCase(string) || "postscript".equalsIgnoreCase(string) ? this.createPDFRenderOption(string5, httpServletRequest, ParameterAccessor.isDesigner(httpServletRequest)) : this.createHTMLRenderOption(bl3, string5, httpServletRequest);
        }
        object.setOutputStream(outputStream);
        object.setOutputFormat(string);
        object.setOption("htmlMasterPageContent", (Object)new Boolean(bl2));
        object.setOption("htmlRtLFlag", (Object)new Boolean(bl));
        object2 = new ViewerHTMLActionHandler(locale, bl, bl2, string);
        string4 = ParameterAccessor.getParameter(httpServletRequest, "__resourceFolder");
        ((ViewerHTMLActionHandler)((Object)object2)).setResourceFolder(string4);
        object.setActionHandler((IHTMLActionHandler)object2);
        if (string3 != null) {
            object.setOption("htmlTitle", (Object)string3);
        }
        if (object instanceof IHTMLRenderOption) {
            boolean bl5 = false;
            if (bl4 != null) {
                bl5 = bl4;
            }
            if ("/run".equalsIgnoreCase(string5)) {
                bl5 = true;
            }
            ((IHTMLRenderOption)object).setEmbeddable(bl5);
        }
        object.setOption("InstanceIdList", (Object)list);
        this.initializeEmitterConfigs(httpServletRequest, object.getOptions());
        iRunAndRenderTask.setRenderOption((IRenderOption)object);
        BirtUtility.addTask(httpServletRequest, (IEngineTask)iRunAndRenderTask);
        try {
            iRunAndRenderTask.run();
        }
        catch (BirtException birtException) {
            AxisFault axisFault = new AxisFault(birtException.getLocalizedMessage(), birtException.getCause());
            axisFault.setFaultCode(new QName("ReportEngineService.runAndRenderReport( )"));
            throw axisFault;
        }
        finally {
            BirtUtility.removeTask(httpServletRequest);
            iRunAndRenderTask.close();
        }
    }

    private void initializeEmitterConfigs(HttpServletRequest httpServletRequest, Map map) {
        if (map == null) {
            return;
        }
        Iterator iterator = httpServletRequest.getParameterMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = String.valueOf(entry.getKey());
            if (!string.startsWith("__")) continue;
            map.put(string.substring(2), ParameterAccessor.getParameter(httpServletRequest, string));
        }
    }

    public void runReport(HttpServletRequest httpServletRequest, IReportRunnable iReportRunnable, String string, Locale locale, Map map) throws RemoteException {
        this.runReport(httpServletRequest, iReportRunnable, string, locale, map, null);
    }

    public void runReport(HttpServletRequest httpServletRequest, IReportRunnable iReportRunnable, String string, Locale locale, Map map, Map map2) throws RemoteException {
        Object object;
        Object object2;
        if (!$assertionsDisabled && iReportRunnable == null) {
            throw new AssertionError();
        }
        IRunTask iRunTask = null;
        iRunTask = this.engine.createRunTask(iReportRunnable);
        iRunTask.setLocale(locale);
        iRunTask.setParameterValues(map);
        BirtUtility.addTask(httpServletRequest, (IEngineTask)iRunTask);
        if (map2 != null) {
            object2 = map2.keySet().iterator();
            while (object2.hasNext()) {
                String string2 = DataUtil.getString(object2.next());
                object = DataUtil.getString(map2.get(string2));
                iRunTask.setParameterDisplayText(string2, (String)object);
            }
        }
        object2 = BirtUtility.getAppContext(httpServletRequest, ReportEngineService.class.getClassLoader());
        iRunTask.setAppContext((Map)object2);
        try {
            iRunTask.run(string);
        }
        catch (BirtException birtException) {
            object = new File(string);
            if (object != null) {
                ((File)object).delete();
            }
            AxisFault axisFault = new AxisFault(birtException.getLocalizedMessage(), birtException.getCause());
            axisFault.setFaultCode(new QName("ReportEngineService.runReport( )"));
            throw axisFault;
        }
        finally {
            BirtUtility.removeTask(httpServletRequest);
            iRunTask.close();
        }
    }

    public ByteArrayOutputStream renderReport(HttpServletRequest httpServletRequest, IReportDocument iReportDocument, long l, boolean bl, boolean bl2, List list, Locale locale, boolean bl3) throws RemoteException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.renderReport(byteArrayOutputStream, httpServletRequest, iReportDocument, null, l, null, bl, bl2, list, locale, bl3, null);
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream renderReport(HttpServletRequest httpServletRequest, IReportDocument iReportDocument, String string, long l, boolean bl, boolean bl2, List list, Locale locale, boolean bl3) throws RemoteException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.renderReport(byteArrayOutputStream, httpServletRequest, iReportDocument, string, l, null, bl, bl2, list, locale, bl3, null);
        return byteArrayOutputStream;
    }

    public void renderReport(OutputStream outputStream, HttpServletRequest httpServletRequest, IReportDocument iReportDocument, long l, String string, boolean bl, boolean bl2, List list, Locale locale, boolean bl3, String string2) throws RemoteException {
        this.renderReport(outputStream, httpServletRequest, iReportDocument, null, l, string, bl, bl2, list, locale, bl3, string2);
    }

    public void renderReport(OutputStream outputStream, HttpServletRequest httpServletRequest, IReportDocument iReportDocument, String string, long l, String string2, boolean bl, boolean bl2, List list, Locale locale, boolean bl3, String string3) throws RemoteException {
        String string4;
        if (iReportDocument == null) {
            AxisFault axisFault = new AxisFault(BirtResources.getMessage("birt.viewer.actionException.NO_REPORT_DOCUMENT"));
            axisFault.setFaultCode(new QName("ReportEngineService.renderReport( )"));
            throw axisFault;
        }
        OutputStream outputStream2 = outputStream;
        if (outputStream2 == null) {
            outputStream2 = new ByteArrayOutputStream();
        }
        if ((string4 = string3) == null) {
            string4 = httpServletRequest.getServletPath();
        }
        IRenderTask iRenderTask = this.engine.createRenderTask(iReportDocument);
        BirtUtility.addTask(httpServletRequest, (IEngineTask)iRenderTask);
        Map map = BirtUtility.getAppContext(httpServletRequest, ReportEngineService.class.getClassLoader());
        iRenderTask.setAppContext(map);
        Object object = null;
        if (string == null) {
            string = ParameterAccessor.getFormat(httpServletRequest);
        }
        object = "pdf".equalsIgnoreCase(string) || "postscript".equalsIgnoreCase(string) ? this.createPDFRenderOption(string4, httpServletRequest, ParameterAccessor.isDesigner(httpServletRequest)) : this.createHTMLRenderOption(bl2, string4, httpServletRequest);
        object.setOutputStream(outputStream2);
        object.setOutputFormat(string);
        ViewerHTMLActionHandler viewerHTMLActionHandler = null;
        if ("pdf".equalsIgnoreCase(string) || "postscript".equalsIgnoreCase(string)) {
            viewerHTMLActionHandler = new ViewerHTMLActionHandler(iReportDocument, l, locale, false, bl3, bl, string);
        } else {
            boolean bl4 = false;
            if ("/frameset".equalsIgnoreCase(string4) || "/run".equalsIgnoreCase(string4)) {
                bl4 = true;
            }
            if (object instanceof IHTMLRenderOption) {
                ((IHTMLRenderOption)object).setEmbeddable(bl4);
            }
            object.setOption("htmlRtLFlag", (Object)new Boolean(bl3));
            object.setOption("InstanceIdList", (Object)list);
            object.setOption("htmlMasterPageContent", (Object)new Boolean(bl));
            viewerHTMLActionHandler = new ViewerHTMLActionHandler(iReportDocument, l, locale, bl4, bl3, bl, string);
        }
        String string5 = ParameterAccessor.getParameter(httpServletRequest, "__resourceFolder");
        viewerHTMLActionHandler.setResourceFolder(string5);
        object.setActionHandler((IHTMLActionHandler)viewerHTMLActionHandler);
        this.initializeEmitterConfigs(httpServletRequest, object.getOptions());
        iRenderTask.setRenderOption((IRenderOption)object);
        iRenderTask.setLocale(locale);
        try {
            if (l > 0L) {
                iRenderTask.setPageNumber(l);
            }
            if (!(string2 == null || "/frameset".equalsIgnoreCase(string4) && "html".equalsIgnoreCase(string))) {
                iRenderTask.setPageRange(string2);
            }
            iRenderTask.render();
        }
        catch (Exception exception) {
            AxisFault axisFault = new AxisFault(exception.getLocalizedMessage(), exception.getCause());
            axisFault.setFaultCode(new QName("ReportEngineService.renderReport( )"));
            throw axisFault;
        }
        finally {
            BirtUtility.removeTask(httpServletRequest);
            iRenderTask.close();
        }
    }

    public void renderReportlet(OutputStream outputStream, HttpServletRequest httpServletRequest, IReportDocument iReportDocument, String string, boolean bl, boolean bl2, List list, Locale locale, boolean bl3) throws RemoteException {
        this.renderReportlet(outputStream, httpServletRequest, iReportDocument, string, null, bl, bl2, list, locale, bl3, null);
    }

    public void renderReportlet(OutputStream outputStream, HttpServletRequest httpServletRequest, IReportDocument iReportDocument, String string, boolean bl, boolean bl2, List list, Locale locale, boolean bl3, String string2) throws RemoteException {
        this.renderReportlet(outputStream, httpServletRequest, iReportDocument, string, null, bl, bl2, list, locale, bl3, string2);
    }

    public void renderReportlet(OutputStream outputStream, HttpServletRequest httpServletRequest, IReportDocument iReportDocument, String string, String string2, boolean bl, boolean bl2, List list, Locale locale, boolean bl3, String string3) throws RemoteException {
        String string4;
        if (iReportDocument == null) {
            AxisFault axisFault = new AxisFault(BirtResources.getMessage("birt.viewer.actionException.NO_REPORT_DOCUMENT"));
            axisFault.setFaultCode(new QName("ReportEngineService.renderReportlet( )"));
            throw axisFault;
        }
        OutputStream outputStream2 = outputStream;
        if (outputStream2 == null) {
            outputStream2 = new ByteArrayOutputStream();
        }
        if ((string4 = string3) == null) {
            string4 = httpServletRequest.getServletPath();
        }
        IRenderTask iRenderTask = this.engine.createRenderTask(iReportDocument);
        BirtUtility.addTask(httpServletRequest, (IEngineTask)iRenderTask);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("BIRT_VIEWER_HTTPSERVET_REQUEST", httpServletRequest);
        hashMap.put("PARENT_CLASSLOADER", ReportEngineService.class.getClassLoader());
        hashMap.put("CHART_RESOLUTION", ParameterAccessor.getDpi(httpServletRequest));
        ParameterAccessor.pushAppContext(hashMap, httpServletRequest);
        iRenderTask.setAppContext(hashMap);
        Object object = null;
        if (string2 == null) {
            string2 = ParameterAccessor.getFormat(httpServletRequest);
        }
        object = "pdf".equalsIgnoreCase(string2) || "postscript".equalsIgnoreCase(string2) ? this.createPDFRenderOption(string4, httpServletRequest, ParameterAccessor.isDesigner(httpServletRequest)) : this.createHTMLRenderOption(bl2, string4, httpServletRequest);
        object.setOutputFormat(string2);
        object.setOutputStream(outputStream2);
        ViewerHTMLActionHandler viewerHTMLActionHandler = null;
        if ("pdf".equalsIgnoreCase(string2) || "postscript".equalsIgnoreCase(string2)) {
            viewerHTMLActionHandler = new ViewerHTMLActionHandler(iReportDocument, -1L, locale, false, bl3, bl, string2);
        } else {
            boolean bl4 = false;
            if ("/frameset".equalsIgnoreCase(string4) || "/frameset".equalsIgnoreCase(string4)) {
                bl4 = true;
            }
            if (object instanceof IHTMLRenderOption) {
                ((IHTMLRenderOption)object).setEmbeddable(bl4);
            }
            object.setOption("htmlRtLFlag", (Object)new Boolean(bl3));
            object.setOption("InstanceIdList", (Object)list);
            object.setOption("htmlMasterPageContent", (Object)new Boolean(bl));
            viewerHTMLActionHandler = new ViewerHTMLActionHandler(iReportDocument, -1L, locale, bl4, bl3, bl, string2);
        }
        String string5 = ParameterAccessor.getParameter(httpServletRequest, "__resourceFolder");
        viewerHTMLActionHandler.setResourceFolder(string5);
        object.setActionHandler((IHTMLActionHandler)viewerHTMLActionHandler);
        iRenderTask.setRenderOption((IRenderOption)object);
        iRenderTask.setLocale(locale);
        try {
            if (ParameterAccessor.isIidReportlet(httpServletRequest)) {
                InstanceID instanceID = InstanceID.parse((String)string);
                iRenderTask.setInstanceID(instanceID);
            } else {
                iRenderTask.setReportlet(string);
            }
            iRenderTask.render();
        }
        catch (Exception exception) {
            AxisFault axisFault = new AxisFault(exception.getLocalizedMessage(), exception.getCause());
            axisFault.setFaultCode(new QName("ReportEngineService.renderReport( )"));
            throw axisFault;
        }
        finally {
            BirtUtility.removeTask(httpServletRequest);
            iRenderTask.close();
        }
    }

    public ResultSet[] getResultSets(IReportDocument iReportDocument) throws RemoteException {
        if (!$assertionsDisabled && iReportDocument == null) {
            throw new AssertionError();
        }
        ResultSet[] resultSetArray = null;
        IDataExtractionTask iDataExtractionTask = this.engine.createDataExtractionTask(iReportDocument);
        try {
            List list = iDataExtractionTask.getResultSetList();
            resultSetArray = new ResultSet[list.size()];
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    resultSetArray[i] = new ResultSet();
                    IResultSetItem iResultSetItem = (IResultSetItem)list.get(i);
                    if (!$assertionsDisabled && iResultSetItem == null) {
                        throw new AssertionError();
                    }
                    resultSetArray[i].setQueryName(iResultSetItem.getResultSetName());
                    IResultMetaData iResultMetaData = iResultSetItem.getResultMetaData();
                    if (!$assertionsDisabled && iResultMetaData == null) {
                        throw new AssertionError();
                    }
                    Column[] columnArray = new Column[iResultMetaData.getColumnCount()];
                    for (int j = 0; j < iResultMetaData.getColumnCount(); ++j) {
                        columnArray[j] = new Column();
                        String string = iResultMetaData.getColumnName(j);
                        columnArray[j].setName(string);
                        String string2 = iResultMetaData.getColumnLabel(j);
                        if (string2 == null || string2.length() <= 0) {
                            string2 = string;
                        }
                        columnArray[j].setLabel(string2);
                        columnArray[j].setVisibility(new Boolean(true));
                    }
                    resultSetArray[i].setColumn(columnArray);
                }
            }
        }
        catch (Exception exception) {
            AxisFault axisFault = new AxisFault(exception.getLocalizedMessage(), exception.getCause());
            axisFault.setFaultCode(new QName("ReportEngineService.getResultSets( )"));
            throw axisFault;
        }
        finally {
            iDataExtractionTask.close();
        }
        return resultSetArray;
    }

    public void extractData(IReportDocument iReportDocument, String string, Collection collection, Locale locale, OutputStream outputStream, String string2) throws RemoteException {
        this.extractData(iReportDocument, string, collection, locale, outputStream, string2, ',');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractData(IReportDocument iReportDocument, String string, Collection collection, Locale locale, OutputStream outputStream, String string2, char c) throws RemoteException {
        IDataIterator iDataIterator;
        IExtractionResults iExtractionResults;
        IDataExtractionTask iDataExtractionTask;
        block26: {
            if (!$assertionsDisabled && iReportDocument == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled) {
                if (string == null) throw new AssertionError();
                if (string.length() <= 0) {
                    throw new AssertionError();
                }
            }
            if (!$assertionsDisabled) {
                if (collection == null) throw new AssertionError();
                if (collection.isEmpty()) {
                    throw new AssertionError();
                }
            }
            String[] stringArray = new String[collection.size()];
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = (String)iterator.next();
                ++n;
            }
            iDataExtractionTask = null;
            iExtractionResults = null;
            iDataIterator = null;
            try {
                try {
                    iDataExtractionTask = this.engine.createDataExtractionTask(iReportDocument);
                    iDataExtractionTask.selectResultSet(string);
                    iDataExtractionTask.selectColumns(stringArray);
                    iDataExtractionTask.setLocale(locale);
                    iExtractionResults = iDataExtractionTask.extract();
                    if (iExtractionResults == null || (iDataIterator = iExtractionResults.nextResultIterator()) == null || stringArray.length <= 0) break block26;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(stringArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuffer.append(c);
                        stringBuffer.append(stringArray[i]);
                    }
                    stringBuffer.append('\n');
                    if (string2 != null && string2.trim().length() > 0) {
                        outputStream.write(stringBuffer.toString().getBytes(string2.trim()));
                    } else {
                        outputStream.write(stringBuffer.toString().getBytes());
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    while (iDataIterator.next()) {
                        String string3 = null;
                        try {
                            string3 = this.csvConvertor((String)DataTypeUtil.convert((Object)iDataIterator.getValue(stringArray[0]), (int)5), c);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (string3 != null) {
                            stringBuffer.append(string3);
                        }
                        for (int i = 1; i < stringArray.length; ++i) {
                            stringBuffer.append(c);
                            try {
                                string3 = this.csvConvertor((String)DataTypeUtil.convert((Object)iDataIterator.getValue(stringArray[i]), (int)5), c);
                            }
                            catch (Exception exception) {
                                string3 = null;
                            }
                            if (string3 == null) continue;
                            stringBuffer.append(string3);
                        }
                        stringBuffer.append('\n');
                        if (string2 != null && string2.trim().length() > 0) {
                            outputStream.write(stringBuffer.toString().getBytes(string2.trim()));
                        } else {
                            outputStream.write(stringBuffer.toString().getBytes());
                        }
                        stringBuffer.delete(0, stringBuffer.length());
                    }
                }
                catch (Exception exception) {
                    AxisFault axisFault = new AxisFault(exception.getLocalizedMessage(), exception.getCause());
                    axisFault.setFaultCode(new QName("ReportEngineService.extractData( )"));
                    throw axisFault;
                }
            }
            catch (Throwable throwable) {
                Object var18_23 = null;
                if (iDataIterator != null) {
                    iDataIterator.close();
                }
                if (iExtractionResults != null) {
                    iExtractionResults.close();
                }
                if (iDataExtractionTask == null) throw throwable;
                iDataExtractionTask.close();
                throw throwable;
            }
        }
        Object var18_22 = null;
        if (iDataIterator != null) {
            iDataIterator.close();
        }
        if (iExtractionResults != null) {
            iExtractionResults.close();
        }
        if (iDataExtractionTask == null) return;
        iDataExtractionTask.close();
    }

    private String csvConvertor(String string, char c) throws RemoteException {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("\"", "\"\"");
        boolean bl = false;
        bl = string.indexOf(c) != -1 || string.indexOf(34) != -1 || string.indexOf(10) != -1 || string.startsWith(" ") || string.endsWith(" ");
        string = bl ? "\"" + string + "\"" : string;
        return string;
    }

    public HashMap parseParameters(HttpServletRequest httpServletRequest, IGetParameterDefinitionTask iGetParameterDefinitionTask, Map map, Locale locale) {
        if (!$assertionsDisabled && iGetParameterDefinitionTask == null) {
            throw new AssertionError();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Collection collection = iGetParameterDefinitionTask.getParameterDefns(false);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IScalarParameterDefn iScalarParameterDefn = (IScalarParameterDefn)iterator.next();
            String string = null;
            Object object = null;
            String string2 = iScalarParameterDefn.getName();
            String string3 = iScalarParameterDefn.getDisplayFormat();
            ReportParameterConverter reportParameterConverter = new ReportParameterConverter(string3, locale);
            if (ParameterAccessor.isReportParameterExist(httpServletRequest, string2)) {
                string = ParameterAccessor.getReportParameter(httpServletRequest, string2, string);
                object = reportParameterConverter.parse(string, iScalarParameterDefn.getDataType());
            } else if (ParameterAccessor.isDesigner(httpServletRequest) && map.containsKey(string2)) {
                String string4 = (String)map.get(string2);
                ReportParameterConverter reportParameterConverter2 = new ReportParameterConverter(string3, Locale.US);
                object = reportParameterConverter2.parse(string4, iScalarParameterDefn.getDataType());
            } else {
                object = iGetParameterDefinitionTask.getDefaultValue(iScalarParameterDefn.getName());
            }
            hashMap.put(string2, object);
        }
        return hashMap;
    }

    public boolean validateParameters(IGetParameterDefinitionTask iGetParameterDefinitionTask, Map map) {
        if (!$assertionsDisabled && iGetParameterDefinitionTask == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        boolean bl = false;
        Collection collection = iGetParameterDefinitionTask.getParameterDefns(false);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            IScalarParameterDefn iScalarParameterDefn = (IScalarParameterDefn)iterator.next();
            String string2 = iScalarParameterDefn.getName();
            Object v = map.get(string2);
            if (iScalarParameterDefn.isHidden()) continue;
            if (v == null && !iScalarParameterDefn.allowNull()) {
                bl = true;
                break;
            }
            if (1 != iScalarParameterDefn.getDataType() || (string = (String)v) == null || string.length() > 0 || iScalarParameterDefn.allowBlank()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void clearCache(DataSetHandle dataSetHandle) throws BirtException {
        DataSessionContext dataSessionContext = new DataSessionContext(3, dataSetHandle.getModuleHandle(), null);
        DataRequestSession dataRequestSession = DataRequestSession.newSession((DataSessionContext)dataSessionContext);
        IModelAdapter iModelAdapter = dataRequestSession.getModelAdaptor();
        DataSourceHandle dataSourceHandle = dataSetHandle.getDataSource();
        BaseDataSourceDesign baseDataSourceDesign = iModelAdapter.adaptDataSource(dataSourceHandle);
        BaseDataSetDesign baseDataSetDesign = iModelAdapter.adaptDataSet(dataSetHandle);
        dataRequestSession.clearCache((IBaseDataSourceDesign)baseDataSourceDesign, (IBaseDataSetDesign)baseDataSetDesign);
    }

    public void setMaxRows(int n) {
        if (this.config != null) {
            this.config.setMaxRowsPerQuery(n);
        }
    }

    public List getColumnValueSet(String string, DesignElementHandle designElementHandle, IRequestInfo iRequestInfo) throws BirtException {
        if (string == null || designElementHandle == null || !(designElementHandle instanceof ReportItemHandle)) {
            return Collections.EMPTY_LIST;
        }
        ReportItemHandle reportItemHandle = this.getBindingHolder(designElementHandle);
        if (reportItemHandle == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        DataRequestSession dataRequestSession = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, reportItemHandle.getModuleHandle()));
        arrayList.addAll(dataRequestSession.getColumnValueSet(reportItemHandle.getDataSet(), reportItemHandle.paramBindingsIterator(), reportItemHandle.columnBindingsIterator(), string, iRequestInfo));
        dataRequestSession.shutdown();
        return arrayList;
    }

    public List getColumnValueSet(String string, DesignElementHandle designElementHandle) throws BirtException {
        if (string == null || designElementHandle == null || !(designElementHandle instanceof ReportItemHandle)) {
            return Collections.EMPTY_LIST;
        }
        ReportItemHandle reportItemHandle = this.getBindingHolder(designElementHandle);
        if (reportItemHandle == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        DataRequestSession dataRequestSession = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, reportItemHandle.getModuleHandle()));
        arrayList.addAll(dataRequestSession.getColumnValueSet(reportItemHandle.getDataSet(), reportItemHandle.paramBindingsIterator(), reportItemHandle.columnBindingsIterator(), string));
        dataRequestSession.shutdown();
        return arrayList;
    }

    private ReportItemHandle getBindingHolder(DesignElementHandle designElementHandle) {
        if (designElementHandle instanceof ReportElementHandle) {
            if (designElementHandle instanceof ListingHandle) {
                return (ReportItemHandle)designElementHandle;
            }
            if (designElementHandle instanceof ReportItemHandle && (((ReportItemHandle)designElementHandle).getDataSet() != null || ((ReportItemHandle)designElementHandle).columnBindingsIterator().hasNext())) {
                return (ReportItemHandle)designElementHandle;
            }
            ReportItemHandle reportItemHandle = this.getBindingHolder(designElementHandle.getContainer());
            if (reportItemHandle == null && designElementHandle instanceof ReportItemHandle) {
                reportItemHandle = (ReportItemHandle)designElementHandle;
            }
            return reportItemHandle;
        }
        return null;
    }

    public String getMIMEType(String string) {
        return this.engine.getMIMEType(string);
    }

    public EngineConfig getEngineConfig() {
        return this.config;
    }

    public static void shutdown() {
        instance = null;
    }

    static {
        $assertionsDisabled = !ReportEngineService.class.desiredAssertionStatus();
    }
}

