/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.taglib.AbstractBaseTag;
import org.eclipse.birt.report.taglib.util.BirtTagUtil;

public class RequesterTag
extends AbstractBaseTag {
    private static final long serialVersionUID = -4360776653926113953L;
    private Map parameters;

    public void __init() {
        super.__init();
        this.parameters = new HashMap();
    }

    public int doStartTag() throws JspException {
        try {
            if (this.viewer.isCustom()) {
                JspWriter jspWriter = this.pageContext.getOut();
                jspWriter.write("<DIV ");
                if (this.viewer.getId() != null) {
                    jspWriter.write(" ID=\"" + this.viewer.getId() + "\" ");
                }
                jspWriter.write(this.__handleDivAppearance() + ">\n");
                jspWriter.write("<FORM NAME=\"" + this.viewer.getName() + "\" METHOD=\"post\" ");
                jspWriter.write(" action=\"" + this.viewer.createURI(null) + "\"");
                if (this.viewer.getTarget() != null) {
                    jspWriter.write(" target=\"" + this.viewer.getTarget() + "\"");
                }
                jspWriter.write(">\n");
            }
        }
        catch (Exception exception) {
            this.__handleException(exception);
        }
        return 6;
    }

    public boolean __validate() throws Exception {
        Locale locale = BirtTagUtil.getLocale((HttpServletRequest)this.pageContext.getRequest(), this.viewer.getLocale());
        BirtResources.setLocale(locale);
        if (this.viewer.getId() == null || this.viewer.getId().length() <= 0) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_ATTR_ID"));
        }
        if (!this.__validateRequesterId()) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.INVALID_ATTR_ID"));
        }
        if (this.pageContext.findAttribute(this.viewer.getId()) != null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.ATTR_ID_DUPLICATE"));
        }
        if (this.viewer.isCustom() && (this.viewer.getName() == null || this.viewer.getName().length() <= 0)) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_REQUESTER_NAME"));
        }
        if (this.viewer.getReportDesign() == null && this.viewer.getReportDocument() == null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_REPORT_SOURCE"));
        }
        if (this.viewer.getReportletId() != null && this.viewer.getReportDocument() == null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_REPORT_DOCUMENT"));
        }
        return true;
    }

    protected boolean __validateRequesterId() {
        Pattern pattern = Pattern.compile("^\\w+$");
        Matcher matcher = pattern.matcher(this.viewer.getId());
        return matcher.find();
    }

    protected void __beforeEndTag() {
        this.pageContext.setAttribute(this.viewer.getId(), (Object)this.viewer.getId());
    }

    public void __process() throws Exception {
        if (this.viewer.isCustom()) {
            JspWriter jspWriter = this.pageContext.getOut();
            jspWriter.write("</form>\n");
            jspWriter.write("</div>\n");
        } else {
            this.__handleIFrame();
        }
    }

    protected void __handleIFrame() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        String string = "<iframe ";
        if (this.viewer.getId() != null) {
            string = string + " id=\"" + this.viewer.getId() + "\" ";
        }
        if (this.viewer.getName() != null) {
            string = string + " name=\"" + this.viewer.getName() + "\" ";
        }
        String string2 = this.viewer.createURI("parameter") + "&" + "__nocache";
        string = string + " src=\"" + string2 + "\" ";
        string = string + " frameborder=\"" + this.viewer.getFrameborder() + "\" ";
        if (this.viewer.getScrolling() != null) {
            string = string + " scrolling = \"" + this.viewer.getScrolling() + "\" ";
        }
        string = string + this.__handleAppearance() + "></iframe>\r\n";
        jspWriter.write(string);
    }

    protected String __handleAppearance() {
        String string = " style='";
        if (this.viewer.getStyle() != null) {
            string = string + this.viewer.getStyle() + ";";
        }
        if (this.viewer.getPosition() != null) {
            string = string + "position:" + this.viewer.getPosition() + ";";
        }
        if (this.viewer.getHeight() >= 0) {
            string = string + "height:" + this.viewer.getHeight() + "px;";
        }
        if (this.viewer.getWidth() >= 0) {
            string = string + "width:" + this.viewer.getWidth() + "px;";
        }
        if (this.viewer.getTop() != null) {
            string = string + "top:" + this.viewer.getTop() + "px;";
        }
        if (this.viewer.getLeft() != null) {
            string = string + "left:" + this.viewer.getLeft() + "px;";
        }
        string = string + "' ";
        return string;
    }

    protected String __handleDivAppearance() {
        String string = " style='";
        if (this.viewer.getPosition() != null) {
            string = string + "position:" + this.viewer.getPosition() + ";";
        }
        if (this.viewer.getHeight() >= 0) {
            string = string + "height:" + this.viewer.getHeight() + "px;";
        }
        if (this.viewer.getWidth() >= 0) {
            string = string + "width:" + this.viewer.getWidth() + "px;";
        }
        if (this.viewer.getTop() != null) {
            string = string + "top:" + this.viewer.getTop() + "px;";
        }
        if (this.viewer.getLeft() != null) {
            string = string + "left:" + this.viewer.getLeft() + "px;";
        }
        string = this.viewer.getScrolling() != null && "yes".equalsIgnoreCase(this.viewer.getScrolling()) ? string + "overflow:scroll" : string + "overflow:auto";
        if (this.viewer.getStyle() != null) {
            string = string + this.viewer.getStyle() + ";";
        }
        string = string + "' ";
        return string;
    }

    public void setId(String string) {
        this.viewer.setId(string);
    }

    public void setName(String string) {
        this.viewer.setName(string);
    }

    public void setTitle(String string) {
        this.viewer.setTitle(string);
    }

    public void setBaseURL(String string) {
        this.viewer.setBaseURL(string);
    }

    public void setIsCustom(String string) {
        this.viewer.setCustom(Boolean.valueOf(string));
    }

    public void setScrolling(String string) {
        this.viewer.setScrolling(string);
    }

    public void setPosition(String string) {
        this.viewer.setPosition(string);
    }

    public void setStyle(String string) {
        this.viewer.setStyle(string);
    }

    public void setHeight(String string) {
        this.viewer.setHeight(Integer.parseInt(string));
    }

    public void setWidth(String string) {
        this.viewer.setWidth(Integer.parseInt(string));
    }

    public void setLeft(String string) {
        this.viewer.setLeft("" + Integer.parseInt(string));
    }

    public void setTop(String string) {
        this.viewer.setTop("" + Integer.parseInt(string));
    }

    public void setFrameborder(String string) {
        this.viewer.setFrameborder(string);
    }

    public void setReportDesign(String string) {
        this.viewer.setReportDesign(string);
    }

    public void setReportDocument(String string) {
        this.viewer.setReportDocument(string);
    }

    public void setReportletId(String string) {
        this.viewer.setReportletId(string);
    }

    public void setPattern(String string) {
        this.viewer.setPattern(string);
    }

    public void setTarget(String string) {
        this.viewer.setTarget(string);
    }

    public void setBookmark(String string) {
        this.viewer.setBookmark(string);
    }

    public void setLocale(String string) {
        this.viewer.setLocale(string);
    }

    public void setFormat(String string) {
        this.viewer.setFormat(string);
    }

    public void setSvg(String string) {
        this.viewer.setSvg(BirtTagUtil.convertBooleanValue(string));
    }

    public void setRtl(String string) {
        this.viewer.setRtl(BirtTagUtil.convertBooleanValue(string));
    }

    public void setResourceFolder(String string) {
        this.viewer.setResourceFolder(string);
    }

    public void setForceOverwriteDocument(String string) {
        this.viewer.setForceOverwriteDocument(BirtTagUtil.convertBooleanValue(string));
    }

    public void setShowTitle(String string) {
        this.viewer.setShowTitle(BirtTagUtil.convertBooleanValue(string));
    }

    public void setShowToolBar(String string) {
        this.viewer.setShowToolBar(BirtTagUtil.convertBooleanValue(string));
    }

    public void setShowNavigationBar(String string) {
        this.viewer.setShowNavigationBar(BirtTagUtil.convertBooleanValue(string));
    }

    public void addParameter(String string, Object object) {
        this.parameters.put(string, object);
    }

    public Map getParameters() {
        return this.parameters;
    }
}

