/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.utility.DataUtil;

public class ParameterAccessor {
    public static final String PARAM_ID = "__id";
    public static final String PARAM_TITLE = "__title";
    public static final String PARAM_SHOW_TITLE = "__showtitle";
    public static final String PARAM_TOOLBAR = "__toolbar";
    public static final String PARAM_NAVIGATIONBAR = "__navigationbar";
    public static final String PARAM_PARAMETER_PAGE = "__parameterpage";
    public static final String PARAM_REPORT = "__report";
    public static final String PARAM_REPORT_DOCUMENT = "__document";
    public static final String PARAM_FORMAT = "__format";
    public static final String PARAM_FORMAT_HTM = "htm";
    public static final String PARAM_FORMAT_HTML = "html";
    public static final String PARAM_FORMAT_PDF = "pdf";
    public static final String PARAM_LOCALE = "__locale";
    public static final String PARAM_SVG = "__svg";
    public static final String PARAM_PAGE = "__page";
    public static final String PARAM_PAGE_RANGE = "__pagerange";
    public static final String PARAM_ISNULL = "__isnull";
    public static final String PARAM_ISLOCALE = "__islocale";
    public static final String PARAM_MASTERPAGE = "__masterpage";
    public static final String PARAM_DESIGNER = "__designer";
    public static final String PARAM_OVERWRITE = "__overwrite";
    public static final String PARAM_IMAGEID = "__imageID";
    public static final String PARAM_BOOKMARK = "__bookmark";
    public static final String PARAM_RTL = "__rtl";
    public static final String PARAM_MAXROWS = "__maxrows";
    public static final String PARAM_INSTANCEID = "__instanceid";
    public static final String PARAM_ISREPORTLET = "__isreportlet";
    public static final String PARAM_EXPORT_ENCODING = "__exportEncoding";
    public static final String PARAM_SEP = "__sep";
    public static final String PARAM_FIT_TO_PAGE = "__fittopage";
    public static final String PARAM_PAGEBREAK_ONLY = "__pagebreakonly";
    public static final String PREFIX_DISPLAY_TEXT = "__isdisplay__";
    public static final String PREFIX_ISLOCALE = "__islocale__";
    public static final String PARAM_RESOURCE_FOLDER = "__resourceFolder";
    public static final String PARAM_SERVLET_PATTERN = "__pattern";
    public static final String PARAM_TARGET = "__target";
    public static final String PARAM_NOCACHE_PARAMETER = "__nocache";
    public static final String PARAM_AS_ATTACHMENT = "__asattachment";
    public static final String PARAM_ACTION = "__action";
    public static final String PARAM_DPI = "__dpi";
    public static final String PARAM_CLEAN_SESSION = "__clean";
    public static final String PARAM_AGENTSTYLE_ENGINE = "__agentstyle";
    public static final String HEADER_REQUEST_TYPE = "request-type";
    public static final String HEADER_REQUEST_TYPE_SOAP = "soap";
    public static final String PARAM_IID = "iid";
    public static final String PARAM_RESULTSETNAME = "ResultSetName";
    public static final String PARAM_SELECTEDCOLUMNNUMBER = "SelectedColumnNumber";
    public static final String PARAM_SELECTEDCOLUMN = "SelectedColumn";
    public static final String INIT_PARAM_LOCALE = "BIRT_VIEWER_LOCALE";
    public static final String INIT_PARAM_WORKING_DIR = "BIRT_VIEWER_WORKING_FOLDER";
    public static final String INIT_PARAM_IMAGE_DIR = "BIRT_VIEWER_IMAGE_DIR";
    public static final String INIT_PARAM_LOG_DIR = "BIRT_VIEWER_LOG_DIR";
    public static final String INIT_PARAM_LOG_LEVEL = "BIRT_VIEWER_LOG_LEVEL";
    public static final String INIT_PARAM_SCRIPTLIB_DIR = "BIRT_VIEWER_SCRIPTLIB_DIR";
    public static final String INIT_PARAM_WORKING_FOLDER_ACCESS_ONLY = "WORKING_FOLDER_ACCESS_ONLY";
    public static final String INIT_PARAM_DOCUMENT_FOLDER = "BIRT_VIEWER_DOCUMENT_FOLDER";
    public static final String INIT_PARAM_BIRT_RESOURCE_PATH = "BIRT_RESOURCE_PATH";
    public static final String INIT_PARAM_VIEWER_MAXROWS = "BIRT_VIEWER_MAX_ROWS";
    public static final String INIT_PARAM_OVERWRITE_DOCUMENT = "BIRT_OVERWRITE_DOCUMENT";
    public static final String INIT_PARAM_CONFIG_FILE = "BIRT_VIEWER_CONFIG_FILE";
    public static final String INIT_PARAM_PRINT_SERVERSIDE = "BIRT_VIEWER_PRINT_SERVERSIDE";
    public static final String INIT_PARAM_AGENTSTYLE_ENGINE = "HTML_ENABLE_AGENTSTYLE_ENGINE";
    public static final String UTF_8_ENCODE = "UTF-8";
    public static final String ISO_8859_1_ENCODE = "ISO-8859-1";
    public static final String PARAMETER_SEPARATOR = "&";
    public static final String QUERY_CHAR = "?";
    public static final String EQUALS_OPERATOR = "=";
    public static final String SUFFIX_REPORT_DOCUMENT = ".rptdocument";
    public static final char DEFAULT_SEP = ',';
    public static String workingFolder;
    public static String documentFolder;
    public static String imageFolder;
    public static String logFolder;
    public static String logLevel;
    public static String scriptLibDir;
    public static int maxRows;
    public static Locale webAppLocale;
    public static boolean isWorkingFolderAccessOnly;
    public static String birtResourceFolder;
    protected static boolean isInitContext;
    public static boolean isOverWrite;
    public static final String ATTR_APPCONTEXT_KEY = "AppContextKey";
    public static final String ATTR_APPCONTEXT_VALUE = "AppContextValue";
    public static Map initProps;
    public static final String PROP_BASE_URL = "base_url";
    public static String[] supportedFormats;
    public static boolean isSupportedPrintOnServer;
    public static boolean isCleanSessionFiles;
    public static boolean isAgentStyle;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getBookmark(HttpServletRequest httpServletRequest) {
        int n = ParameterAccessor.getParameterAsInt(httpServletRequest, PARAM_PAGE);
        return n < 1 ? ParameterAccessor.getReportParameter(httpServletRequest, PARAM_BOOKMARK, null) : null;
    }

    public static String getEncodedQueryString(HttpServletRequest httpServletRequest, String string, String string2) {
        String string3;
        Object object;
        String string4 = "";
        Enumeration enumeration = httpServletRequest.getParameterNames();
        Set set = ParameterAccessor.getParameterValues(httpServletRequest, PARAM_ISNULL);
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (object == null || ((String)object).equalsIgnoreCase(PARAM_ISNULL)) continue;
            string3 = ParameterAccessor.getParameter(httpServletRequest, (String)object, false);
            if (set != null && set.remove(ParameterAccessor.toUTFString((String)object)) && !((String)object).equalsIgnoreCase(string)) {
                object = ParameterAccessor.urlEncode((String)object, ISO_8859_1_ENCODE);
                string4 = string4 + (bl ? "" : PARAMETER_SEPARATOR) + PARAM_ISNULL + EQUALS_OPERATOR + (String)object;
                bl = false;
                continue;
            }
            if (((String)object).equalsIgnoreCase(string)) {
                string3 = string2;
            }
            object = ParameterAccessor.urlEncode((String)object, ISO_8859_1_ENCODE);
            string3 = ParameterAccessor.urlEncode(string3, UTF_8_ENCODE);
            string4 = string4 + (bl ? "" : PARAMETER_SEPARATOR) + (String)object + EQUALS_OPERATOR + string3;
            bl = false;
        }
        if (set != null && set.size() > 0) {
            object = set.iterator();
            while (object.hasNext()) {
                string3 = (String)object.next();
                if (string3 == null || string3.equalsIgnoreCase(string)) continue;
                string3 = ParameterAccessor.urlEncode(string3, UTF_8_ENCODE);
                string4 = string4 + (bl ? "" : PARAMETER_SEPARATOR) + PARAM_ISNULL + EQUALS_OPERATOR + string3;
                bl = false;
            }
        }
        if (string != null && string.length() > 0 && ParameterAccessor.getParameter(httpServletRequest, string) == null) {
            object = string2;
            object = ParameterAccessor.urlEncode((String)object, UTF_8_ENCODE);
            string4 = string4 + (bl ? "" : PARAMETER_SEPARATOR) + string + EQUALS_OPERATOR + (String)object;
            bl = false;
        }
        return string4;
    }

    public static String getQueryParameterString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PARAMETER_SEPARATOR);
        stringBuffer.append(string);
        stringBuffer.append(EQUALS_OPERATOR);
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static String getTitle(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_TITLE);
        if (string == null) {
            string = BirtResources.getMessage("birt.viewer.title");
        }
        return ParameterAccessor.htmlEncode(string);
    }

    public static String getFormat(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_FORMAT);
        if (string != null && string.length() > 0) {
            if (PARAM_FORMAT_HTM.equalsIgnoreCase(string)) {
                return PARAM_FORMAT_HTML;
            }
            return string;
        }
        return PARAM_FORMAT_HTML;
    }

    public static int getMaxRows(HttpServletRequest httpServletRequest) {
        int n = ParameterAccessor.getParameterAsInt(httpServletRequest, PARAM_MAXROWS);
        if (n <= 0) {
            n = maxRows;
        }
        return n;
    }

    public static String getIId(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.getReportParameter(httpServletRequest, PARAM_IID, null);
    }

    public static Locale getLocale(HttpServletRequest httpServletRequest) {
        Locale locale = null;
        locale = ParameterAccessor.getLocaleFromString(ParameterAccessor.getParameter(httpServletRequest, PARAM_LOCALE));
        if (locale == null) {
            locale = httpServletRequest.getLocale();
        }
        if (locale == null) {
            locale = webAppLocale;
        }
        return locale;
    }

    public static boolean isRtl(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_RTL))) {
            bl = true;
        }
        return bl;
    }

    public static Locale getLocaleFromString(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        int n = string.indexOf(95);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return new Locale(string2, string3);
        }
        return new Locale(string);
    }

    public static String getLocaleString(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.getParameter(httpServletRequest, PARAM_LOCALE);
    }

    public static int getPage(HttpServletRequest httpServletRequest) {
        int n = ParameterAccessor.getParameterAsInt(httpServletRequest, PARAM_PAGE);
        if (n > 0) {
            return n;
        }
        String string = httpServletRequest.getServletPath();
        n = "/frameset".equalsIgnoreCase(string) && PARAM_FORMAT_HTML.equalsIgnoreCase(ParameterAccessor.getFormat(httpServletRequest)) ? 1 : 0;
        return n;
    }

    public static String getPageRange(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.getParameter(httpServletRequest, PARAM_PAGE_RANGE);
    }

    public static String getReportletId(HttpServletRequest httpServletRequest) {
        if (ParameterAccessor.isIidReportlet(httpServletRequest)) {
            return ParameterAccessor.getParameter(httpServletRequest, PARAM_INSTANCEID);
        }
        if (ParameterAccessor.isBookmarkReportlet(httpServletRequest)) {
            return ParameterAccessor.getParameter(httpServletRequest, PARAM_BOOKMARK);
        }
        return null;
    }

    public static Set getParameterValues(HttpServletRequest httpServletRequest, String string) {
        return ParameterAccessor.getParameterValues(httpServletRequest, string, true);
    }

    public static String getReport(HttpServletRequest httpServletRequest, String string) {
        if (string == null) {
            string = DataUtil.trimString(ParameterAccessor.getParameter(httpServletRequest, PARAM_REPORT));
        }
        if (!ParameterAccessor.isRelativePath(string)) {
            return string;
        }
        string = ParameterAccessor.isRelativePath(workingFolder) ? ParameterAccessor.getRealPath(workingFolder + "/" + string, httpServletRequest.getSession().getServletContext()) : workingFolder + File.separator + string;
        return string;
    }

    public static String getReportDocument(HttpServletRequest httpServletRequest, String string, boolean bl) {
        if (string == null) {
            string = DataUtil.trimString(ParameterAccessor.getParameter(httpServletRequest, PARAM_REPORT_DOCUMENT));
        }
        if (string.length() <= 0 && !bl) {
            return null;
        }
        if (string.length() <= 0) {
            string = ParameterAccessor.generateDocumentFromReport(httpServletRequest);
            string = ParameterAccessor.createDocumentPath(string, httpServletRequest);
        } else {
            if (!ParameterAccessor.isRelativePath(string)) {
                return string;
            }
            string = ParameterAccessor.isRelativePath(workingFolder) ? ParameterAccessor.getRealPath(workingFolder + "/" + string, httpServletRequest.getSession().getServletContext()) : workingFolder + File.separator + string;
        }
        return string;
    }

    protected static String createDocumentPath(String string, HttpServletRequest httpServletRequest) {
        String string2 = null;
        if (string == null || string.length() == 0) {
            return "";
        }
        String string3 = httpServletRequest.getSession().getId();
        String string4 = "\\";
        if (string.lastIndexOf(string4) == -1) {
            string4 = "/";
        }
        string2 = string.lastIndexOf(string4) != -1 ? string.substring(string.lastIndexOf(string4) + 1) : string;
        String string5 = Integer.toHexString(string.hashCode());
        return documentFolder + File.separator + string3 + File.separator + string5 + File.separator + string2;
    }

    protected static void clearTempFiles() {
        File file = new File(documentFolder);
        ParameterAccessor.deleteDir(file);
        ParameterAccessor.makeDir(documentFolder);
        file = new File(imageFolder);
        ParameterAccessor.deleteDir(file);
        ParameterAccessor.makeDir(imageFolder);
    }

    protected static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = ParameterAccessor.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static String getReportParameter(HttpServletRequest httpServletRequest, String string, String string2) {
        Set set;
        if (!($assertionsDisabled || httpServletRequest != null && string != null)) {
            throw new AssertionError();
        }
        String string3 = ParameterAccessor.getParameter(httpServletRequest, string);
        if (string3 == null || string3.length() <= 0) {
            string3 = "";
        }
        Map map = httpServletRequest.getParameterMap();
        String string4 = ParameterAccessor.toISOString(string);
        if (map == null || !map.containsKey(string4)) {
            string3 = string2;
        }
        if ((set = ParameterAccessor.getParameterValues(httpServletRequest, PARAM_ISNULL)) != null && set.contains(string)) {
            string3 = null;
        }
        return string3;
    }

    public static String getResultSetName(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.getReportParameter(httpServletRequest, PARAM_RESULTSETNAME, null);
    }

    public static Collection getSelectedColumns(HttpServletRequest httpServletRequest) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = ParameterAccessor.getParameterAsInt(httpServletRequest, PARAM_SELECTEDCOLUMNNUMBER);
        for (int i = 0; i < n; ++i) {
            String string = PARAM_SELECTEDCOLUMN + String.valueOf(i);
            String string2 = ParameterAccessor.getParameter(httpServletRequest, string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean getSVGFlag(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_SVG))) {
            bl = true;
        }
        return bl;
    }

    public static Locale getWebAppLocale() {
        return webAppLocale;
    }

    public static final String htmlEncode(String string) {
        String string2 = "";
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        block12: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\t': {
                    stringBuffer.append("&#09;");
                    continue block12;
                }
                case '\n': {
                    stringBuffer.append("<br>");
                    continue block12;
                }
                case '\r': {
                    stringBuffer.append("&#13;");
                    continue block12;
                }
                case ' ': {
                    stringBuffer.append("&#32;");
                    continue block12;
                }
                case '\"': {
                    stringBuffer.append("&#34;");
                    continue block12;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block12;
                }
                case '<': {
                    stringBuffer.append("&#60;");
                    continue block12;
                }
                case '>': {
                    stringBuffer.append("&#62;");
                    continue block12;
                }
                case '`': {
                    stringBuffer.append("&#96;");
                    continue block12;
                }
                case '&': {
                    stringBuffer.append("&#38;");
                    continue block12;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    public static final String htmlDecode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.replaceAll("&#09;", "\t");
        string2 = string2.replaceAll("<br>", "\n");
        string2 = string2.replaceAll("&#13;", "\r");
        string2 = string2.replaceAll("&#32;", " ");
        string2 = string2.replaceAll("&#34;", "\"");
        string2 = string2.replaceAll("&#39;", "'");
        string2 = string2.replaceAll("&#60;", "<");
        string2 = string2.replaceAll("&#62;", ">");
        string2 = string2.replaceAll("&#96;", "`");
        string2 = string2.replaceAll("&#38;", PARAMETER_SEPARATOR);
        return string2;
    }

    public static synchronized void initParameters(ServletConfig servletConfig) {
        if (!isInitContext) {
            ParameterAccessor.initParameters(servletConfig.getServletContext());
        }
    }

    public static synchronized void initParameters(ServletContext servletContext) {
        if (isInitContext) {
            return;
        }
        workingFolder = ParameterAccessor.processWorkingFolder(servletContext, servletContext.getInitParameter(INIT_PARAM_WORKING_DIR));
        documentFolder = ParameterAccessor.processRealPath(servletContext, servletContext.getInitParameter(INIT_PARAM_DOCUMENT_FOLDER), "documents", true);
        imageFolder = ParameterAccessor.processRealPath(servletContext, servletContext.getInitParameter(INIT_PARAM_IMAGE_DIR), "report/images", true);
        logFolder = ParameterAccessor.processRealPath(servletContext, servletContext.getInitParameter(INIT_PARAM_LOG_DIR), "logs", true);
        logLevel = servletContext.getInitParameter(INIT_PARAM_LOG_LEVEL);
        scriptLibDir = ParameterAccessor.processRealPath(servletContext, servletContext.getInitParameter(INIT_PARAM_SCRIPTLIB_DIR), "scriptlib", false);
        webAppLocale = ParameterAccessor.getLocaleFromString(servletContext.getInitParameter(INIT_PARAM_LOCALE));
        if (webAppLocale == null) {
            webAppLocale = Locale.getDefault();
        }
        isWorkingFolderAccessOnly = Boolean.valueOf(servletContext.getInitParameter(INIT_PARAM_WORKING_FOLDER_ACCESS_ONLY));
        String string = servletContext.getInitParameter(INIT_PARAM_VIEWER_MAXROWS);
        try {
            maxRows = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            maxRows = -1;
        }
        birtResourceFolder = ParameterAccessor.processRealPath(servletContext, servletContext.getInitParameter(INIT_PARAM_BIRT_RESOURCE_PATH), null, false);
        String string2 = DataUtil.trimString(servletContext.getInitParameter(INIT_PARAM_OVERWRITE_DOCUMENT));
        isOverWrite = "true".equalsIgnoreCase(string2);
        initProps = ParameterAccessor.initViewerProps(servletContext, initProps);
        String string3 = DataUtil.trimString(servletContext.getInitParameter(INIT_PARAM_PRINT_SERVERSIDE));
        if ("ON".equalsIgnoreCase(string3)) {
            isSupportedPrintOnServer = true;
        } else if ("OFF".equalsIgnoreCase(string3)) {
            isSupportedPrintOnServer = false;
        }
        String string4 = servletContext.getInitParameter(INIT_PARAM_AGENTSTYLE_ENGINE);
        isAgentStyle = "true".equalsIgnoreCase(string4);
        ParameterAccessor.clearTempFiles();
        isInitContext = true;
    }

    public static boolean isDesigner(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_DESIGNER))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isGetImageOperator(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_IMAGEID);
        return string != null && string.length() > 0;
    }

    public static boolean isGetReportlet(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.isBookmarkReportlet(httpServletRequest) || ParameterAccessor.isIidReportlet(httpServletRequest);
    }

    public static boolean isBookmarkReportlet(HttpServletRequest httpServletRequest) {
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_ISREPORTLET))) {
            String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_BOOKMARK);
            return string != null && string.length() > 0;
        }
        return false;
    }

    public static boolean isIidReportlet(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_INSTANCEID);
        return string != null && string.length() > 0;
    }

    public static boolean isMasterPageContent(HttpServletRequest httpServletRequest) {
        boolean bl = true;
        if ("false".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_MASTERPAGE))) {
            bl = false;
        }
        return bl;
    }

    public static boolean isOverwrite(HttpServletRequest httpServletRequest) {
        boolean bl = isOverWrite;
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_OVERWRITE);
        if ("true".equalsIgnoreCase(string)) {
            bl = true;
        } else if ("false".equalsIgnoreCase(string)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isRelativePath(String string) {
        if (string == null) {
            return false;
        }
        return !new File(string).isAbsolute();
    }

    public static boolean isReportParameterExist(HttpServletRequest httpServletRequest, String string) {
        Set set;
        if (!($assertionsDisabled || httpServletRequest != null && string != null)) {
            throw new AssertionError();
        }
        boolean bl = false;
        Map map = httpServletRequest.getParameterMap();
        String string2 = ParameterAccessor.toISOString(string);
        if (map != null && map.containsKey(string2)) {
            bl = true;
        }
        if ((set = ParameterAccessor.getParameterValues(httpServletRequest, PARAM_ISNULL)) != null && set.contains(string)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isValidFilePath(String string) {
        if (string == null) {
            return false;
        }
        if (isWorkingFolderAccessOnly) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                return string.indexOf("..") == -1;
            }
            File file2 = new File(workingFolder);
            if (file2.isAbsolute()) {
                String string2 = file.getAbsolutePath();
                String string3 = file2.getAbsolutePath();
                if (ParameterAccessor.isWindowsPlatform()) {
                    string2 = string2.toLowerCase();
                    string3 = string3.toLowerCase();
                }
                return string2.startsWith(string3);
            }
            return false;
        }
        return true;
    }

    protected static String generateDocumentFromReport(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = ParameterAccessor.getReport(httpServletRequest, null);
        if (string2.indexOf(46) >= 0) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
        }
        string2 = (string = ParameterAccessor.getParameter(httpServletRequest, PARAM_ID)) != null && string.length() > 0 ? string2 + string + SUFFIX_REPORT_DOCUMENT : string2 + SUFFIX_REPORT_DOCUMENT;
        return string2;
    }

    public static String getParameter(HttpServletRequest httpServletRequest, String string) {
        return ParameterAccessor.getParameter(httpServletRequest, string, true);
    }

    protected static String getParameter(HttpServletRequest httpServletRequest, String string, boolean bl) {
        String string2 = bl ? ParameterAccessor.toISOString(string) : string;
        String string3 = httpServletRequest.getParameter(string2);
        String string4 = httpServletRequest.getCharacterEncoding();
        return ParameterAccessor.toUTFString(string3, string4);
    }

    protected static int getParameterAsInt(HttpServletRequest httpServletRequest, String string) {
        int n = -1;
        String string2 = ParameterAccessor.getParameter(httpServletRequest, string);
        if (string2 != null && string2.length() > 0) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    protected static Set getParameterValues(HttpServletRequest httpServletRequest, String string, boolean bl) {
        HashSet<String> hashSet = null;
        String string2 = bl ? ParameterAccessor.toISOString(string) : string;
        String[] stringArray = httpServletRequest.getParameterValues(string2);
        if (stringArray != null) {
            hashSet = new HashSet<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(ParameterAccessor.toUTFString(stringArray[i]));
            }
        }
        return hashSet;
    }

    protected static String toISOString(String string) {
        String string2 = string;
        if (string != null) {
            try {
                string2 = new String(string.getBytes(UTF_8_ENCODE), ISO_8859_1_ENCODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = string;
            }
        }
        return string2;
    }

    protected static String toUTFString(String string) {
        String string2 = string;
        if (string != null) {
            try {
                string2 = new String(string.getBytes(ISO_8859_1_ENCODE), UTF_8_ENCODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = string;
            }
        }
        return string2;
    }

    protected static String toUTFString(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        if (string != null) {
            if (string4 == null) {
                string4 = ISO_8859_1_ENCODE;
            }
            try {
                string3 = new String(string.getBytes(string4), UTF_8_ENCODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string3 = string;
            }
        }
        return string3;
    }

    public static String urlEncode(String string, String string2) {
        String string3 = string;
        if (string != null) {
            try {
                string3 = URLEncoder.encode(string, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string3 = string;
            }
        }
        return string3;
    }

    public static String getConfigFileName(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("\\.");
        String string2 = stringArray[stringArray.length - 1];
        String string3 = string.substring(0, string.length() - string2.length()) + "rptconfig";
        return string3;
    }

    public static String getFormat(HttpServletRequest httpServletRequest, String string) {
        if (httpServletRequest == null || string == null) {
            return null;
        }
        return ParameterAccessor.getParameter(httpServletRequest, string + "_format");
    }

    public static boolean isWorkingFolderAccessOnly() {
        return isWorkingFolderAccessOnly;
    }

    public static String isDisplayText(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith(PREFIX_DISPLAY_TEXT)) {
            return string.replaceFirst(PREFIX_DISPLAY_TEXT, "");
        }
        return null;
    }

    public static String generateFileName(HttpServletRequest httpServletRequest, String string) {
        String string2;
        int n;
        String string3;
        String string4 = string3 = "BIRTReport";
        BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
        if (baseAttributeBean == null) {
            return string4;
        }
        String string5 = baseAttributeBean.getReportDesignName();
        if (string5 == null || string5.length() == 0) {
            string5 = baseAttributeBean.getReportDocumentName();
        }
        if (string5 == null || string5.trim().length() <= 0) {
            return string4;
        }
        int n2 = string5.lastIndexOf(47);
        if (n2 == -1) {
            n2 = string5.lastIndexOf(92);
        }
        if (n2 != -1) {
            string5 = string5.substring(n2 + 1);
        }
        if ((n = string5.lastIndexOf(46)) > 0) {
            string4 = string5.substring(0, n);
        }
        for (int i = 0; i < string4.length(); ++i) {
            char c = string4.charAt(i);
            if (c >= '\u0000' && c < '\u0080') continue;
            string4 = string3;
            break;
        }
        if ((string2 = ParameterAccessor.getExtensionName(string)) != null && string2.length() > 0) {
            string4 = string4 + "." + string2;
        }
        return string4;
    }

    public static void reset() {
        isInitContext = false;
    }

    protected static boolean isWindowsPlatform() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    }

    public static String getResourceFolder(HttpServletRequest httpServletRequest) {
        String string = null;
        string = ParameterAccessor.getParameter(httpServletRequest, PARAM_RESOURCE_FOLDER);
        if (string == null || string.trim().length() <= 0) {
            string = birtResourceFolder;
        }
        return string;
    }

    public static Map pushAppContext(Map hashMap, HttpServletRequest httpServletRequest) {
        String string;
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
        }
        if ((string = (String)httpServletRequest.getAttribute(ATTR_APPCONTEXT_KEY)) != null) {
            hashMap.put(string, httpServletRequest.getAttribute(ATTR_APPCONTEXT_VALUE));
        }
        return hashMap;
    }

    public static String getExportEncoding(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_EXPORT_ENCODING);
        if (string == null) {
            string = UTF_8_ENCODE;
        }
        return string;
    }

    public static boolean isShowTitle(HttpServletRequest httpServletRequest) {
        boolean bl = true;
        if ("false".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_SHOW_TITLE))) {
            bl = false;
        }
        return bl;
    }

    public static boolean isShowToolbar(HttpServletRequest httpServletRequest) {
        boolean bl = true;
        if ("false".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_TOOLBAR))) {
            bl = false;
        }
        return bl;
    }

    public static boolean isShowNavigationbar(HttpServletRequest httpServletRequest) {
        boolean bl = true;
        if ("false".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_NAVIGATIONBAR))) {
            bl = false;
        }
        return bl;
    }

    public static String getShowParameterPage(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.getParameter(httpServletRequest, PARAM_PARAMETER_PAGE);
    }

    public static synchronized Map initViewerProps(ServletContext servletContext, Map hashMap) {
        String string;
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        if ((string = servletContext.getInitParameter(INIT_PARAM_CONFIG_FILE)) == null || string.trim().length() <= 0) {
            string = "WEB-INF/viewer.properties";
        }
        try {
            InputStream inputStream = null;
            if (ParameterAccessor.isRelativePath(string)) {
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                inputStream = servletContext.getResourceAsStream(string);
            } else {
                inputStream = new FileInputStream(string);
            }
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(inputStream);
            if (propertyResourceBundle != null) {
                Enumeration<String> enumeration = propertyResourceBundle.getKeys();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    String string2 = enumeration.nextElement();
                    String string3 = (String)propertyResourceBundle.getObject(string2);
                    if (string2 == null || string3 == null) continue;
                    hashMap.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    public static String getInitProp(String string) {
        if (initProps == null || string == null) {
            return null;
        }
        return (String)initProps.get(string);
    }

    public static String getExtensionName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "viewer.extension." + string.replaceAll(" ", "_");
        return DataUtil.trimString(ParameterAccessor.getInitProp(string2));
    }

    public static String getOutputFormatLabel(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "viewer.label." + string.replaceAll(" ", "_");
        String string3 = DataUtil.trimString(ParameterAccessor.getInitProp(string2));
        if (string3.length() <= 0) {
            string3 = string;
        }
        return string3;
    }

    public static String getBaseURL() {
        String string = ParameterAccessor.getInitProp(PROP_BASE_URL);
        if (string != null && string.length() > 0 && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected static String convertSystemPath(String string) {
        if (string == null) {
            return string;
        }
        Pattern pattern = Pattern.compile("\\$\\s*\\{([^\\}]*)\\}\\s*(.*)", 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = DataUtil.trimSepEnd(System.getProperty(matcher.group(1).trim()));
            if (string2.length() <= 0) {
                return DataUtil.trimSepFirst(matcher.group(2).trim());
            }
            return string2 + matcher.group(2).trim();
        }
        return string;
    }

    public static String processWorkingFolder(ServletContext servletContext, String string) {
        string = ParameterAccessor.convertSystemPath(DataUtil.trimString(string));
        String string2 = null;
        if (ParameterAccessor.isRelativePath(string)) {
            string2 = ParameterAccessor.getRealPath(string, servletContext);
            ParameterAccessor.makeDir(string2);
            return DataUtil.trimSepEnd(string);
        }
        string2 = string;
        ParameterAccessor.makeDir(string2);
        return DataUtil.trimSepEnd(string2);
    }

    public static String processRealPath(ServletContext servletContext, String string, String string2, boolean bl) {
        String string3 = null;
        boolean bl2 = false;
        if ((string = ParameterAccessor.convertSystemPath(string)) == null || string.trim().length() <= 0) {
            string = DataUtil.trimString(string2);
        }
        if (ParameterAccessor.isRelativePath(string)) {
            bl2 = true;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            string3 = DataUtil.trimSepEnd(ParameterAccessor.getRealPath(string, servletContext));
        } else {
            string3 = DataUtil.trimSepEnd(string);
        }
        boolean bl3 = ParameterAccessor.makeDir(string3);
        if (!bl) {
            return string3;
        }
        if (bl3) {
            try {
                if (bl && new File(string3).canWrite()) {
                    return string3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl2) {
            string3 = DataUtil.trimSepEnd(System.getProperty("java.io.tmpdir")) + string;
        } else if (string2 != null) {
            string3 = DataUtil.trimSepEnd(System.getProperty("java.io.tmpdir")) + File.separator + string2;
        }
        ParameterAccessor.makeDir(string3);
        return string3;
    }

    private static String getRealPath(String string, ServletContext servletContext) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        String string2 = null;
        try {
            URL uRL;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if ((string2 = servletContext.getRealPath(string)) == null && (uRL = servletContext.getResource("/")) != null) {
                string2 = DataUtil.trimString(uRL.getFile()) + string;
            }
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private static boolean makeDir(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        File file = new File(string);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static String getImageTempFolder(HttpServletRequest httpServletRequest) {
        String string = imageFolder;
        String string2 = httpServletRequest.getSession().getId();
        if (string2 != null) {
            string = string + File.separator + string2;
        }
        return string;
    }

    public static void clearSessionFiles(String string) {
        if (string == null) {
            return;
        }
        String string2 = documentFolder + File.separator + string;
        File file = new File(string2);
        ParameterAccessor.deleteDir(file);
        string2 = imageFolder + File.separator + string;
        file = new File(string2);
        ParameterAccessor.deleteDir(file);
    }

    public static boolean isFitToPage(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_FIT_TO_PAGE);
        return "true".equalsIgnoreCase(string);
    }

    public static boolean isPagebreakOnly(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_PAGEBREAK_ONLY);
        return "true".equalsIgnoreCase(string);
    }

    public static String getOpenType(HttpServletRequest httpServletRequest) {
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_AS_ATTACHMENT))) {
            return "attachment";
        }
        return "inline";
    }

    public static String getAction(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.getParameter(httpServletRequest, PARAM_ACTION);
    }

    public static Number getDpi(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_DPI);
        if (string == null || string.trim().length() <= 0) {
            return null;
        }
        return Integer.valueOf(string);
    }

    public static char getSep(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_SEP);
        if (string == null) {
            return ',';
        }
        String string2 = "viewer.sep." + string;
        String string3 = ParameterAccessor.getInitProp(string2);
        if (string3.length() <= 0) {
            return ',';
        }
        return string3.charAt(0);
    }

    public static void setClean(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_CLEAN_SESSION);
        if ("false".equalsIgnoreCase(string)) {
            isCleanSessionFiles = false;
        } else if ("true".equalsIgnoreCase(string)) {
            isCleanSessionFiles = true;
        }
    }

    public static boolean isAgentStyle(HttpServletRequest httpServletRequest) {
        boolean bl = isAgentStyle;
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_AGENTSTYLE_ENGINE);
        if ("true".equalsIgnoreCase(string)) {
            bl = true;
        } else if ("false".equalsIgnoreCase(string)) {
            bl = false;
        }
        return bl;
    }

    static {
        $assertionsDisabled = !ParameterAccessor.class.desiredAssertionStatus();
        workingFolder = null;
        documentFolder = null;
        imageFolder = null;
        logFolder = null;
        logLevel = null;
        scriptLibDir = null;
        webAppLocale = null;
        isWorkingFolderAccessOnly = false;
        birtResourceFolder = null;
        isInitContext = false;
        supportedFormats = new String[]{PARAM_FORMAT_HTML, PARAM_FORMAT_PDF};
        isSupportedPrintOnServer = true;
        isCleanSessionFiles = true;
    }
}

